---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 75
  claims_with_evidence: 72
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：plugins-discovery-azure-classic 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：72 / 75、根拠なし：3
- 優先レビュー（高）
  1. **UT-DAC-041（AzureComputeServiceImpl コンストラクタ正常系）**：Azure SDKの初期化フローが外部依存のためモック方法の検証が必要
  2. **UT-DAC-050（doClose clientがnullの場合）**：実際にclientがnullになるケースがコード上存在するか要確認
  3. **UT-DAC-013（refreshInterval=-1の無限キャッシュ）**：refreshIntervalが負の値を許容するかSetting定義（positiveTimeSetting）との整合性を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/discovery-azure-classic/src/main/java/org/opensearch/discovery/azure/classic/AzureSeedHostsProvider.java`
- E-02: `plugins/discovery-azure-classic/src/main/java/org/opensearch/plugin/discovery/azure/classic/AzureDiscoveryPlugin.java`
- E-03: `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/AzureServiceDisableException.java`
- E-04: `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/AzureServiceRemoteException.java`
- E-05: `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/management/AzureComputeServiceImpl.java`
- E-06: `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/management/AzureComputeService.java`
- E-07: `plugins/discovery-azure-classic/src/main/java/org/apache/commons/lang/StringUtils.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HostType.fromStringがprivate_ipでPRIVATE_IPを返す | E-01 (L80-87) | ○ |
| C-02 | HostType.fromStringがpublic_ipでPUBLIC_IPを返す | E-01 (L80-87) | ○ |
| C-03 | HostType.fromStringが大文字小文字を無視する | E-01 (L83: equalsIgnoreCase) | ○ |
| C-04 | HostType.fromStringが不正値でIllegalArgumentExceptionをスロー | E-01 (L86) | ○ |
| C-05 | HostType.fromStringが空文字でIllegalArgumentExceptionをスロー | E-01 (L86) | ○ |
| C-06 | HostType.getTypeがtype文字列を返す | E-01 (L76-78) | ○ |
| C-07 | Deployment.fromStringがproductionでPRODUCTIONを返す | E-01 (L102-109) | ○ |
| C-08 | Deployment.fromStringがstagingでSTAGINGを返す | E-01 (L102-109) | ○ |
| C-09 | Deployment.fromStringが大文字小文字を無視する | E-01 (L104: equalsIgnoreCase) | ○ |
| C-10 | Deployment.fromStringが不正値でIllegalArgumentExceptionをスロー | E-01 (L108) | ○ |
| C-11 | getSeedAddressesがキャッシュ無効時にAPIからノードリストを取得 | E-01 (L156-244) | ○ |
| C-12 | getSeedAddressesがキャッシュ期間内にキャッシュを返す | E-01 (L157-163) | ○ |
| C-13 | refreshInterval=-1で無限キャッシュ | E-01 (L159: refreshInterval.millis() < 0) | △ |
| C-14 | キャッシュ期限切れ時にAPIから再取得 | E-01 (L157-163) | ○ |
| C-15 | AzureServiceDisableException発生時に空リスト返却 | E-01 (L172-174) | ○ |
| C-16 | AzureServiceRemoteException発生時に空リスト返却 | E-01 (L175-179) | ○ |
| C-17 | デプロイメントスロット不一致時にスキップ | E-01 (L195-203) | ○ |
| C-18 | デプロイメント名不一致時にスキップ | E-01 (L206-209) | ○ |
| C-19 | ステータスRunningの場合にインスタンス追加 | E-01 (L212-217) | ○ |
| C-20 | ステータスStartingの場合にインスタンス追加 | E-01 (L212-217) | ○ |
| C-21 | ステータスDeployingの場合にインスタンス追加 | E-01 (L212-217) | ○ |
| C-22 | ステータスSuspendedの場合にスキップ | E-01 (L212-217) | ○ |
| C-23 | デプロイメント0件で空リスト | E-01 (L193) | ○ |
| C-24 | ロールインスタンス0件で空リスト | E-01 (L221) | ○ |
| C-25 | PRIVATE_IPでプライベートIPアドレスを返す | E-01 (L247-253) | ○ |
| C-26 | PRIVATE_IPでIPアドレスがnullの場合にnull返却 | E-01 (L249-252) | ○ |
| C-27 | PUBLIC_IPで一致するエンドポイントのアドレスを返す | E-01 (L254-261) | ○ |
| C-28 | PUBLIC_IPで一致するエンドポイントがない場合にnull返却 | E-01 (L254-263) | ○ |
| C-29 | PUBLIC_IPでエンドポイント0件でnull返却 | E-01 (L255) | ○ |
| C-30 | コンストラクタが設定値を正しく初期化 | E-01 (L125-147) | ○ |
| C-31 | AzureDiscoveryPluginコンストラクタの初期化 | E-02 (L62-66) | ○ |
| C-32 | getSeedHostProvidersがazureキーでSupplierを返す | E-02 (L74-79) | ○ |
| C-33 | getSettingsが10個のSettingを返す | E-02 (L92-105) | ○ |
| C-34 | createSeedHostsProviderがAzureSeedHostsProviderを返す | E-02 (L82-89) | ○ |
| C-35 | AzureServiceDisableExceptionのメッセージ付きコンストラクタ | E-03 (L36-38) | ○ |
| C-36 | AzureServiceDisableExceptionの原因付きコンストラクタ | E-03 (L40-42) | ○ |
| C-37 | AzureServiceDisableExceptionがIllegalStateExceptionのサブクラス | E-03 (L35) | ○ |
| C-38 | AzureServiceRemoteExceptionのメッセージ付きコンストラクタ | E-04 (L36-38) | ○ |
| C-39 | AzureServiceRemoteExceptionの原因付きコンストラクタ | E-04 (L40-42) | ○ |
| C-40 | AzureServiceRemoteExceptionがIllegalStateExceptionのサブクラス | E-04 (L35) | ○ |
| C-41 | AzureComputeServiceImpl正常初期化 | E-05 (L63-103) | △ |
| C-42 | subscriptionId未設定でIllegalArgumentException | E-05 (L64, L105-111) | ○ |
| C-43 | serviceName未設定でIllegalArgumentException | E-05 (L66, L105-111) | ○ |
| C-44 | keystorePath未設定でIllegalArgumentException | E-05 (L67, L105-111) | ○ |
| C-45 | keystorePassword未設定でIllegalArgumentException | E-05 (L68, L105-111) | ○ |
| C-46 | getServiceDetailsが正常にレスポンスを返す | E-05 (L114-121) | ○ |
| C-47 | getServiceDetailsで例外時にAzureServiceRemoteExceptionスロー | E-05 (L118-120) | ○ |
| C-48 | doCloseでclient.close()が呼ばれる | E-05 (L130-138) | ○ |
| C-49 | doCloseでIOException時にエラーログ出力 | E-05 (L133-135) | ○ |
| C-50 | doCloseでclient=nullの場合にNPEが発生しない | E-05 (L131) | △ |
| C-51 | getRequiredSettingでnull値時にIllegalArgumentException | E-05 (L105-111) | ○ |
| C-52 | getRequiredSettingで空文字時にIllegalArgumentException | E-05 (L107) | ○ |
| C-53 | getRequiredSettingで正常値が返される | E-05 (L105-111) | ○ |
| C-54 | StringUtils.join(Collection)の基本動作 | E-07 (L22-25) | ○ |
| C-55 | StringUtils.join(Collection)のnull入力 | E-07 (L23) | ○ |
| C-56 | StringUtils.join(Collection)の空コレクション | E-07 (L22-25) | ○ |
| C-57 | StringUtils.join(Iterator)の基本動作 | E-07 (L27-30) | ○ |
| C-58 | StringUtils.join(Iterator)のnull入力 | E-07 (L28) | ○ |
| C-59 | StringUtils.join(Object[])の基本動作 | E-07 (L32-35) | ○ |
| C-60 | StringUtils.join(Object[])のnull入力 | E-07 (L33) | ○ |
| C-61 | StringUtils.join(Iterable)の基本動作 | E-07 (L37-40) | ○ |
| C-62 | StringUtils.join(Iterable)のnull入力 | E-07 (L38) | ○ |
| C-63 | StringUtils.isBlankが空白文字列でtrue | E-07 (L42-44) | ○ |
| C-64 | StringUtils.isBlankがnullでtrue | E-07 (L42-44) | ○ |
| C-65 | StringUtils.isBlankが空文字でtrue | E-07 (L42-44) | ○ |
| C-66 | StringUtils.isBlankが非空白文字列でfalse | E-07 (L42-44) | ○ |
| C-67 | StringUtils.isEmptyが空文字でtrue | E-07 (L46-48) | ○ |
| C-68 | StringUtils.isEmptyがnullでtrue | E-07 (L46-48) | ○ |
| C-69 | StringUtils.isEmptyが非空文字列でfalse | E-07 (L46-48) | ○ |
| C-70 | ENDPOINT_SETTINGのデフォルト値確認 | E-06 (L80-91) | ○ |
| C-71 | ENDPOINT_SETTINGの不正URI入力ハンドリング | E-06 (L84-88) | ○ |
| C-72 | REFRESH_SETTINGのデフォルト値確認 | E-06 (L95-99) | ○ |
| C-73 | HOST_TYPE_SETTINGのデフォルト値確認 | E-06 (L100-105) | ○ |
| C-74 | ENDPOINT_NAME_SETTINGのデフォルト値確認 | E-06 (L106-111) | ○ |
| C-75 | DEPLOYMENT_SLOT_SETTINGのデフォルト値確認 | E-06 (L116-121) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-13: `REFRESH_SETTING`は`Setting.positiveTimeSetting`で定義されており、負の値（-1）を設定可能かはSettingのバリデーション仕様に依存する。コード上は`refreshInterval.millis() < 0`の条件が存在するが、実際にこの設定値が許容されるか要確認。
  - 候補：OpenSearchのSetting.positiveTimeSettingのバリデーション仕様 / テスト実装での確認
- C-41: Azure SDK（ComputeManagementService.create等）の初期化フローは外部依存であり、正常系テストの実施にはモック化が必須。モック方法の詳細は実装時に検討が必要。
  - 候補：既存テストコードのモック実装パターン / Azure SDKのテスト支援ライブラリ
- C-50: `doClose()`メソッドでは`client != null`チェックがあるが、コンストラクタで例外が発生した場合にclientがnullのままとなる可能性がある。ただしAbstractLifecycleComponentのライフサイクル管理上、コンストラクタ例外後にdoCloseが呼ばれるかは要確認。
  - 候補：AbstractLifecycleComponentのライフサイクル管理仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 例外クラス（AzureServiceDisableException、AzureServiceRemoteException）のテストケースは単純で信頼性が高い
- 0: 低リスク - StringUtilsシムのテストケースはデリゲーション確認のみで明確
- 1: 中リスク - AzureSeedHostsProviderのキャッシュ機構テスト（時間依存のテストは不安定になりやすい）
- 1: 中リスク - AzureComputeServiceImplのコンストラクタテスト（Azure SDK外部依存のモック化が必要）
- 0: 低リスク - Setting定義のデフォルト値テストは静的定義の確認のみ

## 6) レビュアーチェックリスト（最小）
- [ ] UT-DAC-013: refreshIntervalに負の値（-1）がpositiveTimeSettingで許容されるか確認
- [ ] UT-DAC-041: AzureComputeServiceImplの正常初期化テストでAzure SDK依存部分のモック方法が適切か確認
- [ ] UT-DAC-050: doCloseでclient=nullケースが実際に発生しうるかライフサイクル管理仕様と照合
- [ ] テストケースの優先度（高/中/低）が実プロジェクトの方針と合致しているか確認
- [ ] getSeedAddressesのキャッシュ関連テスト（UT-DAC-012〜014）が時間依存テストとして適切に実装可能か確認
