---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 73
  claims_with_evidence: 71
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：plugins-discovery-ec2 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：71 / 73、根拠なし：2
- 優先レビュー（高）
  1. **C-37 (AmazonEc2ClientReference incRef/decRef)**: RefCountedReleasableの継承動作のため直接的なコード根拠はこのモジュール内にない
  2. **C-38 (AmazonEc2ClientReference close on decRef)**: RefCountedReleasableの継承動作のため直接的なコード根拠はこのモジュール内にない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/discovery-ec2/src/main/java/org/opensearch/discovery/ec2/Ec2ClientSettings.java` (行56-240)
- E-02: `plugins/discovery-ec2/src/main/java/org/opensearch/discovery/ec2/AwsEc2ServiceImpl.java` (行62-227)
- E-03: `plugins/discovery-ec2/src/main/java/org/opensearch/discovery/ec2/Ec2NameResolver.java` (行71-153)
- E-04: `plugins/discovery-ec2/src/main/java/org/opensearch/discovery/ec2/AmazonEc2ClientReference.java` (行43-48)
- E-05: `plugins/discovery-ec2/src/main/java/org/opensearch/discovery/ec2/AwsEc2SeedHostsProvider.java` (行69-271)
- E-06: `plugins/discovery-ec2/src/main/java/org/opensearch/discovery/ec2/Ec2DiscoveryPlugin.java` (行67-198)
- E-07: `plugins/discovery-ec2/src/main/java/org/opensearch/discovery/ec2/AwsEc2Service.java` (行45-129)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | loadCredentials: access_keyとsecret_keyでAwsBasicCredentialsが返却される | E-01 (行207-210) | ○ |
| C-02 | loadCredentials: session_token付きでAwsSessionCredentialsが返却される | E-01 (行211-213) | ○ |
| C-03 | loadCredentials: 空キーでnullが返却される | E-01 (行178, 189) | ○ |
| C-04 | loadCredentials: session_tokenのみでSettingsException | E-01 (行179-186) | ○ |
| C-05 | loadCredentials: secret_keyのみでSettingsException | E-01 (行191-198) | ○ |
| C-06 | loadCredentials: access_keyのみでSettingsException | E-01 (行199-205) | ○ |
| C-07 | getClientSettings: 全設定値の読み込み | E-01 (行221-239) | ○ |
| C-08 | getClientSettings: デフォルト設定 | E-01 (行221-239) | ○ |
| C-09 | Ec2ClientSettingsコンストラクタ: パラメータ設定 | E-01 (行150-170) | ○ |
| C-10 | getFullEndpoint: httpsスキーム付きがそのまま | E-02 (行118-119) | ○ |
| C-11 | getFullEndpoint: httpスキーム付きがそのまま | E-02 (行118-119) | ○ |
| C-12 | getFullEndpoint: スキームなしでhttps付与 | E-02 (行123-124) | ○ |
| C-13 | getFullEndpoint: 空文字列でnull | E-02 (行115-117) | ○ |
| C-14 | getFullEndpoint: nullでnull | E-02 (行115-117) | ○ |
| C-15 | buildCredentials: null時にDefaultCredentialsProvider | E-02 (行170-173) | ○ |
| C-16 | buildCredentials: 設定済み時にStaticCredentialsProvider | E-02 (行174-177) | ○ |
| C-17 | buildRetryPolicy: リトライ回数10 | E-02 (行165-166) | ○ |
| C-18 | buildOverrideConfiguration: RetryPolicy含む | E-02 (行154-156) | ○ |
| C-19 | buildProxyConfiguration: プロキシホスト設定時 | E-02 (行127-145) | ○ |
| C-20 | buildProxyConfiguration: プロキシ未設定時 | E-02 (行149-151) | ○ |
| C-21 | client: 初期化済みで正常返却 | E-02 (行181-187) | ○ |
| C-22 | client: 未初期化でIllegalStateException | E-02 (行183-184) | ○ |
| C-23 | refreshAndClearCache: 新設定で更新 | E-02 (行195-205) | ○ |
| C-24 | refreshAndClearCache: 初回呼び出し | E-02 (行201-204) | ○ |
| C-25 | close: クライアント参照リセット | E-02 (行208-213) | ○ |
| C-26 | close: 未初期化状態 | E-02 (行209-212) | ○ |
| C-27 | resolveIfPossible: ec2でprivate IPv4 | E-03 (行88-90, 144-150) | ○ |
| C-28 | resolveIfPossible: ec2:privateIpv4 | E-03 (行82, 144-150) | ○ |
| C-29 | resolveIfPossible: ec2:publicIpv4 | E-03 (行84, 144-150) | ○ |
| C-30 | resolveIfPossible: ec2:privateDns | E-03 (行83, 144-150) | ○ |
| C-31 | resolveIfPossible: ec2:publicDns | E-03 (行85, 144-150) | ○ |
| C-32 | resolveIfPossible: 未知の値でnull | E-03 (行145-150) | ○ |
| C-33 | resolve: メタデータ未設定でIOException | E-03 (行132-134) | ○ |
| C-34 | resolve: 空メタデータでIOException | E-03 (行121-123) | ○ |
| C-35 | resolve: 接続失敗でIOException | E-03 (行127-129) | ○ |
| C-36 | resolveDefault: null返却 | E-03 (行138-139) | ○ |
| C-37 | AmazonEc2ClientReference: incRef/decRef動作 | E-04 (行43-47) | △ |
| C-38 | AmazonEc2ClientReference: decRefでclose | E-04 (行43-47) | △ |
| C-39 | AmazonEc2ClientReferenceコンストラクタ | E-04 (行45-47) | ○ |
| C-40 | AwsEc2SeedHostsProviderコンストラクタ | E-05 (行91-121) | ○ |
| C-41 | fetchDynamicNodes: private_ip | E-05 (行193-194) | ○ |
| C-42 | fetchDynamicNodes: public_ip | E-05 (行199) | ○ |
| C-43 | fetchDynamicNodes: private_dns | E-05 (行192-193) | ○ |
| C-44 | fetchDynamicNodes: public_dns | E-05 (行197-198) | ○ |
| C-45 | fetchDynamicNodes: tag:プレフィックス | E-05 (行200-210) | ○ |
| C-46 | fetchDynamicNodes: 不正ホストタイプ | E-05 (行212) | ○ |
| C-47 | fetchDynamicNodes: anyGroup一致 | E-05 (行164-175) | ○ |
| C-48 | fetchDynamicNodes: anyGroup不一致 | E-05 (行166) | ○ |
| C-49 | fetchDynamicNodes: allGroup全一致 | E-05 (行178) | ○ |
| C-50 | fetchDynamicNodes: allGroup部分一致除外 | E-05 (行178) | ○ |
| C-51 | fetchDynamicNodes: SG IDフィルタリング | E-05 (行162-163, 166) | ○ |
| C-52 | fetchDynamicNodes: グループフィルタ空 | E-05 (行156) | ○ |
| C-53 | fetchDynamicNodes: 空レスポンス | E-05 (行153) | ○ |
| C-54 | fetchDynamicNodes: SdkExceptionで空リスト | E-05 (行147-149) | ○ |
| C-55 | fetchDynamicNodes: nullアドレスのスキップ | E-05 (行232-234) | ○ |
| C-56 | fetchDynamicNodes: タグ未設定スキップ | E-05 (行200-210) | ○ |
| C-57 | buildDescribeInstancesRequest: 状態フィルタ | E-05 (行245) | ○ |
| C-58 | buildDescribeInstancesRequest: タグフィルタ | E-05 (行247-250) | ○ |
| C-59 | buildDescribeInstancesRequest: AZフィルタ | E-05 (行252-255) | ○ |
| C-60 | buildDescribeInstancesRequest: 空AZフィルタ | E-05 (行252) | ○ |
| C-61 | getSeedAddresses: キャッシュ返却 | E-05 (行124-126) | ○ |
| C-62 | Ec2DiscoveryPluginコンストラクタ | E-06 (行80-89) | ○ |
| C-63 | getCustomNameResolver | E-06 (行92-95) | ○ |
| C-64 | getSeedHostProviders | E-06 (行98-100) | ○ |
| C-65 | getSettings: 全設定返却 | E-06 (行103-126) | ○ |
| C-66 | getAvailabilityZoneNodeAttributes: AZ設定 | E-06 (行147-185) | ○ |
| C-67 | getAvailabilityZoneNodeAttributes: false時EMPTY | E-06 (行148-149) | ○ |
| C-68 | getAvailabilityZoneNodeAttributes: 空メタデータ | E-06 (行174-175) | ○ |
| C-69 | getAvailabilityZoneNodeAttributes: IO失敗 | E-06 (行179-181) | ○ |
| C-70 | close: ec2Service.close | E-06 (行188-190) | ○ |
| C-71 | reload: 設定リフレッシュ | E-06 (行193-197) | ○ |
| C-72 | fetchDynamicNodes: 複数Reservation | E-05 (行153-154) | ○ |
| C-73 | fetchDynamicNodes: アドレス解析失敗 | E-05 (行221-231) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-37, C-38: `AmazonEc2ClientReference`は`RefCountedReleasable`を継承しており、`incRef`/`decRef`の動作は親クラスに定義されている。このモジュール内には直接的なコード根拠がないが、コンストラクタで`client::close`をリリースアクションとして渡していることから、参照カウント0でcloseが呼ばれる動作は推定可能。
  - 候補：`org.opensearch.common.concurrent.RefCountedReleasable` / OpenSearchコアライブラリのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースの大部分はソースコードから直接導出されており、ロジックの分岐条件もソースコードで確認可能
- 1: 中リスク - `AmazonEc2ClientReference`の参照カウント動作は親クラス依存のためモジュール内検証が限定的
- 0: 低リスク - EC2メタデータサービスへのアクセスを伴うテストケースはモック化が前提

## 6) レビュアーチェックリスト（最小）
- [ ] `Ec2ClientSettings.loadCredentials`の認証情報バリデーション（C-01~C-06）が全分岐をカバーしているか確認
- [ ] `AwsEc2SeedHostsProvider.fetchDynamicNodes`のセキュリティグループフィルタリング（C-47~C-52）がanyGroup/allGroupの両パターンを網羅しているか確認
- [ ] `AmazonEc2ClientReference`の参照カウント動作（C-37, C-38）について親クラス`RefCountedReleasable`の仕様を確認
- [ ] EC2メタデータサービス関連のテスト（C-27~C-35, C-66~C-69）でモック化方針が適切か確認
- [ ] `AwsEc2ServiceImpl.buildProxyConfiguration`のURISyntaxException処理（C-19）のエッジケースを確認
