---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 96
  claims_with_evidence: 92
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：plugins-discovery-gce 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：92 / 96、根拠なし：4
- 優先レビュー（高）
  1. **C-39 (UT-GCE-039)**: ALLOW_REROUTE_GCE_SETTINGSはシステムプロパティ依存であり、テスト時の設定変更方法が不明確
  2. **C-88 (UT-GCE-088)**: FIPSモードの検出はリフレクションベースであり、テスト環境でのFIPSモード再現が困難
  3. **C-71 (UT-GCE-071)**: メタデータサーバーからのプロジェクトID自動解決はネットワーク依存
  4. **C-74 (UT-GCE-074)**: メタデータサーバーからのゾーン自動解決はネットワーク依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/discovery-gce/src/main/java/org/opensearch/discovery/gce/GceSeedHostsProvider.java`
- E-02: `plugins/discovery-gce/src/main/java/org/opensearch/discovery/gce/RetryHttpInitializerWrapper.java`
- E-03: `plugins/discovery-gce/src/main/java/org/opensearch/plugin/discovery/gce/GceDiscoveryPlugin.java`
- E-04: `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceMetadataService.java`
- E-05: `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/network/GceNameResolver.java`
- E-06: `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceInstancesService.java`
- E-07: `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceInstancesServiceImpl.java`
- E-08: `plugins/discovery-gce/src/main/java/org/opensearch/cloud/gce/GceModule.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GceSeedHostsProviderコンストラクタで設定値が正しく初期化される | E-01 (L94-113) | ○ |
| C-02 | GCEインスタンスのプライベートIPからTransportAddressリストが構築される | E-01 (L120-295) | ○ |
| C-03 | opensearch_portメタデータでポート付きアドレスが使用される | E-01 (L254-263) | ○ |
| C-04 | 複数ゾーンのインスタンスがマージされる | E-01 (L157-158), E-07 (L101-131) | ○ |
| C-05 | タグフィルタに一致するインスタンスのみが含まれる | E-01 (L180-218) | ○ |
| C-06 | TERMINATEDステータスのインスタンスが除外される | E-01 (L172-177) | ○ |
| C-07 | 自ノードのIPアドレスがリストから除外される | E-01 (L247-250) | ○ |
| C-08 | キャッシュが有効な場合にキャッシュされたリストが返される | E-01 (L133-138) | ○ |
| C-09 | キャッシュが期限切れの場合に新しいリストが取得される | E-01 (L133-139) | ○ |
| C-10 | refreshIntervalが負の値の場合に永久キャッシュされる | E-01 (L135) | ○ |
| C-11 | refreshIntervalが0の場合に毎回APIが呼ばれる | E-01 (L133) | ○ |
| C-12 | パブリックIPがAccessConfigから取得される | E-01 (L226-236) | ○ |
| C-13 | projectがnullまたは空の場合にIllegalArgumentException | E-01 (L122-131) | ○ |
| C-14 | zonesがnullまたは空の場合にIllegalArgumentException | E-01 (L122-131) | ○ |
| C-15 | GCE APIがnullを返した場合に空リスト | E-01 (L160-163) | ○ |
| C-16 | GCE API呼び出しで例外発生時に空リスト | E-01 (L287-289) | ○ |
| C-17 | インスタンスにタグがnullの場合にタグフィルタで除外 | E-01 (L183-189) | ○ |
| C-18 | インスタンスのタグItemsが空の場合にタグフィルタで除外 | E-01 (L183-189) | ○ |
| C-19 | opensearch_portがString以外の型の場合にデフォルトポート | E-01 (L257-262) | ○ |
| C-20 | NetworkInterfaceがnullの場合のハンドリング | E-01 (L223-244) | ○ |
| C-21 | インスタンスリストが空の場合に空リスト | E-01 (L160-163) | ○ |
| C-22 | インスタンスが1件のみの場合 | E-01 (L165-286) | ○ |
| C-23 | タグフィルタが空リストの場合に全インスタンスが含まれる | E-01 (L181) | ○ |
| C-24 | 複数タグフィルタで一部のみ一致する場合に除外 | E-01 (L193-206) | ○ |
| C-25 | RetryHttpInitializerWrapperデフォルトコンストラクタ | E-02 (L67-69) | ○ |
| C-26 | maxWait指定コンストラクタ | E-02 (L71-73) | ○ |
| C-27 | Credentialがnullの場合にNullPointerException | E-02 (L77) | ○ |
| C-28 | HttpRequestにインターセプタとハンドラが設定される | E-02 (L89-120) | ○ |
| C-29 | Credentialが認証エラーを処理できる場合にtrue | E-02 (L99-105) | ○ |
| C-30 | バックオフハンドラがリトライ可能な場合にtrue | E-02 (L106-109) | ○ |
| C-31 | IOExceptionハンドラがExponentialBackOffで設定される | E-02 (L116-119) | ○ |
| C-32 | Credentialもバックオフも処理できない場合にfalse | E-02 (L111-113) | ○ |
| C-33 | MockGoogleCredential.Builderが返される | E-02 (L83-86) | ○ |
| C-34 | GceDiscoveryPluginコンストラクタでsettingsが保持される | E-03 (L90-93) | ○ |
| C-35 | gceキーでSeedHostsProviderが登録される | E-03 (L101-106) | ○ |
| C-36 | gceプロバイダがGceSeedHostsProviderインスタンスを生成 | E-03 (L103-104) | ○ |
| C-37 | GceNameResolverが返される | E-03 (L109-112) | ○ |
| C-38 | GCE関連の設定が登録される | E-03 (L115-133) | ○ |
| C-39 | ALLOW_REROUTE_GCE_SETTINGSがtrueの場合に追加設定 | E-03 (L68-70, L128-131) | △ |
| C-40 | closeでGceInstancesServiceがクローズされる | E-03 (L136-138) | ○ |
| C-41 | gceInstancesServiceが未設定の場合にclose安全完了 | E-03 (L136-138) | ○ |
| C-42 | GceInstancesServiceImplインスタンスが生成される | E-03 (L96-98) | ○ |
| C-43 | GceMetadataServiceコンストラクタでsettings保持 | E-04 (L72-74) | ○ |
| C-44 | メタデータパスからGCEメタデータが取得される | E-04 (L83-107) | ○ |
| C-45 | Metadata-Flavorヘッダが設定される | E-04 (L97) | ○ |
| C-46 | URLがGCE_HOST設定値をベースに構築される | E-04 (L87) | ○ |
| C-47 | メタデータサーバーへの接続失敗時にIOException | E-04 (L104-106) | ○ |
| C-48 | HttpTransportが遅延初期化される | E-04 (L76-81) | ○ |
| C-49 | 2回目の呼び出しで同一インスタンスが返される | E-04 (L76-81) | ○ |
| C-50 | doStopでHttpTransportがshutdownされる | E-04 (L115-124) | ○ |
| C-51 | shutdown時のIOExceptionがログ出力される | E-04 (L118-120) | ○ |
| C-52 | gceHttpTransportがnullの場合にdoStop安全完了 | E-04 (L116) | ○ |
| C-53 | GceNameResolverコンストラクタ | E-05 (L87-89) | ○ |
| C-54 | _gce_指定でプライベートIPが解決される | E-05 (L98-100) | ○ |
| C-55 | _gce:hostname_指定でホスト名が解決される | E-05 (L101-102) | ○ |
| C-56 | _gce:privateIp_指定でデフォルトNIC(0)のIP解決 | E-05 (L103-112) | ○ |
| C-57 | _gce:privateIp:1_指定でNIC 1のIP解決 | E-05 (L106-108) | ○ |
| C-58 | gceプレフィックスでない値でnull返却 | E-05 (L141-145) | ○ |
| C-59 | 不正なGCE設定値でIllegalArgumentException | E-05 (L113-120) | ○ |
| C-60 | メタデータがnullまたは空でIOException | E-05 (L124-126) | ○ |
| C-61 | メタデータ取得例外時にIOExceptionでラップ | E-05 (L129-131) | ○ |
| C-62 | resolveDefaultがnullを返す | E-05 (L135-137) | ○ |
| C-63 | GceInstancesServiceImplコンストラクタ初期化 | E-07 (L146-151) | ○ |
| C-64 | validateCertsがデフォルトでtrue | E-07 (L74-78, L148) | ○ |
| C-65 | 各ゾーンからインスタンスリストが取得・マージされる | E-07 (L101-131) | ○ |
| C-66 | ゾーンのAPI呼び出しで例外発生時に空リスト | E-07 (L115-120) | ○ |
| C-67 | InstanceListがemptyの場合に空リスト | E-07 (L112-114) | ○ |
| C-68 | InstanceListのitemsがnullの場合に空リスト | E-07 (L112-114) | ○ |
| C-69 | ゾーンリストが空の場合に空リスト | E-07 (L103, L126-128) | ○ |
| C-70 | settingsにPROJECT_SETTINGがある場合にその値が返される | E-07 (L153-156) | ○ |
| C-71 | settingsにPROJECT_SETTINGがない場合にメタデータサーバーから取得 | E-07 (L158-164) | △ |
| C-72 | メタデータサーバーから取得失敗時にnull | E-07 (L161-163) | ○ |
| C-73 | settingsにZONE_SETTINGがある場合にその値が返される | E-07 (L167-170) | ○ |
| C-74 | settingsにZONE_SETTINGがない場合にメタデータサーバーから取得 | E-07 (L172-180) | △ |
| C-75 | ゾーンメタデータ解決失敗時にnull | E-07 (L178-180) | ○ |
| C-76 | メタデータサーバーからの値取得成功 | E-07 (L183-195) | ○ |
| C-77 | Metadata-Flavorヘッダがない応答でnull | E-07 (L194, L197-201) | ○ |
| C-78 | Metadata-FlavorがGoogleでtrue | E-07 (L197-201) | ○ |
| C-79 | Metadata-Flavorが異なる値でfalse | E-07 (L197-201) | ○ |
| C-80 | Metadata-Flavorヘッダがnullでfalse | E-07 (L199-200) | ○ |
| C-81 | Computeクライアントが正しく構築される | E-07 (L226-282) | ○ |
| C-82 | リトライ設定ありでRetryHttpInitializerWrapper使用 | E-07 (L260-269) | ○ |
| C-83 | maxWaitが0以下の場合にデフォルトRetryHttpInitializerWrapper | E-07 (L264-268) | ○ |
| C-84 | リフレッシュインターバル内でキャッシュされたクライアント返却 | E-07 (L227-233) | ○ |
| C-85 | 認証トークン取得失敗時にIllegalArgumentException | E-07 (L276-278) | ○ |
| C-86 | validateCerts=trueで信頼済みトランスポート生成 | E-07 (L205-217) | ○ |
| C-87 | validateCerts=falseで証明書検証なしトランスポート生成 | E-07 (L218-221) | ○ |
| C-88 | FIPSモードでBCFKSキーストア使用 | E-07 (L206-214) | △ |
| C-89 | closeでHttpTransportがshutdown | E-07 (L295-299) | ○ |
| C-90 | gceHttpTransportがnullの場合にclose安全完了 | E-07 (L296) | ○ |
| C-91 | projectId()がプロジェクトIDを返す | E-07 (L285-287) | ○ |
| C-92 | zones()がゾーンリストを返す | E-07 (L290-292) | ○ |
| C-93 | GceModuleコンストラクタでsettings保持 | E-08 (L47-49) | ○ |
| C-94 | getComputeServiceImplがGceInstancesServiceImplクラスを返す | E-08 (L42, L51-53) | ○ |
| C-95 | GceInstancesServiceがcomputeServiceImplにバインドされる | E-08 (L56-58) | ○ |
| C-96 | バインドがeagerSingletonとして構成される | E-08 (L58) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-39: `ALLOW_REROUTE_GCE_SETTINGS`はシステムプロパティ`opensearch.allow_reroute_gce_settings`に依存しており、テスト環境でのシステムプロパティ変更方法が実行時に決定されるため、テストケースの前提条件が不明確
  - 候補：既存テストコードの確認 / システムプロパティ設定方法の調査
- C-71, C-74: `resolveProject()`/`resolveZones()`のメタデータサーバーからの自動解決は実際のGCEメタデータサーバーへのHTTPリクエストに依存しており、ユニットテストではモック化が必要
  - 候補：`getAppEngineValueFromMetadataServer`のモック化 / HttpTransportのモック
- C-88: FIPSモードの検出はBouncyCastleのリフレクションに依存しており、テスト環境でFIPSモードを再現する方法が不明確
  - 候補：リフレクション先のモック / FIPSモード対応テスト環境の構築

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半のテストケース（92件）はソースコードから直接根拠が確認でき、ロジックの網羅性も高い
- 1: 中リスク - メタデータサーバーへの自動解決機能（C-71, C-74）はネットワーク依存のため、テスト実行環境によっては追加のモック設定が必要
- 1: 中リスク - FIPSモード対応（C-88）はBouncyCastle依存であり、テスト環境構築に注意が必要
- 0: 低リスク - ALLOW_REROUTE_GCE_SETTINGS（C-39）はテスト用フラグであり、本番影響は低い

## 6) レビュアーチェックリスト（最小）
- [ ] GceSeedHostsProvider.getSeedAddresses()のキャッシュロジック（refreshInterval=0, >0, <0）の3パターンが正しくテストされているか確認
- [ ] タグフィルタリングのロジックで、全タグ一致が必要な仕様がテストケースに反映されているか確認
- [ ] RetryHttpInitializerWrapperのリトライ判定ロジック（Credential優先、バックオフ次点）が正しくカバーされているか確認
- [ ] GceInstancesServiceImpl.resolveProject()/resolveZones()のメタデータサーバーフォールバックのモック方法を確認
- [ ] GceNameResolverの各GceAddressResolverType（gce, gce:hostname, gce:privateIp, gce:privateIp:X）の解決パスが正しいか確認
- [ ] FIPSモード対応（BCFKSキーストア）のテスト実行可能性を確認
