---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 59
  claims_with_evidence: 56
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：plugins-ingest-attachment 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：56 / 59、根拠なし：3
- 優先レビュー（高）
  1. **C-45 (TikaException伝播テスト)**：PrivilegedActionException内部のTikaExceptionアンボクシングの実行時動作は直接確認困難
  2. **C-46 (IOException伝播テスト)**：PrivilegedActionException内部のIOExceptionアンボクシングの実行時動作は直接確認困難
  3. **C-51 (不正URI処理テスト)**：URISyntaxExceptionの発生条件はURL.toURI()の実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/ingest-attachment/src/main/java/org/opensearch/ingest/attachment/AttachmentProcessor.java` (AttachmentProcessorクラス全体: 297行)
- E-02: `plugins/ingest-attachment/src/main/java/org/opensearch/ingest/attachment/IngestAttachmentPlugin.java` (IngestAttachmentPluginクラス: 49行)
- E-03: `plugins/ingest-attachment/src/main/java/org/opensearch/ingest/attachment/TikaImpl.java` (TikaImplクラス: 255行)
- E-04: AttachmentProcessor.java L61-91 (コンストラクタとフィールド定義)
- E-05: AttachmentProcessor.java L98-204 (executeメソッド)
- E-06: AttachmentProcessor.java L227-275 (Factoryクラス)
- E-07: AttachmentProcessor.java L277-295 (Property列挙型)
- E-08: TikaImpl.java L165-185 (parseメソッド)
- E-09: TikaImpl.java L197-236 (getRestrictedPermissionsメソッド)
- E-10: TikaImpl.java L240-253 (addReadPermissionsメソッド)
- E-11: AttachmentProcessor.java L65 (NUMBER_OF_CHARS_INDEXED = 100000)
- E-12: AttachmentProcessor.java L229 (DEFAULT_PROPERTIES = EnumSet.allOf(Property.class))

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 有効なBase64エンコード済みドキュメントが正しくパースされる | E-05 (L98-204) | ○ |
| C-02 | CONTENTプロパティでコンテンツが抽出される | E-05 (L131-134) | ○ |
| C-03 | LANGUAGEプロパティで言語が検出される | E-05 (L136-142) | ○ |
| C-04 | DATEプロパティで作成日が抽出される | E-05 (L144-149) | ○ |
| C-05 | TITLEプロパティでタイトルが抽出される | E-05 (L151-156) | ○ |
| C-06 | AUTHORプロパティで著者が抽出される | E-05 (L158-162) | ○ |
| C-07 | AUTHORがない場合にCreatorにフォールバック | E-05 (L163-168) | ○ |
| C-08 | KEYWORDSプロパティでキーワードが抽出される | E-05 (L171-175) | ○ |
| C-09 | KEYWORDSがない場合にSubjectにフォールバック | E-05 (L176-181) | ○ |
| C-10 | CONTENT_TYPEプロパティでコンテンツタイプが抽出される | E-05 (L184-189) | ○ |
| C-11 | CONTENT_LENGTHメタデータありの場合にlong値が使用される | E-05 (L191-199) | ○ |
| C-12 | CONTENT_LENGTHメタデータなしの場合にparsedContent長が使用される | E-05 (L196-198) | ○ |
| C-13 | indexedCharsFieldからインデックス文字数を取得 | E-05 (L111-118) | ○ |
| C-14 | indexedCharsFieldのフィールドがない場合にデフォルトにフォールバック | E-05 (L114-117) | ○ |
| C-15 | ignoreMissing=trueでフィールドnullならドキュメント返却 | E-05 (L103-104) | ○ |
| C-16 | ignoreMissing=falseでフィールドnullならIllegalArgumentException | E-05 (L105-106) | ○ |
| C-17 | パース不可能時にOpenSearchParseException | E-05 (L127-128) | ○ |
| C-18 | ZeroByteFileException時にエラーにならない | E-05 (L124-126) | ○ |
| C-19 | 空コンテンツ時にCONTENTが追加されない | E-05 (L131, Strings.hasLength) | ○ |
| C-20 | 空コンテンツ時にLANGUAGEが追加されない | E-05 (L136, Strings.hasLength) | ○ |
| C-21 | 全プロパティ指定時に全メタデータ抽出 | E-05, E-12 | ○ |
| C-22 | 空セットプロパティ時に空Map設定 | E-05 (L202) | ○ |
| C-23 | getType()が'attachment'を返却 | E-01 (L63, L208) | ○ |
| C-24 | getField()がfield値を返却 | E-01 (L211-213) | ○ |
| C-25 | getTargetField()がtargetField値を返却 | E-01 (L215-217) | ○ |
| C-26 | getProperties()がproperties値を返却 | E-01 (L219-221) | ○ |
| C-27 | getIndexedChars()がindexedChars値を返却 | E-01 (L223-225) | ○ |
| C-28 | isIgnoreMissing()がignoreMissing値を返却 | E-01 (L93-95) | ○ |
| C-29 | Factory.createで必須パラメータのみで生成 | E-06 (L232-274) | ○ |
| C-30 | Factory.createで全オプション指定で生成 | E-06 (L238-243) | ○ |
| C-31 | propertiesパラメータ指定時に選択プロパティのみ | E-06 (L246-259) | ○ |
| C-32 | properties未指定時にDEFAULT_PROPERTIES使用 | E-06 (L260-261), E-12 | ○ |
| C-33 | 不正propertyNameで設定例外 | E-06 (L251-258) | ○ |
| C-34 | field未指定で例外 | E-06 (L238, readStringProperty) | ○ |
| C-35 | Property.parseで小文字から列挙値 | E-07 (L288-289) | ○ |
| C-36 | Property.parseで大文字から列挙値 | E-07 (L288-289) | ○ |
| C-37 | Property.parseで大小混在から列挙値 | E-07 (L288-289) | ○ |
| C-38 | Property.parseで存在しない名前で例外 | E-07 (L289, valueOf) | ○ |
| C-39 | Property.toLowerCaseでCONTENT_TYPEが'content_type' | E-07 (L292-293) | ○ |
| C-40 | Property.toLowerCaseでCONTENTが'content' | E-07 (L292-293) | ○ |
| C-41 | getProcessors()がAttachmentProcessor.Factoryを返却 | E-02 (L45-47) | ○ |
| C-42 | 返却Mapのサイズが1 | E-02 (L46, Collections.singletonMap) | ○ |
| C-43 | TikaImpl.parseでテキスト抽出 | E-08 (L165-185) | ○ |
| C-44 | TikaImpl.parseでlimitにより文字数制限 | E-08 (L171, parseToString limit引数) | ○ |
| C-45 | TikaImpl.parseでTikaException伝播 | E-08 (L177-178) | △ |
| C-46 | TikaImpl.parseでIOException伝播 | E-08 (L179-180) | △ |
| C-47 | getRestrictedPermissionsで最小権限セット返却 | E-09 (L197-236) | ○ |
| C-48 | PermissionCollectionがreadOnly | E-09 (L234) | ○ |
| C-49 | addReadPermissionsでディレクトリ権限追加 | E-10 (L244-245) | ○ |
| C-50 | addReadPermissionsでファイル権限追加 | E-10 (L246-247) | ○ |
| C-51 | addReadPermissionsで不正URIでRuntimeException | E-10 (L250-252) | △ |
| C-52 | indexedChars=0でコンテンツが空 | E-05 (L123, parseToString limit=0) | ○ |
| C-53 | カスタムtargetFieldにデータ設定 | E-05 (L202) | ○ |
| C-54 | CONTENTのtrim処理 | E-05 (L133, parsedContent.trim()) | ○ |
| C-55 | DATE指定だがメタデータなしの場合にdateなし | E-05 (L145-148) | ○ |
| C-56 | TITLE指定だがメタデータなしの場合にtitleなし | E-05 (L152-155) | ○ |
| C-57 | AUTHOR指定だがAuthorもCreatorもない場合にauthorなし | E-05 (L158-168) | ○ |
| C-58 | KEYWORDS指定だがKeywordsもSubjectもない場合にkeywordsなし | E-05 (L171-181) | ○ |
| C-59 | CONTENT_TYPE指定だがメタデータなしの場合にcontent_typeなし | E-05 (L185-188) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-45, C-46: TikaImpl.parseメソッド内のPrivilegedExceptionActionにおけるTikaException/IOExceptionのアンボクシング動作は、実際のTikaパーサの例外発生をトリガーする必要があり、ユニットテストでの直接的な根拠確認が困難。コードレベルでは分岐は明確に記述されている（L177-180）が、実行パスの完全な検証にはインテグレーションテストが必要。
  - 候補：Tikaの既存テストスイート / モック化によるPrivilegedActionExceptionのシミュレーション
- C-51: URISyntaxExceptionの発生は、URL.toURI()の内部実装に依存する。不正なURLを構成するテストデータの作成が必要。
  - 候補：カスタムURLオブジェクトの構成 / モックの使用

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アクセサメソッド（getField, getTargetField等）のテストケース（C-24〜C-28）は自明
- 0: 低リスク - Property列挙型のparse/toLowerCaseテスト（C-35〜C-40）はJava標準APIの動作に依存
- 1: 中リスク - TikaImpl.parseの例外伝播テスト（C-45, C-46）はセキュリティマネージャ環境下での動作確認が必要
- 1: 中リスク - getRestrictedPermissionsテスト（C-47, C-48）はクラスパス・環境依存の権限設定を含む
- 0: 低リスク - IngestAttachmentPluginのテスト（C-41, C-42）はシンプルなファクトリ登録の確認

## 6) レビュアーチェックリスト（最小）
- [ ] executeメソッドの全条件分岐（各Propertyの有無、メタデータの有無）がテストケースでカバーされているか
- [ ] ignoreMissing=true/falseの両パターンが網羅されているか
- [ ] indexedCharsFieldのフォールバック動作が正しくテストされているか
- [ ] Factory.createの不正入力パターン（不正プロパティ名、必須パラメータ欠如）が網羅されているか
- [ ] TikaImpl.parseの例外ハンドリング（TikaException, IOException, ZeroByteFileException）が全パスでテストされているか
- [ ] セキュリティ権限関連（getRestrictedPermissions, addReadPermissions）のテスト実行環境が適切か確認
