---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 73
  claims_with_evidence: 73
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：plugins-ingestion-fs 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：73 / 73、根拠なし：0
- 優先レビュー（高）
  1. **UT-IFS-071 getPointerBasedLag 境界値**: 全行読み取り後のラグが負になる可能性があるが、仕様として意図的かどうか確認が必要
  2. **UT-IFS-057 readFromFile 巻き戻し**: reader再生成のスレッドセーフティ確認推奨
  3. **UT-IFS-048 コンストラクタ異常系**: ファイル未存在時のログ出力レベル（warn）の妥当性確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/ingestion-fs/src/main/java/org/opensearch/plugin/ingestion/fs/FileOffset.java`
- E-02: `plugins/ingestion-fs/src/main/java/org/opensearch/plugin/ingestion/fs/FileMessage.java`
- E-03: `plugins/ingestion-fs/src/main/java/org/opensearch/plugin/ingestion/fs/FileSourceConfig.java`
- E-04: `plugins/ingestion-fs/src/main/java/org/opensearch/plugin/ingestion/fs/FileConsumerFactory.java`
- E-05: `plugins/ingestion-fs/src/main/java/org/opensearch/plugin/ingestion/fs/FilePlugin.java`
- E-06: `plugins/ingestion-fs/src/main/java/org/opensearch/plugin/ingestion/fs/FilePartitionConsumer.java`
- E-07: `plugins/ingestion-fs/src/main/java/org/opensearch/plugin/ingestion/fs/package-info.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FileOffset コンストラクタは正のline値で初期化できる | E-01 (L29-32) | ○ |
| C-02 | FileOffset コンストラクタはline=0で初期化できる | E-01 (L30: assert line >= 0) | ○ |
| C-03 | FileOffset コンストラクタはLong.MAX_VALUEで初期化できる | E-01 (L29: long型引数) | ○ |
| C-04 | getLine()はコンストラクタで設定した値を返す | E-01 (L37-39) | ○ |
| C-05 | serialize()はLong.BYTESサイズのバイト配列を返す | E-01 (L42-46) | ○ |
| C-06 | serialize()は境界値0を正しくシリアライズする | E-01 (L42-46) | ○ |
| C-07 | asString()はline値を文字列化して返す | E-01 (L49-51) | ○ |
| C-08 | asString()は0を文字列"0"として返す | E-01 (L49-51) | ○ |
| C-09 | asPointField()はLongPointフィールドを生成する | E-01 (L54-56) | ○ |
| C-10 | newRangeQueryGreaterThan()はline以上のレンジクエリを生成する | E-01 (L59-61) | ○ |
| C-11 | compareTo()は同値で0を返す | E-01 (L64-68) | ○ |
| C-12 | compareTo()は大きい値で正を返す | E-01 (L68: Long.compare) | ○ |
| C-13 | compareTo()は小さい値で負を返す | E-01 (L68: Long.compare) | ○ |
| C-14 | compareTo()はnull入力でIllegalArgumentExceptionをスローする | E-01 (L65-67) | ○ |
| C-15 | compareTo()は異なる型でIllegalArgumentExceptionをスローする | E-01 (L65-67) | ○ |
| C-16 | equals()は同値でtrueを返す | E-01 (L72-76) | ○ |
| C-17 | equals()は異値でfalseを返す | E-01 (L75) | ○ |
| C-18 | equals()は同一参照でtrueを返す | E-01 (L73) | ○ |
| C-19 | equals()はnullでfalseを返す | E-01 (L74: instanceof) | ○ |
| C-20 | equals()は異なる型でfalseを返す | E-01 (L74: instanceof) | ○ |
| C-21 | hashCode()は同値オブジェクトで同じ値を返す | E-01 (L79-81) | ○ |
| C-22 | toString()は"FileOffset{line=X}"形式を返す | E-01 (L84-86) | ○ |
| C-23 | FileMessageコンストラクタはpayloadとtimestampを保持する | E-02 (L25-28) | ○ |
| C-24 | getPayload()は設定したペイロードを返す | E-02 (L31-33) | ○ |
| C-25 | getPayload()はnullペイロードをそのまま返す | E-02 (L26: フィールド代入のみ) | ○ |
| C-26 | getPayload()は空バイト配列をそのまま返す | E-02 (L26: フィールド代入のみ) | ○ |
| C-27 | getTimestamp()は設定したタイムスタンプを返す | E-02 (L36-38) | ○ |
| C-28 | getTimestamp()はnullタイムスタンプをそのまま返す | E-02 (L27: Long型でnull可) | ○ |
| C-29 | FileSourceConfigはstreamとbase_directoryで初期化される | E-03 (L27-30) | ○ |
| C-30 | streamキー欠落時にgetStream()がnullを返す | E-03 (L28: Map.get) | ○ |
| C-31 | base_directoryキー欠落時にgetBaseDirectory()がnullを返す | E-03 (L29: Map.get) | ○ |
| C-32 | 空Map時に両フィールドがnullになる | E-03 (L28-29: Map.get) | ○ |
| C-33 | getStream()は設定値を返す | E-03 (L35-37) | ○ |
| C-34 | getBaseDirectory()は設定値を返す | E-03 (L42-44) | ○ |
| C-35 | FileConsumerFactoryのデフォルトコンストラクタでインスタンス生成 | E-04 (L24) | ○ |
| C-36 | initialize()でIngestionSourceからconfigが設定される | E-04 (L27-29) | ○ |
| C-37 | createShardConsumer()でFilePartitionConsumerが生成される | E-04 (L32-35) | ○ |
| C-38 | parsePointerFromString()で数値文字列からFileOffset生成 | E-04 (L38-40) | ○ |
| C-39 | parsePointerFromString()で"0"からFileOffset(0)生成 | E-04 (L39: Long.parseLong) | ○ |
| C-40 | parsePointerFromString()で非数値文字列はNumberFormatException | E-04 (L39: Long.parseLong) | ○ |
| C-41 | parsePointerFromString()でnullはNullPointerException | E-04 (L39: Long.parseLong(null)) | ○ |
| C-42 | FilePluginのデフォルトコンストラクタでインスタンス生成 | E-05 (L30) | ○ |
| C-43 | getIngestionConsumerFactories()はキー"FILE"のMapを返す | E-05 (L34-36) | ○ |
| C-44 | getIngestionConsumerFactories()のMapサイズは1 | E-05 (L35: Map.of) | ○ |
| C-45 | getType()は"FILE"を返す | E-05 (L39-41) | ○ |
| C-46 | 定数TYPEは"FILE" | E-05 (L25) | ○ |
| C-47 | FilePartitionConsumerは存在するファイルで正しく初期化 | E-06 (L48-59) | ○ |
| C-48 | FilePartitionConsumerは存在しないファイルでも生成可能(警告ログ) | E-06 (L54-55) | ○ |
| C-49 | readNext(offset)はincludeStart=trueでoffsetから読む | E-06 (L62-66) | ○ |
| C-50 | readNext(offset)はincludeStart=falseでoffset+1から読む | E-06 (L64) | ○ |
| C-51 | readNext(offset)はmaxMessages=1で1件のみ返す | E-06 (L98) | ○ |
| C-52 | readNext(offset)はファイル末尾超過で空リスト返却 | E-06 (L92-95, L98) | ○ |
| C-53 | readNext(offset)はファイル未存在時に空リスト返却 | E-06 (L76-78) | ○ |
| C-54 | readNext(maxMessages)は前回位置の次から読む | E-06 (L69-71) | ○ |
| C-55 | readNext(maxMessages)は初回時に0行目から読む | E-06 (L70: lastReadLine + 1, 初期値-1) | ○ |
| C-56 | readFromFile()はstartLineまでスキップする | E-06 (L92-95) | ○ |
| C-57 | readFromFile()はstartLine < currentLineで巻き戻す | E-06 (L86-90) | ○ |
| C-58 | readFromFile()は空ファイルで空リスト返却 | E-06 (L98) | ○ |
| C-59 | ReadResultのFileMessageはUTF-8バイト配列を含む | E-06 (L100: StandardCharsets.UTF_8) | ○ |
| C-60 | earliestPointer()はFileOffset(0)を返す | E-06 (L114-116) | ○ |
| C-61 | latestPointer()はファイル行数のFileOffsetを返す | E-06 (L119-136) | ○ |
| C-62 | latestPointer()はファイル未存在時にFileOffset(0)を返す | E-06 (L120-122) | ○ |
| C-63 | latestPointer()は空ファイルでFileOffset(0)を返す | E-06 (L129-132) | ○ |
| C-64 | pointerFromTimestampMillis()はearliestPointer()を返す | E-06 (L144-146) | ○ |
| C-65 | pointerFromOffset()は文字列からFileOffset生成 | E-06 (L149-151) | ○ |
| C-66 | pointerFromOffset()は非数値文字列でNumberFormatException | E-06 (L150: Long.parseLong) | ○ |
| C-67 | getShardId()は設定値を返す | E-06 (L154-156) | ○ |
| C-68 | getPointerBasedLag()は未読み取り時にexpectedStartPointerからのラグを返す | E-06 (L165-168) | ○ |
| C-69 | getPointerBasedLag()は読み取り済み時に残り行数を返す | E-06 (L170-171) | ○ |
| C-70 | getPointerBasedLag()はファイル未存在時に0を返す | E-06 (L160-162) | ○ |
| C-71 | getPointerBasedLag()は全行読み取り済みのラグ計算 | E-06 (L171) | ○ |
| C-72 | close()はreader非nullの場合readerを閉じる | E-06 (L175-179) | ○ |
| C-73 | close()はreader nullの場合に例外なし | E-06 (L176-178: null check) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません。全73件の主張すべてにソースコードの根拠があります。
- ただし、以下の点は実行時テストで検証が必要です：
  - FilePartitionConsumerのreadFromFile()メソッドのsynchronizedブロックにおけるスレッドセーフティの実際の動作
  - IOExceptionが発生するケース（ファイルシステムのパーミッション問題等）の実機検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - FileOffset, FileMessage, FileSourceConfig, FilePlugin: シンプルなデータクラス・設定クラスのため、テストケースは高い信頼性を持つ
- 1: 中リスク - FilePartitionConsumer.getPointerBasedLag(): 全行読み取り後のラグ計算で負の値(-1)が返る可能性がある（UT-IFS-071）。仕様として意図的かどうかの確認推奨
- 1: 中リスク - FilePartitionConsumer.readFromFile(): synchronizedメソッドだが、reader状態管理の巻き戻しロジックが正しく動作するかの実機検証推奨
- 0: 低リスク - FileConsumerFactory: initialize()未呼び出し時のcreateShardConsumer()はassertで保護されているが、テスト対象としなかった（assert無効化環境では不定動作の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] FileOffset.compareTo()のnullおよび型不一致テストケース(UT-IFS-014, UT-IFS-015)が実際のIngestionShardPointer実装で検証可能か確認
- [ ] FilePartitionConsumer.getPointerBasedLag()のラグ計算(UT-IFS-068~071)が仕様と一致しているか確認（特に全行読み取り済み時の負の値）
- [ ] FileConsumerFactory.initialize()未呼び出し時のcreateShardConsumer()のassert動作を-eaフラグの有無で確認
- [ ] FilePartitionConsumer.readFromFile()のIOException発生時のRuntimeException変換(UT-IFS-053関連)が適切か確認
- [ ] テストケース全体で正常系・異常系・境界値のバランスが適切か確認
