---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 75
  claims_with_evidence: 72
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：plugins-ingestion-kafka 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：72 / 75、根拠なし：3
- 優先レビュー（高）
  1. **C-34 (UT-KFK-034)**：KafkaSourceConfigのtopic未指定時の例外 - ConfigurationUtils.readStringPropertyの内部挙動に依存
  2. **C-35 (UT-KFK-035)**：KafkaSourceConfigのbootstrap_servers未指定時の例外 - ConfigurationUtils.readStringPropertyの内部挙動に依存
  3. **C-45 (UT-KFK-045)**：KafkaConsumerFactory.createShardConsumerの戻り値検証 - 実際のKafka接続が必要なため統合テスト寄り

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaOffset.java`（96行）
- E-02: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaMessage.java`（51行）
- E-03: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaSourceConfig.java`（87行）
- E-04: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaPlugin.java`（41行）
- E-05: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaConsumerFactory.java`（44行）
- E-06: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaPartitionConsumer.java`（299行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KafkaOffset: 正の整数でインスタンス生成 | E-01 (L29-32) | ○ |
| C-02 | KafkaOffset: offset=0で生成可能 | E-01 (L30: assert offset >= 0) | ○ |
| C-03 | KafkaOffset: Long.MAX_VALUEで生成可能 | E-01 (L30: assert offset >= 0) | ○ |
| C-04 | KafkaOffset.serialize: バイト配列にシリアライズ | E-01 (L35-38) | ○ |
| C-05 | KafkaOffset.serialize: offset=0のシリアライズ | E-01 (L35-38) | ○ |
| C-06 | KafkaOffset.asString: 文字列変換 | E-01 (L42-44) | ○ |
| C-07 | KafkaOffset.asPointField: LongPointフィールド生成 | E-01 (L47-49) | ○ |
| C-08 | KafkaOffset.newRangeQueryGreaterThan: レンジクエリ生成 | E-01 (L52-54) | ○ |
| C-09 | KafkaOffset.getOffset: オフセット取得 | E-01 (L60-62) | ○ |
| C-10 | KafkaOffset.toString: 文字列表現フォーマット | E-01 (L65-67) | ○ |
| C-11 | KafkaOffset.compareTo: 等値比較で0 | E-01 (L70-78) | ○ |
| C-12 | KafkaOffset.compareTo: 大きい値との比較で正 | E-01 (L70-78) | ○ |
| C-13 | KafkaOffset.compareTo: 小さい値との比較で負 | E-01 (L70-78) | ○ |
| C-14 | KafkaOffset.compareTo: null入力でIllegalArgumentException | E-01 (L72-73) | ○ |
| C-15 | KafkaOffset.compareTo: 型不一致でIllegalArgumentException | E-01 (L74-76) | ○ |
| C-16 | KafkaOffset.equals: 同一オフセットでtrue | E-01 (L81-90) | ○ |
| C-17 | KafkaOffset.equals: 異なるオフセットでfalse | E-01 (L81-90) | ○ |
| C-18 | KafkaOffset.equals: nullでfalse | E-01 (L85-86) | ○ |
| C-19 | KafkaOffset.equals: 異なる型でfalse | E-01 (L85-86) | ○ |
| C-20 | KafkaOffset.equals: 自分自身でtrue | E-01 (L82-84) | ○ |
| C-21 | KafkaOffset.hashCode: 同じオフセットで同じhashCode | E-01 (L93-95) | ○ |
| C-22 | KafkaMessage: key・payload・timestampの設定 | E-02 (L28-32) | ○ |
| C-23 | KafkaMessage: keyがnullでも生成可能 | E-02 (L28: @Nullable byte[] key) | ○ |
| C-24 | KafkaMessage.getKey: key取得 | E-02 (L38-40) | ○ |
| C-25 | KafkaMessage.getKey: null keyの取得 | E-02 (L28, L38-40) | ○ |
| C-26 | KafkaMessage.getPayload: payload取得 | E-02 (L43-45) | ○ |
| C-27 | KafkaMessage.getTimestamp: timestamp取得 | E-02 (L48-50) | ○ |
| C-28 | KafkaSourceConfig: 必須パラメータでインスタンス生成 | E-03 (L36-56) | ○ |
| C-29 | KafkaSourceConfig: auto.offset.resetデフォルト値"none" | E-03 (L43) | ○ |
| C-30 | KafkaSourceConfig: auto.offset.reset明示的指定 | E-03 (L43) | ○ |
| C-31 | KafkaSourceConfig: max.poll.recordsデフォルトとしてmaxPollSize使用 | E-03 (L47) | ○ |
| C-32 | KafkaSourceConfig: max.poll.records明示的指定が優先 | E-03 (L47) | ○ |
| C-33 | KafkaSourceConfig: topicとbootstrap_serversの除外 | E-03 (L50-51) | ○ |
| C-34 | KafkaSourceConfig: topic未指定でエラー | E-03 (L38: ConfigurationUtils.readStringProperty) | △ |
| C-35 | KafkaSourceConfig: bootstrap_servers未指定でエラー | E-03 (L39: ConfigurationUtils.readStringProperty) | △ |
| C-36 | KafkaSourceConfig.getTopic: トピック名取得 | E-03 (L62-64) | ○ |
| C-37 | KafkaSourceConfig.getBootstrapServers: サーバー取得 | E-03 (L70-72) | ○ |
| C-38 | KafkaSourceConfig.getAutoOffsetResetConfig: 設定取得 | E-03 (L80-82) | ○ |
| C-39 | KafkaSourceConfig.getConsumerConfigurations: Map取得 | E-03 (L84-86) | ○ |
| C-40 | KafkaPlugin: インスタンス生成 | E-04 (L29) | ○ |
| C-41 | KafkaPlugin.getIngestionConsumerFactories: ファクトリ登録 | E-04 (L33-35) | ○ |
| C-42 | KafkaPlugin.getType: "KAFKA"返却 | E-04 (L24, L38-40) | ○ |
| C-43 | KafkaConsumerFactory: インスタンス生成 | E-05 (L27) | ○ |
| C-44 | KafkaConsumerFactory.initialize: 設定初期化 | E-05 (L30-32) | ○ |
| C-45 | KafkaConsumerFactory.createShardConsumer: コンシューマ生成 | E-05 (L35-37) | △ |
| C-46 | KafkaConsumerFactory.parsePointerFromString: 正常パース | E-05 (L41-43) | ○ |
| C-47 | KafkaConsumerFactory.parsePointerFromString: "0"パース | E-05 (L41-43) | ○ |
| C-48 | KafkaConsumerFactory.parsePointerFromString: 不正文字列 | E-05 (L42: Long.valueOf) | ○ |
| C-49 | KafkaPartitionConsumer: 正常なパーティションでの生成 | E-06 (L73-90) | ○ |
| C-50 | KafkaPartitionConsumer: 存在しないトピックでエラー | E-06 (L81-83) | ○ |
| C-51 | KafkaPartitionConsumer: 存在しないパーティションでエラー | E-06 (L84-86) | ○ |
| C-52 | KafkaPartitionConsumer.createConsumerProperties: 基本プロパティ | E-06 (L98-108) | ○ |
| C-53 | KafkaPartitionConsumer.createConsumerProperties: オーバーライド | E-06 (L104) | ○ |
| C-54 | KafkaPartitionConsumer.readNext(offset): メッセージ読み取り | E-06 (L145-155) | ○ |
| C-55 | KafkaPartitionConsumer.readNext(offset): includeStart=false | E-06 (L226-230) | ○ |
| C-56 | KafkaPartitionConsumer.readNext(offset): 空結果 | E-06 (L239-250) | ○ |
| C-57 | KafkaPartitionConsumer.readNext(): 連続読み取り | E-06 (L165-170) | ○ |
| C-58 | KafkaPartitionConsumer.earliestPointer: 最初のオフセット | E-06 (L173-179) | ○ |
| C-59 | KafkaPartitionConsumer.earliestPointer: デフォルト値 | E-06 (L176: getOrDefault 0L) | ○ |
| C-60 | KafkaPartitionConsumer.latestPointer: 最後のオフセット | E-06 (L182-187) | ○ |
| C-61 | KafkaPartitionConsumer.latestPointer: デフォルト値 | E-06 (L184: getOrDefault 0L) | ○ |
| C-62 | KafkaPartitionConsumer.pointerFromTimestampMillis: 正常変換 | E-06 (L190-218) | ○ |
| C-63 | KafkaPartitionConsumer.pointerFromTimestampMillis: earliest fallback | E-06 (L207-209) | ○ |
| C-64 | KafkaPartitionConsumer.pointerFromTimestampMillis: latest fallback | E-06 (L210-212) | ○ |
| C-65 | KafkaPartitionConsumer.pointerFromTimestampMillis: none fallback error | E-06 (L213-215) | ○ |
| C-66 | KafkaPartitionConsumer.pointerFromTimestampMillis: 空マップ処理 | E-06 (L195-196) | ○ |
| C-67 | KafkaPartitionConsumer.pointerFromOffset: 正常変換 | E-06 (L221-224) | ○ |
| C-68 | KafkaPartitionConsumer.pointerFromOffset: 不正入力 | E-06 (L222: Long.parseLong) | ○ |
| C-69 | KafkaPartitionConsumer.getShardId: パーティションID返却 | E-06 (L254-256) | ○ |
| C-70 | KafkaPartitionConsumer.getPointerBasedLag: 通常ラグ計算 | E-06 (L267-285) | ○ |
| C-71 | KafkaPartitionConsumer.getPointerBasedLag: 初回ラグ計算 | E-06 (L272-277) | ○ |
| C-72 | KafkaPartitionConsumer.getPointerBasedLag: 開始が終了を超過 | E-06 (L276: Math.max(0, ...)) | ○ |
| C-73 | KafkaPartitionConsumer.getPointerBasedLag: エラー時-1返却 | E-06 (L281-283) | ○ |
| C-74 | KafkaPartitionConsumer.close: リソース解放 | E-06 (L288-290) | ○ |
| C-75 | KafkaPartitionConsumer.getClientId: クライアントID返却 | E-06 (L296-298) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-34, C-35: `ConfigurationUtils.readStringProperty`が必須パラメータ未指定時にどのような例外をスローするかは、このクラスの内部実装に依存する。`org.opensearch.core.util.ConfigurationUtils`のソースコードを確認する必要がある。
  - 候補：OpenSearchException / IllegalArgumentException / NullPointerException
- C-45: `KafkaConsumerFactory.createShardConsumer`は内部で`KafkaPartitionConsumer`のコンストラクタを呼び出し、実際のKafkaブローカーへの接続が発生するため、単体テストではモックが必要。テスト可能性の確認が必要。
  - 候補：統合テストとして実施 / KafkaPartitionConsumerのコンストラクタをモック化

## 5) リスクフラグ（レビュー観点）
- 0: KafkaOffset, KafkaMessage - 純粋なデータクラスであり、外部依存なし。テストケースの信頼度は高い。
- 1: KafkaSourceConfig - ConfigurationUtilsの挙動に依存する部分があるが、概ねソースコードから確認可能。
- 1: KafkaConsumerFactory - initialize/createShardConsumerは外部依存があるが、テスト設計は妥当。
- 1: KafkaPartitionConsumer - Kafkaコンシューマのモック化が必要。テスト用コンストラクタ(protected)が提供されており、モック注入が可能。

## 6) レビュアーチェックリスト（最小）
- [ ] ConfigurationUtils.readStringPropertyの例外挙動を確認し、C-34/C-35の期待結果を修正する
- [ ] KafkaConsumerFactory.createShardConsumerのテストがモック環境で実行可能か確認する
- [ ] KafkaPartitionConsumerのfetchメソッド(private)のテストが、readNextを通じて十分にカバーされているか確認する
- [ ] KafkaPartitionConsumerのスレッドセーフ性（synchronizedキーワード）に関するテストケースの追加を検討する
- [ ] AccessController.doPrivilegedでラップされた処理のセキュリティポリシーに関するテストの必要性を検討する
