---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 69
  claims_with_evidence: 66
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：plugins-ingestion-kinesis 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：66 / 69、根拠なし：3
- 優先レビュー（高）
  1. **C-45 (createClient正常系・endpointOverrideなし)**：KinesisClientの内部ビルダー動作はモック/統合テストでのみ検証可能
  2. **C-46 (createClient正常系・endpointOverrideあり)**：URI設定の実際の適用はAWS SDKの内部処理に依存
  3. **C-64 (fetch上限値制限)**：privateメソッドのため直接テスト不可、readNext経由で間接的に検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/ingestion-kinesis/src/main/java/org/opensearch/plugin/kinesis/SequenceNumber.java`
- E-02: `plugins/ingestion-kinesis/src/main/java/org/opensearch/plugin/kinesis/KinesisSourceConfig.java`
- E-03: `plugins/ingestion-kinesis/src/main/java/org/opensearch/plugin/kinesis/KinesisMessage.java`
- E-04: `plugins/ingestion-kinesis/src/main/java/org/opensearch/plugin/kinesis/KinesisConsumerFactory.java`
- E-05: `plugins/ingestion-kinesis/src/main/java/org/opensearch/plugin/kinesis/KinesisShardConsumer.java`
- E-06: `plugins/ingestion-kinesis/src/main/java/org/opensearch/plugin/kinesis/KinesisPlugin.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SequenceNumber: コンストラクタで有効なシーケンス番号を設定 | E-01 (L33-35) | ○ |
| C-02 | SequenceNumber: getSequenceNumberで設定値を取得 | E-01 (L42-44) | ○ |
| C-03 | SequenceNumber: serializeでUTF-8バイト配列を返却 | E-01 (L47-49) | ○ |
| C-04 | SequenceNumber: asStringでシーケンス番号を文字列返却 | E-01 (L52-54) | ○ |
| C-05 | SequenceNumber: asPointFieldでKeywordFieldを生成 | E-01 (L57-59) | ○ |
| C-06 | SequenceNumber: newRangeQueryGreaterThanでTermRangeQuery生成 | E-01 (L62-64) | ○ |
| C-07 | SequenceNumber: toStringで正しいフォーマット返却 | E-01 (L67-69) | ○ |
| C-08 | SequenceNumber: compareTo同値で0返却 | E-01 (L72-80) | ○ |
| C-09 | SequenceNumber: compareTo大小関係（正の値） | E-01 (L79) | ○ |
| C-10 | SequenceNumber: compareTo大小関係（負の値） | E-01 (L79) | ○ |
| C-11 | SequenceNumber: compareTo nullでIllegalArgumentException | E-01 (L73-75) | ○ |
| C-12 | SequenceNumber: compareTo型不一致でIllegalArgumentException | E-01 (L76-78) | ○ |
| C-13 | SequenceNumber: equals同一インスタンスでtrue | E-01 (L84-86) | ○ |
| C-14 | SequenceNumber: equals同値インスタンスの挙動 | E-01 (L83-92) | ○ |
| C-15 | SequenceNumber: equals nullでfalse | E-01 (L88-89) | ○ |
| C-16 | SequenceNumber: equals異なる型でfalse | E-01 (L88-89) | ○ |
| C-17 | SequenceNumber: hashCodeの一貫性 | E-01 (L95-97) | ○ |
| C-18 | SequenceNumber: NON_EXISTING定数の値検証 | E-01 (L26) | ○ |
| C-19 | SequenceNumber: serialize空文字列 | E-01 (L47-49) | ○ |
| C-20 | KinesisSourceConfig: 全必須パラメータで初期化 | E-02 (L35-41) | ○ |
| C-21 | KinesisSourceConfig: endpoint_override指定時の設定 | E-02 (L40) | ○ |
| C-22 | KinesisSourceConfig: endpoint_override未指定時のデフォルト値 | E-02 (L40) | ○ |
| C-23 | KinesisSourceConfig: region欠落で例外 | E-02 (L36) | ○ |
| C-24 | KinesisSourceConfig: stream欠落で例外 | E-02 (L37) | ○ |
| C-25 | KinesisSourceConfig: access_key欠落で例外 | E-02 (L38) | ○ |
| C-26 | KinesisSourceConfig: secret_key欠落で例外 | E-02 (L39) | ○ |
| C-27 | KinesisSourceConfig: getStream | E-02 (L47-49) | ○ |
| C-28 | KinesisSourceConfig: getRegion | E-02 (L55-57) | ○ |
| C-29 | KinesisSourceConfig: getAccessKey | E-02 (L63-65) | ○ |
| C-30 | KinesisSourceConfig: getSecretKey | E-02 (L69-71) | ○ |
| C-31 | KinesisSourceConfig: getEndpointOverride | E-02 (L79-81) | ○ |
| C-32 | KinesisMessage: コンストラクタ | E-03 (L25-28) | ○ |
| C-33 | KinesisMessage: getPayload | E-03 (L31-33) | ○ |
| C-34 | KinesisMessage: getTimestamp | E-03 (L36-38) | ○ |
| C-35 | KinesisMessage: timestamp null | E-03 (L25-28) | ○ |
| C-36 | KinesisMessage: 空ペイロード | E-03 (L25-28) | ○ |
| C-37 | KinesisMessage: nullペイロード | E-03 (L25-28) | ○ |
| C-38 | KinesisConsumerFactory: コンストラクタ | E-04 (L27) | ○ |
| C-39 | KinesisConsumerFactory: initialize | E-04 (L30-32) | ○ |
| C-40 | KinesisConsumerFactory: createShardConsumer | E-04 (L35-38) | ○ |
| C-41 | KinesisConsumerFactory: parsePointerFromString正常 | E-04 (L41-43) | ○ |
| C-42 | KinesisConsumerFactory: parsePointerFromString空文字 | E-04 (L41-43) | ○ |
| C-43 | KinesisShardConsumer: コンストラクタ正常 | E-05 (L75-93) | ○ |
| C-44 | KinesisShardConsumer: コンストラクタ不正シャードID | E-05 (L86-88) | ○ |
| C-45 | KinesisShardConsumer: createClient正常（endpointOverrideなし） | E-05 (L101-117) | △ |
| C-46 | KinesisShardConsumer: createClient正常（endpointOverrideあり） | E-05 (L108-114) | △ |
| C-47 | KinesisShardConsumer: createClient不正URI | E-05 (L111-113) | ○ |
| C-48 | KinesisShardConsumer: readNext(SequenceNumber)正常 | E-05 (L120-134) | ○ |
| C-49 | KinesisShardConsumer: readNext includeStart=true | E-05 (L229) | ○ |
| C-50 | KinesisShardConsumer: readNext レコード0件 | E-05 (L218-243) | ○ |
| C-51 | KinesisShardConsumer: readNext(long, int)正常 | E-05 (L137-142) | ○ |
| C-52 | KinesisShardConsumer: readNext lastShardIterator null | E-05 (L138-140) | ○ |
| C-53 | KinesisShardConsumer: earliestPointer正常 | E-05 (L145-147) | ○ |
| C-54 | KinesisShardConsumer: earliestPointerレコードなし | E-05 (L196-205) | ○ |
| C-55 | KinesisShardConsumer: latestPointer正常 | E-05 (L150-152) | ○ |
| C-56 | KinesisShardConsumer: latestPointerレコードなし | E-05 (L196-205) | ○ |
| C-57 | KinesisShardConsumer: pointerFromTimestampMillis | E-05 (L208-211) | ○ |
| C-58 | KinesisShardConsumer: pointerFromOffset | E-05 (L214-216) | ○ |
| C-59 | KinesisShardConsumer: getShardId | E-05 (L246-248) | ○ |
| C-60 | KinesisShardConsumer: getPointerBasedLag常に0 | E-05 (L255-257) | ○ |
| C-61 | KinesisShardConsumer: close正常 | E-05 (L260-264) | ○ |
| C-62 | KinesisShardConsumer: close kinesisClient null | E-05 (L261-263) | ○ |
| C-63 | KinesisShardConsumer: getClientId | E-05 (L270-272) | ○ |
| C-64 | KinesisShardConsumer: fetch上限値10000制限 | E-05 (L227) | △ |
| C-65 | KinesisShardConsumer: fetchタイムスタンプnull処理 | E-05 (L237) | ○ |
| C-66 | KinesisPlugin: コンストラクタ | E-06 (L29) | ○ |
| C-67 | KinesisPlugin: getIngestionConsumerFactories | E-06 (L33-35) | ○ |
| C-68 | KinesisPlugin: getType | E-06 (L38-40) | ○ |
| C-69 | KinesisPlugin: TYPE定数 | E-06 (L24) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-45, C-46: createClientメソッドは静的メソッドでAWS SDKのKinesisClientBuilderを内部で使用しているため、実際のクライアント生成の検証には統合テストまたはPowerMock等が必要
  - 候補：AWS SDK KinesisClientBuilderのドキュメント / 統合テスト結果
- C-64: fetchメソッドはprivateであり、maxMessagesの上限制限（10000）の検証はreadNextメソッド経由で間接的に行う必要がある
  - 候補：KinesisシャードイテレータAPIの仕様ドキュメント / AWS Kinesis GetRecords APIリファレンス

## 5) リスクフラグ（レビュー観点）
- 0: SequenceNumber, KinesisMessage, KinesisPlugin - 単純なデータクラス・プラグイン登録で低リスク
- 1: KinesisSourceConfig - ConfigurationUtilsの例外挙動に依存（中リスク）
- 1: KinesisConsumerFactory - createShardConsumer内でassert使用（本番環境では無効化される可能性あり、中リスク）
- 2: KinesisShardConsumer - AWS SDKとの連携、ネットワーク通信、状態管理を含む（高リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] SequenceNumber.equalsメソッドが参照比較（==）を使用している点を確認（L91: `sequenceNumber == that.sequenceNumber` はString比較としてバグの可能性あり）
- [ ] KinesisConsumerFactory.createShardConsumerでassert文が使用されている点を確認（本番環境で無効化される場合のnullチェック不足）
- [ ] KinesisShardConsumer.createClientのendpointOverride URI検証が実際に不正URIで例外を投げるか確認
- [ ] KinesisShardConsumer.fetchのmaxMessages上限10000がKinesis APIの制約と一致するか確認
- [ ] KinesisSourceConfigの必須パラメータ欠落時の例外型がConfigurationUtilsの実装と一致するか確認
