---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 86
  claims_with_evidence: 82
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：plugins-mapper-annotated-text 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：82 / 86、根拠なし：4
- 優先レビュー（高）
  1. **C-72（空パッセージ配列のformat）**：Passageが0件の場合のコード上の挙動が明示的にガードされていない
  2. **C-80（空フィールド値のloadFieldValues）**：親クラスの挙動に依存するため直接的根拠なし
  3. **C-41（externalValueの使用）**：externalValueSet()がtrueの場合のパスは条件分岐から読み取れるが実行時動作の検証が必要
  4. **C-38（positions無効でのposition_increment_gap制約）**：buildFieldType内部ロジックの条件分岐から推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - AnnotatedText.parse() メソッド（L202-244）
- E-02: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - AnnotationToken クラス（L252-296）
- E-03: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - AnnotationsInjector クラス（L400-536）
- E-04: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - Builder クラス（L95-185）
- E-05: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - parseCreateField() メソッド（L577-596）
- E-06: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - readToString() メソッド（L385-398）
- E-07: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - AnnotationAnalyzerWrapper クラス（L356-383）
- E-08: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - AnnotatedHighlighterAnalyzer クラス（L324-354）
- E-09: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java` - AnnotatedTextFieldType クラス（L538-552）
- E-10: `plugins/mapper-annotated-text/src/main/java/org/opensearch/search/fetch/subphase/highlight/AnnotatedPassageFormatter.java` - Markup クラス（L104-141）
- E-11: `plugins/mapper-annotated-text/src/main/java/org/opensearch/search/fetch/subphase/highlight/AnnotatedPassageFormatter.java` - MarkupPassage クラス（L67-102）
- E-12: `plugins/mapper-annotated-text/src/main/java/org/opensearch/search/fetch/subphase/highlight/AnnotatedPassageFormatter.java` - mergeAnnotations() メソッド（L144-177）
- E-13: `plugins/mapper-annotated-text/src/main/java/org/opensearch/search/fetch/subphase/highlight/AnnotatedPassageFormatter.java` - format() メソッド（L179-220）
- E-14: `plugins/mapper-annotated-text/src/main/java/org/opensearch/search/fetch/subphase/highlight/AnnotatedPassageFormatter.java` - getIntersectingAnnotations() メソッド（L222-241）
- E-15: `plugins/mapper-annotated-text/src/main/java/org/opensearch/search/fetch/subphase/highlight/AnnotatedTextHighlighter.java` - loadFieldValues() メソッド（L56-75）
- E-16: `plugins/mapper-annotated-text/src/main/java/org/opensearch/search/fetch/subphase/highlight/AnnotatedTextHighlighter.java` - getAnalyzer() メソッド（L77-80）
- E-17: `plugins/mapper-annotated-text/src/main/java/org/opensearch/search/fetch/subphase/highlight/AnnotatedTextHighlighter.java` - getPassageFormatter() メソッド（L82-85）
- E-18: `plugins/mapper-annotated-text/src/main/java/org/opensearch/plugin/mapper/AnnotatedTextPlugin.java` - getMappers() メソッド（L49-51）
- E-19: `plugins/mapper-annotated-text/src/main/java/org/opensearch/plugin/mapper/AnnotatedTextPlugin.java` - getHighlighters() メソッド（L54-56）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マークアップ付きテキストが正しくパースされる | E-01 | ○ |
| C-02 | 複数のアノテーションを含むテキストが正しくパースされる | E-01 | ○ |
| C-03 | マークアップなしのテキストがそのまま返却される | E-01 | ○ |
| C-04 | URLエンコードされた値が正しくデコードされる | E-01 | ○ |
| C-05 | key=value形式でOpenSearchParseExceptionがスローされる | E-01 | ○ |
| C-06 | 空文字列が渡された場合の処理 | E-01 | ○ |
| C-07 | アノテーション値が空の場合 | E-01 | ○ |
| C-08 | オフセットが正しく計算される | E-01 | ○ |
| C-09 | intersectsで重なる範囲の場合trueが返る | E-02 | ○ |
| C-10 | intersectsで重ならない範囲の場合falseが返る | E-02 | ○ |
| C-11 | intersectsの境界値テスト | E-02 | ○ |
| C-12 | intersectsの内包ケース | E-02 | ○ |
| C-13 | equalsで同一値がtrueを返す | E-02 | ○ |
| C-14 | equalsで異なる値がfalseを返す | E-02 | ○ |
| C-15 | equalsでnull比較がfalseを返す | E-02 | ○ |
| C-16 | hashCodeの整合性 | E-02 | ○ |
| C-17 | AnnotationToken.toStringのフォーマット | E-02 | ○ |
| C-18 | numAnnotationsの正常系 | E-01 | ○ |
| C-19 | getAnnotationの正常系 | E-01 | ○ |
| C-20 | getAnnotationの範囲外アクセス | E-01 | ○ |
| C-21 | AnnotatedText.toStringの表現 | E-01 | ○ |
| C-22 | readToStringの正常系 | E-06 | ○ |
| C-23 | readToStringの空Reader | E-06 | ○ |
| C-24 | readToStringのIOException処理 | E-06 | ○ |
| C-25 | readToStringの8KB以上の文字列 | E-06 | ○ |
| C-26 | AnnotationsInjector.setAnnotationsの正常系 | E-03 | ○ |
| C-27 | AnnotationsInjector.setAnnotationsのnull | E-03 | ○ |
| C-28 | AnnotationsInjector.setAnnotationsの空アノテーション | E-03 | ○ |
| C-29 | AnnotationsInjector.resetの正常系 | E-03 | ○ |
| C-30 | incrementTokenのアノテーションなし | E-03 | ○ |
| C-31 | incrementTokenのアノテーション注入 | E-03 | ○ |
| C-32 | incrementTokenの入力枯渇 | E-03 | ○ |
| C-33 | AnnotatedTextFieldType.typeNameの正常系 | E-09 | ○ |
| C-34 | Builder.buildの正常系 | E-04 | ○ |
| C-35 | Builder.buildのindexOptions=NONE | E-04 | ○ |
| C-36 | positionIncrementGapの負の値 | E-04 | ○ |
| C-37 | positionIncrementGapの正の値 | E-04 | ○ |
| C-38 | positions無効でposition_increment_gap設定時の制約 | E-04 | △ |
| C-39 | parseCreateFieldの正常系 | E-05 | ○ |
| C-40 | parseCreateFieldのnull値 | E-05 | ○ |
| C-41 | parseCreateFieldのexternalValue使用 | E-05 | △ |
| C-42 | contentTypeの正常系 | E-05 | ○ |
| C-43 | getMergeBuilderの正常系 | E-04 | ○ |
| C-44 | AnnotationAnalyzerWrapper.getWrappedAnalyzer | E-07 | ○ |
| C-45 | AnnotationAnalyzerWrapper.wrapComponentsのラップ処理 | E-07 | ○ |
| C-46 | AnnotationAnalyzerWrapper.wrapComponentsの二重ラップ防止 | E-07 | ○ |
| C-47 | AnnotatedHighlighterAnalyzer.getWrappedAnalyzer | E-08 | ○ |
| C-48 | AnnotatedHighlighterAnalyzer.setAnnotations | E-08 | ○ |
| C-49 | AnnotatedPassageFormatterコンストラクタ | E-13 | ○ |
| C-50 | setAnnotationsの正常系 | E-14 | ○ |
| C-51 | Markupコンストラクタ | E-10 | ○ |
| C-52 | Markup.isAfterでtrueが返る | E-10 | ○ |
| C-53 | Markup.isAfterでfalseが返る | E-10 | ○ |
| C-54 | Markup.samePositionでtrueが返る | E-10 | ○ |
| C-55 | Markup.samePositionでfalseが返る | E-10 | ○ |
| C-56 | Markup.overlapsでtrueが返る | E-10 | ○ |
| C-57 | Markup.overlapsでfalseが返る | E-10 | ○ |
| C-58 | Markup.overlapsの完全内包 | E-10 | ○ |
| C-59 | Markup.overlapsの境界一致 | E-10 | ○ |
| C-60 | Markup.mergeのmetadata結合 | E-10 | ○ |
| C-61 | Markup.toStringのフォーマット | E-10 | ○ |
| C-62 | addUnlessOverlappingの正常追加 | E-11 | ○ |
| C-63 | addUnlessOverlappingの重複排除 | E-11 | ○ |
| C-64 | addUnlessOverlappingの同一位置マージ | E-11 | ○ |
| C-65 | addUnlessOverlappingの順序付き挿入 | E-11 | ○ |
| C-66 | mergeAnnotationsの正常マージ | E-12 | ○ |
| C-67 | mergeAnnotationsの優先順位 | E-12 | ○ |
| C-68 | mergeAnnotationsのアノテーション0件 | E-12 | ○ |
| C-69 | mergeAnnotationsの検索ヒット0件 | E-12 | ○ |
| C-70 | mergeAnnotationsの範囲外フィルタ | E-12 | ○ |
| C-71 | formatの正常系 | E-13 | ○ |
| C-72 | formatの空パッセージ配列 | E-13 | △ |
| C-73 | formatの複数パッセージ | E-13 | ○ |
| C-74 | formatのPARAGRAPH_SEPARATOR除去 | E-13 | ○ |
| C-75 | formatのNULL_SEPARATOR除去 | E-13 | ○ |
| C-76 | getIntersectingAnnotationsの正常系 | E-14 | ○ |
| C-77 | getIntersectingAnnotationsの交差なし | E-14 | ○ |
| C-78 | getIntersectingAnnotationsのオフセット調整 | E-14 | ○ |
| C-79 | loadFieldValuesの正常系 | E-15 | ○ |
| C-80 | loadFieldValuesの空リスト | E-15 | △ |
| C-81 | getAnalyzerの正常系 | E-16 | ○ |
| C-82 | getPassageFormatterの正常系 | E-17 | ○ |
| C-83 | getMappers のマッパー登録 | E-18 | ○ |
| C-84 | getMappers のMapサイズ | E-18 | ○ |
| C-85 | getHighlighters のハイライター登録 | E-19 | ○ |
| C-86 | getHighlighters のMapサイズ | E-19 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-38: `buildFieldType`メソッド内でindexOptionsとpositionIncrementGapの組み合わせによる例外スロー条件はコードから読み取れるが、実際にIndexOptions.DOCSが渡された場合のFieldType構築パスが複雑であるため、実行時検証が望ましい
  - 候補：統合テスト / BuilderContextを用いた結合テスト
- C-41: `externalValueSet()`がtrueとなるケースはインデクシング時の特殊なコンテキストで発生するため、単体テストでのモック設定が必要
  - 候補：ParseContextのモック / 既存テストの参照
- C-72: `format()`メソッドに空のPassage配列を渡した場合、ループが実行されず空配列が返るはずだが明示的なガード節がないため要確認
  - 候補：実行テスト / Lucene Passage APIのドキュメント
- C-80: `loadFieldValues`が空リストを返す場合の挙動は親クラス`UnifiedHighlighter`の実装に依存する
  - 候補：親クラスの実装調査 / 統合テスト

## 5) リスクフラグ（レビュー観点）
- 0: AnnotatedText.parse() のパース処理は正規表現ベースであり、コードから直接テストケースの入出力を導出可能（低リスク）
- 0: Markup関連の位置計算ロジックはシンプルな比較演算であり、コードから明確に導出可能（低リスク）
- 1: AnnotationsInjector.incrementToken() はLucene TokenStreamの状態管理に依存しており、単体テストにはTokenStreamのモックが必要（中リスク）
- 1: format()メソッドはPassageオブジェクトのモックが必要で、Lucene内部APIへの依存がある（中リスク）
- 0: AnnotatedTextPlugin のプラグイン登録はシンプルなMap返却であり、テストは容易（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] AnnotatedText.parse()のテストケースが正規表現パターン`markdownPattern`の全分岐をカバーしているか確認
- [ ] key=value形式のパース時にOpenSearchParseExceptionがスローされる仕様が現行コード（L223）と一致しているか確認
- [ ] Markup.overlaps()の3つの条件分岐（L131-133）がテストケースで網羅されているか確認
- [ ] AnnotationsInjector.incrementToken()のテストケースがLucene TokenStream APIのモック前提であることを了解しているか確認
- [ ] getIntersectingAnnotationsのfieldValueOffset累積計算（L238）が正しくテストされているか確認
