---
generated_at: 2026-02-03 00:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：plugins-mapper-murmur3 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **C-20（異なる入力値で異なるハッシュ値）**：ハッシュ衝突の可能性は理論的にゼロではないため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/mapper-murmur3/src/main/java/org/opensearch/index/mapper/murmur3/Murmur3FieldMapper.java` - Murmur3FieldMapper本体（行62-165）
- E-02: `plugins/mapper-murmur3/src/main/java/org/opensearch/plugin/mapper/MapperMurmur3Plugin.java` - プラグイン登録クラス（行43-49）
- E-03: `plugins/mapper-murmur3/src/main/java/org/opensearch/index/mapper/murmur3/Murmur3FieldMapper.java` - Defaults内部クラス（行66-72）
- E-04: `plugins/mapper-murmur3/src/main/java/org/opensearch/index/mapper/murmur3/Murmur3FieldMapper.java` - Builder内部クラス（行78-101）
- E-05: `plugins/mapper-murmur3/src/main/java/org/opensearch/index/mapper/murmur3/Murmur3FieldMapper.java` - Murmur3FieldType内部クラス（行106-131）
- E-06: `plugins/mapper-murmur3/src/main/java/org/opensearch/index/mapper/murmur3/Murmur3FieldMapper.java` - parseCreateFieldメソッド（行148-163）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト設定でMurmur3FieldMapperが正しく生成されること | E-04 (Builder.build, 行93-100) | ○ |
| C-02 | stored=trueの設定でMapperが生成されること | E-04 (stored Parameter, 行80) | ○ |
| C-03 | metaパラメータが正しく設定されること | E-04 (meta Parameter, 行81) | ○ |
| C-04 | storedとmetaの2つのパラメータが返却されること | E-04 (getParameters, 行88-89) | ○ |
| C-05 | フィールド名を指定してBuilderが生成されること | E-04 (コンストラクタ, 行83-85) | ○ |
| C-06 | typeNameが"murmur3"を返すこと | E-05 (typeName, 行112-113) | ○ |
| C-07 | SortedNumericIndexFieldData.Builderが返却されること | E-05 (fielddataBuilder, 行117-119) | ○ |
| C-08 | docValuesが無効な場合にエラーがスローされること | E-05 (failIfNoDocValues, 行118) | ○ |
| C-09 | SourceValueFetcherが返却されること | E-05 (valueFetcher, 行123-125) | ○ |
| C-10 | format指定時にSourceValueFetcherが返却されること | E-05 (valueFetcher, 行123-125) | ○ |
| C-11 | termQueryがQueryShardExceptionをスローすること | E-05 (termQuery, 行128-130) | ○ |
| C-12 | termQueryのエラーメッセージにフィールド名が含まれること | E-05 (termQuery, 行129: name()を文字列連結) | ○ |
| C-13 | 文字列値に対してMurmurHash3ハッシュが計算されDocValuesフィールドが追加されること | E-06 (行156-158) | ○ |
| C-14 | stored=trueの場合にStoredFieldも追加されること | E-06 (行159-161) | ○ |
| C-15 | stored=falseの場合にStoredFieldが追加されないこと | E-06 (行159の条件分岐) | ○ |
| C-16 | externalValueが設定されている場合にその値が使用されること | E-06 (行150-151) | ○ |
| C-17 | null値の場合にフィールドが追加されないこと | E-06 (行155のnullチェック) | ○ |
| C-18 | 空文字列の場合にハッシュが計算されること | E-06 (行155: nullでなければハッシュ計算される) | ○ |
| C-19 | 同じ入力値に対して同じハッシュ値が生成されること | E-06 (MurmurHash3.hash128は決定的アルゴリズム) | ○ |
| C-20 | 異なる入力値に対して異なるハッシュ値が生成されること | **根拠不足** | △ |
| C-21 | 非常に長い文字列に対してハッシュが計算されること | E-06 (BytesRef変換は長さ制限なし) | ○ |
| C-22 | マルチバイト文字列に対してハッシュが計算されること | E-06 (BytesRefはUTF-8バイト列を処理) | ○ |
| C-23 | contentTypeが"murmur3"を返すこと | E-01 (contentType, 行143-145, CONTENT_TYPE定数, 行64) | ○ |
| C-24 | getMergeBuilderがBuilderインスタンスを返却すること | E-01 (getMergeBuilder, 行138-140) | ○ |
| C-25 | デフォルトのFieldTypeのIndexOptionsがNONEであること | E-03 (行69) | ○ |
| C-26 | デフォルトのFieldTypeがfreezeされていること | E-03 (行70) | ○ |
| C-27 | PARSERからBuilderが正しく生成されること | E-01 (行103) | ○ |
| C-28 | Murmur3FieldTypeが正しく初期化されること | E-05 (コンストラクタ, 行107-109: isSearchable=false, hasDocValues=true) | ○ |
| C-29 | murmur3タイプのMapperが登録されること | E-02 (getMappers, 行46-48) | ○ |
| C-30 | 返却されるMapが不変であること | E-02 (Collections.singletonMap, 行47) | ○ |
| C-31 | Murmur3FieldMapperが正しく初期化されること | E-01 (コンストラクタ, 行133-135) | ○ |
| C-32 | CONTENT_TYPEが"murmur3"であること | E-01 (行64) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-20「異なる入力値に対して異なるハッシュ値が生成されること」：MurmurHash3は統計的に衝突が少ないハッシュ関数だが、理論的に異なる入力が同じハッシュ値を生成する可能性はゼロではない。テストケースとしては特定の入力ペアで異なるハッシュ値となることを確認する実装テストとして妥当だが、一般的な保証ではない。
  - 候補：MurmurHash3アルゴリズム仕様書 / ハッシュ衝突確率の理論的分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モジュールは小規模（ソースファイル2つ）で、コードの見通しが良く、テストケースの網羅性は高い
- 0: 低リスク - parseCreateFieldメソッドの主要な分岐（externalValue/parser値、null判定、stored判定）はすべてカバーされている
- 1: 中リスク - C-20のハッシュ衝突テストは特定入力に依存するため、テスト設計時に適切な入力ペアの選定が必要

## 6) レビュアーチェックリスト（最小）
- [ ] parseCreateFieldの全分岐（externalValue有無、null判定、stored判定）がテストケースでカバーされているか
- [ ] Murmur3FieldTypeの各publicメソッド（typeName, fielddataBuilder, valueFetcher, termQuery）のテストが網羅されているか
- [ ] MapperMurmur3PluginのgetMappersが正しいMapper登録を検証しているか
- [ ] 境界値テスト（空文字列、長文字列）が適切に設計されているか
- [ ] C-20のハッシュ衝突テストの入力値ペアが適切に選定されるか確認
