---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：plugins-mapper-size

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **C-09（大規模ドキュメントの境界値テスト）**：Integer範囲超過時の挙動が未検証
  2. **C-25（マルチバイト文字のバイト長）**：BytesReference.length()がバイト長を返す前提だが、実装の直接確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/mapper-size/src/main/java/org/opensearch/index/mapper/size/SizeFieldMapper.java` - SizeFieldMapperの全実装
- E-02: `plugins/mapper-size/src/main/java/org/opensearch/plugin/mapper/MapperSizePlugin.java` - MapperSizePluginの実装
- E-03: `plugins/mapper-size/src/internalClusterTest/java/org/opensearch/index/mapper/size/SizeMappingTests.java` - 既存の単体テスト
- E-04: `plugins/mapper-size/src/internalClusterTest/java/org/opensearch/index/mapper/size/SizeMappingIT.java` - 既存の統合テスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | enabled=trueでtrue返却 | E-01 (L91-93), E-03 (L62-77) | ○ |
| C-02 | enabled=falseでfalse返却 | E-01 (L91-93), E-03 (L79-87) | ○ |
| C-03 | デフォルトではfalse | E-01 (L74-77: Explicit<>(false, false)) | ○ |
| C-04 | enabled=trueでソースサイズがドキュメントに追加 | E-01 (L96-103), E-03 (L62-77), E-04 (L123-130) | ○ |
| C-05 | フィールドがstored属性を持つ | E-01 (L102: createFields(..., true, true, false, true)), E-03 (L70-76) | ○ |
| C-06 | フィールドがpoint index属性を持つ | E-01 (L102), E-03 (L70-76) | ○ |
| C-07 | enabled=falseでフィールド未追加 | E-01 (L98-100), E-03 (L79-87) | ○ |
| C-08 | 空JSONドキュメントでサイズが2 | E-01 (L101: context.sourceToParse().source().length()) | ○ |
| C-09 | 大規模ドキュメントでサイズ正確 | E-01 (L102: NumberType.INTEGER) | △ |
| C-10 | contentTypeが"_size"返却 | E-01 (L87-89, L49) | ○ |
| C-11 | getMergeBuilderがBuilderを返す | E-01 (L106-108) | ○ |
| C-12 | getMergeBuilderが設定を引き継ぐ | E-01 (L107: new Builder().init(this)) | ○ |
| C-13 | BuilderからSizeFieldMapper構築 | E-01 (L69-71) | ○ |
| C-14 | getParametersがenabledを含む | E-01 (L64-66) | ○ |
| C-15 | enabled=trueでビルド時にenabled=true | E-01 (L57, L69-71) | ○ |
| C-16 | フィールド型がNumberFieldType(INTEGER) | E-01 (L70: new NumberFieldType(NAME, NumberType.INTEGER)) | ○ |
| C-17 | PARSERデフォルトでenabled=false | E-01 (L74-75: new Explicit<>(false, false)) | ○ |
| C-18 | PARSERからBuilder取得可能 | E-01 (L76: c -> new Builder()) | ○ |
| C-19 | true->falseマッピングマージ | E-01 (L106-108), E-03 (L99-117) | ○ |
| C-20 | false->trueマッピングマージ | E-01 (L57: updateableBoolParam), E-04 (L87-107) | ○ |
| C-21 | NAME定数が"_size" | E-01 (L49) | ○ |
| C-22 | getMetadataMappersがSizeFieldMapperエントリ返却 | E-02 (L46-48) | ○ |
| C-23 | getMetadataMappersのMapサイズが1 | E-02 (L47: Collections.singletonMap) | ○ |
| C-24 | getMetadataMappersのMapが不変 | E-02 (L47: Collections.singletonMap) | ○ |
| C-25 | マルチバイト文字でバイト長が正しい | E-01 (L101) | △ |

## 4) 不足情報（Unknown / Missing）
- C-09: NumberType.INTEGERを使用しているため、Integer.MAX_VALUE（約2GB）を超えるドキュメントでの挙動が不明。実際にはそのような巨大ドキュメントはOpenSearchの制限により処理されない可能性が高いが、明示的な検証根拠がない。
  - 候補：OpenSearchのドキュメントサイズ上限設定 / NumberType.INTEGERのcreateFieldsの実装
- C-25: BytesReference.length()はバイト長を返すと推定されるが、SizeFieldMapper内での直接的なドキュメントやコメントがない。
  - 候補：BytesReferenceのJavadoc / CoreモジュールのBytesReference実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モジュール自体は非常にシンプルで、SizeFieldMapper（約109行）とMapperSizePlugin（約49行）のみで構成
- 0: 低リスク - 既存テスト（SizeMappingTests, SizeMappingIT）が主要な正常系/状態遷移を網羅しており、テストケース設計の妥当性が裏付けられる
- 1: 中リスク - Integer型によるサイズ格納のため、理論上2GB超のドキュメントで問題が発生する可能性がある（実運用上はOpenSearchの制約により影響は軽微）

## 6) レビュアーチェックリスト（最小）
- [ ] C-09: 大規模ドキュメントのテストケースが実運用上の境界値として妥当か確認
- [ ] C-25: マルチバイト文字のバイト長テストが適切なテストデータで実施可能か確認
- [ ] enabled=true/falseの切り替えに関するテストケース（C-19, C-20）がupdateableBoolParamの仕様と整合しているか確認
- [ ] NumberType.INTEGERのcreateFieldsの引数（stored=true, indexed=true, docValues=false, hasPoints=true）がテストケース（C-05, C-06）の期待結果と整合しているか確認
