---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 148
  claims_with_evidence: 145
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：plugins-repository-azure 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：145 / 148、根拠なし：3
- 優先レビュー（高）
  1. **C-046 (UT-AZR-046)**：UnknownHostExceptionの発生条件は環境依存であり、テスト環境でのDNS解決結果が異なる可能性がある
  2. **C-119 (UT-AZR-119)**：InterruptedException発生時のclose()の動作は、スレッド割り込みを手動で発生させる必要があり、テスト実装が複雑
  3. **C-123 (UT-AZR-123)**：Integer.MAX_VALUEを超えるタイムアウト値の設定可否はSettings実装に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureRepositoryPlugin.java`
- E-02: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/ProxySettings.java`
- E-03: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureBlobStore.java`
- E-04: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/LocationMode.java`
- E-05: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureBlobContainer.java`
- E-06: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureStorageSettings.java`
- E-07: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureStorageService.java`
- E-08: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/AzureRepository.java`
- E-09: `plugins/repository-azure/src/main/java/org/opensearch/repositories/azure/TokenCredentialType.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | AzureRepositoryPlugin コンストラクタが AzureStorageService を生成する | E-01 (L65-68) | ○ |
| C-002 | createAzureStoreService が AzureStorageService を返す | E-01 (L71-73) | ○ |
| C-003 | getRepositories が "azure" キーの Map を返す | E-01 (L76-86) | ○ |
| C-004 | getSettings が 16 個の設定を返す | E-01 (L89-108), E-06 | ○ |
| C-005 | getExecutorBuilders が 1 件の ExecutorBuilder を返す | E-01 (L111-113) | ○ |
| C-006 | executorBuilder が ScalingExecutorBuilder(min=0,max=32,30s) を返す | E-01 (L115-117) | ○ |
| C-007 | reload が有効設定で成功する | E-01 (L120-127) | ○ |
| C-008 | reload が空設定で SettingsException をスローする | E-01 (L122-125) | ○ |
| C-009 | ProxySettings コンストラクタが全フィールドを設定する | E-02 (L65-71) | ○ |
| C-010 | getType がコンストラクタで設定した type を返す | E-02 (L73-75) | ○ |
| C-011 | getAddress が InetSocketAddress を返す | E-02 (L77-79) | ○ |
| C-012 | isAuthenticated が username/password 両方設定時 true を返す | E-02 (L89-91) | ○ |
| C-013 | isAuthenticated が username=null 時 false を返す | E-02 (L89-91) | ○ |
| C-014 | isAuthenticated が password=null 時 false を返す | E-02 (L89-91) | ○ |
| C-015 | isAuthenticated が username 空文字時 false を返す | E-02 (L89-91) | ○ |
| C-016 | isAuthenticated が password 空文字時 false を返す | E-02 (L89-91) | ○ |
| C-017 | equals が同一プロパティで true を返す | E-02 (L93-103) | ○ |
| C-018 | equals が異なるプロパティで false を返す | E-02 (L93-103) | ○ |
| C-019 | equals が null で false を返す | E-02 (L95-96) | ○ |
| C-020 | equals が自身で true を返す | E-02 (L95) | ○ |
| C-021 | hashCode が同一プロパティで同じ値を返す | E-02 (L106-108) | ○ |
| C-022 | ProxyType.HTTP.toProxyType() が HTTP を返す | E-02 (L34, L54-61) | ○ |
| C-023 | ProxyType.SOCKS4.toProxyType() が SOCKS4 を返す | E-02 (L42-43, L54-61) | ○ |
| C-024 | ProxyType.SOCKS5.toProxyType() が SOCKS5 を返す | E-02 (L44, L54-61) | ○ |
| C-025 | ProxyType.DIRECT.toProxyType() が SettingsException をスローする | E-02 (L55-59) | ○ |
| C-026 | getTokenCredentialTypes が ["managed"] を返す | E-09 (L15, L23-25) | ○ |
| C-027 | valueOfType("managed") が MANAGED_IDENTITY を返す | E-09 (L27-39) | ○ |
| C-028 | valueOfType が大文字小文字を無視する | E-09 (L29) | ○ |
| C-029 | valueOfType が enum 名でも変換する | E-09 (L29) | ○ |
| C-030 | valueOfType が未サポートタイプで IllegalArgumentException をスローする | E-09 (L33-38) | ○ |
| C-031 | LocationMode に 4 値が定義されている | E-04 (L16-36) | ○ |
| C-032 | load が有効設定から Map を読み込む | E-06 (L411-425) | ○ |
| C-033 | load が default 未定義時に最初の設定を default に設定する | E-06 (L417-422) | ○ |
| C-034 | load が空設定で空 Map を返す | E-06 (L411-425) | ○ |
| C-035 | buildConnectString がアカウントキーで接続文字列を構築する | E-06 (L346-366) | ○ |
| C-036 | buildConnectString が SAS トークンで接続文字列を構築する | E-06 (L346-366) | ○ |
| C-037 | buildConnectString が EndpointSuffix を含める | E-06 (L362-364) | ○ |
| C-038 | buildConnectString がキーも SAS もない場合例外をスローする | E-06 (L349-351) | ○ |
| C-039 | buildConnectString がキーと SAS 両方ある場合例外をスローする | E-06 (L352-354) | ○ |
| C-040 | validateAndCreateProxySettings が DIRECT で NO_PROXY を返す | E-06 (L452-469) | ○ |
| C-041 | validateAndCreateProxySettings が HTTP プロキシで ProxySettings を返す | E-06 (L452-476) | ○ |
| C-042 | validateAndCreateProxySettings が DIRECT+port で例外をスローする | E-06 (L459-462) | ○ |
| C-043 | validateAndCreateProxySettings が DIRECT+host で例外をスローする | E-06 (L459-462) | ○ |
| C-044 | validateAndCreateProxySettings が HTTP+host 空で例外をスローする | E-06 (L463-465) | ○ |
| C-045 | validateAndCreateProxySettings が HTTP+port=0 で例外をスローする | E-06 (L463-465) | ○ |
| C-046 | validateAndCreateProxySettings が不明ホストで例外をスローする | E-06 (L474-476) | △ |
| C-047 | overrideLocationMode が LocationMode を上書きする | E-06 (L490-516) | ○ |
| C-048 | overrideLocationMode が空 Map で空 Map を返す | E-06 (L490-516) | ○ |
| C-049 | getTimeout がタイムアウト値を返す | E-06 (L334-336) | ○ |
| C-050 | getMaxRetries がリトライ回数を返す | E-06 (L338-340) | ○ |
| C-051 | getConnectTimeout が接続タイムアウトを返す | E-06 (L372-374) | ○ |
| C-052 | toString が設定内容を含む文字列を返す | E-06 (L388-404) | ○ |
| C-053 | configure が BlobServiceClientBuilder を設定して返す | E-06 (L518-520) | ○ |
| C-054 | AzureBlobStore コンストラクタが正しく初期化する | E-03 (L109-155) | ○ |
| C-055 | toString がコンテナ名を返す | E-03 (L158-160) | ○ |
| C-056 | getService が AzureStorageService を返す | E-03 (L162-164) | ○ |
| C-057 | getLocationMode が LocationMode を返す | E-03 (L169-171) | ○ |
| C-058 | blobContainer が AzureBlobContainer を返す | E-03 (L174-176) | ○ |
| C-059 | close が service.close() を呼ぶ | E-03 (L179-181) | ○ |
| C-060 | blobExists が存在する blob で true を返す | E-03 (L183-192) | ○ |
| C-061 | blobExists が存在しない blob で false を返す | E-03 (L183-192) | ○ |
| C-062 | deleteBlob が blob を削除する | E-03 (L194-207) | ○ |
| C-063 | deleteBlobDirectory がディレクトリ内 blob を削除する | E-03 (L209-274) | ○ |
| C-064 | deleteBlobDirectory が空ディレクトリで DeleteResult(0,0) を返す | E-03 (L209-274) | ○ |
| C-065 | deleteBlobDirectory が例外で IOException をスローする | E-03 (L268-272) | ○ |
| C-066 | getInputStream が position+length で InputStream を返す | E-03 (L276-289) | ○ |
| C-067 | getInputStream が length=null で position のみで InputStream を返す | E-03 (L283-287) | ○ |
| C-068 | listBlobsByPrefix がプレフィックス一致 blob を返す | E-03 (L291-320) | ○ |
| C-069 | listBlobsByPrefix が prefix=null で全 blob を返す | E-03 (L301) | ○ |
| C-070 | children が子ディレクトリ Map を返す | E-03 (L322-349) | ○ |
| C-071 | writeBlob が blob を書き込む | E-03 (L351-394) | ○ |
| C-072 | writeBlob が failIfAlreadyExists=true で ETag 条件を設定する | E-03 (L361-363) | ○ |
| C-073 | writeBlob が blob 既存で FileAlreadyExistsException をスローする | E-03 (L376-381) | ○ |
| C-074 | stats が操作統計 Map を返す | E-03 (L405-407) | ○ |
| C-075 | Stats.toMap が 6 キー全て 0 で初期化される | E-03 (L430-459) | ○ |
| C-076 | metricsCollector が HEAD で headOperations をインクリメント | E-03 (L126-128) | ○ |
| C-077 | metricsCollector が GET+comp=list で listOperations をインクリメント | E-03 (L132-133) | ○ |
| C-078 | metricsCollector が GET で getOperations をインクリメント | E-03 (L134-135) | ○ |
| C-079 | metricsCollector が PUT+comp=block+blockid で putBlockOperations をインクリメント | E-03 (L143-144) | ○ |
| C-080 | metricsCollector が PUT+comp=blocklist で putBlockListOperations をインクリメント | E-03 (L145-146) | ○ |
| C-081 | metricsCollector が PUT 通常で putOperations をインクリメント | E-03 (L147-152) | ○ |
| C-082 | metricsCollector がステータス 300 以上でインクリメントしない | E-03 (L121-123) | ○ |
| C-083 | AzureBlobContainer コンストラクタが keyPath を設定する | E-05 (L74-79) | ○ |
| C-084 | blobExists が存在する blob で true を返す | E-05 (L82-90) | ○ |
| C-085 | blobExists が存在しない blob で false を返す | E-05 (L82-90) | ○ |
| C-086 | blobExists が URISyntaxException で false を返す | E-05 (L86-88) | ○ |
| C-087 | blobExists が BlobStorageException で false を返す | E-05 (L86-88) | ○ |
| C-088 | readBlob が InputStream を返す | E-05 (L116-118) | ○ |
| C-089 | readBlob(position,length) が InputStream を返す | E-05 (L121-123) | ○ |
| C-090 | openInputStream が SECONDARY_ONLY で blob 不在時 NoSuchFileException をスローする | E-05 (L94-101) | ○ |
| C-091 | openInputStream が 404 で NoSuchFileException をスローする | E-05 (L105-108) | ○ |
| C-092 | openInputStream がその他 BlobStorageException で IOException をスローする | E-05 (L109) | ○ |
| C-093 | readBlobPreferredLength が 4MB を返す | E-05 (L67, L126-128) | ○ |
| C-094 | writeBlob が blobStore.writeBlob を呼ぶ | E-05 (L131-138) | ○ |
| C-095 | writeBlob が URISyntaxException で IOException をスローする | E-05 (L135-137) | ○ |
| C-096 | writeBlobWithMetadata が CryptoMetadata 非 null で UnsupportedOperationException をスローする | E-05 (L149-153) | ○ |
| C-097 | writeBlobWithMetadata が CryptoMetadata=null で writeBlob に委譲する | E-05 (L156) | ○ |
| C-098 | writeBlobAtomic が writeBlob に委譲する | E-05 (L160-162) | ○ |
| C-099 | delete が deleteBlobDirectory を呼ぶ | E-05 (L165-171) | ○ |
| C-100 | delete が URISyntaxException で IOException をスローする | E-05 (L168-170) | ○ |
| C-101 | deleteBlobsIgnoringIfNotExists が複数 blob を並列削除する | E-05 (L174-206) | ○ |
| C-102 | deleteBlobsIgnoringIfNotExists が空リストで正常完了する | E-05 (L176-177) | ○ |
| C-103 | deleteBlobsIgnoringIfNotExists が 404 を無視する | E-05 (L191-194) | ○ |
| C-104 | deleteBlobsIgnoringIfNotExists が 404 以外で IOException をスローする | E-05 (L191-194) | ○ |
| C-105 | listBlobsByPrefix が blobStore.listBlobsByPrefix を呼ぶ | E-05 (L209-218) | ○ |
| C-106 | listBlobsByPrefix が例外で IOException をスローする | E-05 (L214-217) | ○ |
| C-107 | listBlobs が listBlobsByPrefix(null) に委譲する | E-05 (L221-224) | ○ |
| C-108 | children が blobStore.children を呼ぶ | E-05 (L227-234) | ○ |
| C-109 | children が例外で IOException をスローする | E-05 (L231-233) | ○ |
| C-110 | buildKey が keyPath+blobName を返す | E-05 (L236-238) | ○ |
| C-111 | buildKey が blobName=null で keyPath のみを返す | E-05 (L237) | ○ |
| C-112 | AzureStorageService コンストラクタが設定を読み込む | E-07 (L141-148) | ○ |
| C-113 | client(String) が有効クライアント名で BlobServiceClient を返す | E-07 (L158-161, L172-193) | ○ |
| C-114 | client(String) が存在しないクライアント名で SettingsException をスローする | E-07 (L174-175) | ○ |
| C-115 | client(String,BiConsumer) が statsCollector 付きで BlobServiceClient を返す | E-07 (L172-193) | ○ |
| C-116 | refreshAndClearCache が新設定を反映し古い設定を返す | E-07 (L310-321) | ○ |
| C-117 | refreshAndClearCache がクライアントキャッシュをクリアする | E-07 (L313-317) | ○ |
| C-118 | close がクライアントと executor を閉じる | E-07 (L324-337) | ○ |
| C-119 | close が InterruptedException で IOException をスローする | E-07 (L333-336) | △ |
| C-120 | getBlobRequestTimeout が正タイムアウトで Duration を返す | E-07 (L339-358) | ○ |
| C-121 | getBlobRequestTimeout が負タイムアウトで null を返す | E-07 (L349, L357) | ○ |
| C-122 | getBlobRequestTimeout が存在しないクライアント名で SettingsException をスローする | E-07 (L341-343) | ○ |
| C-123 | getBlobRequestTimeout が Integer.MAX_VALUE 超で IllegalArgumentException をスローする | E-07 (L350-352) | △ |
| C-124 | getBlobRequestOptionsForWriteBlob が null を返す | E-07 (L360-362) | ○ |
| C-125 | createRetryPolicy が ExponentialRetryPolicy を作成する | E-07 (L291-301) | ○ |
| C-126 | createRetryPolicy が secondaryHost 付きで作成する | E-07 (L291-301) | ○ |
| C-127 | applyLocationMode が PRIMARY_ONLY でセカンダリなし | E-07 (L254-255) | ○ |
| C-128 | applyLocationMode が SECONDARY_ONLY でセカンダリをメインに設定 | E-07 (L256-261) | ○ |
| C-129 | applyLocationMode が PRIMARY_THEN_SECONDARY でセカンダリをリトライ先に設定 | E-07 (L262-263) | ○ |
| C-130 | applyLocationMode が SECONDARY_THEN_PRIMARY でプライマリをリトライ先に設定 | E-07 (L264-270) | ○ |
| C-131 | applyLocationMode がエンドポイント null で IllegalArgumentException をスローする | E-07 (L249-251) | ○ |
| C-132 | applyLocationMode が SECONDARY_ONLY でセカンダリ URI null で例外をスローする | E-07 (L257-260) | ○ |
| C-133 | AzureRepository コンストラクタが正しく初期化する | E-08 (L112-143) | ○ |
| C-134 | AzureRepository が先頭 / を除去する | E-08 (L123) | ○ |
| C-135 | AzureRepository が空 base_path で cleanPath を使用する | E-08 (L132) | ○ |
| C-136 | AzureRepository が複数階層パスを正しく構築する | E-08 (L127-129) | ○ |
| C-137 | isReadOnly が明示 readonly 設定を返す | E-08 (L138-139) | ○ |
| C-138 | isReadOnly が SECONDARY_ONLY で true を返す | E-08 (L141) | ○ |
| C-139 | isReadOnly が PRIMARY_ONLY で false を返す | E-08 (L141) | ○ |
| C-140 | basePath が設定された BlobPath を返す | E-08 (L177-179) | ○ |
| C-141 | chunkSize が設定された ByteSizeValue を返す | E-08 (L182-184) | ○ |
| C-142 | createBlobStore が AzureBlobStore を生成する | E-08 (L160-174) | ○ |
| C-143 | getRestrictedSystemRepositorySettings が BASE_PATH と LOCATION_MODE を含む | E-08 (L192-198) | ○ |
| C-144 | buildLocation が base_path と container を含む Map を返す | E-08 (L145-152) | ○ |
| C-145 | HttpStatsPolicy.process が statsCollector を呼ぶ | E-07 (L385-388) | ○ |
| C-146 | HttpStatsPolicy.getPipelinePosition が PER_RETRY を返す | E-07 (L391-393) | ○ |
| C-147 | NioThreadFactory.newThread が非デーモン通常優先度スレッドを生成する | E-07 (L435-447) | ○ |
| C-148 | IdentityClientThreadFactory.newThread がデーモンスレッドを生成する | E-07 (L118-127) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-046: UnknownHostException の発生はネットワーク環境に依存する。テスト環境によっては DNS 解決が成功する可能性がある。
  - 候補：モック化 / テスト用の無効ホスト名 / InetAddress のスタブ
- C-119: InterruptedException をテスト中にシミュレートする方法が必要。executor のモック化またはスレッド割り込みの制御が必要。
  - 候補：ExecutorService のモック / Thread.interrupt() / CountDownLatch による制御
- C-123: Integer.MAX_VALUE を超える TimeValue の設定がフレームワーク側で許容されるか確認が必要。
  - 候補：Settings API のバリデーション確認 / TimeValue.timeValueMillis(Long.MAX_VALUE) の動作検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ProxySettings, TokenCredentialType, LocationMode の各テストケース（明確なロジック、根拠あり）
- 0: 低リスク - getter/setter、toString、equals/hashCode のテストケース
- 1: 中リスク - AzureBlobStore, AzureBlobContainer の操作系テストケース（Azure SDK モックが必要）
- 1: 中リスク - metricsCollector のテストケース（BiConsumer のラムダ式内ロジック）
- 1: 中リスク - AzureStorageService の buildClient, applyLocationMode テストケース（Azure SDK 依存）
- 2: 高リスク - 環境依存テスト（DNS 解決、スレッド割り込み、タイムアウト上限）

## 6) レビュアーチェックリスト（最小）
- [ ] AzureStorageSettings.buildConnectString の正常系・異常系テストケースが認証ロジックを網羅しているか確認
- [ ] AzureBlobContainer.openInputStream の SECONDARY_ONLY モード分岐が正しくテストされているか確認
- [ ] metricsCollector のクエリパラメータ判定ロジックが全パターン網羅されているか確認
- [ ] ProxySettings のバリデーションテストケースが全条件分岐をカバーしているか確認
- [ ] AzureRepository.isReadOnly の readonly 設定と LocationMode の組み合わせが網羅されているか確認
- [ ] AzureStorageService.applyLocationMode の全 LocationMode パターンに対するテストケースが存在するか確認
- [ ] 環境依存テスト（C-046, C-119, C-123）の実装可能性を確認
