---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 135
  claims_with_evidence: 131
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：plugins-repository-gcs 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：131 / 135、根拠なし：4
- 優先レビュー（高）
  1. **C-066 (UT-GCS-066)**: FIPSモードでのtruststoreバリデーション - BCFIPSプロバイダの存在チェックはコード上確認済みだが、実環境でのテスト実行可否は要確認
  2. **C-078 (UT-GCS-078)**: 不明ホスト名のDNS解決失敗 - テスト環境でのDNS挙動に依存
  3. **C-127 (UT-GCS-127)**: ADC取得成功 - 環境依存のためテスト実行環境の構成が必要
  4. **C-128 (UT-GCS-128)**: ADC取得失敗 - 環境依存のためモック化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStoragePlugin.java`
- E-02: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageRepository.java`
- E-03: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageBlobStore.java`
- E-04: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageBlobContainer.java`
- E-05: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageService.java`
- E-06: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageClientSettings.java`
- E-07: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageRetryingInputStream.java`
- E-08: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageOperationsStats.java`
- E-09: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleCloudStorageHttpStatsCollector.java`
- E-10: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/ProxySettings.java`
- E-11: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/TruststoreSettings.java`
- E-12: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleApplicationDefaultCredentials.java`
- E-13: `plugins/repository-gcs/src/main/java/org/opensearch/repositories/gcs/GoogleShouldRetryStorageStrategy.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | GoogleCloudStoragePlugin コンストラクタで storageService が生成される | E-01 (L56-60) | ○ |
| C-002 | createStorageService が GoogleCloudStorageService を返す | E-01 (L63-65) | ○ |
| C-003 | getRepositories が "gcs" キーのマップを返す | E-01 (L68-84) | ○ |
| C-004 | getSettings が15個の設定を含むリストを返す | E-01 (L87-105) | ○ |
| C-005 | reload が refreshAndClearCache を呼ぶ | E-01 (L108-116) | ○ |
| C-006 | basePath がスラッシュ区切りで構築される | E-02 (L100-109) | ○ |
| C-007 | basePath が空の場合 cleanPath | E-02 (L107-108) | ○ |
| C-008 | getSetting が正常値を返す | E-02 (L148-157) | ○ |
| C-009 | getSetting で null 時に RepositoryException | E-02 (L150-151) | ○ |
| C-010 | getSetting で空文字列時に RepositoryException | E-02 (L153-154) | ○ |
| C-011 | chunkSize が設定値を返す | E-02 (L132-133) | ○ |
| C-012 | getRestrictedSystemRepositorySettings に BUCKET, BASE_PATH が含まれる | E-02 (L137-143) | ○ |
| C-013 | blobContainer が GoogleCloudStorageBlobContainer を返す | E-03 (L138-140) | ○ |
| C-014 | close が closeRepositoryClient を呼ぶ | E-03 (L143-145) | ○ |
| C-015 | listBlobs が listBlobsByPrefix に委譲 | E-03 (L153-155) | ○ |
| C-016 | listBlobsByPrefix がプレフィックスでフィルタ | E-03 (L166-181) | ○ |
| C-017 | listBlobsByPrefix で 0 件時に空マップ | E-03 (L166-181) | ○ |
| C-018 | listChildren が子ディレクトリマップを返す | E-03 (L183-202) | ○ |
| C-019 | listChildren で 0 件時に空マップ | E-03 (L183-202) | ○ |
| C-020 | blobExists が存在する場合 true | E-03 (L210-214) | ○ |
| C-021 | blobExists が存在しない場合 false | E-03 (L210-214) | ○ |
| C-022 | readBlob(String) が RetryingInputStream を返す | E-03 (L222-224) | ○ |
| C-023 | readBlob(String, long, long) が InputStream を返す | E-03 (L234-251) | ○ |
| C-024 | readBlob で position < 0 の場合 IllegalArgumentException | E-03 (L235-237) | ○ |
| C-025 | readBlob で length < 0 の場合 IllegalArgumentException | E-03 (L238-240) | ○ |
| C-026 | readBlob で length=0 の場合 ByteArrayInputStream | E-03 (L241-242) | ○ |
| C-027 | writeBlob で小サイズは multipart | E-03 (L259-266) | ○ |
| C-028 | writeBlob で大サイズは resumable | E-03 (L259-266) | ○ |
| C-029 | writeBlob で既存 blob 時に FileAlreadyExistsException | E-03 (L341-342, L380-381) | ○ |
| C-030 | writeBlobResumable で HTTP 410 リトライ | E-03 (L282-349) | ○ |
| C-031 | writeBlobResumable で 3 回 410 後に例外 | E-03 (L292, L350-351) | ○ |
| C-032 | deleteDirectory で全削除と DeleteResult 返却 | E-03 (L392-411) | ○ |
| C-033 | deleteDirectory で 0 件時 ZERO | E-03 (L392-411) | ○ |
| C-034 | deleteBlobsIgnoringIfNotExists でバッチ削除 | E-03 (L418-455) | ○ |
| C-035 | deleteBlobsIgnoringIfNotExists で 404 無視 | E-03 (L435-436) | ○ |
| C-036 | deleteBlobsIgnoringIfNotExists で空リスト時に即 return | E-03 (L419-421) | ○ |
| C-037 | deleteBlobsIgnoringIfNotExists で 404 以外の例外時に IOException | E-03 (L434-438, L451-453) | ○ |
| C-038 | stats() が操作統計マップを返す | E-03 (L462-465) | ○ |
| C-039 | BlobContainer コンストラクタでパス設定 | E-04 (L54-58) | ○ |
| C-040 | BlobContainer.blobExists がパス連結で委譲 | E-04 (L61-67) | ○ |
| C-041 | BlobContainer.blobExists で例外時に BlobStoreException | E-04 (L64-66) | ○ |
| C-042 | BlobContainer.listBlobs が委譲 | E-04 (L70-72) | ○ |
| C-043 | BlobContainer.children が委譲 | E-04 (L75-77) | ○ |
| C-044 | BlobContainer.readBlob(String) が委譲 | E-04 (L85-87) | ○ |
| C-045 | BlobContainer.readBlob(String, long, long) が委譲 | E-04 (L90-92) | ○ |
| C-046 | BlobContainer.writeBlob が委譲 | E-04 (L95-97) | ○ |
| C-047 | writeBlobWithMetadata が writeBlob に委譲 | E-04 (L100-109) | ○ |
| C-048 | writeBlobAtomic が writeBlob に委譲 | E-04 (L112-114) | ○ |
| C-049 | BlobContainer.delete が deleteDirectory に委譲 | E-04 (L117-119) | ○ |
| C-050 | BlobContainer.deleteBlobsIgnoringIfNotExists がパス付きで委譲 | E-04 (L122-124) | ○ |
| C-051 | デフォルトコンストラクタで ADC 設定 | E-05 (L83-85) | ○ |
| C-052 | refreshAndClearCache でキャッシュクリア | E-05 (L98-101) | ○ |
| C-053 | client でキャッシュヒット | E-05 (L116-149) | ○ |
| C-054 | client でキャッシュミス時に新規作成 | E-05 (L116-149) | ○ |
| C-055 | client で未知クライアント名時に IllegalArgumentException | E-05 (L133-140) | ○ |
| C-056 | closeRepositoryClient でキャッシュ削除 | E-05 (L151-153) | ○ |
| C-057 | toTimeout で正の値がミリ秒変換 | E-05 (L292-304) | ○ |
| C-058 | toTimeout で null 時に -1 | E-05 (L294-297) | ○ |
| C-059 | toTimeout で ZERO 時に -1 | E-05 (L294-297) | ○ |
| C-060 | toTimeout で MINUS_ONE 時に 0 | E-05 (L299-302) | ○ |
| C-061 | createStorageOptions で user-agent ヘッダー設定 | E-05 (L252-260) | ○ |
| C-062 | credential null 時に ADC 使用 | E-05 (L268-273) | ○ |
| C-063 | credential 設定時に ServiceAccountCredentials 使用 | E-05 (L274-284) | ○ |
| C-064 | tokenUri 設定時に tokenServerUri 更新 | E-05 (L277-282) | ○ |
| C-065 | カスタム truststore ロード | E-05 (L222-246) | ○ |
| C-066 | FIPS モードで truststore 未設定時に IllegalStateException | E-05 (L233-238) | ○ |
| C-067 | getProjectId で projectId 設定時にその値を返す | E-06 (L249-251) | ○ |
| C-068 | getProjectId で projectId 空時に credential の projectId | E-06 (L249-251) | ○ |
| C-069 | getProjectId で両方なし時に null | E-06 (L249-251) | ○ |
| C-070 | load で全クライアント設定ロード | E-06 (L277-288) | ○ |
| C-071 | load で default クライアント自動追加 | E-06 (L282-286) | ○ |
| C-072 | loadCredential で認証情報ロード | E-06 (L374-394) | ○ |
| C-073 | loadCredential で未設定時に null | E-06 (L376-379) | ○ |
| C-074 | validateAndCreateProxySettings で ProxySettings 生成 | E-06 (L304-330) | ○ |
| C-075 | DIRECT 時に NO_PROXY_SETTINGS | E-06 (L320-321) | ○ |
| C-076 | DIRECT で設定値あり時に SettingsException | E-06 (L311-316) | ○ |
| C-077 | 非 DIRECT で host/port 不足時に SettingsException | E-06 (L317-319) | ○ |
| C-078 | 不明ホスト名時に SettingsException | E-06 (L327-329) | △ |
| C-079 | truststore 全未設定時に NO_TRUSTSTORE_SETTINGS | E-06 (L341-343) | ○ |
| C-080 | truststore 全設定時に TruststoreSettings 生成 | E-06 (L359) | ○ |
| C-081 | truststore type 未設定時に SettingsException | E-06 (L344-349) | ○ |
| C-082 | truststore path 未設定時に SettingsException | E-06 (L350-357) | ○ |
| C-083 | RetryingInputStream デフォルトコンストラクタ | E-07 (L86-88) | ○ |
| C-084 | RetryingInputStream start 負で IllegalArgumentException | E-07 (L92-94) | ○ |
| C-085 | RetryingInputStream end < start で IllegalArgumentException | E-07 (L95-97) | ○ |
| C-086 | RetryingInputStream end=MAX_VALUE で IllegalArgumentException | E-07 (L95-97) | ○ |
| C-087 | read() で currentOffset 更新 | E-07 (L209-219) | ○ |
| C-088 | read(byte[], int, int) で currentOffset 更新 | E-07 (L223-237) | ○ |
| C-089 | read() で IOException 時にリトライ | E-07 (L216-218, L247-267) | ○ |
| C-090 | read() で maxAttempts 超過時に例外 | E-07 (L248-249) | ○ |
| C-091 | ensureOpen で close 後に IllegalStateException | E-07 (L239-244) | ○ |
| C-092 | close で closed=true | E-07 (L270-273) | ○ |
| C-093 | skip で UnsupportedOperationException | E-07 (L276-278) | ○ |
| C-094 | reset で UnsupportedOperationException | E-07 (L281-283) | ○ |
| C-095 | openStream で 404 時に NoSuchFileException | E-07 (L151-154) | ○ |
| C-096 | ContentLengthValidatingInputStream read(byte[], int, int) | E-07 (L173-181) | ○ |
| C-097 | ContentLengthValidatingInputStream read() | E-07 (L184-192) | ○ |
| C-098 | checkContentLengthOnEOF で早期切断検出 | E-07 (L201-205) | ○ |
| C-099 | ContentLengthValidatingInputStream skip | E-07 (L195-199) | ○ |
| C-100 | trackGetOperation でカウント増加 | E-08 (L52-54) | ○ |
| C-101 | trackPutOperation でカウント増加 | E-08 (L56-58) | ○ |
| C-102 | trackPostOperation でカウント増加 | E-08 (L60-62) | ○ |
| C-103 | trackListOperation でカウント増加 | E-08 (L64-66) | ○ |
| C-104 | getTrackedBucket が bucketName 返却 | E-08 (L68-70) | ○ |
| C-105 | toMap が 3 キーのマップを返す | E-08 (L72-78) | ○ |
| C-106 | InsertObject が post+put の合計 | E-08 (L76) | ○ |
| C-107 | 初期状態で全カウント 0 | E-08 (L41-44) | ○ |
| C-108 | HttpStatsCollector で 3 つの tracker 初期化 | E-09 (L52-67) | ○ |
| C-109 | download パスで getCount インクリメント | E-09 (L53-56) | ○ |
| C-110 | metadata パスで getCount インクリメント | E-09 (L58-61) | ○ |
| C-111 | list パスで listCount インクリメント | E-09 (L63-66) | ○ |
| C-112 | 非成功ステータスで追跡されない | E-09 (L82) | ○ |
| C-113 | 非対象パスでカウント不変 | E-09 (L85-89) | ○ |
| C-114 | ProxySettings コンストラクタ | E-10 (L32-38) | ○ |
| C-115 | getAddress で InetSocketAddress 生成 | E-10 (L44-46) | ○ |
| C-116 | isAuthenticated で両方設定時 true | E-10 (L56-58) | ○ |
| C-117 | isAuthenticated で username null 時 false | E-10 (L56-58) | ○ |
| C-118 | isAuthenticated で password 空時 false | E-10 (L56-58) | ○ |
| C-119 | equals 同値性 | E-10 (L60-74) | ○ |
| C-120 | equals 非同値性 | E-10 (L60-74) | ○ |
| C-121 | hashCode 一貫性 | E-10 (L76-78) | ○ |
| C-122 | NO_PROXY_SETTINGS が DIRECT | E-10 (L20) | ○ |
| C-123 | TruststoreSettings isConfigured true | E-11 (L24-26) | ○ |
| C-124 | TruststoreSettings isConfigured path null で false | E-11 (L24-26) | ○ |
| C-125 | TruststoreSettings isConfigured type 空で false | E-11 (L24-26) | ○ |
| C-126 | NO_TRUSTSTORE_SETTINGS が isConfigured false | E-11 (L22) | ○ |
| C-127 | ADC 取得成功 | E-12 (L25-33) | △ |
| C-128 | ADC 取得失敗時 null 返却 | E-12 (L25-33) | △ |
| C-129 | getIdempotentHandler が非 null | E-13 (L54-57) | ○ |
| C-130 | getNonidempotentHandler が非 null | E-13 (L59-62) | ○ |
| C-131 | shouldRetry で UnknownHostException 時 true | E-13 (L43-45) | ○ |
| C-132 | shouldRetry で SocketException 時 true | E-13 (L46-48) | ○ |
| C-133 | shouldRetry でその他例外時にデリゲート委譲 | E-13 (L49-50) | ○ |
| C-134 | shouldRetry でラップされた UnknownHostException 時 true | E-13 (L43-45) | △ |
| C-135 | createNextAttempt がデリゲートに委譲 | E-13 (L38-40) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-078: UnknownHostException によるSettingsException - DNS解決失敗はテスト実行環境のネットワーク設定に依存するため、モックを用いたテストが推奨される
  - 候補：InetAddress.getByNameをモック化 / テスト用のinvalidホスト名を使用
- C-127, C-128: GoogleApplicationDefaultCredentials.get() - 環境変数 GOOGLE_APPLICATION_CREDENTIALS やメタデータサーバへの接続に依存
  - 候補：GoogleCredentials.getApplicationDefaultをモック化 / テスト用の環境変数設定
- C-134: ExceptionsHelper.unwrap でラップされた例外の検出 - ExceptionsHelper の挙動に依存するため、ラップ深度のテストが必要
  - 候補：StorageException(cause=UnknownHostException) でテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ProxySettings, TruststoreSettings, GoogleCloudStorageOperationsStats のテストケースは単純なPOJO/recordのため信頼度が高い
- 1: 中リスク - GoogleCloudStorageBlobContainer の委譲テストはモック設計に依存するが、ロジック自体は単純
- 1: 中リスク - GoogleCloudStorageHttpStatsCollector のパスマッチングテストはGCS APIバージョン変更時に影響を受ける可能性がある
- 2: 高リスク - GoogleCloudStorageService.createClient/loadTrustStore は外部依存（SSL証明書、FIPSプロバイダ）が多く、テスト環境構築が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GoogleCloudStorageBlobStore の writeBlob で LARGE_BLOB_THRESHOLD_BYTE_SIZE の境界値テストが十分か確認
- [ ] GoogleCloudStorageRetryingInputStream のリトライロジックで、maxAttempts の設定値に基づくテストケースが正しいか確認
- [ ] GoogleCloudStorageClientSettings.validateAndCreateProxySettings のプロキシ認証テスト（username/password 付き）が網羅されているか確認
- [ ] GoogleCloudStorageService.createStorageOptions のテストで、host/projectId が未設定の場合のデフォルト挙動が検証されているか確認
- [ ] ContentLengthValidatingInputStream の checkContentLengthOnEOF で、contentLength と一致する場合（正常完了）のテストケースが含まれているか確認
