---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 89
  claims_with_evidence: 85
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：plugins-repository-hdfs 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：85 / 89、根拠なし：4
- 優先レビュー（高）
  1. **C-75, C-76（getHostName）**：ネットワーク依存のテストのため、モック化の方針がコードから読み取れない
  2. **C-63（conf.プレフィックス設定のHadoop Configuration反映）**：内部メソッドのため外部から検証しにくい
  3. **C-65（HA有効時のhaEnabled検出）**：FailoverProxyProviderの設定依存で検証が複雑

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsBlobContainer.java`
- E-02: `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsBlobStore.java`
- E-03: `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsPlugin.java`
- E-04: `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsRepository.java`
- E-05: `plugins/repository-hdfs/src/main/java/org/opensearch/repositories/hdfs/HdfsSecurityContext.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | blobExists - 存在するBlobにtrue | E-01 (L84-86) | ○ |
| C-02 | blobExists - 存在しないBlobにfalse | E-01 (L84-86) | ○ |
| C-03 | blobExists - IOExceptionスロー | E-01 (L84-86) | ○ |
| C-04 | delete - 再帰削除とDeleteResult返却 | E-01 (L89-92) | ○ |
| C-05 | delete - IOException伝播 | E-01 (L89-92) | ○ |
| C-06 | deleteBlobsIgnoringIfNotExists - 複数Blob正常削除 | E-01 (L95-113) | ○ |
| C-07 | deleteBlobsIgnoringIfNotExists - FileNotFoundException無視 | E-01 (L100-101) | ○ |
| C-08 | deleteBlobsIgnoringIfNotExists - IOExceptionまとめてスロー | E-01 (L96-113) | ○ |
| C-09 | deleteBlobsIgnoringIfNotExists - 空リスト | E-01 (L95-113) | ○ |
| C-10 | readBlob - InputStream返却 | E-01 (L116-128) | ○ |
| C-11 | readBlob - NoSuchFileException | E-01 (L125-127) | ○ |
| C-12 | readBlob(position, length) - 範囲指定読み取り | E-01 (L131-148) | ○ |
| C-13 | readBlob(position, length) - NoSuchFileException | E-01 (L136-138) | ○ |
| C-14 | readBlob(position, length) - seek失敗時close | E-01 (L140-145) | ○ |
| C-15 | writeBlob - 正常書き込み(failIfAlreadyExists=true) | E-01 (L151-165) | ○ |
| C-16 | writeBlob - 上書き許可(failIfAlreadyExists=false) | E-01 (L154-156) | ○ |
| C-17 | writeBlob - FileAlreadyExistsException | E-01 (L160-162) | ○ |
| C-18 | writeBlobWithMetadata - メタデータ無視で委譲 | E-01 (L167-178) | ○ |
| C-19 | writeBlobAtomic - 一時ファイル経由書き込み | E-01 (L181-194) | ○ |
| C-20 | writeBlobAtomic - 上書きrename | E-01 (L188) | ○ |
| C-21 | writeBlobAtomic - FileAlreadyExistsException | E-01 (L189-190) | ○ |
| C-22 | listBlobsByPrefix - プレフィックス一致Blob返却 | E-01 (L213-224) | ○ |
| C-23 | listBlobsByPrefix - prefix=nullで全件 | E-01 (L215) | ○ |
| C-24 | listBlobsByPrefix - ディレクトリ除外 | E-01 (L219) | ○ |
| C-25 | listBlobsByPrefix - 一致なしで空Map | E-01 (L213-224) | ○ |
| C-26 | listBlobs - listBlobsByPrefix(null)委譲 | E-01 (L227-229) | ○ |
| C-27 | children - 子ディレクトリBlobContainer返却 | E-01 (L232-242) | ○ |
| C-28 | children - ファイル除外 | E-01 (L236) | ○ |
| C-29 | children - 子ディレクトリなしで空Map | E-01 (L232-242) | ○ |
| C-30 | HDFSPrivilegedInputSteam.read() | E-01 (L258-259) | ○ |
| C-31 | HDFSPrivilegedInputSteam.read(byte[]) | E-01 (L262-263) | ○ |
| C-32 | HDFSPrivilegedInputSteam.read(byte[], off, len) | E-01 (L266-267) | ○ |
| C-33 | HDFSPrivilegedInputSteam.skip | E-01 (L270-271) | ○ |
| C-34 | HDFSPrivilegedInputSteam.available | E-01 (L274-275) | ○ |
| C-35 | HDFSPrivilegedInputSteam.reset | E-01 (L278-283) | ○ |
| C-36 | HdfsBlobStore - readOnly=false初期化 | E-02 (L54-73) | ○ |
| C-37 | HdfsBlobStore - readOnly=true初期化 | E-02 (L66-72) | ○ |
| C-38 | HdfsBlobStore - haEnabled=trueでrestrictPermissions=false | E-02 (L58-62) | ○ |
| C-39 | HdfsBlobStore - 既存ディレクトリFileAlreadyExistsException無視 | E-02 (L69-71) | ○ |
| C-40 | HdfsBlobStore.toString | E-02 (L83-85) | ○ |
| C-41 | HdfsBlobStore.blobContainer - HdfsBlobContainer返却 | E-02 (L88-90) | ○ |
| C-42 | HdfsBlobStore.blobContainer - readOnly=falseでmkdirs | E-02 (L92-104) | ○ |
| C-43 | HdfsBlobStore.blobContainer - IOExceptionでOpenSearchException | E-02 (L99-101) | ○ |
| C-44 | HdfsBlobStore.translateToHdfsPath | E-02 (L106-112) | ○ |
| C-45 | HdfsBlobStore.translateToHdfsPath - 空パス | E-02 (L106-112) | ○ |
| C-46 | HdfsBlobStore.execute - 正常実行 | E-02 (L121-129) | ○ |
| C-47 | HdfsBlobStore.execute - close後AlreadyClosedException | E-02 (L122-124) | ○ |
| C-48 | HdfsBlobStore.execute - IOException伝播 | E-02 (L121-129) | ○ |
| C-49 | HdfsBlobStore.close | E-02 (L132-134) | ○ |
| C-50 | HdfsPlugin.getRepositories - hdfsファクトリ返却 | E-03 (L128-138) | ○ |
| C-51 | HdfsPlugin.getRepositories - HdfsRepository生成 | E-03 (L134-136) | ○ |
| C-52 | HdfsRepository - 正常初期化 | E-04 (L79-122) | ○ |
| C-53 | HdfsRepository - uri未設定でIllegalArgumentException | E-04 (L92-94) | ○ |
| C-54 | HdfsRepository - uri空文字でIllegalArgumentException | E-04 (L92-94) | ○ |
| C-55 | HdfsRepository - 非hdfsスキームでIllegalArgumentException | E-04 (L96-105) | ○ |
| C-56 | HdfsRepository - URIにパス含むでIllegalArgumentException | E-04 (L106-115) | ○ |
| C-57 | HdfsRepository - path未設定でIllegalArgumentException | E-04 (L117-121) | ○ |
| C-58 | HdfsRepository - chunk_size設定 | E-04 (L89) | ○ |
| C-59 | HdfsRepository - chunk_size未設定でnull | E-04 (L89) | ○ |
| C-60 | HdfsRepository.basePath | E-04 (L266-268) | ○ |
| C-61 | HdfsRepository.chunkSize | E-04 (L271-273) | ○ |
| C-62 | HdfsRepository.createBlobstore - 正常作成 | E-04 (L124-172) | ○ |
| C-63 | HdfsRepository.createBlobstore - conf.プレフィックス反映 | E-04 (L129-133) | △ |
| C-64 | HdfsRepository.createBlobstore - load_defaults=false | E-04 (L125) | ○ |
| C-65 | HdfsRepository.createBlobstore - HA検出 | E-04 (L144-147) | △ |
| C-66 | HdfsRepository.createBlobstore - 接続失敗 | E-04 (L167-171) | ○ |
| C-67 | HdfsRepository.login - SIMPLE認証 | E-04 (L174-219) | ○ |
| C-68 | HdfsRepository.login - KERBEROS認証 | E-04 (L174-219) | ○ |
| C-69 | HdfsRepository.login - KERBEROS+principal未設定 | E-04 (L191-198) | ○ |
| C-70 | HdfsRepository.login - SIMPLE+principal設定でKERBEROSへ | E-04 (L185-190) | ○ |
| C-71 | HdfsRepository.login - 非対応認証方式 | E-04 (L177-179) | ○ |
| C-72 | HdfsRepository.login - IOExceptionでUncheckedIOException | E-04 (L216-218) | ○ |
| C-73 | HdfsRepository.preparePrincipal - _HOST置換 | E-04 (L222-241) | ○ |
| C-74 | HdfsRepository.preparePrincipal - _HOST未含有 | E-04 (L225) | ○ |
| C-75 | HdfsRepository.getHostName - 正常取得 | E-04 (L244-255) | △ |
| C-76 | HdfsRepository.getHostName - 解決失敗 | E-04 (L252-254) | △ |
| C-77 | HdfsSecurityContext.locateKeytabFile - 正常 | E-05 (L108-118) | ○ |
| C-78 | HdfsSecurityContext.locateKeytabFile - 不在RuntimeException | E-05 (L111-113) | ○ |
| C-79 | HdfsSecurityContext.locateKeytabFile - SecurityException | E-05 (L114-116) | ○ |
| C-80 | HdfsSecurityContext - SIMPLE初期化 | E-05 (L124-128, L143-146) | ○ |
| C-81 | HdfsSecurityContext - KERBEROS初期化 | E-05 (L124-128, L132-142) | ○ |
| C-82 | HdfsSecurityContext.renderPermissions - SIMPLE | E-05 (L143-146) | ○ |
| C-83 | HdfsSecurityContext.renderPermissions - KERBEROS+ServicePermission | E-05 (L132-142) | ○ |
| C-84 | HdfsSecurityContext.doPrivilegedOrThrow - restrictPermissions=true | E-05 (L154-165) | ○ |
| C-85 | HdfsSecurityContext.doPrivilegedOrThrow - restrictPermissions=false | E-05 (L159-160) | ○ |
| C-86 | HdfsSecurityContext.doPrivilegedOrThrow - PrivilegedActionException | E-05 (L162-164) | ○ |
| C-87 | HdfsSecurityContext.ensureLogin - keytabベースUGI | E-05 (L167-175) | ○ |
| C-88 | HdfsSecurityContext.ensureLogin - 非keytabUGI | E-05 (L168) | ○ |
| C-89 | HdfsSecurityContext.ensureLogin - IOException | E-05 (L171-173) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-63: `createBlobstore`の`conf.`プレフィックス設定反映は内部メソッドであり、外部からの直接テストが困難。統合テストでの検証が望ましい。
  - 候補：統合テスト / Hadoop Configuration のモック
- C-65: HA有効判定は`FailoverProxyProvider`の設定有無に依存し、テスト時にHadoop Configurationの適切なモック設定が必要。
  - 候補：Hadoop Configuration モック / テスト用設定ファイル
- C-75, C-76: `getHostName`は`InetAddress.getLocalHost()`に依存するstaticメソッドであり、ネットワーク環境に依存する。
  - 候補：PowerMock / モック不要でテスト環境に依存

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - HdfsBlobContainer, HdfsBlobStoreの大部分のテストケースは明確なコード根拠がある
- 1: 中リスク - createBlobstore, loginメソッドのテストはHadoop/Kerberos環境への依存が大きく、モック化の設計が重要
- 1: 中リスク - HdfsSecurityContextのdoPrivilegedOrThrowはJavaセキュリティマネージャに依存するため、テスト環境の設定に注意

## 6) レビュアーチェックリスト（最小）
- [ ] 全89テストケースが5つのソースファイルを適切にカバーしているか
- [ ] HdfsRepositoryコンストラクタのバリデーション（uri, path, scheme）の異常系テストが十分か
- [ ] HdfsBlobStore.execute のclose後のAlreadyClosedExceptionテストが正しく設計されているか
- [ ] HdfsSecurityContextのSIMPLE/KERBEROS両認証方式のパーミッション生成テストが網羅的か
- [ ] HDFSPrivilegedInputSteamの各メソッドテストにおけるdoPrivilegedOrThrowの呼び出し検証が含まれているか
- [ ] createBlobstore, loginなどの内部メソッドに対するテストの実現可能性を確認（privateメソッドへのアクセス方法）
