---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 162
  claims_with_evidence: 158
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：plugins-repository-s3 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：158 / 162、根拠なし：4
- 優先レビュー（高）
  1. **C-091**: S3Service.buildCredentials IRSA認証フロー - IRSAの環境変数依存の挙動は実行環境に依存
  2. **C-092**: S3Service.buildCredentials InstanceProfile認証 - コンテナ/EC2環境依存の分岐
  3. **C-098/099**: S3RetryingInputStream read リトライ動作 - リトライ挙動のテストは外部S3依存
  4. **C-131**: TransferSemaphoresHolder セマフォフォールバック - 40%閾値の検証は並行テスト必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/S3Repository.java`
- E-02: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/S3BlobStore.java`
- E-03: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/S3BlobContainer.java`
- E-04: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/S3ClientSettings.java`
- E-05: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/S3Service.java`
- E-06: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/S3RepositoryPlugin.java`
- E-07: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/S3RetryingInputStream.java`
- E-08: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/ProxySettings.java`
- E-09: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/async/AsyncTransferManager.java`
- E-10: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/async/UploadRequest.java`
- E-11: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/async/SizeBasedBlockingQ.java`
- E-12: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/async/S3AsyncDeleteHelper.java`
- E-13: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/async/TransferSemaphoresHolder.java`
- E-14: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/utils/HttpRangeUtils.java`
- E-15: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/utils/AwsRequestSigner.java`
- E-16: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/utils/SseKmsUtil.java`
- E-17: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/GenericStatsMetricPublisher.java`
- E-18: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/StatsMetricPublisher.java`
- E-19: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/io/CheckedContainer.java`
- E-20: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/utils/Protocol.java`
- E-21: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/S3TransferRejectedException.java`
- E-22: `plugins/repository-s3/src/main/java/org/opensearch/repositories/s3/AmazonS3Reference.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | S3Repository.validateRepositoryMetadata: 有効なメタデータで検証成功 | E-01 (L600-624) | ○ |
| C-002 | S3Repository.validateRepositoryMetadata: bucket未設定でRepositoryException | E-01 (L602-603) | ○ |
| C-003 | S3Repository.validateRepositoryMetadata: chunkSize < bufferSizeでRepositoryException | E-01 (L607-619) | ○ |
| C-004 | S3Repository.validateHttpClientType: nettyが有効 | E-01 (L627-632) | ○ |
| C-005 | S3Repository.validateHttpClientType: crtが有効 | E-01 (L627-632) | ○ |
| C-006 | S3Repository.validateHttpClientType: 不正値でBlobStoreException | E-01 (L630) | ○ |
| C-007 | S3Repository.validateStorageClass: 有効なストレージクラス | E-01 (L634-647) | ○ |
| C-008 | S3Repository.validateStorageClass: 空文字列で許可 | E-01 (L635-637) | ○ |
| C-009 | S3Repository.validateStorageClass: GLACIERで例外 | E-01 (L640-642) | ○ |
| C-010 | S3Repository.validateStorageClass: 不正値で例外 | E-01 (L644-646) | ○ |
| C-011 | S3Repository.validateCannedACL: 有効ACL | E-01 (L649-661) | ○ |
| C-012 | S3Repository.validateCannedACL: 空文字列で許可 | E-01 (L650-652) | ○ |
| C-013 | S3Repository.validateCannedACL: 不正ACLで例外 | E-01 (L660) | ○ |
| C-014 | S3Repository.readRepositoryMetadata: base_path設定あり | E-01 (L554-556) | ○ |
| C-015 | S3Repository.readRepositoryMetadata: base_path空でルートパス | E-01 (L557-559) | ○ |
| C-016 | S3Repository.isReloadable: trueを返却 | E-01 (L523) | ○ |
| C-017 | S3Repository.isSeverSideEncryptionEnabled: trueを返却 | E-01 (L688-691) | ○ |
| C-018 | SERVER_SIDE_ENCRYPTION_TYPE_SETTING: AES256有効 | E-01 (L136-146) | ○ |
| C-019 | SERVER_SIDE_ENCRYPTION_TYPE_SETTING: aws:kms有効 | E-01 (L136-146) | ○ |
| C-020 | SERVER_SIDE_ENCRYPTION_TYPE_SETTING: 不正値で例外 | E-01 (L143) | ○ |
| C-021 | EXPECTED_BUCKET_OWNER_SETTING: 12桁有効 | E-01 (L172-176) | ○ |
| C-022 | EXPECTED_BUCKET_OWNER_SETTING: 12桁以外で例外 | E-01 (L174) | ○ |
| C-023 | S3BlobStore.initStorageClass: STANDARD初期化 | E-02 (L311-326) | ○ |
| C-024 | S3BlobStore.initStorageClass: nullでSTANDARDデフォルト | E-02 (L312-314) | ○ |
| C-025 | S3BlobStore.initStorageClass: 空文字列でSTANDARDデフォルト | E-02 (L312-314) | ○ |
| C-026 | S3BlobStore.initStorageClass: GLACIERで例外 | E-02 (L317-319) | ○ |
| C-027 | S3BlobStore.initStorageClass: 不正値で例外 | E-02 (L321-323) | ○ |
| C-028 | S3BlobStore.initCannedACL: privateで正しく初期化 | E-02 (L331-343) | ○ |
| C-029 | S3BlobStore.initCannedACL: nullでPRIVATEデフォルト | E-02 (L332-334) | ○ |
| C-030 | S3BlobStore.initCannedACL: 不正値で例外 | E-02 (L342) | ○ |
| C-031 | S3BlobStore.serverSideEncryptionEncryptionContext: Base64エンコード | E-02 (L232-236) | ○ |
| C-032 | S3BlobStore.serverSideEncryptionEncryptionContext: 空でnull | E-02 (L233) | ○ |
| C-033 | S3BlobStore.serverSideEncryptionEncryptionContext: nullでnull | E-02 (L233) | ○ |
| C-034 | S3BlobStore.expectedBucketOwner: 設定値返却 | E-02 (L241-243) | ○ |
| C-035 | S3BlobStore.expectedBucketOwner: 空でnull | E-02 (L242) | ○ |
| C-036 | S3BlobStore.blobContainer: S3BlobContainer生成 | E-02 (L262-264) | ○ |
| C-037 | S3BlobStore.stats: 統計Map返却 | E-02 (L277-281) | ○ |
| C-038 | S3BlobStore.extendedStats: 拡張統計返却 | E-02 (L284-292) | ○ |
| C-039 | S3BlobStore.extendedStats: 空で空Map | E-02 (L285-287) | ○ |
| C-040 | S3BlobContainer.readBlob: 範囲読み取り | E-03 (L168-179) | ○ |
| C-041 | S3BlobContainer.readBlob: position負で例外 | E-03 (L169-171) | ○ |
| C-042 | S3BlobContainer.readBlob: length負で例外 | E-03 (L172-174) | ○ |
| C-043 | S3BlobContainer.readBlob: length=0で空ストリーム | E-03 (L175-177) | ○ |
| C-044 | S3BlobContainer.readBlobPreferredLength: 32MB返却 | E-03 (L183-186) | ○ |
| C-045 | S3BlobContainer.numberOfMultiparts: 正しいパーツ計算 | E-03 (L754-771) | ○ |
| C-046 | S3BlobContainer.numberOfMultiparts: 割り切れる場合 | E-03 (L766-767) | ○ |
| C-047 | S3BlobContainer.numberOfMultiparts: totalSize <= partSize | E-03 (L759-761) | ○ |
| C-048 | S3BlobContainer.numberOfMultiparts: totalSize=0 | E-03 (L759) | ○ |
| C-049 | S3BlobContainer.numberOfMultiparts: partSize=0で例外 | E-03 (L755-757) | ○ |
| C-050 | S3BlobContainer.ensureMultiPartUploadSize: 有効サイズ | E-03 (L732-743) | ○ |
| C-051 | S3BlobContainer.ensureMultiPartUploadSize: 最大超過 | E-03 (L733-736) | ○ |
| C-052 | S3BlobContainer.ensureMultiPartUploadSize: 最小未満 | E-03 (L738-742) | ○ |
| C-053 | S3BlobContainer.executeSingleUpload: MAX_FILE_SIZE超過 | E-03 (L578-579) | ○ |
| C-054 | S3BlobContainer.executeSingleUpload: bufferSize超過 | E-03 (L581-583) | ○ |
| C-055 | S3BlobContainer.transformResponseToInputStreamContainer: 正常変換 | E-03 (L810-822) | ○ |
| C-056 | S3BlobContainer.transformResponseToInputStreamContainer: contentRange null | E-03 (L817-818) | ○ |
| C-057 | S3BlobContainer.transformResponseToInputStreamContainer: contentLength null | E-03 (L817-818) | ○ |
| C-058 | S3BlobContainer.listBlobsByPrefixInSortedOrder: limit負 | E-03 (L465-467) | ○ |
| C-059 | S3BlobContainer.deleteBlobsAsyncIgnoringIfNotExists: 空リスト | E-03 (L966-969) | ○ |
| C-060 | S3BlobContainer.remoteIntegrityCheckSupported: true | E-03 (L411-413) | ○ |
| C-061 | S3ClientSettings.load: defaultクライアント含む | E-04 (L486-498) | ○ |
| C-062 | S3ClientSettings.load: 複数クライアント | E-04 (L487-497) | ○ |
| C-063 | S3ClientSettings.checkDeprecatedCredentials: 両方ありでtrue | E-04 (L500-522) | ○ |
| C-064 | S3ClientSettings.checkDeprecatedCredentials: 両方なしでfalse | E-04 (L521) | ○ |
| C-065 | S3ClientSettings.checkDeprecatedCredentials: access_keyのみ | E-04 (L501-510) | ○ |
| C-066 | S3ClientSettings.checkDeprecatedCredentials: secret_keyのみ | E-04 (L512-520) | ○ |
| C-067 | S3ClientSettings.loadCredentials: BasicCredentials | E-04 (L535-561) | ○ |
| C-068 | S3ClientSettings.loadCredentials: SessionCredentials | E-04 (L543-544) | ○ |
| C-069 | S3ClientSettings.loadCredentials: 認証情報なしでnull | E-04 (L558) | ○ |
| C-070 | S3ClientSettings.loadCredentials: accessKeyありsecretKeyなし | E-04 (L549) | ○ |
| C-071 | S3ClientSettings.loadCredentials: secretKeyありaccessKeyなし | E-04 (L552) | ○ |
| C-072 | S3ClientSettings.loadCredentials: sessionTokenのみ | E-04 (L555-556) | ○ |
| C-073 | S3ClientSettings.refine: 設定オーバーライド | E-04 (L378-479) | ○ |
| C-074 | S3ClientSettings.refine: 変更なしで同一インスタンス | E-04 (L436-455) | ○ |
| C-075 | S3ClientSettings.validateAndCreateProxySettings: DIRECT | E-04 (L613-652) | ○ |
| C-076 | S3ClientSettings.validateAndCreateProxySettings: DIRECTでホストあり | E-04 (L637-639) | ○ |
| C-077 | S3ClientSettings.validateAndCreateProxySettings: タイプありホストなし | E-04 (L641-643) | ○ |
| C-078 | S3ClientSettings.validateAndCreateProxySettings: HTTP+SOCKS | E-04 (L647-649) | ○ |
| C-079 | S3ClientSettings.validateInetAddressFor: 不正ホスト | E-04 (L654-660) | ○ |
| C-080 | IrsaCredentials: 正しい初期化 | E-04 (L726-735) | ○ |
| C-081 | IrsaCredentials: 空identityTokenFileがnull | E-04 (L732) | ○ |
| C-082 | IrsaCredentials: 空roleSessionNameのデフォルト | E-04 (L734) | ○ |
| C-083 | S3ClientSettings.equals: 同一設定 | E-04 (L663-687) | ○ |
| C-084 | S3ClientSettings.equals: 異なる設定 | E-04 (L663-687) | ○ |
| C-085 | S3Service.settings: 既存クライアント取得 | E-05 (L184-211) | ○ |
| C-086 | S3Service.settings: 不正クライアント名で例外 | E-05 (L205-210) | ○ |
| C-087 | S3Service.refreshAndClearCache: キャッシュクリア | E-05 (L144-152) | ○ |
| C-088 | S3Service.resolveEndpointOverride: URI返却 | E-05 (L251-265) | ○ |
| C-089 | S3Service.resolveEndpointOverride: スキーマ付与 | E-05 (L257-261) | ○ |
| C-090 | S3Service.resolveEndpointOverride: 空でOptional.empty | E-05 (L252-254) | ○ |
| C-091 | S3Service.buildCredentials: StaticCredentialsProvider | E-05 (L391-455) | ○ |
| C-092 | S3Service.buildCredentials: InstanceProfile | E-05 (L453-454) | △ |
| C-093 | S3Service.buildOverrideConfiguration: リトライポリシー | E-05 (L349-372) | ○ |
| C-094 | S3Service.buildOverrideConfiguration: throttle無効 | E-05 (L366-367) | ○ |
| C-095 | S3RetryingInputStream: start負で例外 | E-07 (L90-91) | ○ |
| C-096 | S3RetryingInputStream: end < startで例外 | E-07 (L93-94) | ○ |
| C-097 | S3RetryingInputStream: end=MAX_VALUEで例外 | E-07 (L93) | ○ |
| C-098 | S3RetryingInputStream.read: データ読み取り | E-07 (L140-155) | △ |
| C-099 | S3RetryingInputStream.read: EOF検知 | E-07 (L145-147) | △ |
| C-100 | S3RetryingInputStream.skip: UnsupportedOperation | E-07 (L246-248) | ○ |
| C-101 | S3RetryingInputStream.reset: UnsupportedOperation | E-07 (L250-253) | ○ |
| C-102 | S3RetryingInputStream.ensureOpen: クローズ後例外 | E-07 (L175-179) | ○ |
| C-103 | ProxySettings: 正しい初期化 | E-08 (L64-69) | ○ |
| C-104 | ProxySettings.isAuthenticated: trueケース | E-08 (L101-103) | ○ |
| C-105 | ProxySettings.isAuthenticated: 空ユーザー名 | E-08 (L101-103) | ○ |
| C-106 | ProxySettings.isAuthenticated: nullパスワード | E-08 (L101-103) | ○ |
| C-107 | ProxySettings.recreateWithNewHostAndPort | E-08 (L105-107) | ○ |
| C-108 | ProxyType.toProtocol: HTTPからHTTP | E-08 (L37-47) | ○ |
| C-109 | ProxyType.toProtocol: DIRECTで例外 | E-08 (L39-41) | ○ |
| C-110 | ProxyType.toProtocol: SOCKSで例外 | E-08 (L42-44) | ○ |
| C-111 | ProxySettings.equals: 同一設定 | E-08 (L110-119) | ○ |
| C-112 | AsyncTransferManager.calculateOptimalPartSize: 5MB未満 | E-09 (L341-343) | ○ |
| C-113 | AsyncTransferManager.calculateOptimalPartSize: HIGH+retry | E-09 (L345-347) | ○ |
| C-114 | AsyncTransferManager.calculateOptimalPartSize: URGENT+retry | E-09 (L345-347) | ○ |
| C-115 | AsyncTransferManager.calculateOptimalPartSize: 大ファイル | E-09 (L348-350) | ○ |
| C-116 | AsyncTransferManager.calculateOptimalPartSize: 5MB境界 | E-09 (L342) | ○ |
| C-117 | SizeBasedBlockingQ.produce: 有効アイテム追加 | E-11 (L84-111) | ○ |
| C-118 | SizeBasedBlockingQ.produce: nullアイテム | E-11 (L85-87) | ○ |
| C-119 | SizeBasedBlockingQ.produce: サイズ0以下 | E-11 (L85-87) | ○ |
| C-120 | SizeBasedBlockingQ.produce: キャパシティ超過 | E-11 (L90-91) | ○ |
| C-121 | SizeBasedBlockingQ.produce: クローズ済み | E-11 (L101-103) | ○ |
| C-122 | SizeBasedBlockingQ.isMaxCapacityBelowContentLength: true | E-11 (L126-128) | ○ |
| C-123 | SizeBasedBlockingQ.isMaxCapacityBelowContentLength: false | E-11 (L127) | ○ |
| C-124 | S3AsyncDeleteHelper.createDeleteBatches: 正しい分割 | E-12 (L48-56) | ○ |
| C-125 | S3AsyncDeleteHelper.createDeleteBatches: 割り切れる | E-12 (L48-56) | ○ |
| C-126 | S3AsyncDeleteHelper.createDeleteBatches: 1件 | E-12 (L48-56) | ○ |
| C-127 | S3AsyncDeleteHelper.processDeleteResponse: エラーなし | E-12 (L93-106) | ○ |
| C-128 | S3AsyncDeleteHelper.processDeleteResponse: エラーあり | E-12 (L96-105) | ○ |
| C-129 | TransferSemaphoresHolder.acquirePermit: LOW | E-13 (L139-171) | ○ |
| C-130 | TransferSemaphoresHolder.acquirePermit: NORMAL | E-13 (L163-164) | ○ |
| C-131 | TransferSemaphoresHolder.acquirePermit: LOWフォールバック | E-13 (L153) | △ |
| C-132 | TransferSemaphoresHolder.createRequestContext | E-13 (L128-130) | ○ |
| C-133 | TypeSemaphore.tryAcquire: 通知 | E-13 (L84-90) | ○ |
| C-134 | TypeSemaphore.release: 通知 | E-13 (L102-105) | ○ |
| C-135 | UploadRequest: 正しい初期化 | E-10 (L49-79) | ○ |
| C-136 | UploadRequest: getters | E-10 (L81-138) | ○ |
| C-137 | HttpRangeUtils.getStartOffsetFromRangeHeader: 正常パース | E-14 (L27-33) | ○ |
| C-138 | HttpRangeUtils.getStartOffsetFromRangeHeader: ワイルドカード | E-14 (L17, L27-33) | ○ |
| C-139 | HttpRangeUtils.getStartOffsetFromRangeHeader: 不正ヘッダ | E-14 (L29-31) | ○ |
| C-140 | HttpRangeUtils.toHttpRangeHeader: レンジ生成 | E-14 (L41-43) | ○ |
| C-141 | AwsRequestSigner.fromSignerName: 有効名 | E-15 (L44-54) | ○ |
| C-142 | AwsRequestSigner.fromSignerName: S3V4 | E-15 (L26, L44-54) | ○ |
| C-143 | AwsRequestSigner.fromSignerName: 不正名 | E-15 (L48-49) | ○ |
| C-144 | GenericStatsMetricPublisher.updateNormalPriorityQSize | E-17 (L42-44) | ○ |
| C-145 | GenericStatsMetricPublisher.updateLowPriorityQSize | E-17 (L46-48) | ○ |
| C-146 | GenericStatsMetricPublisher.updateNormalPermits: increment | E-17 (L50-56) | ○ |
| C-147 | GenericStatsMetricPublisher.updateNormalPermits: decrement | E-17 (L50-56) | ○ |
| C-148 | GenericStatsMetricPublisher.stats: Map返却 | E-17 (L82-89) | ○ |
| C-149 | StatsMetricPublisher.Stats.toMap | E-18 (L212-220) | ○ |
| C-150 | CheckedContainer: 初期化と操作 | E-19 (L11-31) | ○ |
| C-151 | S3RepositoryPlugin.halfNumberOfProcessors: 偶数 | E-06 (L168-170) | ○ |
| C-152 | S3RepositoryPlugin.halfNumberOfProcessors: 奇数 | E-06 (L168-170) | ○ |
| C-153 | S3RepositoryPlugin.halfNumberOfProcessors: 1 | E-06 (L168-170) | ○ |
| C-154 | S3RepositoryPlugin.getRepositories: s3タイプ | E-06 (L332-343) | ○ |
| C-155 | S3RepositoryPlugin.reload: 設定リロード | E-06 (L382-387) | ○ |
| C-156 | SseKmsUtil: AES256設定 | E-16 (L62-86) | ○ |
| C-157 | SseKmsUtil: KMS設定 | E-16 (L62-86) | ○ |
| C-158 | SseKmsUtil: CryptoMetadataのKMSキー優先 | E-16 (L69-79) | ○ |
| C-159 | SseKmsUtil: bucket_defaultで設定なし | E-16 (L62-86) | ○ |
| C-160 | Protocol.toString: HTTP | E-20 (L26, L44-47) | ○ |
| C-161 | Protocol.toString: HTTPS | E-20 (L33, L44-47) | ○ |
| C-162 | S3TransferRejectedException: 例外生成 | E-21 (L17-19) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-092: PrivilegedInstanceProfileCredentialsProviderの内部動作はAWS SDKに依存しており、単体テストでは実際のEC2/コンテナ環境なしでの検証が制限される
  - 候補：モック化によるテスト / integration test
- C-098/C-099: S3RetryingInputStreamのread()メソッドは内部でS3への接続を行うため、単体テストではS3クライアントのモックが必要
  - 候補：S3クライアントのモック / テスト用S3RetryingInputStreamサブクラス
- C-131: TransferSemaphoresHolderの40%閾値のフォールバック動作はタイミング依存であり、並行テストが必要
  - 候補：セマフォ状態を制御した上でのテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの明示的な条件分岐・バリデーションに基づいており信頼性が高い
- 1: 中リスク - S3RetryingInputStreamのリトライ動作テストはS3クライアントのモック精度に依存
- 1: 中リスク - TransferSemaphoresHolderの並行動作テストはタイミング依存の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] S3Repository.validateRepositoryMetadata のバリデーション条件が網羅されているか
- [ ] S3ClientSettings.loadCredentials の認証情報の全組み合わせがカバーされているか
- [ ] S3BlobContainer.numberOfMultiparts の境界値テストが十分か
- [ ] SSE暗号化設定（AES256/KMS/bucket_default）の全パターンがテストされているか
- [ ] ProxySettings のプロキシタイプ別テストケースが網羅されているか
- [ ] AsyncTransferManager.calculateOptimalPartSize の優先度別パーツサイズ計算が正しいか
- [ ] SizeBasedBlockingQ のキャパシティ制限と異常系テストが十分か
