---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：plugins-store-smb 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **C-10 (UT-SMB-010)**: ファイルがREAD/WRITEモードで開かれることの直接的な検証方法が不明確
  2. **C-11 (UT-SMB-011)**: CREATE/TRUNCATE_EXISTINGモードの確認方法が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/store-smb/src/main/java/org/opensearch/plugin/store/smb/SMBStorePlugin.java` - プラグインクラス、getDirectoryFactories()メソッドの実装
- E-02: `plugins/store-smb/src/main/java/org/opensearch/index/store/SmbDirectoryWrapper.java` - FSDirectoryラッパー、createOutput()、SmbFSIndexOutput内部クラス、getPendingDeletions()
- E-03: `plugins/store-smb/src/main/java/org/opensearch/index/store/smbmmapfs/SmbMmapFsDirectoryFactory.java` - MMapDirectory用ファクトリ、newFSDirectory()
- E-04: `plugins/store-smb/src/main/java/org/opensearch/index/store/smbniofs/SmbNIOFsDirectoryFactory.java` - NIOFSDirectory用ファクトリ、newFSDirectory()
- E-05: `server/src/main/java/org/opensearch/index/store/FsDirectoryFactory.java` - 親クラスFsDirectoryFactory、setPreload()メソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | smb_mmap_fsとsmb_nio_fsの2つのファクトリが登録される | E-01 (L47-L51) | ○ |
| C-02 | smb_mmap_fsキーにSmbMmapFsDirectoryFactoryが対応する | E-01 (L49) | ○ |
| C-03 | smb_nio_fsキーにSmbNIOFsDirectoryFactoryが対応する | E-01 (L50) | ○ |
| C-04 | 返却されるMapが変更不可である | E-01 (L51: Collections.unmodifiableMap) | ○ |
| C-05 | 返却されるMapのサイズが2である | E-01 (L48: HashMap(2), L49-L50) | ○ |
| C-06 | FSDirectoryを渡してインスタンスが生成される | E-02 (L59-L62) | ○ |
| C-07 | 内部のfsDirectoryフィールドにFSDirectoryが保持される | E-02 (L57, L61) | ○ |
| C-08 | 指定した名前のファイルにIndexOutputが生成される | E-02 (L65-L68) | ○ |
| C-09 | 生成されたIndexOutputでデータが書き込める | E-02 (L70-L105) | ○ |
| C-10 | ファイルがREADおよびWRITEモードで開かれる | E-02 (L87-L88) | △ |
| C-11 | ファイルがCREATEおよびTRUNCATE_EXISTINGモードで開かれる | E-02 (L85-L86) | △ |
| C-12 | ディレクトリがクローズ済みの場合にエラーとなる | E-02 (L66: ensureOpen()) | ○ |
| C-13 | 存在しないディレクトリパスの場合にIOExceptionがスローされる | E-02 (L83-L84: Files.newByteChannel) | ○ |
| C-14 | CHUNK_SIZE以下のデータが一度に書き込まれる | E-02 (L94-L100) | ○ |
| C-15 | CHUNK_SIZE(8192バイト)ちょうどのデータが書き込まれる | E-02 (L75, L96) | ○ |
| C-16 | CHUNK_SIZEを超えるデータが複数チャンクに分割される | E-02 (L94-L100: whileループ) | ○ |
| C-17 | CHUNK_SIZE+1バイトのデータが2チャンクに分割される | E-02 (L96: Math.min) | ○ |
| C-18 | 0バイトのデータが渡された場合に何も書き込まれない | E-02 (L95: while length > 0) | ○ |
| C-19 | 1バイトのデータが正常に書き込まれる | E-02 (L94-L100) | ○ |
| C-20 | CHUNK_SIZEが8192である | E-02 (L75) | ○ |
| C-21 | 内部ディレクトリのpendingDeletionsが返却される | E-02 (L110-L112) | ○ |
| C-22 | 削除保留ファイルがない場合に空のSetが返却される | E-02 (L111: in.getPendingDeletions()) | ○ |
| C-23 | SmbDirectoryWrapperでラップされたMMapDirectoryが返却される | E-03 (L50-L57) | ○ |
| C-24 | 内部のMMapDirectoryが指定されたlocationを使用する | E-03 (L53: new MMapDirectory(location, lockFactory)) | ○ |
| C-25 | INDEX_STORE_PRE_LOAD_SETTINGが適用される | E-03 (L52-L54), E-05 (L118-L122) | ○ |
| C-26 | INDEX_STORE_PRE_LOAD_SETTINGが空の場合もDirectoryが正常に生成される | E-03 (L54), E-05 (L119: isEmpty()チェック) | ○ |
| C-27 | SmbMmapFsDirectoryFactoryで無効パスの場合にIOException | E-03 (L53: new MMapDirectory) | ○ |
| C-28 | SmbDirectoryWrapperでラップされたNIOFSDirectoryが返却される | E-04 (L27-L28) | ○ |
| C-29 | 内部のNIOFSDirectoryが指定されたlocationを使用する | E-04 (L28: new NIOFSDirectory(location, lockFactory)) | ○ |
| C-30 | 指定されたLockFactoryが使用される | E-04 (L28) | ○ |
| C-31 | SmbNIOFsDirectoryFactoryで無効パスの場合にIOException | E-04 (L28: new NIOFSDirectory) | ○ |
| C-32 | 大きなデータが正しく分割書き込みされる | E-02 (L94-L100: whileループの反復) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-10, C-11: StandardOpenOptionの指定はソースコード上で確認できるが、単体テストレベルでこれらのオプションが実際に適用されていることを外部から検証する直接的な手段が限定的である。実装はFiles.newByteChannel()に渡されるため、統合テストやモック検証が必要になる可能性がある。
  - 候補：Files.newByteChannelのモック化 / リフレクション / 統合テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モジュール全体が4ファイル・少量のコードで構成されており、ロジックが明確。テストケースの網羅性は高い。
- 1: 中リスク - StandardOpenOptionの検証（C-10, C-11）は単体テストでの直接検証が困難であり、テスト実装時に工夫が必要。

## 6) レビュアーチェックリスト（最小）
- [ ] SMBStorePlugin.getDirectoryFactories()のテストケース(UT-SMB-001〜005)がプラグイン登録を網羅しているか
- [ ] SmbDirectoryWrapper.createOutput()のテストケース(UT-SMB-008〜013)がファイルI/Oの正常系・異常系を網羅しているか
- [ ] SmbFSIndexOutput.write()のチャンク分割ロジックのテストケース(UT-SMB-014〜019, 032)が境界値を適切にカバーしているか
- [ ] UT-SMB-010, UT-SMB-011のStandardOpenOption検証が実現可能な方法で記述されているか確認
- [ ] SmbMmapFsDirectoryFactory/SmbNIOFsDirectoryFactoryのテストケースがファクトリパターンの正常系・異常系を網羅しているか
