---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 107
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：plugins-telemetry-otel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：107 / 110、根拠なし：3
- 優先レビュー（高）
  1. **C-05 (UT-OTL-005)**：二重初期化防止のテスト。initializeOpenTelemetrySdkのnullチェックロジックは確認できるが、同一インスタンス検証の具体的手段はコードからは明確でない
  2. **C-68 (UT-OTL-068)**：Resourceに"OpenSearch"サービス名が設定される主張。コードで確認できるが、テスト実行時のグローバルSDK登録による副作用の影響を要確認
  3. **C-94 (UT-OTL-094)**：Samplerの逆順連鎖の主張。OTelSamplerFactory.createのListIterator逆順イテレーションは確認できるが、具体的なチェーン構造検証の実現方法は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/OTelTelemetryPlugin.java`
- E-02: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/OTelTelemetrySettings.java`
- E-03: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/OTelAttributesConverter.java`
- E-04: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelCounter.java`
- E-05: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelUpDownCounter.java`
- E-06: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelHistogram.java`
- E-07: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/OTelMetricsTelemetry.java`
- E-08: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/metrics/exporter/OTelMetricsExporterFactory.java`
- E-09: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelSpan.java`
- E-10: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelPropagatedSpan.java`
- E-11: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelTracingTelemetry.java`
- E-12: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelTracingContextPropagator.java`
- E-13: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelSpanKindConverter.java`
- E-14: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelTelemetry.java`
- E-15: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/OTelResourceProvider.java`
- E-16: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/sampler/ProbabilisticSampler.java`
- E-17: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/sampler/RequestSampler.java`
- E-18: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/sampler/ProbabilisticTransportActionSampler.java`
- E-19: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/sampler/OTelSamplerFactory.java`
- E-20: `plugins/telemetry-otel/src/main/java/org/opensearch/telemetry/tracing/exporter/OTelSpanExporterFactory.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OTelTelemetryPluginコンストラクタでSettingsが保持される | E-01 (L45-47) | ○ |
| C-02 | getSettingsで7つの設定項目リストが返却される | E-01 (L50-60) | ○ |
| C-03 | getNameで"otel"が返却される | E-01 (L77-79, L36) | ○ |
| C-04 | getTelemetryでOptional<Telemetry>が返却される | E-01 (L63-66) | ○ |
| C-05 | 2回呼び出しでSDKが再初期化されない | E-01 (L68-74) | △ |
| C-06 | closeでrefCountedOpenTelemetry.close()が呼ばれる | E-01 (L86-90) | ○ |
| C-07 | closeでnullの場合にエラーが発生しない | E-01 (L87-89) | ○ |
| C-08 | String型属性がOTel Attributesに変換される | E-03 (L46) | ○ |
| C-09 | Long型属性が変換される | E-03 (L44) | ○ |
| C-10 | Double型属性が変換される | E-03 (L45) | ○ |
| C-11 | Boolean型属性が変換される | E-03 (L43) | ○ |
| C-12 | サポートされない型でIllegalArgumentException | E-03 (L47-49) | ○ |
| C-13 | null属性で空Attributesが返却される | E-03 (L35-38) | ○ |
| C-14 | 空属性マップで空Attributesが返却される | E-03 (L35-38) | ○ |
| C-15 | Tags型がOTel Attributesに変換される | E-03 (L58-64) | ○ |
| C-16 | null Tagsで空Attributesが返却される | E-03 (L60-63) | ○ |
| C-17 | OTelCounter.add(double)でdelegateに委譲される | E-04 (L32-34) | ○ |
| C-18 | OTelCounter.add(double, Tags)でタグ変換+委譲 | E-04 (L37-39) | ○ |
| C-19 | OTelCounter.add(0.0)の境界値動作 | E-04 (L32-34) | ○ |
| C-20 | OTelUpDownCounter.add(double)で委譲 | E-05 (L32-34) | ○ |
| C-21 | OTelUpDownCounter.add(double, Tags)でタグ変換+委譲 | E-05 (L37-39) | ○ |
| C-22 | OTelUpDownCounter.add(負の値)の動作 | E-05 (L32-34) | ○ |
| C-23 | OTelHistogram.record(double)で委譲 | E-06 (L32-34) | ○ |
| C-24 | OTelHistogram.record(double, Tags)でタグ変換+委譲 | E-06 (L37-39) | ○ |
| C-25 | OTelHistogram.record(0.0)の境界値動作 | E-06 (L32-34) | ○ |
| C-26 | OTelMetricsTelemetryコンストラクタでincRef()が呼ばれる | E-07 (L45) | ○ |
| C-27 | createCounterでOTelCounterが作成される | E-07 (L52-61) | ○ |
| C-28 | createUpDownCounterでOTelUpDownCounterが作成される | E-07 (L65-74) | ○ |
| C-29 | createHistogramでOTelHistogramが作成される | E-07 (L87-92) | ○ |
| C-30 | createGauge(5引数)でCloseableが返却される | E-07 (L96-104) | ○ |
| C-31 | createGauge(4引数)でCloseableが返却される | E-07 (L108-116) | ○ |
| C-32 | OTelMetricsTelemetry.closeで両リソースクローズ | E-07 (L119-122) | ○ |
| C-33 | OTelMetricsExporterFactory.createで有効なExporterが生成される | E-08 (L47-52) | ○ |
| C-34 | getDefaultメソッド優先でMetricExporterが生成される | E-08 (L62-67) | ○ |
| C-35 | createメソッドなしでIllegalStateException | E-08 (L74-76) | ○ |
| C-36 | OTelSpanコンストラクタでspan名とdelegateが設定される | E-09 (L28-31) | ○ |
| C-37 | endSpanでdelegateSpan.end()が呼ばれる | E-09 (L34-36) | ○ |
| C-38 | addAttribute(String, String)でdelegateに委譲 | E-09 (L39-41) | ○ |
| C-39 | addAttribute(String, Long)でdelegateに委譲 | E-09 (L44-46) | ○ |
| C-40 | addAttribute(String, Double)でdelegateに委譲 | E-09 (L49-51) | ○ |
| C-41 | addAttribute(String, Boolean)でdelegateに委譲 | E-09 (L54-56) | ○ |
| C-42 | setErrorでStatusCode.ERRORが設定される | E-09 (L59-63) | ○ |
| C-43 | setErrorでnull例外時にステータス未変更 | E-09 (L60) | ○ |
| C-44 | addEventでdelegateに委譲 | E-09 (L66-68) | ○ |
| C-45 | getTraceIdでdelegateのtraceIdが返却される | E-09 (L71-73) | ○ |
| C-46 | getSpanIdでdelegateのspanIdが返却される | E-09 (L76-78) | ○ |
| C-47 | OTelPropagatedSpanが正しく初期化される | E-10 (L20-22) | ○ |
| C-48 | OTelTracingTelemetryコンストラクタでincRef()が呼ばれる | E-11 (L37) | ○ |
| C-49 | createSpanで親Spanなしの新Spanが作成される | E-11 (L49-51, L75-76) | ○ |
| C-50 | createSpanで親Spanありの子Spanが作成される | E-11 (L49-51, L77-81) | ○ |
| C-51 | createSpanで属性とSpanKindが設定される | E-11 (L58-67) | ○ |
| C-52 | getContextPropagatorでOTelTracingContextPropagatorが返却される | E-11 (L54-56) | ○ |
| C-53 | OTelTracingTelemetry.closeで両リソースクローズ | E-11 (L43-46) | ○ |
| C-54 | extractで有効なヘッダからSpanが抽出される | E-12 (L40-43) | ○ |
| C-55 | extractで空propsマップの処理 | E-12 (L40-43) | ○ |
| C-56 | extractFromHeadersでCollection型ヘッダからSpan抽出 | E-12 (L54-57) | ○ |
| C-57 | injectでSpanコンテキストがBiConsumerに注入される | E-12 (L60-62) | ○ |
| C-58 | injectでnullセッターが安全に処理される | E-12 (L69-73) | ○ |
| C-59 | CLIENT SpanKindがOTel CLIENTに変換される | E-13 (L33-34) | ○ |
| C-60 | SERVER SpanKindがOTel SERVERに変換される | E-13 (L35-36) | ○ |
| C-61 | INTERNAL SpanKindがOTel INTERNALに変換される | E-13 (L37-39) | ○ |
| C-62 | null SpanKindでINTERNALが返却される | E-13 (L29-30) | ○ |
| C-63 | OTelTelemetryコンストラクタでrefが保持される | E-14 (L33-35) | ○ |
| C-64 | getTracingTelemetryでOTelTracingTelemetryが返却される | E-14 (L38-40) | ○ |
| C-65 | getMetricsTelemetryでOTelMetricsTelemetryが返却される | E-14 (L43-45) | ○ |
| C-66 | OTelResourceProvider.getで有効なSDKが生成される | E-15 (L57-66) | ○ |
| C-67 | カスタム構成でSDKが生成される | E-15 (L76-90) | ○ |
| C-68 | Resourceにサービス名"OpenSearch"が設定される | E-15 (L82) | △ |
| C-69 | ProbabilisticSampler.createでインスタンスが生成される | E-16 (L57-59) | ○ |
| C-70 | telemetrySettingsがnullでNPE | E-16 (L42) | ○ |
| C-71 | settingsがnullでNPE | E-16 (L43) | ○ |
| C-72 | shouldSampleでサンプリング判定 | E-16 (L70-91) | ○ |
| C-73 | サンプリング率変更時にSampler更新 | E-16 (L78-84) | ○ |
| C-74 | サンプリング通過時にfallbackSamplerが呼ばれる | E-16 (L86-88) | ○ |
| C-75 | DROP時にfallbackSamplerが呼ばれない | E-16 (L86-90) | ○ |
| C-76 | fallbackSampler=nullでdefaultSamplerの結果が返却される | E-16 (L86-90) | ○ |
| C-77 | getDescriptionで"Probabilistic Sampler"が返却される | E-16 (L95-96) | ○ |
| C-78 | サンプリング率0.0でDROP | E-16 (L70-91) | ○ |
| C-79 | サンプリング率1.0で全サンプリング | E-16 (L70-91) | ○ |
| C-80 | RequestSamplerでfallbackSamplerが設定される | E-17 (L33-35) | ○ |
| C-81 | trace=trueでrecordAndSample | E-17 (L49) | ○ |
| C-82 | trace=falseでdrop | E-17 (L49) | ○ |
| C-83 | trace属性なしでfallbackSampler呼び出し | E-17 (L51-53) | ○ |
| C-84 | trace属性なし+fallbackSampler=nullでrecordAndSample | E-17 (L54) | ○ |
| C-85 | getDescriptionで"Request Sampler"が返却される | E-17 (L58-59) | ○ |
| C-86 | ProbabilisticTransportActionSampler.createでインスタンス生成 | E-18 (L60-62) | ○ |
| C-87 | telemetrySettingsがnullでNPE | E-18 (L45) | ○ |
| C-88 | TRANSPORT_ACTION属性ありでサンプリング判定 | E-18 (L73-80) | ○ |
| C-89 | TRANSPORT_ACTION属性なしでfallbackSampler呼び出し | E-18 (L81) | ○ |
| C-90 | TRANSPORT_ACTION属性なし+fallbackSampler=nullでdrop | E-18 (L83) | ○ |
| C-91 | アクションサンプリング通過時にfallbackSampler連鎖 | E-18 (L76-78) | ○ |
| C-92 | getDescriptionで"Transport Action Sampler"が返却される | E-18 (L92-93) | ○ |
| C-93 | OTelSamplerFactory.createでSamplerチェーンが生成される | E-19 (L51-64) | ○ |
| C-94 | リスト逆順でSamplerが連鎖される | E-19 (L53-61) | △ |
| C-95 | createメソッドなしのSamplerクラスでIllegalStateException | E-19 (L87-88) | ○ |
| C-96 | OTelSpanExporterFactory.createで有効なExporterが生成される | E-20 (L47-52) | ○ |
| C-97 | getDefaultメソッド優先でSpanExporterが生成される | E-20 (L62-67) | ○ |
| C-98 | createメソッドなしでIllegalStateException | E-20 (L74-75) | ○ |
| C-99 | インスタンス化失敗でIllegalStateException | E-20 (L77-80, L84-88) | ○ |
| C-100 | TRACER_EXPORTER_BATCH_SIZE_SETTINGデフォルト値512 | E-02 (L46-51) | ○ |
| C-101 | TRACER_EXPORTER_MAX_QUEUE_SIZE_SETTINGデフォルト値2048 | E-02 (L56-61) | ○ |
| C-102 | TRACER_EXPORTER_DELAY_SETTINGデフォルト値2秒 | E-02 (L66-70) | ○ |
| C-103 | TRACER_SAMPLER_ACTION_PROBABILITYデフォルト値0.001 | E-02 (L146-153) | ○ |
| C-104 | TRACER_SAMPLER_ACTION_PROBABILITY最小値0.0 | E-02 (L149) | ○ |
| C-105 | TRACER_SAMPLER_ACTION_PROBABILITY最大値1.0 | E-02 (L150) | ○ |
| C-106 | OTEL_TRACER_SPAN_EXPORTER_CLASS_SETTINGデフォルトLoggingSpanExporter | E-02 (L78) | ○ |
| C-107 | 存在しないクラス名でIllegalStateException | E-02 (L88-90) | ○ |
| C-108 | OTEL_METRICS_EXPORTER_CLASS_SETTINGデフォルトLoggingMetricExporter | E-02 (L102) | ○ |
| C-109 | OTEL_TRACER_SPAN_SAMPLER_CLASS_SETTINGSデフォルト2クラス | E-02 (L126) | ○ |
| C-110 | TRACER_EXPORTER_BATCH_SIZE_SETTING最小値1 | E-02 (L49) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-05：initializeOpenTelemetrySdkの二重初期化防止テストでは、内部状態（refCountedOpenTelemetry）の同一性検証が必要だが、privateフィールドのためリフレクション等の手段が必要
  - 候補：テストでリフレクションによるフィールドアクセス / getTelemetryの戻り値の同一性検証 / モックによる検証
- C-68：OTelResourceProvider.getではbuildAndRegisterGlobal()が呼ばれるため、テスト実行時のグローバル状態への副作用がある可能性
  - 候補：テスト間のグローバルSDKリセット / テスト用のスコープ限定SDK構築
- C-94：OTelSamplerFactory.createの逆順連鎖は、ListIteratorの逆順イテレーションにより実現されているが、チェーン構造の内部検証にはサンプラーのfallbackフィールドへのアクセスが必要
  - 候補：テスト用サンプラーの作成 / shouldSampleの呼び出し順序で検証

## 5) リスクフラグ（レビュー観点）
- 0: OTelAttributesConverter、OTelSpanKindConverter、OTelCounter、OTelHistogram、OTelUpDownCounter -- 単純なデリゲーション/変換のため低リスク
- 1: OTelMetricsTelemetry、OTelTracingTelemetry、OTelTelemetry -- 参照カウント管理のためリソースリーク検証が中程度のリスク
- 1: OTelSpanExporterFactory、OTelMetricsExporterFactory -- リフレクションによるインスタンス生成のためセキュリティ・権限関連で中程度のリスク
- 2: ProbabilisticSampler -- synchronizedブロック内のサンプリング率更新でスレッドセーフ性が高リスク
- 1: OTelResourceProvider -- グローバルSDK登録（buildAndRegisterGlobal）によるテスト間干渉のリスク
- 1: RequestSampler、ProbabilisticTransportActionSampler -- フォールバックチェーンの正確性検証が中程度のリスク

## 6) レビュアーチェックリスト（最小）
- [ ] ProbabilisticSamplerのshouldSample内synchronizedブロックによるスレッドセーフ性テストケースが十分か確認
- [ ] OTelResourceProvider.get()のbuildAndRegisterGlobal()によるグローバル状態への副作用がテスト間で適切にクリーンアップされるか確認
- [ ] OTelSpanExporterFactoryおよびOTelMetricsExporterFactoryのリフレクションによるインスタンス化で、セキュリティマネージャ環境でのテスト実行可否を確認
- [ ] OTelTelemetryPluginの二重初期化防止ロジック（initializeOpenTelemetrySdk）のテスト方法が適切か確認
- [ ] RefCountedReleasableの参照カウント管理（incRef/close）がリソースリークなく動作するか確認
- [ ] OTelTracingContextPropagatorのextract/injectでW3C TraceContext伝播が正しく動作するか確認
