---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 121
  claims_with_evidence: 118
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：plugins-workload-management 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 121、根拠なし：3
- 優先レビュー（高）
  1. **C-009 (loadExtensions)**: ExtensionLoaderの具体的な振る舞いがプラグイン外部の実装に依存
  2. **C-017 (AutoTaggingActionFilter apply - principal属性)**: attributeExtensionsの具体的なExtractor実装が外部プラグインに依存
  3. **C-121 (WorkloadManagementPluginModule configure)**: Guice内部バインディングの検証方法がコードからは直接確認困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WorkloadManagementPlugin.java`
- E-02: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/AutoTaggingActionFilter.java`
- E-03: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WlmClusterSettingValuesProvider.java`
- E-04: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/service/WorkloadGroupPersistenceService.java`
- E-05: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/WorkloadGroupFeatureType.java`
- E-06: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/WorkloadGroupFeatureValueValidator.java`
- E-07: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/WorkloadGroupRuleRoutingService.java`
- E-08: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/attribute_extractor/IndicesExtractor.java`
- E-09: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/RefreshBasedSyncMechanism.java`
- E-10: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/detect/RuleEventClassifier.java`
- E-11: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/detect/AddRuleEvent.java`
- E-12: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/detect/DeleteRuleEvent.java`
- E-13: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/detect/UpdateRuleEvent.java`
- E-14: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/detect/RuleEvent.java`
- E-15: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/CreateWorkloadGroupRequest.java`
- E-16: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/CreateWorkloadGroupResponse.java`
- E-17: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/UpdateWorkloadGroupRequest.java`
- E-18: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/UpdateWorkloadGroupResponse.java`
- E-19: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/GetWorkloadGroupRequest.java`
- E-20: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/GetWorkloadGroupResponse.java`
- E-21: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/DeleteWorkloadGroupRequest.java`
- E-22: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/TransportCreateWorkloadGroupAction.java`
- E-23: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/TransportDeleteWorkloadGroupAction.java`
- E-24: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/TransportGetWorkloadGroupAction.java`
- E-25: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/TransportUpdateWorkloadGroupAction.java`
- E-26: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rest/RestCreateWorkloadGroupAction.java`
- E-27: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rest/RestDeleteWorkloadGroupAction.java`
- E-28: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rest/RestGetWorkloadGroupAction.java`
- E-29: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rest/RestUpdateWorkloadGroupAction.java`
- E-30: `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WorkloadManagementPluginModule.java`
- E-31: `plugins/workload-management/wlm-spi/src/main/java/org/opensearch/plugin/wlm/spi/AttributeExtractorExtension.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | createComponentsが必要なコンポーネントを全て返却する | E-01 (L121-175) | ○ |
| C-002 | 4つのActionHandlerが返却される | E-01 (L189-195) | ○ |
| C-003 | 4つのRestHandlerが返却される | E-01 (L204-218) | ○ |
| C-004 | 3つのSettingが返却される | E-01 (L222-228) | ○ |
| C-005 | システムインデックスディスクリプタが返却される | E-01 (L199-201) | ○ |
| C-006 | AutoTaggingActionFilterが返却される | E-01 (L184-186) | ○ |
| C-007 | principal属性がorderedAttributesに追加される | E-01 (L251-257) | ○ |
| C-008 | principal以外の属性は無視される | E-01 (L253) | ○ |
| C-009 | AttributeExtractorExtensionが正しく登録される | E-01 (L259-263), E-31 | △ |
| C-010 | TransportServiceがRuleRoutingServiceに設定される | E-01 (L178-181) | ○ |
| C-011 | WorkloadManagementPluginModuleが返却される | E-01 (L231-233) | ○ |
| C-012 | Integer.MAX_VALUEが返却される | E-02 (L70-72) | ○ |
| C-013 | SearchRequestでWLM有効時にラベル評価が行われる | E-02 (L75-100) | ○ |
| C-014 | ラベルが見つからない場合はヘッダ設定なし | E-02 (L98-99) | ○ |
| C-015 | WLMがDISABLEDの場合はラベル評価をスキップ | E-02 (L85-88) | ○ |
| C-016 | SearchRequest以外はスキップ | E-02 (L83-88) | ○ |
| C-017 | principal属性が登録されている場合にExtractorが追加される | E-02 (L92-96), E-31 | △ |
| C-018 | 初期設定のWlmModeが返却される | E-03 (L61-63) | ○ |
| C-019 | WlmModeがENABLEDの場合は例外がスローされない | E-03 (L39-48) | ○ |
| C-020 | WlmModeがDISABLEDの場合にIllegalStateExceptionがスローされる | E-03 (L40-47) | ○ |
| C-021 | WlmModeがMONITOR_ONLYの場合にIllegalStateExceptionがスローされる | E-03 (L40-47) | ○ |
| C-022 | 設定更新リスナーが登録される | E-03 (L29-32) | ○ |
| C-023 | 新しいWorkloadGroupがクラスタステートに保存される | E-04 (L159-185) | ○ |
| C-024 | maxWorkloadGroupCountに達している場合にIllegalStateException | E-04 (L164-167) | ○ |
| C-025 | 同名WorkloadGroupが既に存在する場合にIllegalArgumentException | E-04 (L170-177) | ○ |
| C-026 | リソース割当合計が1.0を超える場合にIllegalArgumentException | E-04 (L329-354) | ○ |
| C-027 | 名前指定で該当WorkloadGroupが返却される | E-04 (L192-203) | ○ |
| C-028 | 名前がnullの場合に全WorkloadGroupが返却される | E-04 (L194-196) | ○ |
| C-029 | 名前が空文字の場合に全WorkloadGroupが返却される | E-04 (L194) | ○ |
| C-030 | 存在しない名前で空のCollectionが返却される | E-04 (L197-202) | ○ |
| C-031 | 指定名のWorkloadGroupが削除されたClusterStateが返却される | E-04 (L237-242) | ○ |
| C-032 | 存在しないWorkloadGroup削除でResourceNotFoundException | E-04 (L244-251) | ○ |
| C-033 | 既存WorkloadGroupが更新されたClusterStateが返却される | E-04 (L301-322) | ○ |
| C-034 | 存在しないWorkloadGroup更新でResourceNotFoundException | E-04 (L307-311) | ○ |
| C-035 | 更新後のリソース割当合計が1.0を超える場合にIllegalArgumentException | E-04 (L313, L329-354) | ○ |
| C-036 | 有効な値でmaxWorkloadGroupCountが更新される | E-04 (L108-111) | ○ |
| C-037 | 最小値1でmaxWorkloadGroupCountが更新される | E-04 (L117-121) | ○ |
| C-038 | 最大値100でmaxWorkloadGroupCountが更新される | E-04 (L117-121) | ○ |
| C-039 | 0以下の場合にIllegalArgumentException | E-04 (L118-120) | ○ |
| C-040 | 101以上の場合にIllegalArgumentException | E-04 (L118-120) | ○ |
| C-041 | クラスタステート更新タスクが送信される | E-04 (L128-152) | ○ |
| C-042 | "workload_group"が返却される | E-05 (L26, L44-46) | ○ |
| C-043 | 10が返却される | E-05 (L27, L49-51) | ○ |
| C-044 | 100が返却される | E-05 (L28, L54-56) | ○ |
| C-045 | INDEX_PATTERNを含むorderedAttributesが返却される | E-05 (L39-41, L59-61) | ○ |
| C-046 | INDEX_PATTERNがorderedAttributesにpriority=2で追加される | E-05 (L39) | ○ |
| C-047 | 有効なworkload group IDの場合は例外なし | E-06 (L34-38) | ○ |
| C-048 | 無効なworkload group IDの場合にResourceNotFoundException | E-06 (L35-38) | ○ |
| C-049 | インデックスが存在する場合にリクエストがルーティングされる(Create) | E-07 (L73-79) | ○ |
| C-050 | インデックスが存在しない場合にインデックスが作成されてからルーティング | E-07 (L80-103) | ○ |
| C-051 | インデックス作成が非ACKの場合にlistener.onFailure | E-07 (L84-87) | ○ |
| C-052 | ResourceAlreadyExistsException時はルーティング続行 | E-07 (L95-96) | ○ |
| C-053 | インデックスが存在する場合にリクエストがルーティングされる(Update) | E-07 (L107-117) | ○ |
| C-054 | Update時インデックス未存在でResourceNotFoundException | E-07 (L110-112) | ○ |
| C-055 | プライマリシャードノードが見つからない場合にlistener.onFailure | E-07 (L146-148) | ○ |
| C-056 | TransportServiceが正しく設定される | E-07 (L68-70) | ○ |
| C-057 | RuleAttribute.INDEX_PATTERNが返却される | E-08 (L35-37) | ○ |
| C-058 | IndicesRequestのインデックス名がListとして返却される | E-08 (L40-42) | ○ |
| C-059 | 空のインデックス配列の場合に空Listが返却される | E-08 (L41) | ○ |
| C-060 | LogicalOperator.ANDが返却される | E-08 (L45-47) | ○ |
| C-061 | WLM有効時にルール同期が実行される | E-09 (L105-133) | ○ |
| C-062 | WLMがDISABLEDの場合に同期がスキップされる | E-09 (L106-108) | ○ |
| C-063 | WLMがMONITOR_ONLYの場合に同期がスキップされる | E-09 (L106-108) | ○ |
| C-064 | IndexNotFoundExceptionが発生した場合にログ出力のみ | E-09 (L125-127) | ○ |
| C-065 | その他の例外が発生した場合にwarningログ出力 | E-09 (L129) | ○ |
| C-066 | スケジュールタスクが開始される | E-09 (L136-142) | ○ |
| C-067 | スケジュールタスクがキャンセルされる(doStop) | E-09 (L145-149) | ○ |
| C-068 | scheduledFutureがnullの場合にNPEが発生しない | E-09 (L146-148) | ○ |
| C-069 | スケジュールタスクがキャンセルされる(doClose) | E-09 (L152-156) | ○ |
| C-070 | 新規ルールに対してAddRuleEventが生成される | E-10 (L49-71) | ○ |
| C-071 | 削除されたルールに対してDeleteRuleEventが生成される | E-10 (L65-69) | ○ |
| C-072 | 更新されたルールに対してUpdateRuleEventが生成される | E-10 (L55-58) | ○ |
| C-073 | 変更のないルールに対してイベントが生成されない | E-10 (L54, L73-74) | ○ |
| C-074 | 追加・更新・削除が混在する場合に正しいイベントが生成される | E-10 (L49-71) | ○ |
| C-075 | previousRulesとnewRulesが両方空の場合に空リスト | E-10 (L49-71) | ○ |
| C-076 | previousRulesとpreviousRuleMapが更新される | E-10 (L90-93) | ○ |
| C-077 | ruleProcessingService.addが呼ばれる | E-11 (L32-33) | ○ |
| C-078 | ruleProcessingService.removeが呼ばれる | E-12 (L32-33) | ○ |
| C-079 | removeしてからaddが呼ばれる | E-13 (L35-37) | ○ |
| C-080 | 有効なXContentからCreateWorkloadGroupRequestが生成される | E-15 (L60-63) | ○ |
| C-081 | StreamOutputに正しくシリアライズされる | E-15 (L70-73) | ○ |
| C-082 | validateがnullを返す | E-15 (L66-68) | ○ |
| C-083 | StreamInputからデシリアライズされる | E-15 (L51-54) | ○ |
| C-084 | CreateWorkloadGroupResponseのtoXContent | E-16 (L57-59) | ○ |
| C-085 | CreateWorkloadGroupResponseのストリームラウンドトリップ | E-16 (L36-53) | ○ |
| C-086 | UpdateWorkloadGroupRequestのfromXContent | E-17 (L53-56) | ○ |
| C-087 | UpdateWorkloadGroupRequestのvalidate | E-17 (L59-62) | ○ |
| C-088 | UpdateWorkloadGroupRequestのストリームラウンドトリップ | E-17 (L44-82) | ○ |
| C-089 | UpdateWorkloadGroupResponseのtoXContent | E-18 (L57-59) | ○ |
| C-090 | UpdateWorkloadGroupResponseのストリームラウンドトリップ | E-18 (L36-53) | ○ |
| C-091 | GetWorkloadGroupRequestのvalidate正常系 | E-19 (L45-49) | ○ |
| C-092 | GetWorkloadGroupRequestのvalidate(name=null) | E-19 (L46-48) | ○ |
| C-093 | GetWorkloadGroupRequestのストリームラウンドトリップ | E-19 (L39-56) | ○ |
| C-094 | GetWorkloadGroupResponseのtoXContent | E-20 (L58-66) | ○ |
| C-095 | GetWorkloadGroupResponseの空リストのXContent | E-20 (L58-66) | ○ |
| C-096 | GetWorkloadGroupResponseのストリームラウンドトリップ | E-20 (L46-55) | ○ |
| C-097 | DeleteWorkloadGroupRequestのvalidate正常系 | E-21 (L44-51) | ○ |
| C-098 | DeleteWorkloadGroupRequestのvalidate(name=null) | E-21 (L45-49) | ○ |
| C-099 | DeleteWorkloadGroupRequestのストリームラウンドトリップ | E-21 (L38-64) | ○ |
| C-100 | TransportCreateのclusterManagerOperation | E-22 (L69-75) | ○ |
| C-101 | TransportCreateのcheckBlock | E-22 (L88-90) | ○ |
| C-102 | TransportDeleteでルールなし時に削除される | E-23 (L120-153) | ○ |
| C-103 | TransportDeleteで関連ルール存在時にIllegalStateException | E-23 (L141-151) | ○ |
| C-104 | TransportDeleteでWorkloadGroup未存在時にResourceNotFoundException | E-23 (L126-128) | ○ |
| C-105 | TransportGetで名前指定の取得 | E-24 (L89-101) | ○ |
| C-106 | TransportGetで存在しない名前でResourceNotFoundException | E-24 (L97-99) | ○ |
| C-107 | TransportGetで名前null時に全件取得 | E-24 (L95-101) | ○ |
| C-108 | TransportUpdateのclusterManagerOperation | E-25 (L69-74) | ○ |
| C-109 | RestCreateWorkloadGroupActionのgetName | E-26 (L50-52) | ○ |
| C-110 | RestCreateWorkloadGroupActionのroutes | E-26 (L58-60) | ○ |
| C-111 | RestCreateWorkloadGroupActionのprepareRequest正常系 | E-26 (L63-73) | ○ |
| C-112 | RestCreateWorkloadGroupActionのprepareRequest異常系 | E-26 (L64), E-03 (L39-48) | ○ |
| C-113 | RestDeleteWorkloadGroupActionのprepareRequest正常系 | E-27 (L55-67) | ○ |
| C-114 | RestDeleteWorkloadGroupActionのprepareRequest異常系 | E-27 (L56), E-03 (L39-48) | ○ |
| C-115 | RestDeleteWorkloadGroupActionのroutes | E-27 (L50-52) | ○ |
| C-116 | RestGetWorkloadGroupActionのprepareRequest | E-28 (L55-57) | ○ |
| C-117 | RestGetWorkloadGroupActionのroutes | E-28 (L50-52) | ○ |
| C-118 | RestUpdateWorkloadGroupActionのprepareRequest正常系 | E-29 (L63-73) | ○ |
| C-119 | RestUpdateWorkloadGroupActionのprepareRequest異常系 | E-29 (L64), E-03 (L39-48) | ○ |
| C-120 | RestUpdateWorkloadGroupActionのroutes | E-29 (L58-59) | ○ |
| C-121 | WorkloadManagementPluginModuleのconfigure | E-30 (L26-29) | △ |

## 4) 不足情報（Unknown / Missing）
- C-009: `loadExtensions`メソッドのテストでは、ExtensionLoaderインターフェースの具体的な実装がプラグインSPI(E-31)に依存しており、モック戦略の詳細が不明
  - 候補：ExtensionLoaderのモック / テスト用AttributeExtractorExtension実装
- C-017: `apply`メソッドのprincipal属性テストでは、`AttributeExtractorExtension`の実装が外部プラグインに委譲されており、具体的なExtractorの動作がプラグイン外
  - 候補：モックAttributeExtractorExtension / テスト用スタブ
- C-121: `configure`メソッドの内部バインディングはGuiceの`AbstractModule`を継承しており、実際のバインディング結果の検証にはGuiceインジェクタのインスタンス化が必要
  - 候補：Guice Injectorを使用したインテグレーションテスト / AbstractModuleのテスト用ユーティリティ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Request/Responseクラスのシリアライズ・デシリアライズテスト（C-081〜C-099）は型安全で検証が容易
- 0: 低リスク - FeatureTypeの定数値テスト（C-042〜C-044）はハードコード値の確認のみ
- 1: 中リスク - WorkloadGroupPersistenceServiceのバリデーションロジック（C-023〜C-035）はビジネスルールに基づくため、テスト入力値の網羅性を確認すべき
- 1: 中リスク - AutoTaggingActionFilterのフロー制御（C-013〜C-017）は複数の条件分岐があり、全パスの網羅を確認すべき
- 2: 高リスク - WorkloadGroupRuleRoutingServiceのルーティングロジック（C-049〜C-055）はネットワーク通信を伴うため、モック戦略の妥当性をレビュー

## 6) レビュアーチェックリスト（最小）
- [ ] WorkloadGroupPersistenceServiceのリソース上限チェック（validateTotalUsage）のテストケースが全てのResourceTypeをカバーしているか
- [ ] AutoTaggingActionFilterでSearchRequest以外のリクエスト型（BulkRequest, IndexRequestなど）のテストが必要かどうか
- [ ] TransportDeleteWorkloadGroupActionの関連ルールチェックで、getRuleの失敗ケース（タイムアウト等）が十分にカバーされているか
- [ ] RefreshBasedSyncMechanismのdoRunメソッドの同期(synchronized)に関するスレッドセーフテストが必要かどうか
- [ ] WorkloadGroupRuleRoutingServiceのcreateIndex失敗時のエラーハンドリングパターンが全て網羅されているか
- [ ] REST APIハンドラのprepareRequestで、不正なリクエストボディ（JSONパースエラー等）のテストケースが必要かどうか
