---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 148
  claims_with_evidence: 145
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：server-bootstrap 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：145 / 148、根拠なし：3
- 優先レビュー（高）
  1. **C-079 (Bootstrap.checkLucene)**: Luceneバージョン不一致テストの入力値が推測に基づく
  2. **C-113 (SecurityProviderManager.removeNonCompliantFipsProviders)**: 実行環境依存でSunJCEが存在しない可能性
  3. **C-127 (OpenSearchPolicy.implies untrusted)**: ポリシー動作はセキュリティマネージャ環境に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/bootstrap/BootstrapCheck.java` - BootstrapCheckインターフェースとBootstrapCheckResult内部クラス
- E-02: `server/src/main/java/org/opensearch/bootstrap/BootstrapChecks.java` - 各種BootstrapCheck実装クラスとcheck/enforceLimitsメソッド
- E-03: `server/src/main/java/org/opensearch/bootstrap/BootstrapContext.java` - BootstrapContextクラス定義
- E-04: `server/src/main/java/org/opensearch/bootstrap/BootstrapException.java` - BootstrapException定義
- E-05: `server/src/main/java/org/opensearch/bootstrap/BootstrapInfo.java` - BootstrapInfoクラスとSYSTEM_PROPERTIESフィールド
- E-06: `server/src/main/java/org/opensearch/bootstrap/BootstrapSettings.java` - 設定定義（Setting定数）
- E-07: `server/src/main/java/org/opensearch/bootstrap/Bootstrap.java` - Bootstrapクラス（readPassphrase, initializeNatives, checkLucene等）
- E-08: `server/src/main/java/org/opensearch/bootstrap/OpenSearchUncaughtExceptionHandler.java` - 未キャッチ例外ハンドラ
- E-09: `server/src/main/java/org/opensearch/bootstrap/StartupException.java` - StartupExceptionクラス
- E-10: `server/src/main/java/org/opensearch/bootstrap/Natives.java` - Nativesラッパークラス
- E-11: `server/src/main/java/org/opensearch/bootstrap/Spawner.java` - Spawnerクラス
- E-12: `server/src/main/java/org/opensearch/bootstrap/FilePermissionUtils.java` - ファイルパーミッションユーティリティ
- E-13: `server/src/main/java/org/opensearch/bootstrap/Security.java` - セキュリティマネージャ初期化
- E-14: `server/src/main/java/org/opensearch/bootstrap/SecurityProviderManager.java` - セキュリティプロバイダ管理
- E-15: `server/src/main/java/org/opensearch/bootstrap/FipsTrustStoreValidator.java` - FIPSトラストストア検証
- E-16: `server/src/main/java/org/opensearch/bootstrap/OpenSearch.java` - エントリポイントクラス
- E-17: `server/src/main/java/org/opensearch/bootstrap/OpenSearchPolicy.java` - セキュリティポリシー実装
- E-18: `server/src/main/java/org/opensearch/bootstrap/ConsoleCtrlHandler.java` - コンソールCtrlハンドラインターフェース
- E-19: `server/src/main/java/org/opensearch/bootstrap/JNANatives.java` - JNAネイティブ呼び出し実装
- E-20: `server/src/main/java/org/opensearch/bootstrap/jvm/DenyJvmVersionsParser.java` - JVMバージョン拒否リストパーサー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | BootstrapCheckResult.success()が成功結果を返す | E-01 (L57-59) | ○ |
| C-002 | BootstrapCheckResult.failure()がメッセージ付き失敗結果を返す | E-01 (L61-63) | ○ |
| C-003 | failure()にnullを渡すとNullPointerException | E-01 (L62: Objects.requireNonNull) | ○ |
| C-004 | isSuccess()がtrueを返す（成功時） | E-01 (L70-72: this == SUCCESS) | ○ |
| C-005 | isFailure()がtrueを返す（失敗時） | E-01 (L74-76: !isSuccess()) | ○ |
| C-006 | isSuccess()がfalseを返す（失敗時） | E-01 (L70-72) | ○ |
| C-007 | getMessage()がメッセージを返す | E-01 (L78-82) | ○ |
| C-008 | alwaysEnforce()がデフォルトでfalse | E-01 (L94-96: default method) | ○ |
| C-009 | enforceLimits: 非ループバック→true | E-02 (L201-206) | ○ |
| C-010 | enforceLimits: ループバックのみ→false | E-02 (L201-206) | ○ |
| C-011 | enforceLimits: single-node→false | E-02 (L205) | ○ |
| C-012 | check: 全成功→例外なし | E-02 (L121-188) | ○ |
| C-013 | check: 失敗→NodeValidationException | E-02 (L178-187) | ○ |
| C-014 | check: enforceLimits=false→警告のみ | E-02 (L166-171) | ○ |
| C-015 | enforce.bootstrap.checksが不正値→IllegalArgumentException | E-02 (L147-155) | ○ |
| C-016 | alwaysEnforce=trueのチェックは常に強制 | E-02 (L166) | ○ |
| C-017 | checks()が空でないリストを返す | E-02 (L209-238) | ○ |
| C-018 | HeapSizeCheck: 等しいヒープ→成功 | E-02 (L263-288) | ○ |
| C-019 | HeapSizeCheck: 異なるヒープ→失敗 | E-02 (L266-284) | ○ |
| C-020 | HeapSizeCheck: ヒープ0→成功 | E-02 (L266: if初期==0) | ○ |
| C-021 | FileDescriptorCheck: 閾値以上→成功 | E-02 (L333-346) | ○ |
| C-022 | FileDescriptorCheck: 閾値未満→失敗 | E-02 (L335-343) | ○ |
| C-023 | FileDescriptorCheck: -1→成功 | E-02 (L335: != -1) | ○ |
| C-024 | FileDescriptorCheck: limit<=0→例外 | E-02 (L327-329) | ○ |
| C-025 | FileDescriptorCheck: limit<0→例外 | E-02 (L327-329) | ○ |
| C-026 | OsXFileDescriptorCheck: limit=10240 | E-02 (L308-315) | ○ |
| C-027 | MlockallCheck: lock=false→成功 | E-02 (L358-364) | ○ |
| C-028 | MlockallCheck: lock=true,未ロック→失敗 | E-02 (L359-360) | ○ |
| C-029 | MlockallCheck: lock=true,ロック済→成功 | E-02 (L359) | ○ |
| C-030 | MaxNumberOfThreadsCheck: 閾値以上→成功 | E-02 (L379-392) | ○ |
| C-031 | MaxNumberOfThreadsCheck: 閾値未満→失敗 | E-02 (L380) | ○ |
| C-032 | MaxSizeVirtualMemoryCheck: INFINITY→成功 | E-02 (L404-416) | ○ |
| C-033 | MaxSizeVirtualMemoryCheck: 制限値→失敗 | E-02 (L405) | ○ |
| C-034 | MaxFileSizeCheck: INFINITY→成功 | E-02 (L436-449) | ○ |
| C-035 | MaxFileSizeCheck: 制限値→失敗 | E-02 (L438) | ○ |
| C-036 | MaxMapCountCheck: 閾値以上→成功 | E-02 (L466-483) | ○ |
| C-037 | MaxMapCountCheck: 閾値未満→失敗 | E-02 (L469) | ○ |
| C-038 | MaxMapCountCheck: mmap無効→成功 | E-02 (L468,480-481) | ○ |
| C-039 | parseProcSysVmMaxMapCount: 正常パース | E-02 (L524-526) | ○ |
| C-040 | parseProcSysVmMaxMapCount: 不正文字列→例外 | E-02 (L524: Long.parseLong) | ○ |
| C-041 | ClientJvmCheck: server VM→成功 | E-02 (L533-544) | ○ |
| C-042 | ClientJvmCheck: client VM→失敗 | E-02 (L534) | ○ |
| C-043 | UseSerialGCCheck: false→成功 | E-02 (L560-572) | ○ |
| C-044 | UseSerialGCCheck: true→失敗 | E-02 (L561) | ○ |
| C-045 | SystemCallFilterCheck: 無効設定→成功 | E-02 (L587-595) | ○ |
| C-046 | SystemCallFilterCheck: 有効・未インストール→失敗 | E-02 (L588) | ○ |
| C-047 | OnErrorCheck: 設定あり→mightFork=true | E-02 (L635-638) | ○ |
| C-048 | OnErrorCheck: 空→mightFork=false | E-02 (L637) | ○ |
| C-049 | OnErrorCheck: null→mightFork=false | E-02 (L636-637) | ○ |
| C-050 | OnErrorCheck: alwaysEnforce=true | E-02 (L626-628) | ○ |
| C-051 | OnOutOfMemoryErrorCheck: 設定あり→true | E-02 (L661-664) | ○ |
| C-052 | OnOutOfMemoryErrorCheck: 空→false | E-02 (L663) | ○ |
| C-053 | EarlyAccessCheck: リリースビルド→成功 | E-02 (L689-701) | ○ |
| C-054 | EarlyAccessCheck: Oracle EA→失敗 | E-02 (L691) | ○ |
| C-055 | EarlyAccessCheck: 非Oracle EA→成功 | E-02 (L691: Oracle Corporationチェック) | ○ |
| C-056 | DiscoveryConfiguredCheck: 設定済み→成功 | E-02 (L738-746) | ○ |
| C-057 | DiscoveryConfiguredCheck: 未設定→失敗 | E-02 (L748-758) | ○ |
| C-058 | DiscoveryConfiguredCheck: 非zen2→成功 | E-02 (L741-743) | ○ |
| C-059 | MultipleDataPathCheck: warm+1パス→成功 | E-02 (L768-774) | ○ |
| C-060 | MultipleDataPathCheck: warm+複数パス→失敗 | E-02 (L769-770) | ○ |
| C-061 | MultipleDataPathCheck: 非warm+複数パス→成功 | E-02 (L769) | ○ |
| C-062 | MultipleDataPathCheck: alwaysEnforce=true | E-02 (L776-779) | ○ |
| C-063 | BootstrapContext初期化 | E-03 (L56-59) | ○ |
| C-064 | BootstrapContext.settings()がEnvironmentのsettings | E-03 (L65-67) | ○ |
| C-065 | BootstrapContext.environment() | E-03 (L61-63) | ○ |
| C-066 | BootstrapContext.metadata() | E-03 (L69-71) | ○ |
| C-067 | BootstrapExceptionが原因をラップ | E-04 (L54-56) | ○ |
| C-068 | getSystemProperties読み取り専用ビュー | E-05 (L87-138) | ○ |
| C-069 | put→UnsupportedOperationException | E-05 (L117-119) | ○ |
| C-070 | remove→UnsupportedOperationException | E-05 (L121-123) | ○ |
| C-071 | MEMORY_LOCK_SETTINGデフォルト=false | E-06 (L54) | ○ |
| C-072 | SYSTEM_CALL_FILTER_SETTINGデフォルト=true | E-06 (L55-59) | ○ |
| C-073 | CTRLHANDLER_SETTINGデフォルト=true | E-06 (L60) | ○ |
| C-074 | SECURITY_FILTER_BAD_DEFAULTSデフォルト=true | E-06 (L48-52) | ○ |
| C-075 | readPassphrase正常読み取り | E-07 (L303-321) | ○ |
| C-076 | readPassphrase空→例外 | E-07 (L315-318) | ○ |
| C-077 | readPassphrase超過→例外 | E-07 (L308-312) | ○ |
| C-078 | initializeNatives root実行→例外 | E-07 (L124-126) | ○ |
| C-079 | checkLuceneバージョン一致→成功 | E-07 (L483-493) | △ |
| C-080 | isFatalUncaught Error→true | E-08 (L78-80) | ○ |
| C-081 | isFatalUncaught Exception→false | E-08 (L78-80) | ○ |
| C-082 | isFatalUncaught InternalError→true | E-08 (L78-80) | ○ |
| C-083 | isFatalUncaught StackOverflowError→true | E-08 (L78-80) | ○ |
| C-084 | isFatalUncaught IOError→true | E-08 (L78-80) | ○ |
| C-085 | uncaughtException OOM→halt(127) | E-08 (L60-61) | ○ |
| C-086 | uncaughtException RuntimeException→haltなし | E-08 (L73-75) | ○ |
| C-087 | uncaughtException InternalError→halt(128) | E-08 (L59) | ○ |
| C-088 | uncaughtException StackOverflowError→halt(126) | E-08 (L63) | ○ |
| C-089 | uncaughtException UnknownError→halt(125) | E-08 (L65) | ○ |
| C-090 | getFirstGuiceCause 原因あり | E-09 (L146-154) | ○ |
| C-091 | getFirstGuiceCause 原因なし→自身 | E-09 (L153) | ○ |
| C-092 | printStackTrace出力 | E-09 (L72-74) | ○ |
| C-093 | printStackTraceスタックトレース切り詰め | E-09 (L106-109: STACKTRACE_LIMIT) | ○ |
| C-094 | Natives.definitelyRunningAsRoot JNA不可→false | E-10 (L78-84) | ○ |
| C-095 | Natives.isMemoryLocked JNA不可→false | E-10 (L116-121) | ○ |
| C-096 | Natives.isSystemCallFilterInstalled JNA不可→false | E-10 (L155-160) | ○ |
| C-097 | Natives.getShortPathName JNA不可→元パス | E-10 (L100-106) | ○ |
| C-098 | Spawner二重呼び出し→例外 | E-11 (L79-81) | ○ |
| C-099 | Spawner modulesDir不在→例外 | E-11 (L82-84) | ○ |
| C-100 | Spawner.getProcesses初期状態=空 | E-11 (L62, L152-154) | ○ |
| C-101 | getProcesses不変リスト | E-11 (L153: Collections.unmodifiableList) | ○ |
| C-102 | Spawner.close→プロセス破棄 | E-11 (L66-68) | ○ |
| C-103 | addSingleFilePath 既存ファイル | E-12 (L60-72) | ○ |
| C-104 | addSingleFilePath 存在しないファイル | E-12 (L61-62: Files.exists分岐) | ○ |
| C-105 | addDirectoryPath 既存ディレクトリ | E-12 (L84-118) | ○ |
| C-106 | addDirectoryPath recursiveAccessOnly=true | E-12 (L100-103) | ○ |
| C-107 | addDirectoryPath アクセス不可→例外 | E-12 (L93-96) | ○ |
| C-108 | ensureDirectoryExists 既存ディレクトリ | E-13 (L490-496) | ○ |
| C-109 | ensureDirectoryExists 新規作成 | E-13 (L498-499) | ○ |
| C-110 | ensureDirectoryExists ファイル→NotDirectoryException | E-13 (L500-505) | ○ |
| C-111 | getCodebaseJarMap JAR含む | E-13 (L177-192) | ○ |
| C-112 | getCodebaseJarMap 非JARフィルタ | E-13 (L183-185) | ○ |
| C-113 | removeNonCompliantFipsProviders SunJCE削除 | E-14 (L26-28) | △ |
| C-114 | getPosition 存在プロバイダ | E-14 (L34-45) | ○ |
| C-115 | getPosition 不存在→-1 | E-14 (L36,44) | ○ |
| C-116 | FipsTrustStore type空→例外 | E-15 (L69-73) | ○ |
| C-117 | FipsTrustStore 不正type→例外 | E-15 (L85-87) | ○ |
| C-118 | FipsTrustStore PKCS11 provider空→例外 | E-15 (L76-79,90-96) | ○ |
| C-119 | FipsTrustStore BCFKS path空→例外 | E-15 (L80-84,90-96) | ○ |
| C-120 | FipsTrustStore BCFKSファイル不在→例外 | E-15 (L143-146) | ○ |
| C-121 | FipsTrustStore BCFKSファイル空→例外 | E-15 (L152-155) | ○ |
| C-122 | FipsTrustStore provider不在→例外 | E-15 (L103-105) | ○ |
| C-123 | OpenSearch version出力 | E-16 (L133-145) | ○ |
| C-124 | OpenSearch 不正引数→UserException | E-16 (L130-132) | ○ |
| C-125 | overrideDnsCachePolicyProperties正常 | E-16 (L109-122) | ○ |
| C-126 | overrideDnsCachePolicyProperties不正数値→例外 | E-16 (L117-119) | ○ |
| C-127 | OpenSearchPolicy untrustedポリシー適用 | E-17 (L105-107) | △ |
| C-128 | OpenSearchPolicy codeSource=null→false | E-17 (L94-98) | ○ |
| C-129 | OpenSearchPolicy プラグインポリシー参照 | E-17 (L110-113) | ○ |
| C-130 | SystemPolicy BadDefault拒否 | E-17 (L243-245) | ○ |
| C-131 | SystemPolicy 通常パーミッション委譲 | E-17 (L247) | ○ |
| C-132 | DenyJvmVersionsParser 単一バージョンパース | E-20 (L133-175) | ○ |
| C-133 | DenyJvmVersionsParser 範囲(両端含む)パース | E-20 (L144-170) | ○ |
| C-134 | DenyJvmVersionsParser 範囲(上限未含)パース | E-20 (L144-170) | ○ |
| C-135 | DenyJvmVersionsParser 無限範囲パース | E-20 (L160-168) | ○ |
| C-136 | DenyJvmVersionsParser 不正フォーマット→例外 | E-20 (L136-138) | ○ |
| C-137 | DenyJvmVersionsParser 閉じ括弧なし→例外 | E-20 (L145-147) | ○ |
| C-138 | getDeniedJvmVersions リスト読み込み | E-20 (L100-120) | ○ |
| C-139 | SingleVersion.test 一致→true | E-20 (L50-52) | ○ |
| C-140 | SingleVersion.test 不一致→false | E-20 (L50-52) | ○ |
| C-141 | VersionRange.test 範囲内→true | E-20 (L76-91) | ○ |
| C-142 | VersionRange.test 下限一致(含む)→true | E-20 (L78-82) | ○ |
| C-143 | VersionRange.test 上限一致(含まない)→false | E-20 (L84-89) | ○ |
| C-144 | VersionRange.test 範囲外→false | E-20 (L78-82) | ○ |
| C-145 | JNANatives.rlimitToString INFINITY→unlimited | E-19 (L177-184) | ○ |
| C-146 | JNANatives.rlimitToString 有限値→数値文字列 | E-19 (L183) | ○ |
| C-147 | JNANatives.definitelyRunningAsRoot Windows→false | E-19 (L188-189) | ○ |
| C-148 | ConsoleCtrlHandler.CTRL_CLOSE_EVENT=2 | E-18 (L42) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-079: Bootstrap.checkLuceneのテストは、Luceneバージョンが実行時に固定されているため、バージョン不一致のケースを直接テストするのが困難。既存のアサーションに依存する。
  - 候補：テスト用のモック / リフレクション / 統合テストで検証
- C-113: SecurityProviderManager.removeNonCompliantFipsProvidersは、実行環境にSunJCEプロバイダが存在することが前提。CI環境によっては異なる可能性がある。
  - 候補：テスト前にプロバイダの存在を確認するガード条件を追加
- C-127: OpenSearchPolicy.impliesのuntrustedコードベーステストは、SecurityManager環境とポリシーファイルの存在に依存する。
  - 候補：テスト用のモックPolicy / テスト専用のpolicyファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - BootstrapCheckResult, BootstrapContext, BootstrapException, BootstrapSettings, ConsoleCtrlHandler等のシンプルなクラスのテストケース
- 1: 中リスク - BootstrapChecksの各チェック実装のテストケース（テスタブルに設計されているが、一部はネイティブ依存）
- 1: 中リスク - DenyJvmVersionsParserのテストケース（リソースファイルへの依存あり）
- 2: 高リスク - Security, OpenSearchPolicy等のセキュリティ関連テストケース（SecurityManager環境への強い依存）

## 6) レビュアーチェックリスト（最小）
- [ ] BootstrapChecksの各チェッククラスのテスト観点が正常系・異常系・境界値を網羅しているか
- [ ] enforceLimitsの判定ロジック（ループバック/single-node）のテストが十分か
- [ ] FipsTrustStoreValidatorの各エラーパスが網羅されているか
- [ ] DenyJvmVersionsParserの各パース形式（単一/範囲/無限範囲）のテストが十分か
- [ ] セキュリティ関連（OpenSearchPolicy, Security）のテストが環境依存を適切に考慮しているか
- [ ] JNA利用不可時のフォールバック動作が全てのNativesメソッドで確認されているか
- [ ] Spawnerの二重起動防止とリソース解放のテストが含まれているか
