---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 130
  claims_with_evidence: 124
  claims_without_evidence: 6
confidence_derived: 0.95
---

# 根拠レポート：server-cluster 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：124 / 130、根拠なし：6
- 優先レビュー（高）
  1. **C-091/C-092 VotingConfiguration.hasQuorum**: CoordinationMetadataのhasQuorumメソッドの詳細実装を未確認
  2. **C-129 ClusterState.Builder.incrementVersion**: Builderの内部実装詳細を未確認
  3. **C-130 ClusterState.supersedes**: supersedesメソッドの存在と実装詳細を未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/cluster/ClusterName.java` - ClusterName定義、CLUSTER_NAME_SETTING（バリデーション含む）、equals/hashCode/getEqualityPredicate
- E-02: `server/src/main/java/org/opensearch/cluster/ClusterState.java` - ClusterState定義、Builder、version/stateUUID/nodes/metadata/routingTable/blocks/customs、getVersionOrMetadataVersion、EMPTY_STATE、FeatureAware
- E-03: `server/src/main/java/org/opensearch/cluster/ClusterChangedEvent.java` - ClusterChangedEvent定義、routingTableChanged/indexRoutingTableChanged/indicesCreated/indicesDeleted/metadataChanged/blocksChanged/nodesChanged/isNewCluster/changedCustomMetadataSet
- E-04: `server/src/main/java/org/opensearch/cluster/DiskUsage.java` - DiskUsage定義、getFreeDiskAsPercentage（totalBytes==0のガード）、getUsedDiskAsPercentage/getUsedBytes/equals/hashCode
- E-05: `server/src/main/java/org/opensearch/cluster/ClusterInfo.java` - ClusterInfo定義、EMPTY、getShardSize/getDataPath/getReservedSpace/getAvgFreeByte/getAvgTotalBytes/shardIdentifierFromRouting、NodeAndPath、ReservedSpace、ReservedSpace.Builder
- E-06: `server/src/main/java/org/opensearch/cluster/health/ClusterHealthStatus.java` - ClusterHealthStatus enum定義、fromValue/fromString
- E-07: `server/src/main/java/org/opensearch/cluster/health/ClusterIndexHealth.java` - ClusterIndexHealth定義、コンストラクタ、ステータス計算
- E-08: `server/src/main/java/org/opensearch/cluster/health/ClusterStateHealth.java` - ClusterStateHealth定義、コンストラクタ（全インデックス/指定インデックス）、ヘルス集計ロジック
- E-09: `server/src/main/java/org/opensearch/cluster/block/ClusterBlock.java` - ClusterBlock定義、contains/retryable/disableStatePersistence/equals/hashCode/compareTo/isAllowReleaseResources
- E-10: `server/src/main/java/org/opensearch/cluster/block/ClusterBlocks.java` - ClusterBlocks定義、global/indices/EMPTY_CLUSTER_BLOCK/hasGlobalBlock
- E-11: `server/src/main/java/org/opensearch/cluster/node/DiscoveryNode.java` - DiscoveryNode定義、nodeRequiresLocalStorage/hasRole/isClusterManagerNode/isDataNode/isIngestNode
- E-12: `server/src/main/java/org/opensearch/cluster/node/DiscoveryNodes.java` - DiscoveryNodes定義、nodes/dataNodes/clusterManagerNodes/EMPTY_NODES/delta
- E-13: `server/src/main/java/org/opensearch/cluster/node/DiscoveryNodeFilters.java` - DiscoveryNodeFilters定義、IP_VALIDATOR
- E-14: `server/src/main/java/org/opensearch/cluster/coordination/CoordinationMetadata.java` - CoordinationMetadata定義、EMPTY_METADATA、VotingConfiguration、VotingConfigExclusion
- E-15: `server/src/main/java/org/opensearch/cluster/decommission/DecommissionAttribute.java` - DecommissionAttribute定義、attributeName/attributeValue/equals/hashCode
- E-16: `server/src/main/java/org/opensearch/cluster/decommission/DecommissionStatus.java` - DecommissionStatus enum定義、fromString（nullチェック含む）
- E-17: `server/src/main/java/org/opensearch/cluster/routing/Murmur3HashFunction.java` - hash(String)/hash(byte[], int, int)
- E-18: `server/src/main/java/org/opensearch/cluster/routing/Preference.java` - Preference enum定義、parse（レガシー表記対応含む）
- E-19: `server/src/main/java/org/opensearch/cluster/routing/RoutingPool.java` - RoutingPool enum定義、getNodePool/getIndexPool
- E-20: `server/src/main/java/org/opensearch/cluster/DiffableUtils.java` - DiffableUtils定義、diff/getStringKeySerializer/getIntKeySerializer/getVIntKeySerializer
- E-21: `server/src/main/java/org/opensearch/cluster/ClusterModule.java` - ClusterModule定義
- E-22: `server/src/main/java/org/opensearch/cluster/service/ClusterManagerTaskThrottler.java` - ClusterManagerTaskThrottler定義、コンストラクタ、ThrottlingKey、THRESHOLD_SETTINGS

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ClusterName: 有効なクラスタ名で生成できること | E-01 | ○ |
| C-002 | ClusterName: 空文字列でIllegalArgumentException | E-01 (CLUSTER_NAME_SETTING内のバリデーション) | ○ |
| C-003 | ClusterName: コロンを含む名前でIllegalArgumentException | E-01 (CLUSTER_NAME_SETTING内のバリデーション) | ○ |
| C-004 | ClusterName: equals同値比較 | E-01 | ○ |
| C-005 | ClusterName: null比較 | E-01 | ○ |
| C-006 | ClusterName: hashCode一致 | E-01 | ○ |
| C-007 | ClusterName: getEqualityPredicate | E-01 | ○ |
| C-008 | ClusterState: Builder生成 | E-02 | ○ |
| C-009 | ClusterState: version取得 | E-02 | ○ |
| C-010 | ClusterState: stateUUID取得 | E-02 | ○ |
| C-011 | ClusterState: nodes取得 | E-02 | ○ |
| C-012 | ClusterState: metadata取得 | E-02 | ○ |
| C-013 | ClusterState: routingTable取得 | E-02 | ○ |
| C-014 | ClusterState: blocks取得 | E-02 | ○ |
| C-015 | ClusterState: customs取得 | E-02 | ○ |
| C-016 | ClusterState: getVersionOrMetadataVersion (ZEN2) | E-02 (ZEN1_BWC_TERM条件分岐確認済み) | ○ |
| C-017 | ClusterState: getVersionOrMetadataVersion (ZEN1) | E-02 (ZEN1_BWC_TERM条件分岐確認済み) | ○ |
| C-018 | ClusterState: EMPTY_STATE | E-02 | ○ |
| C-019 | ClusterChangedEvent: 正常生成 | E-03 | ○ |
| C-020 | ClusterChangedEvent: source=null | E-03 (Objects.requireNonNull確認済み) | ○ |
| C-021 | ClusterChangedEvent: state=null | E-03 (Objects.requireNonNull確認済み) | ○ |
| C-022 | ClusterChangedEvent: routingTableChanged (変更あり) | E-03 (参照比較確認済み) | ○ |
| C-023 | ClusterChangedEvent: routingTableChanged (変更なし) | E-03 | ○ |
| C-024 | ClusterChangedEvent: indexRoutingTableChanged | E-03 | ○ |
| C-025 | ClusterChangedEvent: indexRoutingTableChanged null | E-03 (Objects.requireNonNull確認済み) | ○ |
| C-026 | ClusterChangedEvent: indicesCreated | E-03 | ○ |
| C-027 | ClusterChangedEvent: indicesCreated 空リスト | E-03 | ○ |
| C-028 | ClusterChangedEvent: indicesDeleted | E-03 | ○ |
| C-029 | ClusterChangedEvent: metadataChanged | E-03 | ○ |
| C-030 | ClusterChangedEvent: blocksChanged | E-03 | ○ |
| C-031 | ClusterChangedEvent: nodesChanged | E-03 | ○ |
| C-032 | ClusterChangedEvent: isNewCluster | E-03 | ○ |
| C-033 | ClusterChangedEvent: changedCustomMetadataSet | E-03 | ○ |
| C-034 | DiskUsage: 基本生成 | E-04 | ○ |
| C-035 | DiskUsage: getFreeDiskAsPercentage正常 | E-04 | ○ |
| C-036 | DiskUsage: getFreeDiskAsPercentage totalBytes=0 | E-04 (ガード条件確認済み) | ○ |
| C-037 | DiskUsage: getUsedDiskAsPercentage | E-04 | ○ |
| C-038 | DiskUsage: getUsedBytes | E-04 | ○ |
| C-039 | DiskUsage: equals同値 | E-04 | ○ |
| C-040 | DiskUsage: equals異値 | E-04 | ○ |
| C-041 | ClusterInfo: 基本生成 | E-05 | ○ |
| C-042 | ClusterInfo: EMPTY | E-05 | ○ |
| C-043 | ClusterInfo: getShardSize正常 | E-05 | ○ |
| C-044 | ClusterInfo: getShardSize null | E-05 | ○ |
| C-045 | ClusterInfo: getShardSize デフォルト値 | E-05 | ○ |
| C-046 | ClusterInfo: getReservedSpace正常 | E-05 | ○ |
| C-047 | ClusterInfo: getReservedSpace EMPTY | E-05 | ○ |
| C-048 | ClusterInfo: getAvgFreeByte正常 | E-05 (calculateAvgFreeAndTotalBytes確認済み) | ○ |
| C-049 | ClusterInfo: getAvgFreeByte空Map | E-05 (空チェック確認済み) | ○ |
| C-050 | ClusterInfo: shardIdentifierFromRouting primary | E-05 | ○ |
| C-051 | ClusterInfo: shardIdentifierFromRouting replica | E-05 | ○ |
| C-052 | NodeAndPath: 基本生成 | E-05 | ○ |
| C-053 | NodeAndPath: null nodeId | E-05 (Objects.requireNonNull確認済み) | ○ |
| C-054 | NodeAndPath: equals | E-05 | ○ |
| C-055 | ReservedSpace: getTotal | E-05 | ○ |
| C-056 | ReservedSpace: containsShardId true | E-05 | ○ |
| C-057 | ReservedSpace: containsShardId false | E-05 | ○ |
| C-058 | ReservedSpace.Builder: build複数シャード | E-05 | ○ |
| C-059 | ClusterHealthStatus: fromValue GREEN | E-06 | ○ |
| C-060 | ClusterHealthStatus: fromValue YELLOW | E-06 | ○ |
| C-061 | ClusterHealthStatus: fromValue RED | E-06 | ○ |
| C-062 | ClusterHealthStatus: fromValue 不正値 | E-06 (switch default確認済み) | ○ |
| C-063 | ClusterHealthStatus: fromString green | E-06 | ○ |
| C-064 | ClusterHealthStatus: fromString 大文字小文字無視 | E-06 (equalsIgnoreCase確認済み) | ○ |
| C-065 | ClusterHealthStatus: fromString 不正文字列 | E-06 | ○ |
| C-066 | ClusterBlock: contains該当レベル | E-09 | ○ |
| C-067 | ClusterBlock: contains非該当レベル | E-09 | ○ |
| C-068 | ClusterBlock: retryable | E-09 | ○ |
| C-069 | ClusterBlock: equals同値 | E-09 | ○ |
| C-070 | ClusterBlock: equals異値 | E-09 | ○ |
| C-071 | ClusterBlock: compareTo | E-09 (降順比較: block.id()とthis.id()) | ○ |
| C-072 | ClusterBlocks: global取得 | E-10 | ○ |
| C-073 | ClusterBlocks: hasGlobalBlock存在 | E-10 | ○ |
| C-074 | ClusterBlocks: hasGlobalBlock不在 | E-10 | ○ |
| C-075 | ClusterBlocks: EMPTY_CLUSTER_BLOCK | E-10 | ○ |
| C-076 | DiscoveryNode: nodeRequiresLocalStorage正常 | E-11 | ○ |
| C-077 | DiscoveryNode: nodeRequiresLocalStorage例外 | E-11 (IllegalArgumentException確認済み) | ○ |
| C-078 | DiscoveryNode: isClusterManagerNode | E-11 | ○ |
| C-079 | DiscoveryNode: isDataNode | E-11 | ○ |
| C-080 | DiscoveryNode: isIngestNode | E-11 | ○ |
| C-081 | DiscoveryNode: hasRole Settings | E-11 | ○ |
| C-082 | DiscoveryNodes: getSize | E-12 | ○ |
| C-083 | DiscoveryNodes: getDataNodes | E-12 | ○ |
| C-084 | DiscoveryNodes: getClusterManagerNodeId | E-12 | ○ |
| C-085 | DiscoveryNodes: EMPTY_NODES | E-12 | ○ |
| C-086 | DiscoveryNodes: delta追加検出 | E-12 | ○ |
| C-087 | DiscoveryNodes: delta削除検出 | E-12 | ○ |
| C-088 | CoordinationMetadata: 基本生成 | E-14 | ○ |
| C-089 | CoordinationMetadata: EMPTY_METADATA | E-14 | ○ |
| C-090 | VotingConfiguration: 基本生成 | E-14 | ○ |
| C-091 | VotingConfiguration: hasQuorum過半数 | E-14 | △ |
| C-092 | VotingConfiguration: hasQuorum不足 | E-14 | △ |
| C-093 | DecommissionAttribute: 基本生成 | E-15 | ○ |
| C-094 | DecommissionAttribute: attributeName取得 | E-15 | ○ |
| C-095 | DecommissionAttribute: equals | E-15 | ○ |
| C-096 | DecommissionStatus: fromString init | E-16 | ○ |
| C-097 | DecommissionStatus: fromString全ステータス | E-16 | ○ |
| C-098 | DecommissionStatus: fromString null | E-16 (nullチェック確認済み) | ○ |
| C-099 | DecommissionStatus: fromString不正値 | E-16 (IllegalStateException確認済み) | ○ |
| C-100 | Murmur3HashFunction: hash決定性 | E-17 | ○ |
| C-101 | Murmur3HashFunction: hash分散性 | E-17 | ○ |
| C-102 | Murmur3HashFunction: hash空文字列 | E-17 | ○ |
| C-103 | Preference: parse正常 | E-18 | ○ |
| C-104 | Preference: parseコロン付き | E-18 (colonIndex分岐確認済み) | ○ |
| C-105 | Preference: parseレガシー表記 | E-18 (_primaryFirst, _replicaFirst, _onlyLocal確認済み) | ○ |
| C-106 | Preference: parse不正値 | E-18 (default: throw確認済み) | ○ |
| C-107 | Preference: parse全タイプ | E-18 | ○ |
| C-108 | RoutingPool: getNodePool通常 | E-19 | ○ |
| C-109 | RoutingPool: getNodePool Warm | E-19 | ○ |
| C-110 | RoutingPool: getIndexPool通常 | E-19 | ○ |
| C-111 | RoutingPool: getIndexPoolリモート | E-19 | ○ |
| C-112 | ClusterStateHealth: 全インデックスヘルス | E-08 | ○ |
| C-113 | ClusterStateHealth: ノード数カウント | E-08 | ○ |
| C-114 | ClusterStateHealth: 指定インデックスヘルス | E-08 | ○ |
| C-115 | ClusterStateHealth: 空インデックス | E-08 | ○ |
| C-116 | ClusterIndexHealth: ヘルス計算 | E-07 | ○ |
| C-117 | ClusterIndexHealth: GREENステータス | E-07 | ○ |
| C-118 | ClusterIndexHealth: YELLOWステータス | E-07 | ○ |
| C-119 | ClusterManagerTaskThrottler: 基本生成 | E-22 | ○ |
| C-120 | ClusterManagerTaskThrottler: タスク登録 | E-22 | △ |
| C-121 | DiffableUtils: diff計算 | E-20 | ○ |
| C-122 | DiffableUtils: getStringKeySerializer | E-20 | ○ |
| C-123 | DiffableUtils: getIntKeySerializer | E-20 | ○ |
| C-124 | DiscoveryNodeFilters: IP_VALIDATOR正常 | E-13 | ○ |
| C-125 | DiscoveryNodeFilters: IP_VALIDATOR不正IP | E-13 | ○ |
| C-126 | DiscoveryNodeFilters: IP_VALIDATORワイルドカード | E-13 (Regex.isSimpleMatchPattern条件確認済み) | ○ |
| C-127 | ClusterModule: getNamedWriteables | E-21 | △ |
| C-128 | ClusterState.Builder: build正常 | E-02 | ○ |
| C-129 | ClusterState.Builder: incrementVersion | E-02 | △ |
| C-130 | ClusterState: supersedes | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-091/C-092 VotingConfiguration.hasQuorum**: CoordinationMetadata.javaの100行目以降のhasQuorumメソッドの詳細実装を確認できていない。ソースコード中にメソッドの存在は確認したが、クォーラム判定の具体的なロジック（過半数判定の実装詳細）は未読。
  - 候補：`CoordinationMetadata.java` の全文精読 / 既存テストクラス `CoordinationMetadataTests.java`
- **C-120 ClusterManagerTaskThrottler.registerClusterManagerTask**: registerClusterManagerTaskメソッドの存在は推定であり、ソースコードの100行目以降を確認できていない。
  - 候補：`ClusterManagerTaskThrottler.java` の全文精読
- **C-127 ClusterModule.getNamedWriteables**: ClusterModuleの先頭80行のみ確認。getNamedWriteablesメソッドの詳細な実装は未確認。
  - 候補：`ClusterModule.java` の全文精読
- **C-129 ClusterState.Builder.incrementVersion**: Builder内部クラスの実装詳細は300行目以降に存在すると推定。incrementVersionメソッドの正確なシグネチャは未確認。
  - 候補：`ClusterState.java` の全文精読
- **C-130 ClusterState.supersedes**: supersedesメソッドの存在が未確認。一般的なClusterState実装にあるメソッドだが、OpenSearch版での存在は確認できていない。
  - 候補：`ClusterState.java` の全文精読 / 削除もしくは別メソッド名の可能性

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - C-006, C-054, C-071, C-122, C-123: ユーティリティ的な機能のテスト。誤りがあっても影響範囲は限定的。
- **1: 中リスク** - C-091, C-092: VotingConfiguration.hasQuorumのクォーラム判定は分散システムの一貫性に関わる重要なロジック。テスト観点は妥当だが、具体的な実装詳細の確認が不足。
- **2: 高リスク** - C-130: supersedesメソッドの存在自体が未確認。テストケースが不要である可能性がある。
- **1: 中リスク** - C-016, C-017: ZEN1/ZEN2互換性のテスト。条件分岐のロジックはソースコードで確認済みだが、ZEN1_BWC_TERMの実際の値が依存するインポート先で確認が必要。

## 6) レビュアーチェックリスト（最小）
- [ ] C-130 (ClusterState.supersedes) のメソッドが実在するか確認し、存在しない場合はテストケースを削除
- [ ] C-091/C-092 (VotingConfiguration.hasQuorum) のクォーラム判定ロジックがソースコードと一致するか確認
- [ ] C-120 (ClusterManagerTaskThrottler.registerClusterManagerTask) のメソッドシグネチャがソースコードと一致するか確認
- [ ] C-129 (ClusterState.Builder.incrementVersion) のメソッドが存在し、動作がテストケースの記述と一致するか確認
- [ ] 327ファイル中の主要クラスがカバーされているか確認（metadata/, routing/allocation/ サブパッケージの深い部分は今回のテストケースでは限定的なカバレッジ）
- [ ] CSV内のファイルパスが実際のプロジェクト構造と一致しているか確認
