---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：server-crypto 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **C-21（onCloseコールバックによるキャッシュ削除）**：コールバックのテスト方法が実装依存
  2. **C-35（不正なStreamInputでのIOException）**：StreamInputの不正データ構築方法が未確定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/crypto/CryptoHandlerRegistry.java` - CryptoHandlerRegistryクラス全体（170行）
- E-02: `server/src/main/java/org/opensearch/crypto/CryptoRegistryException.java` - CryptoRegistryExceptionクラス全体（127行）
- E-03: `server/src/main/java/org/opensearch/crypto/package-info.java` - パッケージ情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cryptoPlugins 1件で正常初期化 | E-01 L50-66 コンストラクタのロジック | ○ |
| C-02 | cryptoPlugins null時にcryptoHandlerPluginが未設定 | E-01 L55 null/emptyチェック | ○ |
| C-03 | cryptoPlugins 空リスト時にcryptoHandlerPluginが未設定 | E-01 L55 isEmpty()チェック | ○ |
| C-04 | cryptoPlugins 2件以上でIllegalStateException | E-01 L56-59 size > 1 チェック | ○ |
| C-05 | cryptoKeyProviderPlugins null時にregistryが未設定 | E-01 L63 null/emptyチェック | ○ |
| C-06 | initRegistry初回呼び出しでインスタンス生成 | E-01 L72-87 double-checked locking | ○ |
| C-07 | initRegistry 2回目で既存インスタンス返却 | E-01 L77-78 null チェック | ○ |
| C-08 | getInstance でインスタンス取得 | E-01 L68-70 getInstance実装 | ○ |
| C-09 | getInstance 未初期化時にnull返却 | E-01 L41 volatile instance初期値null | ○ |
| C-10 | loadCryptoFactories で複数プラグイン登録 | E-01 L90-100 ループ処理 | ○ |
| C-11 | loadCryptoFactories で1件プラグイン登録 | E-01 L90-100 ループ処理 | ○ |
| C-12 | loadCryptoFactories で重複typeにIllegalArgumentException | E-01 L93-94 containsKeyチェック | ○ |
| C-13 | loadCryptoFactories の返却Mapが不変 | E-01 L99 Map.copyOf() | ○ |
| C-14 | getCryptoKeyProviderPlugin で登録済みtype取得 | E-01 L110-115 Map.get | ○ |
| C-15 | getCryptoKeyProviderPlugin で未登録typeにnull返却 | E-01 L114 Map.get の仕様 | ○ |
| C-16 | getCryptoKeyProviderPlugin でregistry未初期化時にIllegalStateException | E-01 L111-113 nullチェック | ○ |
| C-17 | fetchCryptoHandler で新規CryptoHandler生成・キャッシュ | E-01 L125-142 synchronized ブロック | ○ |
| C-18 | fetchCryptoHandler でキャッシュ済みハンドラ返却 | E-01 L126-127 キャッシュチェック | ○ |
| C-19 | fetchCryptoHandler で未登録KPプラグイン時にCryptoRegistryException | E-01 L147-148 nullチェック | ○ |
| C-20 | fetchCryptoHandler で生成時例外のラップ | E-01 L156-166 catch ブロック | ○ |
| C-21 | onCloseコールバックでキャッシュエントリ削除 | E-01 L131-134 onClose Runnable | △ |
| C-22 | CryptoRegistryException(String, String) メッセージ構築 | E-02 L34-38 コンストラクタ | ○ |
| C-23 | CryptoRegistryException(String, String) でNOT_FOUND設定 | E-02 L38 restStatus代入 | ○ |
| C-24 | cause=IllegalArgumentException時にBAD_REQUEST | E-02 L52-53 instanceof チェック | ○ |
| C-25 | cause=RuntimeException時にINTERNAL_SERVER_ERROR | E-02 L55 else分岐 | ○ |
| C-26 | causeが正しく設定される | E-02 L48 super(msg, cause) | ○ |
| C-27 | カスタムメッセージ付きコンストラクタのメッセージ | E-02 L67 メッセージ文字列連結 | ○ |
| C-28 | カスタムメッセージコンストラクタでINTERNAL_SERVER_ERROR | E-02 L70 restStatus代入 | ○ |
| C-29 | getName でclientName返却 | E-02 L88-89 getter | ○ |
| C-30 | getType でclientType返却 | E-02 L97-98 getter | ○ |
| C-31 | status でRestStatus返却 | E-02 L79-81 status()メソッド | ○ |
| C-32 | writeTo でシリアライズ | E-02 L121-126 writeTo実装 | ○ |
| C-33 | StreamInputからデシリアライズ | E-02 L107-112 StreamInputコンストラクタ | ○ |
| C-34 | シリアライズ・デシリアライズのラウンドトリップ | E-02 L107-126 writeTo/StreamInputコンストラクタ | ○ |
| C-35 | 不正StreamInputでIOException | E-02 L107 throws IOException宣言 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-21**: onCloseコールバックはcreateCryptoHandler内のラムダとして定義されており、外部から直接テストする方法はソースコードのみでは判断困難。テスト実装時にリフレクションまたはモックを使用する必要がある。
  - 候補：既存テストコードの確認 / createCryptoHandlerのモック化 / リフレクションによるregisteredCryptoHandlersへのアクセス
- **C-35**: StreamInputに不正データを注入した際の正確な例外挙動は、親クラスOpenSearchExceptionのデシリアライズ処理に依存するため、具体的な失敗パターンは実装確認が必要。
  - 候補：OpenSearchExceptionのデシリアライズ仕様確認 / 既存テストパターンの調査

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: CryptoRegistryExceptionのgetter/status関連テスト（C-22〜C-31） - ソースコードから直接的に導出可能
- **0 (低リスク)**: CryptoHandlerRegistryのコンストラクタ・静的メソッド関連テスト（C-01〜C-09） - 分岐ロジックが明確
- **1 (中リスク)**: fetchCryptoHandler関連テスト（C-17〜C-21） - 同期処理・キャッシュ・コールバックの複合テストが必要
- **1 (中リスク)**: シリアライズ/デシリアライズテスト（C-32〜C-35） - 親クラスの挙動への依存あり

## 6) レビュアーチェックリスト（最小）
- [ ] CryptoHandlerRegistryのシングルトンパターン（double-checked locking）に対するスレッドセーフティテストが十分か確認
- [ ] fetchCryptoHandlerのsynchronizedブロック内のcreateCryptoHandler呼び出しに対する並行テストの必要性を検討
- [ ] CryptoRegistryExceptionの3種類のコンストラクタに対してRestStatus設定の網羅性を確認
- [ ] onCloseコールバックのテスト実現方法（リフレクション or モック）を決定
- [ ] StreamInputデシリアライズの異常系テストパターンが既存テストと整合しているか確認
