---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 130
  claims_with_evidence: 126
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：server-discovery 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：126 / 130、根拠なし：4
- 優先レビュー（高）
  1. **UT-DSC-037**：settingsプロバイダの自動追加挙動はコンストラクタ内のロジックから推定したが、統合テストでの確認が望ましい
  2. **UT-DSC-098**：CMノードからのリクエスト時のプローブ開始は内部ロジックからの推定
  3. **UT-DSC-126/127/128**：SeedHostsResolver.resolveConfiguredHostsのライフサイクル依存動作はAbstractLifecycleComponentとの統合確認が必要
  4. **UT-DSC-046~050**：HandshakingTransportAddressConnectorの接続フローは非同期コールバック構造のためモックの正確性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/discovery/BlockingClusterStatePublishResponseHandler.java`
- E-02: `server/src/main/java/org/opensearch/discovery/ClusterManagerNotDiscoveredException.java`
- E-03: `server/src/main/java/org/opensearch/discovery/Discovery.java`
- E-04: `server/src/main/java/org/opensearch/discovery/DiscoveryModule.java`
- E-05: `server/src/main/java/org/opensearch/discovery/DiscoveryStats.java`
- E-06: `server/src/main/java/org/opensearch/discovery/FileBasedSeedHostsProvider.java`
- E-07: `server/src/main/java/org/opensearch/discovery/HandshakingTransportAddressConnector.java`
- E-08: `server/src/main/java/org/opensearch/discovery/InitializeExtensionRequest.java`
- E-09: `server/src/main/java/org/opensearch/discovery/InitializeExtensionResponse.java`
- E-10: `server/src/main/java/org/opensearch/discovery/LocalDiscovery.java`
- E-11: `server/src/main/java/org/opensearch/discovery/PeerFinder.java`
- E-12: `server/src/main/java/org/opensearch/discovery/PeersRequest.java`
- E-13: `server/src/main/java/org/opensearch/discovery/SeedHostsProvider.java`
- E-14: `server/src/main/java/org/opensearch/discovery/SeedHostsResolver.java`
- E-15: `server/src/main/java/org/opensearch/discovery/SettingsBasedSeedHostsProvider.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BlockingClusterStatePublishResponseHandler: コンストラクタでCountDownLatchとpendingNodesを初期化 | E-01 (L59-64) | ○ |
| C-02 | BlockingClusterStatePublishResponseHandler: 空Setで初期化可能 | E-01 (L59-64) | ○ |
| C-03 | onResponse: pendingNodesから除去しlatch.countDown | E-01 (L71-75) | ○ |
| C-04 | onResponse: 全ノード応答でlatchが0になる | E-01 (L71-75, L94-98) | ○ |
| C-05 | onFailure: pendingNodesから除去しfailedNodesに追加 | E-01 (L81-87) | ○ |
| C-06 | onFailure: ラッチもカウントダウンされる | E-01 (L86) | ○ |
| C-07 | awaitAllNodes: タイムアウト内に完了でtrue | E-01 (L94-98) | ○ |
| C-08 | awaitAllNodes: タイムアウトでfalse | E-01 (L95) | ○ |
| C-09 | pendingNodes: 未応答ノードの配列を返す | E-01 (L103-107) | ○ |
| C-10 | getFailedNodes: unmodifiableSetを返す | E-01 (L112-114) | ○ |
| C-11 | ClusterManagerNotDiscoveredException: デフォルトコンストラクタは空文字列 | E-02 (L48-50) | ○ |
| C-12 | ClusterManagerNotDiscoveredException: メッセージ付きコンストラクタ | E-02 (L56-58) | ○ |
| C-13 | ClusterManagerNotDiscoveredException: cause付きコンストラクタ | E-02 (L52-54) | ○ |
| C-14 | status()がSERVICE_UNAVAILABLEを返す | E-02 (L61-63) | ○ |
| C-15 | StreamInputからのデシリアライズ | E-02 (L65-67) | ○ |
| C-16 | DiscoveryStats: 3引数コンストラクタ | E-05 (L58-62) | ○ |
| C-17 | DiscoveryStats: nullのstatsを許容 | E-05 (L58-62, L86-94) | ○ |
| C-18 | DiscoveryStats: writeTo処理 | E-05 (L75-81) | ○ |
| C-19 | DiscoveryStats: StreamInput V2_12_0以降のデシリアライズ | E-05 (L64-71) | ○ |
| C-20 | DiscoveryStats: V2_12_0以前でclusterStateStats=null | E-05 (L67-71) | ○ |
| C-21 | DiscoveryStats: toXContent全stats出力 | E-05 (L84-97) | ○ |
| C-22 | DiscoveryStats: toXContent nullスキップ | E-05 (L86-94) | ○ |
| C-23 | DiscoveryStats: getQueueStats getter | E-05 (L103-105) | ○ |
| C-24 | DiscoveryStats: getPublishStats getter | E-05 (L107-109) | ○ |
| C-25 | DiscoveryStats: getClusterStateStats getter | E-05 (L111-113) | ○ |
| C-26 | DiscoveryModule: isSingleNodeDiscovery single-node=true | E-04 (L245-247) | ○ |
| C-27 | DiscoveryModule: isSingleNodeDiscovery zen=false | E-04 (L245-247) | ○ |
| C-28 | DiscoveryModule: isSingleNodeDiscovery デフォルト=false | E-04 (L91-96, L245-247) | ○ |
| C-29 | DiscoveryModule: 不明なdiscovery type例外 | E-04 (L223) | ○ |
| C-30 | DiscoveryModule: 不明なelection strategy例外 | E-04 (L196-198) | ○ |
| C-31 | DiscoveryModule: 不明なseed provider例外 | E-04 (L174-178) | ○ |
| C-32 | DiscoveryModule: 重複seed provider例外 | E-04 (L149-153) | ○ |
| C-33 | DiscoveryModule: 重複election strategy例外 | E-04 (L158-162) | ○ |
| C-34 | getSeedProviderNames: 新設定使用 | E-04 (L242) | ○ |
| C-35 | getSeedProviderNames: レガシー設定使用 | E-04 (L240) | ○ |
| C-36 | getSeedProviderNames: 新旧両方で例外 | E-04 (L231-239) | ○ |
| C-37 | settingsプロバイダ自動追加 | E-04 (L167-172) | ○ |
| C-38 | getDiscovery getter | E-04 (L249-251) | ○ |
| C-39 | FileBasedSeedHostsProvider: パス解決 | E-06 (L71-73) | ○ |
| C-40 | FileBasedSeedHostsProvider: ファイルからホスト読み込み | E-06 (L75-89, L92-96) | ○ |
| C-41 | FileBasedSeedHostsProvider: コメント行除外 | E-06 (L78) | ○ |
| C-42 | FileBasedSeedHostsProvider: ファイル不在時の空リスト | E-06 (L76, L86-88) | ○ |
| C-43 | FileBasedSeedHostsProvider: IO例外時の空リスト | E-06 (L80-83) | ○ |
| C-44 | FileBasedSeedHostsProvider: 空ファイル | E-06 (L77-79) | ○ |
| C-45 | HandshakingTransportAddressConnector: タイムアウト設定読み込み | E-07 (L88-92) | ○ |
| C-46 | HandshakingTransportAddressConnector: 正常接続フロー | E-07 (L95-217) | ○ |
| C-47 | HandshakingTransportAddressConnector: ローカルノード接続拒否 | E-07 (L142-143) | ○ |
| C-48 | HandshakingTransportAddressConnector: 非CMノード接続拒否 | E-07 (L144-147) | ○ |
| C-49 | HandshakingTransportAddressConnector: 接続失敗 | E-07 (L200-202) | ○ |
| C-50 | HandshakingTransportAddressConnector: ハンドシェイク失敗 | E-07 (L186-193) | ○ |
| C-51 | InitializeExtensionRequest: 3引数コンストラクタ | E-08 (L30-34) | ○ |
| C-52 | InitializeExtensionRequest: writeTo | E-08 (L44-49) | ○ |
| C-53 | InitializeExtensionRequest: StreamInputデシリアライズ | E-08 (L36-41) | ○ |
| C-54 | InitializeExtensionRequest: equals true | E-08 (L69-76) | ○ |
| C-55 | InitializeExtensionRequest: equals false | E-08 (L69-76) | ○ |
| C-56 | InitializeExtensionRequest: equals null | E-08 (L71) | ○ |
| C-57 | InitializeExtensionRequest: equals 異なる型 | E-08 (L71) | ○ |
| C-58 | InitializeExtensionRequest: hashCode | E-08 (L79-81) | ○ |
| C-59 | InitializeExtensionRequest: toString | E-08 (L64-66) | ○ |
| C-60 | InitializeExtensionResponse: コンストラクタ | E-09 (L53-56) | ○ |
| C-61 | InitializeExtensionResponse: writeTo | E-09 (L64-67) | ○ |
| C-62 | InitializeExtensionResponse: StreamInputデシリアライズ | E-09 (L58-61) | ○ |
| C-63 | InitializeExtensionResponse: equals true | E-09 (L91-95) | ○ |
| C-64 | InitializeExtensionResponse: equals false | E-09 (L91-95) | ○ |
| C-65 | InitializeExtensionResponse: equals null | E-09 (L93) | ○ |
| C-66 | InitializeExtensionResponse: hashCode | E-09 (L99-101) | ○ |
| C-67 | InitializeExtensionResponse: toString | E-09 (L87) | ○ |
| C-68 | InitializeExtensionResponse: 空リスト | E-09 (L53-56) | ○ |
| C-69 | LocalDiscovery: コンストラクタ | E-10 (L38-41) | ○ |
| C-70 | LocalDiscovery: publishでUnsupportedOperationException | E-10 (L44-47) | ○ |
| C-71 | LocalDiscovery: doStartでClusterState設定 | E-10 (L50-56) | ○ |
| C-72 | LocalDiscovery: statsでEMPTY_STATS返却 | E-10 (L30-34, L69-71) | ○ |
| C-73 | LocalDiscovery: startInitialJoin空実装 | E-10 (L74-76) | ○ |
| C-74 | LocalDiscovery: setNodeConnectionsService空実装 | E-10 (L79-81) | ○ |
| C-75 | PeersRequest: コンストラクタ | E-12 (L53-57) | ○ |
| C-76 | PeersRequest: 空knownPeers | E-12 (L53-57) | ○ |
| C-77 | PeersRequest: writeTo | E-12 (L66-70) | ○ |
| C-78 | PeersRequest: StreamInputデシリアライズ | E-12 (L59-63) | ○ |
| C-79 | PeersRequest: equals true | E-12 (L86-91) | ○ |
| C-80 | PeersRequest: equals false | E-12 (L86-91) | ○ |
| C-81 | PeersRequest: equals null | E-12 (L88) | ○ |
| C-82 | PeersRequest: hashCode | E-12 (L94-96) | ○ |
| C-83 | PeersRequest: toString | E-12 (L81-83) | ○ |
| C-84 | PeerFinder: activate | E-11 (L157-169) | ○ |
| C-85 | PeerFinder: deactivate | E-11 (L171-183) | ○ |
| C-86 | PeerFinder: getLeader deactivate後 | E-11 (L217-221, L177) | ○ |
| C-87 | PeerFinder: getLeader activate後は空 | E-11 (L164) | ○ |
| C-88 | PeerFinder: getCurrentTerm | E-11 (L224-226) | ○ |
| C-89 | PeerFinder: setCurrentTerm | E-11 (L228-230) | ○ |
| C-90 | PeerFinder: getFoundPeers接続済み | E-11 (L284-288) | ○ |
| C-91 | PeerFinder: getFoundPeers空 | E-11 (L284-288, L290-298) | ○ |
| C-92 | PeerFinder: getLastResolvedAddresses解決済み | E-11 (L253-255) | ○ |
| C-93 | PeerFinder: getLastResolvedAddresses初期状態 | E-11 (L115) | ○ |
| C-94 | PeerFinder: onNodeCommissionStatusChange true | E-11 (L140-150) | ○ |
| C-95 | PeerFinder: onNodeCommissionStatusChange false | E-11 (L140-150) | ○ |
| C-96 | PeerFinder: handlePeersRequestアクティブ時 | E-11 (L197-214) | ○ |
| C-97 | PeerFinder: handlePeersRequest非アクティブ時 | E-11 (L208-211) | ○ |
| C-98 | PeerFinder: handlePeersRequestのCMノードプローブ | E-11 (L203-204) | ○ |
| C-99 | PeerFinder: startProbe新アドレス | E-11 (L363-376) | ○ |
| C-100 | PeerFinder: startProbeローカルアドレス除外 | E-11 (L370-373) | ○ |
| C-101 | PeerFinder: startProbe非アクティブ時スキップ | E-11 (L365-368) | ○ |
| C-102 | PeerFinder: startProbe重複防止 | E-11 (L375) | ○ |
| C-103 | SettingsBasedSeedHostsProvider: 新設定読み込み | E-15 (L92-93) | ○ |
| C-104 | SettingsBasedSeedHostsProvider: レガシー設定読み込み | E-15 (L80, L90) | ○ |
| C-105 | SettingsBasedSeedHostsProvider: 新旧両方で例外 | E-15 (L81-89) | ○ |
| C-106 | SettingsBasedSeedHostsProvider: 両方未設定時デフォルト | E-15 (L94-97) | ○ |
| C-107 | SettingsBasedSeedHostsProvider: getSeedAddresses | E-15 (L103-105) | ○ |
| C-108 | SeedHostsResolver: getMaxConcurrentResolvers新設定 | E-14 (L133) | ○ |
| C-109 | SeedHostsResolver: getMaxConcurrentResolversレガシー | E-14 (L121, L131) | ○ |
| C-110 | SeedHostsResolver: getMaxConcurrentResolvers新旧例外 | E-14 (L122-130) | ○ |
| C-111 | SeedHostsResolver: getMaxConcurrentResolversデフォルト10 | E-14 (L87-92) | ○ |
| C-112 | SeedHostsResolver: getResolveTimeout新設定 | E-14 (L149) | ○ |
| C-113 | SeedHostsResolver: getResolveTimeoutレガシー | E-14 (L137, L147) | ○ |
| C-114 | SeedHostsResolver: getResolveTimeout新旧例外 | E-14 (L138-146) | ○ |
| C-115 | SeedHostsResolver: getResolveTimeoutデフォルト5s | E-14 (L93-97) | ○ |
| C-116 | SeedHostsResolver: resolveHostsListsホスト解決 | E-14 (L164-226) | ○ |
| C-117 | SeedHostsResolver: resolveHostsListsローカルアドレス除外 | E-14 (L193-195, L209) | ○ |
| C-118 | SeedHostsResolver: resolveHostsLists解決失敗スキップ | E-14 (L213-216) | ○ |
| C-119 | SeedHostsResolver: resolveHostsListsタイムアウトスキップ | E-14 (L187, L221-223) | ○ |
| C-120 | SeedHostsResolver: resolveHostsLists空リスト | E-14 (L181-183) | ○ |
| C-121 | SeedHostsResolver: resolveHostsLists executorService null検証 | E-14 (L172) | ○ |
| C-122 | SeedHostsResolver: resolveHostsLists hosts null検証 | E-14 (L174) | ○ |
| C-123 | SeedHostsResolver: resolveHostsLists負タイムアウト検証 | E-14 (L177-179) | ○ |
| C-124 | SeedHostsResolver: resolveHostsListsキャンセル時空リスト | E-14 (L189-191) | ○ |
| C-125 | SeedHostsResolver: resolveHostsLists不変リスト | E-14 (L225) | ○ |
| C-126 | SeedHostsResolver: resolveConfiguredHosts開始済み | E-14 (L255-299) | ○ |
| C-127 | SeedHostsResolver: resolveConfiguredHosts未開始スキップ | E-14 (L256-259) | ○ |
| C-128 | SeedHostsResolver: resolveConfiguredHosts排他制御 | E-14 (L261) | △ |
| C-129 | SeedHostsResolver: doStartでExecutorService生成 | E-14 (L229-243) | ○ |
| C-130 | SeedHostsResolver: doStopでキャンセルと終了 | E-14 (L246-249) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-128: resolveConfiguredHostsの排他制御（AtomicBooleanのcompareAndSet）は非同期テスト環境での正確な検証が困難
  - 候補：マルチスレッドテスト / 統合テスト / AtomicBooleanのモック
- HandshakingTransportAddressConnectorの非同期コールバック構造（C-46~C-50）は複雑な非同期フローのため、モック設計の正確性に依存する
  - 候補：TransportServiceモック / ConnectionモックのActionListenerコールバック
- PeerFinderのPeerインナークラスの動作検証はPeerFinderのサブクラス作成が必要
  - 候補：テスト用サブクラス / リフレクションによるテスト
- DiscoveryModuleのコンストラクタテストは多数の依存オブジェクトのモック/スタブが必要
  - 候補：各依存クラスのモック作成

## 5) リスクフラグ（レビュー観点）
- 0: DiscoveryStats, InitializeExtensionRequest/Response, PeersRequest - シンプルなデータクラスで低リスク
- 1: FileBasedSeedHostsProvider, SettingsBasedSeedHostsProvider - ファイルI/O・設定依存で中リスク
- 1: SeedHostsResolver.resolveHostsLists - 並行処理・タイムアウトを含む中リスク
- 2: HandshakingTransportAddressConnector - 非同期コールバックチェーンの高リスク
- 1: PeerFinder - 並行処理と状態管理を含む中リスク
- 1: DiscoveryModule - 多数の依存関係を持つコンストラクタの中リスク
- 0: LocalDiscovery - シンプルな実装で低リスク
- 0: ClusterManagerNotDiscoveredException - 標準例外クラスで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] BlockingClusterStatePublishResponseHandler のスレッドセーフ性テストが十分か確認
- [ ] HandshakingTransportAddressConnector の非同期コールバックフローのモック設計が適切か確認
- [ ] PeerFinder のactivate/deactivateサイクルにおける状態遷移の網羅性を確認
- [ ] SeedHostsResolver.resolveHostsLists の並行処理テストが十分か確認
- [ ] DiscoveryModule コンストラクタの依存オブジェクト設定の妥当性を確認
- [ ] バージョン互換性テスト（V2_12_0前後）のDiscoveryStatsシリアライゼーションが適切か確認
- [ ] レガシー設定と新設定の排他制御テストが全対象クラスで網羅されているか確認
- [ ] LocalDiscovery.publish のUnsupportedOperationException発生がクラスタレスモードの仕様として正しいか確認
