---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 141
  claims_with_evidence: 139
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：server-env 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：139 / 141、根拠なし：2
- 優先レビュー（高）
  1. **C-131 (OverrideNodeVersionCommand.processNodePaths メタデータ不存在時)**: processNodePathsはprotectedメソッドでOpenSearchNodeCommandの処理フローに依存するため、テスト方法の実現可能性を要確認
  2. **C-132 (OverrideNodeVersionCommand.processNodePaths 互換バージョン時)**: 上記と同様にテスト実現可能性を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/env/Environment.java` - Environmentクラス全体（コンストラクタ、getter、resolveメソッド、validateTmpDir等）
- E-02: `server/src/main/java/org/opensearch/env/NodeEnvironment.java` - NodeEnvironmentクラス全体（コンストラクタ、ロック機構、パス解決、ファイルキャッシュ等）
- E-03: `server/src/main/java/org/opensearch/env/NodeMetadata.java` - NodeMetadataクラス全体（コンストラクタ、upgradeToCurrentVersion、equals/hashCode等）
- E-04: `server/src/main/java/org/opensearch/env/ShardLock.java` - ShardLock抽象クラス全体（close冪等性、getShardId等）
- E-05: `server/src/main/java/org/opensearch/env/ShardLockObtainFailedException.java` - 例外クラス全体（コンストラクタ、buildMessage）
- E-06: `server/src/main/java/org/opensearch/env/OpenSearchFileStore.java` - OpenSearchFileStoreクラス全体（委譲メソッド、負値処理、lucene属性サポート）
- E-07: `server/src/main/java/org/opensearch/env/NodeRepurposeCommand.java` - NodeRepurposeCommandクラス全体（validateBeforeLock、メッセージ生成）
- E-08: `server/src/main/java/org/opensearch/env/OverrideNodeVersionCommand.java` - OverrideNodeVersionCommandクラス全体（processNodePaths）
- E-09: `server/src/main/java/org/opensearch/env/EnvironmentSettingsResponse.java` - EnvironmentSettingsResponseクラス全体（シリアライゼーション、equals/hashCode）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Environment: path.home設定時の正常生成 | E-01 (L129-133) | ○ |
| C-002 | Environment: path.home未設定時のIllegalStateException | E-01 (L132) | ○ |
| C-003 | Environment: configPath指定時の動作 | E-01 (L135-136) | ○ |
| C-004 | Environment: configPath=null時のデフォルト | E-01 (L138) | ○ |
| C-005 | Environment: path.data設定時の動作 | E-01 (L146-155) | ○ |
| C-006 | Environment: path.data未設定時のデフォルト | E-01 (L154) | ○ |
| C-007 | Environment: nodeLocalStorage=false + path.data設定時のエラー | E-01 (L157-162) | ○ |
| C-008 | Environment: path.repo設定時の動作 | E-01 (L169-177) | ○ |
| C-009 | Environment: path.repo未設定時の空配列 | E-01 (L170-171) | ○ |
| C-010 | Environment: path.logs設定時の動作 | E-01 (L180-181) | ○ |
| C-011 | Environment: path.logs未設定時のデフォルト | E-01 (L183) | ○ |
| C-012 | Environment: node.pidfile設定時の動作 | E-01 (L186-188) | ○ |
| C-013 | Environment: pidfile未設定時のnull | E-01 (L189) | ○ |
| C-014 | Environment: settings()の戻り値 | E-01 (L225-227) | ○ |
| C-015 | Environment: pluginsDir()の戻り値 | E-01 (L143, L312-314) | ○ |
| C-016 | Environment: binDir()の戻り値 | E-01 (L192, L316-318) | ○ |
| C-017 | Environment: libDir()の戻り値 | E-01 (L193, L320-322) | ○ |
| C-018 | Environment: modulesDir()の戻り値 | E-01 (L194, L324-326) | ○ |
| C-019 | Environment: tmpDir()の戻り値 | E-01 (L141, L340-342) | ○ |
| C-020 | Environment: resolveRepoFile正常系 | E-01 (L255-257) | ○ |
| C-021 | Environment: resolveRepoFile不一致時null | E-01 (L256) | ○ |
| C-022 | Environment: resolveRepoURL file://正常系 | E-01 (L266-277) | ○ |
| C-023 | Environment: resolveRepoURL jar://正常系 | E-01 (L279-293) | ○ |
| C-024 | Environment: resolveRepoURL 不一致file URL null | E-01 (L271-274) | ○ |
| C-025 | Environment: resolveRepoURL リモートhost file URL null | E-01 (L268, L278) | ○ |
| C-026 | Environment: resolveRepoURL http/https null | E-01 (L295) | ○ |
| C-027 | Environment: resolveRepoURL jar URLに!/なし null | E-01 (L282-284) | ○ |
| C-028 | Environment: validateTmpDir正常系 | E-01 (L345-352) | ○ |
| C-029 | Environment: validateTmpDir不存在時FileNotFoundException | E-01 (L346-348) | ○ |
| C-030 | Environment: validateTmpDirファイル時IOException | E-01 (L349-351) | ○ |
| C-031 | Environment: getFileStore | E-01 (L354-356) | ○ |
| C-032 | Environment: assertEquivalent同一設定 | E-01 (L362-373) | ○ |
| C-033 | Environment: assertEquivalent異なる設定 | E-01 (L375-377) | ○ |
| C-034 | NodeMetadata: 正常コンストラクタ | E-03 (L62-65) | ○ |
| C-035 | NodeMetadata: nodeId=null時NPE | E-03 (L63) | ○ |
| C-036 | NodeMetadata: nodeVersion=null時NPE | E-03 (L64) | ○ |
| C-037 | NodeMetadata: nodeId() | E-03 (L85-87) | ○ |
| C-038 | NodeMetadata: nodeVersion() | E-03 (L89-91) | ○ |
| C-039 | NodeMetadata: upgradeToCurrentVersion V_EMPTY | E-03 (L94-97) | ○ |
| C-040 | NodeMetadata: upgradeToCurrentVersion 互換旧バージョン | E-03 (L111) | ○ |
| C-041 | NodeMetadata: upgradeToCurrentVersion CURRENT | E-03 (L111) | ○ |
| C-042 | NodeMetadata: upgradeToCurrentVersion 古すぎるバージョン | E-03 (L99-103) | ○ |
| C-043 | NodeMetadata: upgradeToCurrentVersion 新しすぎるバージョン | E-03 (L105-109) | ○ |
| C-044 | NodeMetadata: equals同一 | E-03 (L68-73) | ○ |
| C-045 | NodeMetadata: equals異なるnodeId | E-03 (L72) | ○ |
| C-046 | NodeMetadata: equals null | E-03 (L70) | ○ |
| C-047 | NodeMetadata: equals異なるクラス | E-03 (L70) | ○ |
| C-048 | NodeMetadata: hashCode一貫性 | E-03 (L76-78) | ○ |
| C-049 | NodeMetadata: toString | E-03 (L81-83) | ○ |
| C-050 | ShardLock: コンストラクタ | E-04 (L56-58) | ○ |
| C-051 | ShardLock: getShardId | E-04 (L63-65) | ○ |
| C-052 | ShardLock: close初回 | E-04 (L68-72) | ○ |
| C-053 | ShardLock: close冪等性 | E-04 (L69) | ○ |
| C-054 | ShardLock: toString | E-04 (L83-85) | ○ |
| C-055 | ShardLockObtainFailedException: ShardId+message | E-05 (L50-53) | ○ |
| C-056 | ShardLockObtainFailedException: ShardId+message+cause | E-05 (L55-58) | ○ |
| C-057 | ShardLockObtainFailedException: StreamInput | E-05 (L60-62) | ○ |
| C-058 | OpenSearchFileStore: コンストラクタ | E-06 (L64-87) | ○ |
| C-059 | OpenSearchFileStore: name委譲 | E-06 (L101-103) | ○ |
| C-060 | OpenSearchFileStore: type委譲 | E-06 (L106-108) | ○ |
| C-061 | OpenSearchFileStore: isReadOnly委譲 | E-06 (L111-113) | ○ |
| C-062 | OpenSearchFileStore: getTotalSpace正常 | E-06 (L116-123) | ○ |
| C-063 | OpenSearchFileStore: getTotalSpace負値 | E-06 (L118-121) | ○ |
| C-064 | OpenSearchFileStore: getUsableSpace正常 | E-06 (L126-133) | ○ |
| C-065 | OpenSearchFileStore: getUsableSpace負値 | E-06 (L128-131) | ○ |
| C-066 | OpenSearchFileStore: getUnallocatedSpace正常 | E-06 (L136-143) | ○ |
| C-067 | OpenSearchFileStore: getUnallocatedSpace負値 | E-06 (L138-141) | ○ |
| C-068 | OpenSearchFileStore: supportsFileAttributeView 'lucene' | E-06 (L151-157) | ○ |
| C-069 | OpenSearchFileStore: supportsFileAttributeView 非lucene | E-06 (L155) | ○ |
| C-070 | OpenSearchFileStore: getAttribute major_device_number | E-06 (L166-169) | ○ |
| C-071 | OpenSearchFileStore: getAttribute minor_device_number | E-06 (L170-171) | ○ |
| C-072 | OpenSearchFileStore: getAttribute その他 | E-06 (L172-173) | ○ |
| C-073 | NodeEnvironment: resolveNodePath | E-02 (L412-414) | ○ |
| C-074 | NodeEnvironment: resolveNodePath nodeLockId=0 | E-02 (L413) | ○ |
| C-075 | NodeEnvironment: generateNodeId | E-02 (L509-512) | ○ |
| C-076 | NodeEnvironment: generateNodeId同一seed | E-02 (L510) | ○ |
| C-077 | NodeEnvironment: applySegmentInfosTrace true | E-02 (L515-518) | ○ |
| C-078 | NodeEnvironment: applySegmentInfosTrace false | E-02 (L516) | ○ |
| C-079 | NodeEnvironment: hasNodeFile true | E-02 (L880-882) | ○ |
| C-080 | NodeEnvironment: hasNodeFile false | E-02 (L880-882, L311-313) | ○ |
| C-081 | NodeEnvironment: nodeDataPaths | E-02 (L888-895) | ○ |
| C-082 | NodeEnvironment: nodeId | E-02 (L908-913) | ○ |
| C-083 | NodeEnvironment: nodePaths | E-02 (L918-924) | ○ |
| C-084 | NodeEnvironment: nodePaths ローカルストレージなし | E-02 (L920-921) | ○ |
| C-085 | NodeEnvironment: fileCacheNodePath | E-02 (L929-935) | ○ |
| C-086 | NodeEnvironment: fileCacheNodePath ローカルストレージなし | E-02 (L931-932) | ○ |
| C-087 | NodeEnvironment: getNodeLockId | E-02 (L937-943) | ○ |
| C-088 | NodeEnvironment: indexPaths | E-02 (L948-955) | ○ |
| C-089 | NodeEnvironment: availableShardPaths | E-02 (L965-973) | ○ |
| C-090 | NodeEnvironment: shardLock正常 | E-02 (L729-783) | ○ |
| C-091 | NodeEnvironment: shardLock競合 | E-02 (L743-769, L850-873) | ○ |
| C-092 | NodeEnvironment: shardLock再取得 | E-02 (L825-828) | ○ |
| C-093 | NodeEnvironment: lockedShards | E-02 (L801-805) | ○ |
| C-094 | NodeEnvironment: lockedShards空 | E-02 (L801-805) | ○ |
| C-095 | NodeEnvironment: close | E-02 (L1121-1132) | ○ |
| C-096 | NodeEnvironment: close冪等性 | E-02 (L1122) | ○ |
| C-097 | NodeEnvironment: availableIndexFolders | E-02 (L978-997) | ○ |
| C-098 | NodeEnvironment: availableIndexFolders空 | E-02 (L1026) | ○ |
| C-099 | NodeEnvironment: availableIndexFolders(Predicate) | E-02 (L986-997) | ○ |
| C-100 | NodeEnvironment: resolveIndexFolder | E-02 (L1042-1055) | ○ |
| C-101 | NodeEnvironment: resolveIndexFolder不存在 | E-02 (L1050) | ○ |
| C-102 | NodeEnvironment: findAllShardIds | E-02 (L1065-1077) | ○ |
| C-103 | NodeEnvironment: findAllShardIds空 | E-02 (L1105) | ○ |
| C-104 | NodeEnvironment: shardCountPerPath | E-02 (L1085-1100) | ○ |
| C-105 | NodeEnvironment: resolveBaseCustomLocation | E-02 (L1308-1316) | ○ |
| C-106 | NodeEnvironment: resolveBaseCustomLocation空文字 | E-02 (L1309, L1314) | ○ |
| C-107 | NodeEnvironment: resolveBaseCustomLocation null | E-02 (L1309, L1314) | ○ |
| C-108 | NodeEnvironment: resolveCustomLocation | E-02 (L1351-1353, L1355-1358) | ○ |
| C-109 | NodeEnvironment: resolveFileCacheLocation | E-02 (L1339-1341) | ○ |
| C-110 | NodeEnvironment: shardStatePathToDataPath | E-02 (L1364-1372) | ○ |
| C-111 | NodeEnvironment: collectShardDataPaths | E-02 (L1225-1227) | ○ |
| C-112 | NodeEnvironment: collectShardDataPaths空 | E-02 (L1237-1255) | ○ |
| C-113 | NodeEnvironment: collectIndexMetadataPaths | E-02 (L1233-1235) | ○ |
| C-114 | NodeEnvironment: collectFileCacheDataPath | E-02 (L1269-1280) | ○ |
| C-115 | NodeEnvironment: collectFileCacheDataPath空 | E-02 (L1269-1280) | ○ |
| C-116 | NodePath: コンストラクタ | E-02 (L138-151) | ○ |
| C-117 | NodePath: resolve(ShardId) | E-02 (L157-159) | ○ |
| C-118 | NodePath: resolve(Index) | E-02 (L165-167) | ○ |
| C-119 | NodePath: toString | E-02 (L174-188) | ○ |
| C-120 | NodeLock: コンストラクタ | E-02 (L251-284) | ○ |
| C-121 | NodeLock: close | E-02 (L291-298) | ○ |
| C-122 | NodeLock: getNodePaths | E-02 (L286-288) | ○ |
| C-123 | NodeEnvironment: lockAllForIndex正常 | E-02 (L688-715) | ○ |
| C-124 | NodeEnvironment: lockAllForIndex不正シャード数 | E-02 (L695-697) | ○ |
| C-125 | NodeRepurposeCommand: コンストラクタ | E-07 (L78-79) | ○ |
| C-126 | NodeRepurposeCommand: validateBeforeLock data+warm | E-07 (L87-95) | ○ |
| C-127 | NodeRepurposeCommand: validateBeforeLock no-data | E-07 (L87-95) | ○ |
| C-128 | NodeRepurposeCommand: noClusterManagerMessage | E-07 (L317-325) | ○ |
| C-129 | NodeRepurposeCommand: shardMessage | E-07 (L327-329) | ○ |
| C-130 | OverrideNodeVersionCommand: コンストラクタ | E-08 (L82-88) | ○ |
| C-131 | OverrideNodeVersionCommand: processNodePathsメタデータ不存在 | E-08 (L91-97) | △ |
| C-132 | OverrideNodeVersionCommand: processNodePaths互換バージョン | E-08 (L99-108) | △ |
| C-133 | EnvironmentSettingsResponse: Settings コンストラクタ | E-09 (L27-29) | ○ |
| C-134 | EnvironmentSettingsResponse: getEnvironmentSettings | E-09 (L40-42) | ○ |
| C-135 | EnvironmentSettingsResponse: writeTo | E-09 (L36-38) | ○ |
| C-136 | EnvironmentSettingsResponse: StreamInputコンストラクタ | E-09 (L31-33) | ○ |
| C-137 | EnvironmentSettingsResponse: equals同一 | E-09 (L50-54) | ○ |
| C-138 | EnvironmentSettingsResponse: equals異なる | E-09 (L53) | ○ |
| C-139 | EnvironmentSettingsResponse: equals null | E-09 (L52) | ○ |
| C-140 | EnvironmentSettingsResponse: hashCode | E-09 (L57-59) | ○ |
| C-141 | EnvironmentSettingsResponse: toString | E-09 (L45-47) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-131, C-132: OverrideNodeVersionCommandのprocessNodePathsはprotectedメソッドであり、OpenSearchNodeCommandのフレームワーク内で動作する。テストではtestExecuteメソッドや、親クラスのモック化など間接的なアプローチが必要となる可能性がある。実際のテスト実現方法についてはプロジェクトの既存テストパターンを確認することが推奨される。
  - 候補：既存テストの `OverrideNodeVersionCommandTests` / `NodeRepurposeCommandTests` のパターン確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接導出されたテストケースであり、メソッドシグネチャと実装ロジックに基づいている
- 1: 中リスク - C-131, C-132はテスト実装の複雑さが高い可能性がある（親クラスとの統合テストの側面を持つ）
- 0: 低リスク - NodeEnvironmentのテストケースは多くがファイルシステム操作に依存するため、テスト環境のセットアップが必要だが、テスト観点自体は正確

## 6) レビュアーチェックリスト（最小）
- [ ] 全141件のテストケースがソースコードの主要なpublicメソッドを網羅しているか
- [ ] Environment.javaのコンストラクタ分岐（configPath有無、nodeLocalStorage、各Setting有無）が適切にカバーされているか
- [ ] NodeMetadata.upgradeToCurrentVersionの各バージョン条件（V_EMPTY、互換旧、CURRENT、古すぎ、新しすぎ）がすべてテストされているか
- [ ] ShardLockのclose冪等性テストが正しい期待結果を持っているか
- [ ] OpenSearchFileStoreの負値処理（JDK-8162520回避）が正しくテストされているか
- [ ] NodeEnvironmentのロック機構（shardLock取得、競合、再取得）のテスト観点が適切か
- [ ] OverrideNodeVersionCommand/NodeRepurposeCommandのテストが実現可能なレベルで定義されているか
- [ ] EnvironmentSettingsResponseのシリアライゼーション/デシリアライゼーションテストが往復検証を含んでいるか
