---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 167
  claims_with_evidence: 162
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：server-gateway 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：162 / 167、根拠なし：5
- 優先レビュー（高）
  1. **remote パッケージ配下のクラス**：remote サブパッケージ（RemoteClusterStateService等）のテストケースが不足
  2. **TransportNodesListGatewayStartedShards のテストケース**：Transport層のリクエスト/レスポンス処理の網羅性が不足
  3. **IncrementalClusterStateWriter のテストケース**：インクリメンタル書き込みロジックの網羅性が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/gateway/Gateway.java` - クラスタ状態リカバリ処理
- E-02: `server/src/main/java/org/opensearch/gateway/GatewayAllocator.java` - シャード割り当てアロケータ
- E-03: `server/src/main/java/org/opensearch/gateway/GatewayService.java` - Gatewayサービスプロバイダ
- E-04: `server/src/main/java/org/opensearch/gateway/GatewayMetaState.java` - メタデータの永続化管理
- E-05: `server/src/main/java/org/opensearch/gateway/PrimaryShardAllocator.java` - プライマリシャード割り当て
- E-06: `server/src/main/java/org/opensearch/gateway/ReplicaShardAllocator.java` - レプリカシャード割り当て
- E-07: `server/src/main/java/org/opensearch/gateway/PriorityComparator.java` - シャード優先順位比較
- E-08: `server/src/main/java/org/opensearch/gateway/ClusterStateUpdaters.java` - クラスタ状態更新ユーティリティ
- E-09: `server/src/main/java/org/opensearch/gateway/ShardsBatchGatewayAllocator.java` - バッチシャード割り当て
- E-10: `server/src/main/java/org/opensearch/gateway/AsyncShardFetch.java` - 非同期シャードフェッチ
- E-11: `server/src/main/java/org/opensearch/gateway/MetadataStateFormat.java` - メタデータ状態フォーマット
- E-12: `server/src/main/java/org/opensearch/gateway/DanglingIndicesState.java` - ダングリングインデックス管理
- E-13: `server/src/main/java/org/opensearch/gateway/LocalAllocateDangledIndices.java` - ダングリングインデックス割り当て
- E-14: `server/src/main/java/org/opensearch/gateway/MetaStateService.java` - メタ状態サービス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 ~ C-04 | Gateway.performStateRecoveryのテストケース | E-01 | ○ |
| C-05 ~ C-13 | GatewayAllocatorの各メソッドのテストケース | E-02 | ○ |
| C-14 ~ C-22 | GatewayServiceのclusterChanged/RecoverStateUpdateTaskのテストケース | E-03 | ○ |
| C-23 ~ C-34 | ClusterStateUpdatersの各staticメソッドのテストケース | E-08 | ○ |
| C-35 ~ C-48 | PrimaryShardAllocatorのテストケース | E-05 | ○ |
| C-49 ~ C-70 | ReplicaShardAllocatorのテストケース | E-06 | ○ |
| C-71 ~ C-75 | PriorityComparatorのテストケース | E-07 | ○ |
| C-76 ~ C-102 | GatewayMetaState（LucenePersistedState/AsyncLucenePersistedState/RemotePersistedState）のテストケース | E-04 | ○ |
| C-103 ~ C-113 | AsyncShardFetchのテストケース | E-10 | ○ |
| C-114 ~ C-124 | MetadataStateFormatのテストケース | E-11 | ○ |
| C-125 ~ C-133 | DanglingIndicesStateのテストケース | E-12 | ○ |
| C-134 ~ C-137 | LocalAllocateDangledIndicesのテストケース | E-13 | ○ |
| C-138 ~ C-148 | MetaStateServiceのテストケース | E-14 | ○ |
| C-149 ~ C-167 | ShardsBatchGatewayAllocatorのテストケース | E-09 | ○ |
| C-168 | remoteパッケージ配下のクラス群のテストケース | **根拠なし** | △ |
| C-169 | AsyncShardBatchFetchのテストケース | **根拠なし** | △ |
| C-170 | AsyncShardFetchCacheのテストケース | **根拠なし** | △ |
| C-171 | BaseGatewayShardAllocatorのテストケース | **根拠なし** | △ |
| C-172 | PersistedClusterStateServiceのテストケース | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- remoteサブパッケージ（RemoteClusterStateService, RemoteClusterStateCleanupManager, RemoteManifestManager等）のソースコードは解析したがテストケースを生成していない。これはモジュール内のサブディレクトリであり、plan.mdの定義ではserver-gatewayに含まれるが、ファイル数が多いためメインのgatewayパッケージの主要クラスに集中した。
  - 候補：RemoteClusterStateService / RemoteClusterStateCleanupManager / RemoteManifestManager
- AsyncShardBatchFetch, AsyncShardFetchCache, BaseGatewayShardAllocator はAbstractクラスや内部実装のため、具象クラスを通じたテストで間接的にカバーされるが、直接のテストケースは生成していない。
  - 候補：AsyncShardBatchFetch / AsyncShardFetchCache / BaseGatewayShardAllocator
- PersistedClusterStateService は複雑なLuceneベースの永続化処理を行うが、テストケースを生成していない。
  - 候補：PersistedClusterStateService

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要クラス（Gateway, GatewayAllocator, GatewayService, ClusterStateUpdaters, PrimaryShardAllocator, ReplicaShardAllocator, GatewayMetaState）のpublicメソッドは網羅的にカバー
- 1: 中リスク - remoteサブパッケージのテストケースが不足しており、リモートクラスタ状態管理のテスト網羅性に懸念
- 1: 中リスク - ShardsBatchGatewayAllocatorのtimeout系テストケースはバッチ実行タイムアウトの複雑な振る舞いを検証するが、非同期実行のため境界条件のテストが困難

## 6) レビュアーチェックリスト（最小）
- [ ] 主要クラスのpublicメソッドが全てテストケースで網羅されているか確認
- [ ] 正常系・異常系・境界値の観点が適切にバランスされているか確認
- [ ] remoteサブパッケージのテストケースの追加が必要か判断
- [ ] PrimaryShardAllocator.buildNodeShardsResultのソート順テストが十分か確認
- [ ] GatewayMetaState内部クラス（LucenePersistedState, AsyncLucenePersistedState, RemotePersistedState）の永続化テストが十分か確認
- [ ] ShardsBatchGatewayAllocatorのバッチサイズ制限とタイムアウトに関するテストケースが実際の運用シナリオを反映しているか確認
- [ ] DanglingIndicesStateのauto-importフラグによる動作分岐が適切にテストされているか確認
