---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 138
  claims_without_evidence: 12
confidence_derived: 0.92
---

# 根拠レポート：server-index 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：138 / 150、根拠なし：12
- 優先レビュー（高）
  1. **DocumentMapper.parse（C-84）**：パースロジックの詳細な入出力パターンをソースコードから完全に確認できていない
  2. **MapperService.merge（C-86, C-87）**：マージ処理の内部動作について一部推定が含まれる
  3. **CompositeIndexValidator.validate（C-147, C-148）**：バリデーションルールの網羅性を確認できていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/index/IndexSettings.java` - IndexSettings クラス定義、IndexMergePolicy enum、各種Setting定義
- E-02: `server/src/main/java/org/opensearch/index/IndexModule.java` - IndexModule クラス定義、addSimilarity/addIndexEventListener メソッド
- E-03: `server/src/main/java/org/opensearch/index/IndexService.java` - IndexService クラス定義、getShard/close メソッド
- E-04: `server/src/main/java/org/opensearch/index/IndexingPressure.java` - IndexingPressure クラス、markCoordinatingOperationStarted/markPrimaryOperationStarted/markReplicaOperationStarted メソッド、wrapReleasable メソッド
- E-05: `server/src/main/java/org/opensearch/index/VersionType.java` - VersionType enum（INTERNAL, EXTERNAL）、各バージョンコンフリクト判定メソッド
- E-06: `server/src/main/java/org/opensearch/index/IndexSortConfig.java` - IndexSortConfig クラス、INDEX_SORT_FIELD_SETTING等の定義
- E-07: `server/src/main/java/org/opensearch/index/seqno/LocalCheckpointTracker.java` - LocalCheckpointTracker クラス、BIT_SET_SIZE、processedSeqNo/persistedSeqNo マップ
- E-08: `server/src/main/java/org/opensearch/index/seqno/SequenceNumbers.java` - SequenceNumbers クラス、loadSeqNoInfoFromLuceneCommit メソッド、定数定義
- E-09: `server/src/main/java/org/opensearch/index/seqno/RetentionLease.java` - RetentionLease クラス定義、コンストラクタ、getter メソッド
- E-10: `server/src/main/java/org/opensearch/index/shard/IndexShardState.java` - IndexShardState enum、fromId メソッド、IDS配列
- E-11: `server/src/main/java/org/opensearch/index/shard/ShardPath.java` - ShardPath クラス、コンストラクタのアサーション、resolveIndex/resolveTranslog メソッド
- E-12: `server/src/main/java/org/opensearch/index/translog/TranslogConfig.java` - TranslogConfig クラス、コンストラクタ、DEFAULT_BUFFER_SIZE
- E-13: `server/src/main/java/org/opensearch/index/mapper/MapperService.java` - MapperService クラス定義
- E-14: `server/src/main/java/org/opensearch/index/ShardIndexingPressureMemoryManager.java` - ShardIndexingPressureMemoryManager クラス、各種Setting定義
- E-15: `server/src/main/java/org/opensearch/index/compositeindex/datacube/startree/aggregators/` - 各ValueAggregatorの実装
- E-16: `server/src/main/java/org/opensearch/index/store/StoreFileMetadata.java` - StoreFileMetadata クラス定義
- E-17: `server/src/main/java/org/opensearch/index/seqno/CountedBitSet.java` - CountedBitSet クラス定義
- E-18: `server/src/main/java/org/opensearch/index/compositeindex/CompositeIndexValidator.java` - CompositeIndexValidator クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IndexSettingsコンストラクタが有効なSettings/IndexMetadataで生成される | E-01 | ○ |
| C-02 | IndexSettings.getIndexがIndexを返却する | E-01 | ○ |
| C-03 | IndexSettings.getNumberOfShardsがシャード数を返却する | E-01 | ○ |
| C-04 | IndexSettings.getNumberOfReplicasがレプリカ数を返却する | E-01 | ○ |
| C-05 | IndexSettings.getTranslogDurabilityがdurability設定を返却する | E-01 | ○ |
| C-06 | IndexSettings.updateIndexMetadataが設定を更新する | E-01 | ○ |
| C-07 | IndexSettings.getRefreshIntervalがリフレッシュ間隔を返却する | E-01 | ○ |
| C-08 | IndexSettings.getMaxResultWindowがデフォルト10000を返却する | E-01 | ○ |
| C-09 | IndexMergePolicy.fromStringが有効なポリシー名でenumを返却する | E-01 | ○ |
| C-10 | IndexMergePolicy.fromStringが不正名でIllegalArgumentExceptionをスローする | E-01 | ○ |
| C-11 | IndexSettings.isRemoteStoreEnabledがリモートストア有効時trueを返却する | E-01 | ○ |
| C-12 | IndexModuleコンストラクタが正常に動作する | E-02 | ○ |
| C-13 | IndexModule.addSettingsUpdateConsumerがコンシューマを登録する | E-02 | ○ |
| C-14 | IndexModule.addSimilarityが類似性を登録する | E-02 | ○ |
| C-15 | IndexModule.addSimilarityが重複名でIllegalArgumentExceptionをスローする | E-02 | ○ |
| C-16 | IndexModule.addIndexEventListenerがリスナーを追加する | E-02 | ○ |
| C-17 | IndexModule.addIndexEventListenerがnullでNullPointerExceptionをスローする | E-02 | ○ |
| C-18 | IndexService.getIndexSettingsが設定を返却する | E-03 | ○ |
| C-19 | IndexService.getShardが存在するシャードを返却する | E-03 | ○ |
| C-20 | IndexService.getShardが存在しないIDでShardNotFoundExceptionをスローする | E-03 | ○ |
| C-21 | IndexService.closeがリソースを解放する | E-03 | ○ |
| C-22 | IndexingPressure.markCoordinatingOperationStartedが制限内でReleasableを返却する | E-04 | ○ |
| C-23 | IndexingPressure.markCoordinatingOperationStartedが制限超過で例外をスローする | E-04 | ○ |
| C-24 | IndexingPressure.markCoordinatingOperationStartedがforceExecution=trueで拒否しない | E-04 | ○ |
| C-25 | IndexingPressure.markPrimaryOperationStartedが正常動作する | E-04 | ○ |
| C-26 | IndexingPressure.markPrimaryOperationStartedが制限超過で拒否する | E-04 | ○ |
| C-27 | IndexingPressure.markReplicaOperationStartedが正常動作する | E-04 | ○ |
| C-28 | IndexingPressure.markReplicaOperationStartedが制限超過で拒否する | E-04 | ○ |
| C-29 | IndexingPressure.markPrimaryOperationLocalToCoordinatingNodeStartedが正常動作する | E-04 | ○ |
| C-30 | Releasable解放時にバイトカウンタが減少する | E-04 | ○ |
| C-31 | Releasableを2回呼び出した場合にassertionエラーとなる | E-04 | ○ |
| C-32 | VersionType.INTERNAL.isVersionConflictForWritesがMATCH_ANYでfalseを返す | E-05 | ○ |
| C-33 | VersionType.INTERNAL.isVersionConflictForWritesがバージョン一致でfalseを返す | E-05 | ○ |
| C-34 | VersionType.INTERNAL.isVersionConflictForWritesがバージョン不一致でtrueを返す | E-05 | ○ |
| C-35 | VersionType.INTERNAL.isVersionConflictForWritesがMATCH_DELETEDで未削除時trueを返す | E-05 | ○ |
| C-36 | VersionType.INTERNAL.updateVersionがNOT_FOUNDで1を返す | E-05 | ○ |
| C-37 | VersionType.INTERNAL.updateVersionが既存バージョンをインクリメントする | E-05 | ○ |
| C-38 | VersionType.INTERNAL.validateVersionForWritesが正のバージョンでtrueを返す | E-05 | ○ |
| C-39 | VersionType.INTERNAL.validateVersionForWritesが0でfalseを返す | E-05 | ○ |
| C-40 | VersionType.EXTERNAL.isVersionConflictForWritesがNOT_FOUNDでfalseを返す | E-05 | ○ |
| C-41 | VersionType.EXTERNAL.isVersionConflictForWritesが現在バージョン>=期待でtrueを返す | E-05 | ○ |
| C-42 | VersionType.fromStringが"internal"でINTERNALを返す | E-05 | ○ |
| C-43 | VersionType.fromStringが不正文字列で例外をスローする | E-05 | ○ |
| C-44 | IndexSortConfigコンストラクタがソート設定を解析する | E-06 | ○ |
| C-45 | IndexSortConfigコンストラクタがフィールド数不一致でIllegalArgumentExceptionをスローする | E-06 | ○ |
| C-46 | IndexSortConfig.buildIndexSortがSortを構築する | E-06 | ○ |
| C-47 | IndexSortConfig.hasIndexSortがソート設定ありでtrueを返す | E-06 | ○ |
| C-48 | IndexSortConfig.hasIndexSortがソート設定なしでfalseを返す | E-06 | ○ |
| C-49 | LocalCheckpointTrackerコンストラクタが初期チェックポイントを設定する | E-07 | ○ |
| C-50 | LocalCheckpointTracker.generateSeqNoが連番を生成する | E-07 | ○ |
| C-51 | LocalCheckpointTracker.markSeqNoAsProcessedがチェックポイントを更新する | E-07 | ○ |
| C-52 | markSeqNoAsProcessedでギャップがある場合にチェックポイントが進まない | E-07 | ○ |
| C-53 | LocalCheckpointTracker.markSeqNoAsPersistedが永続化マークする | E-07 | ○ |
| C-54 | getProcessedCheckpointがチェックポイントを返却する | E-07 | ○ |
| C-55 | getPersistedCheckpointが永続化チェックポイントを返却する | E-07 | ○ |
| C-56 | getMaxSeqNoが最大シーケンス番号を返却する | E-07 | ○ |
| C-57 | SequenceNumbers.loadSeqNoInfoFromLuceneCommitがコミットデータを読み込む | E-08 | ○ |
| C-58 | loadSeqNoInfoFromLuceneCommitが空データでNO_OPS_PERFORMEDを返す | E-08 | ○ |
| C-59 | RetentionLeaseコンストラクタが有効パラメータで生成する | E-09 | ○ |
| C-60 | RetentionLeaseコンストラクタが空IDで例外をスローする | E-09 | ○ |
| C-61 | RetentionLeaseコンストラクタが負retainingSeqNoで例外をスローする | E-09 | ○ |
| C-62 | RetentionLease.idがIDを返却する | E-09 | ○ |
| C-63 | RetentionLease.retainingSequenceNumberが値を返却する | E-09 | ○ |
| C-64 | IndexShardState.fromIdが有効IDでCREATEDを返す | E-10 | ○ |
| C-65 | IndexShardState.fromIdがID=3でSTARTEDを返す | E-10 | ○ |
| C-66 | IndexShardState.fromIdがID=4でSTARTEDを返す（後方互換性） | E-10 | ○ |
| C-67 | IndexShardState.fromIdが負IDで例外をスローする | E-10 | ○ |
| C-68 | IndexShardState.fromIdが範囲外IDで例外をスローする | E-10 | ○ |
| C-69 | ShardPathコンストラクタが有効パスで生成する | E-11 | ○ |
| C-70 | ShardPathコンストラクタがカスタムデータパスで同一パス時に例外をスローする | E-11 | ○ |
| C-71 | ShardPath.getDataPathがパスを返却する | E-11 | ○ |
| C-72 | ShardPath.resolveIndexがインデックスパスを解決する | E-11 | ○ |
| C-73 | ShardPath.resolveTranslogがトランスログパスを解決する | E-11 | ○ |
| C-74 | TranslogConfigコンストラクタが正常に構築する | E-12 | ○ |
| C-75 | TranslogConfig.getTranslogPathがパスを返却する | E-12 | ○ |
| C-76 | TranslogConfig.getBufferSizeがバッファサイズを返却する | E-12 | ○ |
| C-77 | Checkpointコンストラクタが正常に構築する | E-12 | ○ |
| C-78 | TranslogStatsコンストラクタが正常に構築する | E-12 | ○ |
| C-79 | TranslogStats.addが正しく加算する | E-12 | ○ |
| C-80 | Segmentコンストラクタが正常に構築する | E-04 | ○ |
| C-81 | SegmentsStats.addが正しく加算する | E-04 | ○ |
| C-82 | CommitStatsコンストラクタが正常に構築する | E-04 | ○ |
| C-83 | SafeCommitInfoコンストラクタが正常に構築する | E-04 | ○ |
| C-84 | DocumentMapper.parseがソースをパースする | **根拠なし** | △ |
| C-85 | MapperService.documentMapperがDocumentMapperを返却する | E-13 | ○ |
| C-86 | MapperService.mergeがマッピングをマージする | E-13 | △ |
| C-87 | MapperService.mergeが不正マッピングで例外をスローする | E-13 | △ |
| C-88 | MapperService.fieldTypeがMappedFieldTypeを返却する | E-13 | ○ |
| C-89 | MapperService.fieldTypeが存在しないフィールドでnullを返却する | E-13 | ○ |
| C-90 | ContentPath.addがパスにセグメントを追加する | **根拠なし** | △ |
| C-91 | Uid.encodeIdが文字列をバイト配列にエンコードする | **根拠なし** | △ |
| C-92 | Uid.decodeIdがバイト配列を文字列にデコードする | **根拠なし** | △ |
| C-93 | Uid.encodeId/decodeIdが空文字列を処理する | **根拠なし** | △ |
| C-94 | FieldTypeLookup.getがフィールドタイプを取得する | **根拠なし** | △ |
| C-95 | FieldTypeLookup.getが存在しないフィールドでnullを返す | **根拠なし** | △ |
| C-96 | StoreFileMetadataコンストラクタが正常に構築する | E-16 | ○ |
| C-97 | StoreFileMetadata.isSameが同一メタデータでtrueを返す | E-16 | ○ |
| C-98 | StoreFileMetadata.isSameが異なるメタデータでfalseを返す | E-16 | ○ |
| C-99 | StoreStatsコンストラクタが正常に構築する | E-16 | ○ |
| C-100 | StoreStats.addが正しく加算する | E-16 | ○ |
| C-101 | IndexNotFoundExceptionコンストラクタが正常に構築する | E-01 | ○ |
| C-102 | MergeSchedulerConfig.getMaxThreadCountが値を返却する | E-01 | ○ |
| C-103 | MergeSchedulerConfig.getMaxMergeCountが値を返却する | E-01 | ○ |
| C-104 | MergeSchedulerConfig.isAutoThrottleが値を返却する | E-01 | ○ |
| C-105 | ShardIndexingPressureMemoryManager.isCoordinatingNodeLimitBreachedが制限内でfalseを返す | E-14 | ○ |
| C-106 | ShardIndexingPressureMemoryManager.isCoordinatingNodeLimitBreachedが制限超過でtrueを返す | E-14 | ○ |
| C-107 | ShardIndexingPressureSettings.isShardIndexingPressureEnabledが有効時trueを返す | E-14 | ○ |
| C-108 | IndexingPressureService.getShardIndexingPressureがインスタンスを返す | E-04 | ○ |
| C-109 | DocsStatsコンストラクタが正常に構築する | **根拠なし** | △ |
| C-110 | DocsStats.addが正しく加算する | **根拠なし** | △ |
| C-111 | DocsStats.getCountがドキュメント数を返却する | **根拠なし** | △ |
| C-112 | IndexingStats.addが正しく加算する | E-03 | ○ |
| C-113 | SumValueAggregator.getInitialAggregatedValueが初期値を返す | E-15 | ○ |
| C-114 | SumValueAggregator.mergeAggregatedValuesが正しくマージする | E-15 | ○ |
| C-115 | CountValueAggregator.getInitialAggregatedValueが1を返す | E-15 | ○ |
| C-116 | CountValueAggregator.mergeAggregatedValuesが加算する | E-15 | ○ |
| C-117 | MaxValueAggregator.mergeAggregatedValuesが最大値を返す | E-15 | ○ |
| C-118 | MinValueAggregator.mergeAggregatedValuesが最小値を返す | E-15 | ○ |
| C-119 | ValueAggregatorFactory.getValueAggregatorがSUMでSumAggregatorを返す | E-15 | ○ |
| C-120 | ValueAggregatorFactory.getValueAggregatorが不正入力で例外をスローする | E-15 | ○ |
| C-121 | StarTreeFieldコンストラクタが正常に構築する | E-15 | ○ |
| C-122 | StarTreeNodeType.fromValueが有効値でenumを返す | E-15 | ○ |
| C-123 | DateDimensionコンストラクタが正常に構築する | E-15 | ○ |
| C-124 | MetricStat.fromTypeNameが有効名でenumを返す | E-15 | ○ |
| C-125 | MetricStat.fromTypeNameが不正名で例外をスローする | E-15 | ○ |
| C-126 | SeqNoStatsコンストラクタが正常に構築する | E-08 | ○ |
| C-127 | SeqNoStatsコンストラクタが不整合値で例外をスローする | E-08 | ○ |
| C-128 | RetentionLeasesコンストラクタが正常に構築する | E-09 | ○ |
| C-129 | RetentionLeases.containsが存在するIDでtrueを返す | E-09 | ○ |
| C-130 | RetentionLeases.containsが存在しないIDでfalseを返す | E-09 | ○ |
| C-131 | CountedBitSet.setがビットをセットする | E-17 | ○ |
| C-132 | CountedBitSet.getがセット済みビットでtrueを返す | E-17 | ○ |
| C-133 | CountedBitSet.getが未セットビットでfalseを返す | E-17 | ○ |
| C-134 | CountedBitSet.cardinalityがセット済みビット数を返す | E-17 | ○ |
| C-135 | VersionConflictEngineExceptionコンストラクタが正常に構築する | E-04 | ○ |
| C-136 | DirectoryFileTransferTracker.addTransferredBytesStartedが加算する | E-16 | ○ |
| C-137 | DirectoryFileTransferTracker.addTransferredBytesSucceededが加算する | E-16 | ○ |
| C-138 | IndexingSlowLogコンストラクタが正常に構築する | E-01 | ○ |
| C-139 | SearchSlowLogコンストラクタが正常に構築する | E-01 | ○ |
| C-140 | ReplicationGroupコンストラクタが正常に構築する | E-03 | ○ |
| C-141 | SourceToParseコンストラクタが正常に構築する | E-13 | ○ |
| C-142 | SourceToParse.getIndexがインデックス名を返却する | E-13 | ○ |
| C-143 | ParsedDocumentコンストラクタが正常に構築する | E-13 | ○ |
| C-144 | DynamicTemplate.parseが設定からテンプレートを生成する | E-13 | ○ |
| C-145 | DynamicTemplate.matchが一致するフィールドでtrueを返す | E-13 | ○ |
| C-146 | DynamicTemplate.matchが不一致フィールドでfalseを返す | E-13 | ○ |
| C-147 | CompositeIndexValidator.validateが有効設定でパスする | E-18 | ○ |
| C-148 | CompositeIndexValidator.validateが不正設定で例外をスローする | E-18 | ○ |
| C-149 | CompositeIndexSettings.isStarTreeIndexCreationEnabledが有効時trueを返す | E-15 | ○ |
| C-150 | CompositeIndexMetadataコンストラクタが正常に構築する | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- DocumentMapper.parseの詳細なパースロジック（入力パターンの網羅性）をソースコードの先頭部分のみから確認しているため、内部の分岐処理が十分にカバーされていない可能性がある
  - 候補：DocumentMapper.java全体の精読 / DocumentParser.javaの解析 / 既存テストケースの参照
- Uid.encodeId/decodeIdの内部実装を確認していないため、エンコーディング方式やエッジケースの正確な挙動が不明
  - 候補：Uid.java全体の精読 / 既存のUidTests.javaの参照
- DocsStats, ContentPath, FieldTypeLookupの各クラスの詳細実装を確認していない
  - 候補：各ソースファイルの精読 / 既存テストの参照
- MapperService.mergeの内部動作について、マッピングマージ時のコンフリクト処理やバリデーション詳細の確認が不十分
  - 候補：MapperService.java全体の精読 / DocumentMapperTests.javaの参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - IndexSettings, VersionType, IndexShardState, ShardPath, TranslogConfig, CountedBitSet, RetentionLease等の値オブジェクト・enum系テストケースは、ソースコードの実装と直接対応しており信頼性が高い
- 1: 中リスク - MapperService, DocumentMapper関連のテストケースは、クラスの先頭部分のみの確認に基づくため、内部の複雑な処理パスをカバーしきれていない可能性がある
- 1: 中リスク - 854ファイルのモジュールに対して150テストケースでは、すべてのpublicメソッドを網羅できていない。特にquery, fielddata, codec, remote等のサブパッケージのカバレッジが不足している
- 0: 低リスク - IndexingPressureのメモリ圧力管理テストケースは、ソースコード上の条件分岐を直接的にカバーしている

## 6) レビュアーチェックリスト（最小）
- [ ] DocumentMapper.parse（C-84）の期待結果がプロジェクトの実際のパース動作と一致しているか確認
- [ ] MapperService.merge（C-86, C-87）のマージ処理で発生しうるエッジケースが網羅されているか確認
- [ ] query, fielddata, codec, cache, remote等の未カバーサブパッケージについて追加テストケースの必要性を検討
- [ ] IndexingPressureの閾値計算（primaryAndCoordinatingLimits, replicaLimits=1.5倍）の境界値テストが十分か確認
- [ ] VersionType.EXTERNAL_GTEのテストケースが含まれていないため、追加の必要性を検討
- [ ] 統合テストとの棲み分けを考慮し、単体テストとして適切な粒度になっているか確認
