---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 108
  claims_with_evidence: 105
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：server-indices 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：105 / 108、根拠なし：3
- 優先レビュー（高）
  1. **C-025 (UT-IND-025)**: validateShardLimitのシステムインデックス除外動作はソースコード上のshouldIndexBeIgnoredメソッドから推定しているが、具体的なテスト前提条件の完全性は要確認
  2. **C-053 (UT-IND-053)**: IndicesQueryCache.getStatsの未登録シャードの動作は内部実装のStats nullチェックに依存するため要確認
  3. **C-086 (UT-IND-086)**: IngestionUtils.getParsedPayloadMapの不正JSONに対する具体的な例外型はXContentHelper内部実装に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/indices/SystemIndexDescriptor.java` - コンストラクタのバリデーションロジック（L59-82）
- E-02: `server/src/main/java/org/opensearch/indices/SystemIndexDescriptor.java` - matchesIndexPatternメソッド（L96-98）
- E-03: `server/src/main/java/org/opensearch/indices/SystemIndices.java` - isSystemIndex / findMatchingDescriptor / validateSystemIndexメソッド（L71-141）
- E-04: `server/src/main/java/org/opensearch/indices/SystemIndexRegistry.java` - matchesSystemIndexPattern / checkForOverlappingPatterns / getPluginSystemIndexPredicateメソッド（L59-133）
- E-05: `server/src/main/java/org/opensearch/indices/ShardLimitValidator.java` - checkShardLimit / validateShardLimit / getShardRoutingPoolメソッド（L206-396）
- E-06: `server/src/main/java/org/opensearch/indices/ShardLimitValidator.java` - MaxShardPerClusterLimitValidator / MaxShardPerNodeLimitValidator内部クラス（L401-488）
- E-07: `server/src/main/java/org/opensearch/indices/breaker/BreakerSettings.java` - コンストラクタ / updateFromSettings / アクセサメソッド（L92-167）
- E-08: `server/src/main/java/org/opensearch/indices/breaker/HierarchyCircuitBreakerService.java` - コンストラクタ / validateSettings / getBreaker / statsメソッド（L179-348）
- E-09: `server/src/main/java/org/opensearch/indices/IndicesModule.java` - getMappers / getMetadataMappers / getBuiltInMetadataFieldsメソッド（L152-259）
- E-10: `server/src/main/java/org/opensearch/indices/IndicesQueryCache.java` - コンストラクタ / getStats / clearIndex / setSkipCacheFactorメソッド（L137-266）
- E-11: `server/src/main/java/org/opensearch/indices/IndicesQueryCache.java` - OpenseachUsageTrackingQueryCachingPolicyクラス（L468-522）
- E-12: `server/src/main/java/org/opensearch/indices/TermsLookup.java` - コンストラクタ / equals / hashCode / アクセサメソッド（L60-269）
- E-13: `server/src/main/java/org/opensearch/indices/mapper/MapperRegistry.java` - 全メソッド（L52-101）
- E-14: `server/src/main/java/org/opensearch/indices/pollingingest/IngestionErrorStrategy.java` - createファクトリ / ErrorStrategy enum（L20-73）
- E-15: `server/src/main/java/org/opensearch/indices/pollingingest/DropIngestionErrorStrategy.java` - 全メソッド（L17-42）
- E-16: `server/src/main/java/org/opensearch/indices/pollingingest/BlockIngestionErrorStrategy.java` - 全メソッド（L17-42）
- E-17: `server/src/main/java/org/opensearch/indices/pollingingest/IngestionSettings.java` - Builderクラス / アクセサメソッド（L18-89）
- E-18: `server/src/main/java/org/opensearch/indices/pollingingest/IngestionUtils.java` - getParsedPayloadMapメソッド（L21-30）
- E-19: `server/src/main/java/org/opensearch/indices/pollingingest/PollingIngestStats.java` - equals / hashCode / Builderクラス（L26-276）
- E-20: `server/src/main/java/org/opensearch/indices/replication/common/ReplicationTimer.java` - start / time / stop / resetメソッド（L26-101）
- E-21: `server/src/main/java/org/opensearch/indices/recovery/RecoveryState.java` - Stage enum / fromIdメソッド（L69-119）
- E-22: `server/src/main/java/org/opensearch/indices/ClusterMergeSchedulerConfig.java` - getClusterMaxThreadCountDefault / getClusterMaxMergeCountDefaultメソッド（L178-193）
- E-23: `server/src/main/java/org/opensearch/indices/replication/checkpoint/ReplicationCheckpoint.java` - emptyファクトリメソッド（L45-62）
- E-24: `server/src/main/java/org/opensearch/indices/DefaultRemoteStoreSettings.java` - INSTANCEフィールド（L19-26）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | SystemIndexDescriptorの正常生成 | E-01 | ○ |
| C-002 | indexPatternがnullでNPE | E-01 (L60) | ○ |
| C-003 | indexPatternが1文字でIAE | E-01 (L61-64) | ○ |
| C-004 | indexPatternがドット以外で始まる場合IAE | E-01 (L66-70) | ○ |
| C-005 | indexPatternが.*で始まる場合IAE | E-01 (L71-77) | ○ |
| C-006 | matchesIndexPatternのtrue判定 | E-02 | ○ |
| C-007 | matchesIndexPatternのfalse判定 | E-02 | ○ |
| C-008 | getIndexPatternアクセサ | E-01 | ○ |
| C-009 | getDescriptionアクセサ | E-01 | ○ |
| C-010 | isSystemIndexのtrue判定 | E-03 (L80-82) | ○ |
| C-011 | isSystemIndexのfalse判定 | E-03 (L80-82) | ○ |
| C-012 | findMatchingDescriptorの単一マッチ | E-03 (L90-119) | ○ |
| C-013 | findMatchingDescriptorのnull返却 | E-03 (L96-97) | ○ |
| C-014 | validateSystemIndexのtrue返却 | E-03 (L126-141) | ○ |
| C-015 | validateSystemIndexのfalse返却 | E-03 (L127) | ○ |
| C-016 | matchesSystemIndexPatternのtrue | E-04 (L63-64) | ○ |
| C-017 | matchesSystemIndexPatternのfalse | E-04 (L63-64) | ○ |
| C-018 | 重複パターンでIllegalStateException | E-04 (L104-133) | ○ |
| C-019 | 重複なしパターンの正常検証 | E-04 (L104-133) | ○ |
| C-020 | checkShardLimitの正常通過 | E-05 (L352-389) | ○ |
| C-021 | checkShardLimitの制限超過 | E-05 (L374-387) | ○ |
| C-022 | nodeCount=0でスキップ | E-05 (L362-364) | ○ |
| C-023 | newShards<0でスキップ | E-05 (L362) | ○ |
| C-024 | maxShardsPerClusterSettingの適用 | E-05 (L366-372) | ○ |
| C-025 | システムインデックスの除外 | E-05 (L212-213) | △ |
| C-026 | 制限超過でValidationException | E-05 (L206-227) | ○ |
| C-027 | getShardRoutingPoolのLOCAL_ONLY | E-05 (L391-396) | ○ |
| C-028 | getShardRoutingPoolのREMOTE_CAPABLE | E-05 (L391-396) | ○ |
| C-029 | MaxShardPerClusterのバリデーション | E-06 (L482-488) | ○ |
| C-030 | MaxShardPerCluster=-1のパス | E-06 (L483) | ○ |
| C-031 | BreakerSettings 3引数コンストラクタ | E-07 (L119-121) | ○ |
| C-032 | BreakerSettings 5引数コンストラクタ | E-07 (L123-129) | ○ |
| C-033 | updateFromSettingsの更新 | E-07 (L92-113) | ○ |
| C-034 | updateFromSettingsのデフォルト | E-07 (L115-117) | ○ |
| C-035 | getName | E-07 (L131-133) | ○ |
| C-036 | getLimit | E-07 (L135-137) | ○ |
| C-037 | toString | E-07 (L152-166) | ○ |
| C-038 | HierarchyCircuitBreakerServiceの初期化 | E-08 (L179-277) | ○ |
| C-039 | 重複カスタムブレーカーでIAE | E-08 (L228-234) | ○ |
| C-040 | validateSettingsの正常通過 | E-08 (L305-316) | ○ |
| C-041 | 負のoverheadでISE | E-08 (L312-313) | ○ |
| C-042 | limit=-1のスキップ | E-08 (L308-310) | ○ |
| C-043 | getBreakerの取得 | E-08 (L319-321) | ○ |
| C-044 | statsの全統計取得 | E-08 (L324-336) | ○ |
| C-045 | getMappersの組み込みマッパー | E-09 (L152-194) | ○ |
| C-046 | getMappersの重複検出 | E-09 (L188-189) | ○ |
| C-047 | getMetadataMappersの組み込み | E-09 (L222-252) | ○ |
| C-048 | _field_namesの保護 | E-09 (L240-241) | ○ |
| C-049 | getBuiltInMetadataFields | E-09 (L257-259) | ○ |
| C-050 | getNamedWriteables | E-09 (L122-130) | ○ |
| C-051 | IndicesQueryCacheの初期化 | E-10 (L137-158) | ○ |
| C-052 | getStatsの正常取得 | E-10 (L171-206) | ○ |
| C-053 | 未登録シャードの統計 | E-10 (L177-179) | △ |
| C-054 | clearIndexのキャッシュクリア | E-10 (L253-266) | ○ |
| C-055 | setSkipCacheFactor | E-10 (L160-168) | ○ |
| C-056 | minFrequencyCacheの通常クエリ | E-11 (L480-489) | ○ |
| C-057 | BooleanQueryの頻度 | E-11 (L485-488) | ○ |
| C-058 | 高コストクエリの頻度 | E-11 (L481, L497-501) | ○ |
| C-059 | TermsLookup id指定の生成 | E-12 (L68-69) | ○ |
| C-060 | TermsLookup query指定の生成 | E-12 (L72-93) | ○ |
| C-061 | index=nullでIAE | E-12 (L73-74) | ○ |
| C-062 | path=nullでIAE | E-12 (L76-77) | ○ |
| C-063 | id/query両方nullでIAE | E-12 (L79-82) | ○ |
| C-064 | id/query両方指定でIAE | E-12 (L84-86) | ○ |
| C-065 | equals正常 | E-12 (L254-268) | ○ |
| C-066 | equals不一致 | E-12 (L254-268) | ○ |
| C-067 | hashCode一致 | E-12 (L249-251) | ○ |
| C-068 | routing設定 | E-12 (L147-150) | ○ |
| C-069 | store設定 | E-12 (L154-161) | ○ |
| C-070 | getMapperParsers | E-13 (L72-74) | ○ |
| C-071 | getMetadataMapperParsers | E-13 (L80-82) | ○ |
| C-072 | isMetadataFieldのtrue | E-13 (L87-89) | ○ |
| C-073 | isMetadataFieldのfalse | E-13 (L87-89) | ○ |
| C-074 | DROP戦略の生成 | E-14 (L32-39) | ○ |
| C-075 | BLOCK戦略の生成 | E-14 (L34-35) | ○ |
| C-076 | parseFromStringの正常解析 | E-14 (L55-58) | ○ |
| C-077 | parseFromStringの無効文字列 | E-14 (L58-60) | ○ |
| C-078 | parseFromStringの大文字小文字非区別 | E-14 (L57) | ○ |
| C-079 | DropのshouldIgnoreError=true | E-15 (L34-36) | ○ |
| C-080 | DropのgetName | E-15 (L39-41) | ○ |
| C-081 | BlockのshouldIgnoreError=false | E-16 (L34-36) | ○ |
| C-082 | BlockのgetName | E-16 (L39-41) | ○ |
| C-083 | IngestionSettings全フィールド設定 | E-17 (L32-36, L61-87) | ○ |
| C-084 | IngestionSettings部分更新 | E-17 (L62-66) | ○ |
| C-085 | getParsedPayloadMap正常 | E-18 (L25-29) | ○ |
| C-086 | getParsedPayloadMap不正JSON | E-18 (L27) | △ |
| C-087 | PollingIngestStats equals一致 | E-19 (L126-131) | ○ |
| C-088 | PollingIngestStats equals不一致 | E-19 (L126-131) | ○ |
| C-089 | PollingIngestStats hashCode | E-19 (L134-136) | ○ |
| C-090 | PollingIngestStats Builder | E-19 (L160-265) | ○ |
| C-091 | ReplicationTimer start | E-20 (L50-53) | ○ |
| C-092 | ReplicationTimer time未開始 | E-20 (L66-74) | ○ |
| C-093 | ReplicationTimer time開始後 | E-20 (L66-74) | ○ |
| C-094 | ReplicationTimer stop | E-20 (L83-88) | ○ |
| C-095 | ReplicationTimer reset | E-20 (L90-95) | ○ |
| C-096 | Stage.fromId正常 | E-21 (L113-118) | ○ |
| C-097 | Stage.fromId負のID | E-21 (L114-115) | ○ |
| C-098 | Stage.fromId最大値 | E-21 (L113-118) | ○ |
| C-099 | Stage.fromId範囲外 | E-21 (L114-115) | ○ |
| C-100 | getClusterMaxThreadCountDefault | E-22 (L178-186) | ○ |
| C-101 | getClusterMaxMergeCountDefault | E-22 (L191-193) | ○ |
| C-102 | ReplicationCheckpoint.empty | E-23 (L45-62) | ○ |
| C-103 | ReplicationCheckpoint.emptyコーデック指定 | E-23 (L49-51) | ○ |
| C-104 | DefaultRemoteStoreSettings.INSTANCE | E-24 (L22-25) | ○ |
| C-105 | matchesPluginSystemIndexPatternの正常マッチ | E-04 (L67-78) | ○ |
| C-106 | matchesPluginSystemIndexPatternの未登録プラグイン | E-04 (L68-69) | ○ |
| C-107 | getPluginSystemIndexPredicateの登録済み | E-04 (L83-91) | ○ |
| C-108 | getPluginSystemIndexPredicateの未登録 | E-04 (L85-87) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-025: validateShardLimitのシステムインデックス除外テストは、shouldIndexBeIgnoredの内部メソッド呼び出しチェーンに依存しており、SystemIndicesモックの具体的な設定方法がソースコードからは推定のみ
  - 候補：既存テストコード / SystemIndicesのモック構成例
- C-053: IndicesQueryCache.getStatsで未登録ShardIdが渡された場合の動作は、内部のStats取得がnullになるケースの挙動に依存。デフォルトのQueryCacheStats生成パスは確認済みだが、完全な動作確認には実行テストが必要
  - 候補：IndicesQueryCacheの既存テスト
- C-086: IngestionUtils.getParsedPayloadMapに無効なJSONが渡された場合の具体的な例外型は、XContentHelper.convertToMap内部の実装に依存。OpenSearchParseExceptionまたはRuntimeExceptionが想定されるが、厳密な型は要確認
  - 候補：XContentHelperのソースコード / 既存テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SystemIndexDescriptor / SystemIndices / SystemIndexRegistry / BreakerSettings / MapperRegistry / IngestionErrorStrategy / IngestionSettings / PollingIngestStats / ReplicationTimer / RecoveryState.Stage / ReplicationCheckpoint / DefaultRemoteStoreSettings 関連テストケース（ソースコードから直接導出可能）
- 0: 低リスク - TermsLookupのバリデーション / equals / hashCode テストケース（コンストラクタのバリデーションロジックが明確）
- 1: 中リスク - ShardLimitValidator / HierarchyCircuitBreakerService / IndicesQueryCache関連テストケース（クラスタ状態やモック依存が多い）
- 1: 中リスク - IndicesModuleのgetMappers / getMetadataMappers（プラグイン連携の複雑さ）

## 6) レビュアーチェックリスト（最小）
- [ ] ShardLimitValidator.checkShardLimitのREMOTE_CAPABLE分岐のテストケースが十分か確認
- [ ] HierarchyCircuitBreakerServiceのメモリ使用量計算関連テストが不足していないか確認
- [ ] IndicesRequestCacheに対するテストケースが本CSVの対象範囲に含まれるべきか確認（ファイルサイズが大きく一部のみ解析）
- [ ] IndicesServiceクラスはモジュール内最大のクラスだが、本CSVでは対象外としている点の妥当性確認
- [ ] recovery / replicationサブパッケージの複雑なクラス（RecoverySourceHandler / SegmentReplicationTargetServiceなど）のテストケースが不足していないか確認
- [ ] pollingingest/DefaultStreamPollerやMessageProcessorRunnableなど、状態遷移を伴うクラスのテストケース追加要否を確認
