---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 151
  claims_with_evidence: 148
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：server-ingest 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：148 / 151、根拠なし：3
- 優先レビュー（高）
  1. **C-132 SystemIngestPipelineCache最大エントリ数テスト**：MAX_ENTRIESの値(100)はハードコードされたフィールドから確認したが、evictロジックの詳細な振る舞いは実行時テストが必要
  2. **C-095/C-096 prepareBatchesのグルーピングロジック**：hashCodeベースのグルーピングの詳細な動作は実装に依存し、テスト期待値の正確性は実行時確認が望ましい
  3. **C-101 innerUpdatePipelinesの代替パイプライン生成**：substitutePipelineメソッドの完全な動作はOpenSearchParseExceptionのヘッダ依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/ingest/IngestDocument.java` - IngestDocumentクラスの実装
- E-02: `server/src/main/java/org/opensearch/ingest/Pipeline.java` - Pipelineクラスの実装
- E-03: `server/src/main/java/org/opensearch/ingest/CompoundProcessor.java` - CompoundProcessorクラスの実装
- E-04: `server/src/main/java/org/opensearch/ingest/ConditionalProcessor.java` - ConditionalProcessorクラスの実装
- E-05: `server/src/main/java/org/opensearch/ingest/ConfigurationUtils.java` - ConfigurationUtilsクラスの実装
- E-06: `server/src/main/java/org/opensearch/ingest/IngestService.java` - IngestServiceクラスの実装
- E-07: `server/src/main/java/org/opensearch/ingest/PipelineConfiguration.java` - PipelineConfigurationクラスの実装
- E-08: `server/src/main/java/org/opensearch/ingest/IngestMetadata.java` - IngestMetadataクラスの実装
- E-09: `server/src/main/java/org/opensearch/ingest/IngestStats.java` - IngestStatsクラスの実装
- E-10: `server/src/main/java/org/opensearch/ingest/IngestInfo.java` - IngestInfoクラスの実装
- E-11: `server/src/main/java/org/opensearch/ingest/IngestDocumentWrapper.java` - IngestDocumentWrapperクラスの実装
- E-12: `server/src/main/java/org/opensearch/ingest/DropProcessor.java` - DropProcessorクラスの実装
- E-13: `server/src/main/java/org/opensearch/ingest/PipelineProcessor.java` - PipelineProcessorクラスの実装
- E-14: `server/src/main/java/org/opensearch/ingest/TrackingResultProcessor.java` - TrackingResultProcessorクラスの実装
- E-15: `server/src/main/java/org/opensearch/ingest/AbstractBatchingProcessor.java` - AbstractBatchingProcessorクラスの実装
- E-16: `server/src/main/java/org/opensearch/ingest/SystemIngestPipelineCache.java` - SystemIngestPipelineCacheクラスの実装
- E-17: `server/src/main/java/org/opensearch/ingest/ValueSource.java` - ValueSourceインターフェースの実装
- E-18: `server/src/main/java/org/opensearch/ingest/ProcessorInfo.java` - ProcessorInfoクラスの実装
- E-19: `server/src/main/java/org/opensearch/ingest/IngestPipelineInfo.java` - IngestPipelineInfoクラスの実装
- E-20: `server/src/main/java/org/opensearch/ingest/IndexRequestWrapper.java` - IndexRequestWrapperクラスの実装
- E-21: `server/src/main/java/org/opensearch/ingest/AbstractBatchingSystemProcessor.java` - AbstractBatchingSystemProcessorクラスの実装
- E-22: `server/src/main/java/org/opensearch/ingest/IngestProcessorException.java` - IngestProcessorExceptionクラスの実装
- E-23: `server/src/main/java/org/opensearch/ingest/AbstractProcessor.java` - AbstractProcessorクラスの実装
- E-24: `server/src/main/java/org/opensearch/ingest/Processor.java` - Processorインターフェースの実装
- E-25: `server/src/main/java/org/opensearch/ingest/IngestPipelineType.java` - IngestPipelineType列挙型の実装
- E-26: `server/src/main/java/org/opensearch/ingest/WrappingProcessor.java` - WrappingProcessorインターフェースの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | IngestDocumentコンストラクタがindex/id/sourceを正しく格納する | E-01 (L81-98) | ○ |
| C-002 | routing/version/versionTypeがsourceAndMetadataに格納される | E-01 (L86-94) | ○ |
| C-003 | コピーコンストラクタでdeepCopyMapが呼ばれる | E-01 (L103-105) | ○ |
| C-004 | getFieldValueがドット区切りパスで値を取得する | E-01 (L125-132) | ○ |
| C-005 | 存在しないパスでIllegalArgumentExceptionが発生する | E-01 (L361-401) resolveメソッド | ○ |
| C-006 | 空文字パスでIllegalArgumentExceptionが発生する | E-01 (L877-878) FieldPathコンストラクタ | ○ |
| C-007 | nullパスでIllegalArgumentExceptionが発生する | E-01 (L877) Strings.isEmpty check | ○ |
| C-008 | 型キャストエラーでIllegalArgumentExceptionが発生する | E-01 (L685-695) castメソッド | ○ |
| C-009 | ignoreMissing=trueで存在しないフィールドはnullが返る | E-01 (L144-154) | ○ |
| C-010 | byte配列がそのまま返却される | E-01 (L193-195) | ○ |
| C-011 | Base64文字列がデコードされる | E-01 (L196) | ○ |
| C-012 | 非文字列/非byte[]型でIllegalArgumentException | E-01 (L197-200) | ○ |
| C-013 | 存在するフィールドでhasFieldがtrueを返す | E-01 (L219-299) | ○ |
| C-014 | 存在しないフィールドでhasFieldがfalseを返す | E-01 (L219-299) | ○ |
| C-015 | 配列インデックス範囲外でfalseが返る | E-01 (L247-260) | ○ |
| C-016 | failOutOfRange=trueで範囲外例外が発生する | E-01 (L248-256) | ○ |
| C-017 | setFieldValueで新規フィールドが設定される | E-01 (L481-483, L529-637) | ○ |
| C-018 | ネストパスで中間オブジェクトが自動生成される | E-01 (L542-546) | ○ |
| C-019 | リスト範囲外でIllegalArgumentException | E-01 (L559-562, L611-615) | ○ |
| C-020 | removeFieldでフィールドが削除される | E-01 (L315-359) | ○ |
| C-021 | 存在しないフィールド削除でIllegalArgumentException | E-01 (L330) | ○ |
| C-022 | nullコンテキストからの削除でIllegalArgumentException | E-01 (L353-355) | ○ |
| C-023 | appendFieldValueでリストに値が追加される | E-01 (L415-417, L585-597) | ○ |
| C-024 | スカラー値がリストに変換される | E-01 (L640-656) appendValuesメソッド | ○ |
| C-025 | allowDuplicates=falseで重複排除される | E-01 (L667-683) | ○ |
| C-026 | extractMetadataでメタデータが抽出/削除される | E-01 (L714-720) | ○ |
| C-027 | getMetadataでsourceAndMetadataが変更されない | E-01 (L725-731) | ○ |
| C-028 | executePipelineでhandlerが呼ばれる | E-01 (L797-812) | ○ |
| C-029 | パイプラインサイクルでIllegalStateException | E-01 (L810) | ○ |
| C-030 | deepCopyMapでディープコピーされる | E-01 (L751-754) | ○ |
| C-031 | サポートされていない型でIllegalArgumentException | E-01 (L786) | ○ |
| C-032 | equals/hashCodeの動作 | E-01 (L823-839) | ○ |
| C-033 | Pipeline.createで有効な設定からPipelineが生成される | E-02 (L92-125) | ○ |
| C-034 | サポートされない設定パラメータでOpenSearchParseException | E-02 (L108-115) | ○ |
| C-035 | 空のon_failureでOpenSearchParseException | E-02 (L116-118) | ○ |
| C-036 | 空設定でプロセッサなしパイプライン | E-02 (L139-141) | ○ |
| C-037 | 非システムプロセッサでRuntimeException | E-02 (L147-155) | ○ |
| C-038 | Pipeline.executeでメトリクス記録 | E-02 (L181-192) | ○ |
| C-039 | エラー時にmetrics.failedが加算 | E-02 (L187-189) | ○ |
| C-040 | batchExecuteで複数ドキュメント処理 | E-02 (L266-278) | ○ |
| C-041 | getProcessorsが不変リスト返却 | E-02 (L229-231) | ○ |
| C-042 | flattenAllProcessorsでフラット化 | E-02 (L245-247) | ○ |
| C-043 | CompoundProcessor.innerExecuteで順次実行 | E-03 (L260-295) | ○ |
| C-044 | onFailureProcessorsが実行される | E-03 (L280-284) | ○ |
| C-045 | ignoreFailure=trueでエラー無視 | E-03 (L277-278) | ○ |
| C-046 | プロセッサがnullを返した場合のドロップ | E-03 (L289-291) | ○ |
| C-047 | innerBatchExecuteでバッチ順次処理 | E-03 (L167-258) | ○ |
| C-048 | 空リストでhandler呼び出し | E-03 (L172-175) | ○ |
| C-049 | executeOnFailureAsyncでメタデータ設定/削除 | E-03 (L297-327) | ○ |
| C-050 | flattenProcessorsで再帰的フラット化 | E-03 (L112-128) | ○ |
| C-051 | newCompoundProcessorExceptionのヘッダ生成 | E-03 (L353-374) | ○ |
| C-052 | 既存IngestProcessorExceptionの再利用 | E-03 (L354-356) | ○ |
| C-053 | 条件trueで内部プロセッサ実行 | E-04 (L106-131) | ○ |
| C-054 | 条件falseで内部プロセッサ未実行 | E-04 (L128-130) | ○ |
| C-055 | 条件評価例外でhandlerにエラー渡し | E-04 (L108-113) | ○ |
| C-056 | UnmodifiableIngestDataで読み取り専用 | E-04 (L138-145, L181-273) | ○ |
| C-057 | readStringPropertyで文字列取得 | E-05 (L96-125) | ○ |
| C-058 | 必須プロパティ欠落でOpenSearchParseException | E-05 (L122) | ○ |
| C-059 | 文字列でない場合のOpenSearchParseException | E-05 (L134-139) | ○ |
| C-060 | デフォルト値使用 | E-05 (L119-120) | ○ |
| C-061 | ブールプロパティ読み取り | E-05 (L196-209) | ○ |
| C-062 | ブール型不一致エラー | E-05 (L211-224) | ○ |
| C-063 | 整数プロパティ読み取り | E-05 (L232-253) | ○ |
| C-064 | 整数変換エラー | E-05 (L245-252) | ○ |
| C-065 | double値読み取り | E-05 (L261-281) | ○ |
| C-066 | double必須プロパティ欠落 | E-05 (L268-269) | ○ |
| C-067 | リスト読み取り | E-05 (L307-314) | ○ |
| C-068 | リスト型不一致エラー | E-05 (L316-329) | ○ |
| C-069 | マップ読み取り | E-05 (L337-349) | ○ |
| C-070 | 必須オブジェクト欠落 | E-05 (L389-395) | ○ |
| C-071 | readProcessorでプロセッサ生成 | E-05 (L534-584) | ○ |
| C-072 | 存在しないプロセッサ型エラー | E-05 (L583) | ○ |
| C-073 | null設定エラー | E-05 (L540-542) | ○ |
| C-074 | 条件付きプロセッサ生成 | E-05 (L575-577) | ○ |
| C-075 | newConfigurationExceptionのメタデータ生成 | E-05 (L404-419, L497-512) | ○ |
| C-076 | 整数の文字列変換 | E-05 (L148-176) | ○ |
| C-077 | innerDeleteでパイプライン削除 | E-06 (L579-605) | ○ |
| C-078 | 存在しないパイプラインでResourceNotFoundException | E-06 (L592) | ○ |
| C-079 | ワイルドカード削除 | E-06 (L586-589) | ○ |
| C-080 | nullメタデータで現在のClusterState返却 | E-06 (L581-583) | ○ |
| C-081 | innerGetPipelinesでID指定取得 | E-06 (L618-644) | ○ |
| C-082 | ID指定なしで全パイプライン返却 | E-06 (L624-626) | ○ |
| C-083 | ワイルドカードID取得 | E-06 (L630-635) | ○ |
| C-084 | nullメタデータで空リスト返却 | E-06 (L619-621) | ○ |
| C-085 | innerPutでパイプライン追加 | E-06 (L744-759) | ○ |
| C-086 | 既存パイプライン上書き | E-06 (L753) | ○ |
| C-087 | 空ingestInfosでIllegalStateException | E-06 (L762-763) | ○ |
| C-088 | パイプラインID長制限 | E-06 (L766-778) MAX_PIPELINE_ID_BYTES=512 | ○ |
| C-089 | プロセッサ数上限チェック | E-06 (L798-810) | ○ |
| C-090 | getPipelineでPipeline取得 | E-06 (L681-688) | ○ |
| C-091 | 存在しないIDでnull返却 | E-06 (L681-688) | ○ |
| C-092 | getProcessorNameでtype:tag形式 | E-06 (L1336-1355) | ○ |
| C-093 | ConditionalProcessorで内部プロセッサtype使用 | E-06 (L1338-1339) | ○ |
| C-094 | PipelineProcessorでtype:pipeline名形式 | E-06 (L1344-1348) | ○ |
| C-095 | prepareBatchesのグルーピング | E-06 (L934-961) | △ |
| C-096 | 異なるインデックスの別バッチ分割 | E-06 (L934-961) | △ |
| C-097 | バッチサイズ超過時の分割 | E-06 (L952-956) | ○ |
| C-098 | updateIndexRequestWithIngestDocument | E-06 (L1659-1677) | ○ |
| C-099 | innerUpdatePipelinesで更新 | E-06 (L1499-1593) | ○ |
| C-100 | パイプライン除去 | E-06 (L1575-1582) | ○ |
| C-101 | パイプライン作成失敗時の代替 | E-06 (L1552-1569) | ○ |
| C-102 | getProcessorsInPipelineで型指定取得 | E-06 (L1601-1627) | ○ |
| C-103 | 不存在パイプラインのプロセッサ取得エラー | E-06 (L1603-1604) | ○ |
| C-104 | PipelineConfigurationコンストラクタ | E-07 (L110-114) | ○ |
| C-105 | null検証でNullPointerException | E-07 (L111-113) Objects.requireNonNull | ○ |
| C-106 | getConfigAsMapでMap返却 | E-07 (L120-122) | ○ |
| C-107 | PipelineConfiguration equals/hashCode | E-07 (L172-188) | ○ |
| C-108 | toXContentシリアライズ | E-07 (L135-141) | ○ |
| C-109 | IngestMetadataコンストラクタで不変マップ | E-08 (L76-78) | ○ |
| C-110 | fromXContentでパース | E-08 (L107-114) | ○ |
| C-111 | IngestMetadata toXContent | E-08 (L117-124) | ○ |
| C-112 | IngestStatsコンストラクタ | E-09 (L67-71) | ○ |
| C-113 | IngestStats toXContent | E-09 (L119-149) | ○ |
| C-114 | IngestStats.Builder.build | E-09 (L181-205) | ○ |
| C-115 | IngestInfo.containsProcessor true | E-10 (L82-84) | ○ |
| C-116 | IngestInfo.containsProcessor false | E-10 (L82-84) | ○ |
| C-117 | IngestDocumentWrapperコンストラクタ | E-11 (L21-26) | ○ |
| C-118 | IngestDocumentWrapper.update | E-11 (L44-47) | ○ |
| C-119 | DropProcessor.execute returns null | E-12 (L52-54) | ○ |
| C-120 | DropProcessor.Factory.create | E-12 (L66-77) | ○ |
| C-121 | PipelineProcessor正常実行 | E-13 (L59-69) | ○ |
| C-122 | PipelineProcessor存在しないパイプライン | E-13 (L64-68) | ○ |
| C-123 | TrackingResultProcessor実行結果記録 | E-14 (L70-207) | ○ |
| C-124 | TrackingResultProcessor条件false記録 | E-14 (L73-84) | ○ |
| C-125 | TrackingResultProcessor.decorate | E-14 (L229-265) | ○ |
| C-126 | AbstractBatchingProcessor batchSizeの以下 | E-15 (L55-57) | ○ |
| C-127 | AbstractBatchingProcessor batchSize超過 | E-15 (L61-73) | ○ |
| C-128 | AbstractBatchingProcessor空リスト | E-15 (L49-52) | ○ |
| C-129 | AbstractBatchingProcessor.Factory batchSize不正 | E-15 (L113-116) | ○ |
| C-130 | SystemIngestPipelineCacheキャッシュ保存 | E-16 (L39-51) | ○ |
| C-131 | プロセッサ数上限チェック | E-16 (L44-46) | ○ |
| C-132 | キャッシュ最大エントリ数での削除 | E-16 (L47-49, L54-78) | △ |
| C-133 | キャッシュ取得 | E-16 (L85-98) | ○ |
| C-134 | キャッシュミスでnull | E-16 (L87, L97) | ○ |
| C-135 | キャッシュ無効化 | E-16 (L108-110) | ○ |
| C-136 | ValueSource文字列ラップ | E-17 (L88-98) | ○ |
| C-137 | ValueSource Mapラップ | E-17 (L69-77) | ○ |
| C-138 | ValueSource Listラップ | E-17 (L78-86) | ○ |
| C-139 | ValueSource不正型 | E-17 (L102) | ○ |
| C-140 | MapValue.copyAndResolve | E-17 (L120-126) | ○ |
| C-141 | ListValue.copyAndResolve | E-17 (L158-164) | ○ |
| C-142 | ProcessorInfo equals | E-18 (L84-92) | ○ |
| C-143 | ProcessorInfo compareTo | E-18 (L100-102) | ○ |
| C-144 | IngestPipelineInfo toString | E-19 (L34-36) | ○ |
| C-145 | IndexRequestWrapper getters | E-20 (L50-68) | ○ |
| C-146 | AbstractBatchingSystemProcessor isSystemGenerated | E-21 (L31-33) | ○ |
| C-147 | AbstractBatchingSystemProcessor.Factory isSystemGenerated | E-21 (L53-55) | ○ |
| C-148 | IngestProcessorExceptionコンストラクタ | E-22 (L49-51) | ○ |
| C-149 | AbstractProcessor getTag/getDescription | E-23 (L50-58) | ○ |
| C-150 | ProcessorデフォルトbatchExecute | E-24 (L96-107) | ○ |
| C-151 | ProcessorデフォルトbatchExecute空リスト | E-24 (L97-99) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-095/C-096**: prepareBatchesメソッドのhashCodeベースのグルーピングは実装を直接参照しているが、hashCode衝突時の振る舞いについては実行時テストでの確認が望ましい
  - 候補：既存テストコード / 統合テスト / hashCode衝突パターンテスト
- **C-132**: SystemIngestPipelineCacheのevictOldestAndExpiredCacheEntryメソッドは時間依存のロジック（System.currentTimeMillis, EXPIRES_IN_MINUTES=60）を含むため、テストの前提条件設定が複雑
  - 候補：テスト用の時間制御機構 / Mockによる時間固定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として信頼度が高く、ソースコードの直接確認に基づいてテストケースが生成されている
- 1: 中リスク - IngestServiceの大規模なクラス(1700行超)についてはprivateメソッドの間接テストが中心となるため、カバレッジの十分性を確認すること
- 1: 中リスク - SystemIngestPipelineCacheの時間依存ロジックのテストは実行環境に依存する可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] IngestDocument.getFieldValue/setFieldValue/removeFieldのパスパースロジックが十分にカバーされているか確認
- [ ] CompoundProcessorのonFailure/ignoreFailureの組み合わせテストが漏れていないか確認
- [ ] IngestServiceのresolvePipelines/resolveSystemIngestPipelineの各分岐がテスト対象として十分か確認（privateメソッドのため間接テストとなる）
- [ ] SystemIngestPipelineCacheの有効期限切れのテストケースが十分か確認
- [ ] ConfigurationUtilsの各readXxxPropertyメソッドのnull/デフォルト値/型不一致パターンの網羅性を確認
