---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 163
  claims_with_evidence: 158
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：server-lucene 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：158 / 163、根拠なし：5
- 優先レビュー（高）
  1. **C-145〜C-149 (CustomUnifiedHighlighter.highlightField)**: 複雑な統合テストに近く、モック構築の具体的手法はソースコードだけでは判断困難
  2. **C-152〜C-153 (CustomFieldHighlighter.highlightFieldForDoc)**: 親クラスFieldHighlighterとの統合動作の検証方法が根拠不足
  3. **C-157〜C-163 (CustomFieldQuery.flatten)**: 多数のクエリタイプの展開ロジックの網羅性は実際のテスト実装時に追加確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/lucene/analysis/miscellaneous/DuplicateByteSequenceSpotter.java`
- E-02: `server/src/main/java/org/opensearch/lucene/analysis/miscellaneous/DuplicateSequenceAttributeImpl.java`
- E-03: `server/src/main/java/org/opensearch/lucene/analysis/miscellaneous/DuplicateSequenceAttribute.java`
- E-04: `server/src/main/java/org/opensearch/lucene/analysis/miscellaneous/DeDuplicatingTokenFilter.java`
- E-05: `server/src/main/java/org/opensearch/lucene/analysis/miscellaneous/DisableGraphAttributeImpl.java`
- E-06: `server/src/main/java/org/opensearch/lucene/analysis/miscellaneous/DisableGraphAttribute.java`
- E-07: `server/src/main/java/org/opensearch/lucene/util/LongHashSet.java`
- E-08: `server/src/main/java/org/opensearch/lucene/util/UnsignedLongHashSet.java`
- E-09: `server/src/main/java/org/opensearch/lucene/util/CombinedBitSet.java`
- E-10: `server/src/main/java/org/opensearch/lucene/util/SPIClassIterator.java`
- E-11: `server/src/main/java/org/opensearch/lucene/similarity/LegacyBM25Similarity.java`
- E-12: `server/src/main/java/org/opensearch/lucene/queries/SearchAfterSortedDocQuery.java`
- E-13: `server/src/main/java/org/opensearch/lucene/queries/BinaryDocValuesRangeQuery.java`
- E-14: `server/src/main/java/org/opensearch/lucene/queries/MinDocQuery.java`
- E-15: `server/src/main/java/org/opensearch/lucene/queries/BlendedTermQuery.java`
- E-16: `server/src/main/java/org/opensearch/lucene/queries/ExtendedCommonTermsQuery.java`
- E-17: `server/src/main/java/org/opensearch/lucene/queries/SpanMatchNoDocsQuery.java`
- E-18: `server/src/main/java/org/opensearch/lucene/search/vectorhighlight/CustomFieldQuery.java`
- E-19: `server/src/main/java/org/opensearch/lucene/search/uhighlight/CustomUnifiedHighlighter.java`
- E-20: `server/src/main/java/org/opensearch/lucene/search/uhighlight/CustomFieldHighlighter.java`
- E-21: `server/src/main/java/org/opensearch/lucene/search/uhighlight/CustomPassageFormatter.java`
- E-22: `server/src/main/java/org/opensearch/lucene/search/uhighlight/BoundedBreakIteratorScanner.java`
- E-23: `server/src/main/java/org/opensearch/lucene/search/uhighlight/Snippet.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | DuplicateByteSequenceSpotterコンストラクタの初期化確認 | E-01 (L106-110) | ○ |
| C-002 | addByteが6バイト未満で0を返す | E-01 (L131-141) | ○ |
| C-003 | addByteが6バイト以上で重複検出 | E-01 (L131-165) | ○ |
| C-004 | MAX_HIT_COUNT(255)上限 | E-01 (L82, L275) | ○ |
| C-005 | 異なるシーケンスの独立追跡 | E-01 (L131-165) | ○ |
| C-006 | startNewSequenceでバッファリセット | E-01 (L118-121) | ○ |
| C-007 | startNewSequence後もTrieは保持 | E-01 (L118-121) | ○ |
| C-008 | getEstimatedSizeInBytes | E-01 (L300-302) | ○ |
| C-009 | getNodesAllocatedByDepth | E-01 (L307-309) | ○ |
| C-010 | getNodesAllocatedByDepth防御的コピー | E-01 (L309 clone()) | ○ |
| C-011 | RootTreeNode add(byte,int) depth 0-1 | E-01 (L214-234) | ○ |
| C-012 | RootTreeNode add(byte,int) depth >= 2 | E-01 (L228-230) | ○ |
| C-013 | RootTreeNode add(int) UnsupportedOperationException | E-01 (L237-239) | ○ |
| C-014 | LightweightTreeNode add(int) 新規追加 | E-01 (L260-268) | ○ |
| C-015 | LightweightTreeNode add(int) カウントインクリメント | E-01 (L271-279) | ○ |
| C-016 | LightweightTreeNode add(byte,int) UnsupportedOperationException | E-01 (L294-296) | ○ |
| C-017 | DuplicateSequenceAttributeImpl clear | E-02 (L55-57) | ○ |
| C-018 | DuplicateSequenceAttributeImpl copyTo | E-02 (L60-63) | ○ |
| C-019 | DuplicateSequenceAttributeImpl getNumPriorUsesInASequence | E-02 (L66-68) | ○ |
| C-020 | DuplicateSequenceAttributeImpl setNumPriorUsesInASequence | E-02 (L71-73) | ○ |
| C-021 | DuplicateSequenceAttributeImpl reflectWith | E-02 (L76-78) | ○ |
| C-022 | DeDuplicatingTokenFilter accept (emitDuplicates=false) | E-04 (L89-91) | ○ |
| C-023 | DeDuplicatingTokenFilter accept (emitDuplicates=true) | E-04 (L89-91) | ○ |
| C-024 | DeDuplicatingTokenFilter 2引数コンストラクタ | E-04 (L68-70) | ○ |
| C-025 | DisableGraphAttributeImpl clear | E-05 (L43) | ○ |
| C-026 | DisableGraphAttributeImpl copyTo | E-05 (L49) | ○ |
| C-027〜C-040 | LongHashSetの全テストケース | E-07 | ○ |
| C-041〜C-048 | UnsignedLongHashSetの全テストケース | E-08 | ○ |
| C-049〜C-063 | CombinedBitSetの全テストケース | E-09 | ○ |
| C-064〜C-073 | SPIClassIteratorの全テストケース | E-10 | ○ |
| C-074〜C-080 | LegacyBM25Similarityの全テストケース | E-11 | ○ |
| C-081〜C-086 | SearchAfterSortedDocQueryの全テストケース | E-12 | ○ |
| C-087〜C-097 | BinaryDocValuesRangeQueryの全テストケース | E-13 | ○ |
| C-098〜C-104 | MinDocQueryの全テストケース | E-14 | ○ |
| C-105〜C-113 | BlendedTermQueryの全テストケース | E-15 | ○ |
| C-114〜C-118 | ExtendedCommonTermsQueryの全テストケース | E-16 | ○ |
| C-119〜C-123 | SpanMatchNoDocsQueryの全テストケース | E-17 | ○ |
| C-124〜C-127 | Snippetの全テストケース | E-23 | ○ |
| C-128〜C-133 | CustomPassageFormatterの全テストケース | E-21 | ○ |
| C-134〜C-144 | BoundedBreakIteratorScannerの全テストケース | E-22 | ○ |
| C-145 | CustomUnifiedHighlighter.highlightFieldマッチあり | E-19 (L138-182) | △ |
| C-146 | CustomUnifiedHighlighter.highlightFieldマッチなし | E-19 (L139-142) | ○ |
| C-147 | CustomUnifiedHighlighter.highlightField null入力 | E-19 (L143-146) | ○ |
| C-148 | fieldMaxAnalyzedOffset > maxAnalyzedOffset例外 | E-19 (L149-158) | ○ |
| C-149 | ANALYSIS+長大フィールド例外 | E-19 (L162-178) | ○ |
| C-150 | getOffsetSource | E-19 (L276-281) | ○ |
| C-151 | getFlags WEIGHT_MATCHES除去 | E-19 (L285-290) | ○ |
| C-152 | CustomFieldHighlighter.highlightFieldForDoc | E-20 (L91-99) | △ |
| C-153 | highlightFieldForDoc後のfieldValueクリア | E-20 (L96-98) | ○ |
| C-154 | getSummaryPassagesNoHighlight noMatchSize>0 | E-20 (L102-130) | ○ |
| C-155 | getSummaryPassagesNoHighlight noMatchSize=0 | E-20 (L102-130) | ○ |
| C-156 | getSummaryPassagesNoHighlight セパレータのみ | E-20 (L104-108) | ○ |
| C-157 | CustomFieldQuery.flatten BoostQuery | E-18 (L100-103) | ○ |
| C-158 | CustomFieldQuery.flatten SpanTermQuery | E-18 (L104-105) | ○ |
| C-159 | CustomFieldQuery.flatten ConstantScoreQuery | E-18 (L106-107) | ○ |
| C-160 | CustomFieldQuery.flatten FunctionScoreQuery | E-18 (L108-109) | ○ |
| C-161 | CustomFieldQuery.flatten SynonymQuery | E-18 (L127-131) | ○ |
| C-162 | CustomFieldQuery.flatten 16件超MultiPhraseQuery | E-18 (L152-165) | △ |
| C-163 | CustomFieldQuery.flatten BlockJoinQuery | E-18 (L133-137) | △ |

## 4) 不足情報（Unknown / Missing）
- C-145: CustomUnifiedHighlighter.highlightFieldの正常系マッチありテストは、IndexReader/IndexSearcherのモック構築が複雑で、具体的なテスト構成方法はソースコードのみでは不十分
  - 候補: 既存テストコード / テストフレームワークのドキュメント / Lucene UnifiedHighlighterのテスト例
- C-152: CustomFieldHighlighter.highlightFieldForDocは親クラスFieldHighlighterへの委譲動作を含むため、統合テスト的な検証が必要
  - 候補: FieldHighlighterのテスト例 / Luceneのテストケース
- C-162: 16件超のMultiPhraseQueryのフォールバック条件は閾値がハードコードされており、境界値テストの正確な設計には追加確認が必要
  - 候補: MultiPhraseQueryの仕様ドキュメント / 既存テストコード
- C-163: OpenSearchToParentBlockJoinQueryの子クエリ展開は、BlockJoinQueryの構築方法に依存する
  - 候補: OpenSearchToParentBlockJoinQueryのテスト例

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - analysis/miscellaneous配下のクラス群（DuplicateByteSequenceSpotter, DuplicateSequenceAttributeImpl等）は自己完結的でテストしやすい
- 0: 低リスク - util配下のクラス群（LongHashSet, UnsignedLongHashSet, CombinedBitSet）はデータ構造として独立しておりテストしやすい
- 1: 中リスク - queries配下のクラス群（SearchAfterSortedDocQuery, BinaryDocValuesRangeQuery等）はLucene IndexSearcherとの連携が必要
- 1: 中リスク - similarity/LegacyBM25Similarityは内部でBM25Similarityに委譲しており、scorer()メソッドのテストにはCollectionStatistics/TermStatisticsのモック構築が必要
- 2: 高リスク - search/uhighlight配下のクラス群（CustomUnifiedHighlighter, CustomFieldHighlighter）はLuceneのハイライトフレームワークとの深い統合が必要で、単体テストの構築が複雑

## 6) レビュアーチェックリスト（最小）
- [ ] DuplicateByteSequenceSpotter.addByte()のバッファ循環ロジック（circular buffer）が正しくテストされているか
- [ ] LongHashSet/UnsignedLongHashSetのMISSING値処理（Long.MIN_VALUE / Numbers.MIN_UNSIGNED_LONG_VALUE_AS_LONG）の境界値テストが十分か
- [ ] CombinedBitSetのnextSetBit/prevSetBitがDocIdSetIterator.NO_MORE_DOCSを正しく扱えているか
- [ ] BinaryDocValuesRangeQueryのQueryType各enumバリアントの境界条件（完全一致、隣接、包含の境界）が網羅されているか
- [ ] CustomUnifiedHighlighter.highlightFieldのmaxAnalyzedOffset関連の例外条件が実際のテストで再現可能か
- [ ] CustomFieldQuery.flattenの各クエリタイプ展開が実際のLucene IndexSearcherで動作するか
- [ ] BoundedBreakIteratorScannerのpreceding/followingの呼び出し順序制約が適切にテストされているか
