---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 148
  claims_with_evidence: 142
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：server-monitor 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：142 / 148、根拠なし：6
- 優先レビュー（高）
  1. **JvmService.stats のキャッシュ動作（UT-MON-097, UT-MON-098）**：キャッシュの更新タイミングはSystem.currentTimeMillis依存でテスト環境での再現性に注意
  2. **WarmFsService.stats のシャード使用量計算（UT-MON-141）**：IndicesService/IndexService/IndexShardのモック構成が複雑
  3. **OsProbe各メソッドの戻り値（UT-MON-116〜121）**：OS MXBeanの実装依存であり環境によって挙動が異なる

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/monitor/StatusInfo.java` - StatusInfo class (status/info fields, toString)
- E-02: `server/src/main/java/org/opensearch/monitor/Probes.java` - getLoadAndScaleToPercent static method
- E-03: `server/src/main/java/org/opensearch/monitor/MonitorService.java` - MonitorService lifecycle, service accessors
- E-04: `server/src/main/java/org/opensearch/monitor/NodeHealthService.java` - NodeHealthService interface
- E-05: `server/src/main/java/org/opensearch/monitor/fs/FsHealthService.java` - FsHealthService (getHealth, settings, FsHealthMonitor)
- E-06: `server/src/main/java/org/opensearch/monitor/fs/FsInfo.java` - FsInfo, Path, DeviceStats, IoStats, Builder
- E-07: `server/src/main/java/org/opensearch/monitor/fs/FsProbe.java` - FsProbe (stats, adjustForHugeFilesystems, getFSInfo, ioStats)
- E-08: `server/src/main/java/org/opensearch/monitor/fs/FsService.java` - FsService (stats, FsInfoCache)
- E-09: `server/src/main/java/org/opensearch/monitor/fs/FsServiceProvider.java` - FsServiceProvider (createFsService)
- E-10: `server/src/main/java/org/opensearch/monitor/fs/WarmFsService.java` - WarmFsService (stats override)
- E-11: `server/src/main/java/org/opensearch/monitor/jvm/GcNames.java` - GcNames (getByMemoryPoolName, getByGcName)
- E-12: `server/src/main/java/org/opensearch/monitor/jvm/HotThreads.java` - HotThreads (type, detect, isIdleThread)
- E-13: `server/src/main/java/org/opensearch/monitor/jvm/JvmGcMonitorService.java` - JvmGcMonitorService (thresholds, JvmMonitor, checkGcOverhead, buildPools)
- E-14: `server/src/main/java/org/opensearch/monitor/jvm/JvmInfo.java` - JvmInfo (versionAsInteger, versionUpdatePack, Mem)
- E-15: `server/src/main/java/org/opensearch/monitor/jvm/JvmStats.java` - JvmStats (Mem, MemoryPoolGcStats, GarbageCollector, etc.)
- E-16: `server/src/main/java/org/opensearch/monitor/jvm/JvmService.java` - JvmService (info, stats, refresh)
- E-17: `server/src/main/java/org/opensearch/monitor/jvm/JvmPid.java` - JvmPid (getPid)
- E-18: `server/src/main/java/org/opensearch/monitor/jvm/DeadlockAnalyzer.java` - DeadlockAnalyzer (findDeadlocks, Deadlock)
- E-19: `server/src/main/java/org/opensearch/monitor/os/OsInfo.java` - OsInfo (fields, toXContent)
- E-20: `server/src/main/java/org/opensearch/monitor/os/OsProbe.java` - OsProbe (memory, swap, cpu, cgroup methods)
- E-21: `server/src/main/java/org/opensearch/monitor/os/OsService.java` - OsService (info, stats, OsStatsCache)
- E-22: `server/src/main/java/org/opensearch/monitor/os/OsStats.java` - OsStats (Cpu, Mem, Swap, Cgroup, Builder, calculatePercentage)
- E-23: `server/src/main/java/org/opensearch/monitor/process/ProcessInfo.java` - ProcessInfo (id, mlockall, refreshInterval)
- E-24: `server/src/main/java/org/opensearch/monitor/process/ProcessProbe.java` - ProcessProbe (FD, CPU, memory methods)
- E-25: `server/src/main/java/org/opensearch/monitor/process/ProcessService.java` - ProcessService (info, stats, ProcessStatsCache)
- E-26: `server/src/main/java/org/opensearch/monitor/process/ProcessStats.java` - ProcessStats (Cpu, Mem)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StatusInfo HEALTHY生成 (UT-MON-001) | E-01 | ○ |
| C-02 | StatusInfo UNHEALTHY生成 (UT-MON-002) | E-01 | ○ |
| C-03 | StatusInfo.toString フォーマット (UT-MON-003) | E-01 (line 70-72) | ○ |
| C-04 | StatusInfo null info (UT-MON-004) | E-01 | ○ |
| C-05 | Probes.getLoadAndScaleToPercent 正常値 (UT-MON-005〜007) | E-02 (line 44-56) | ○ |
| C-06 | Probes.getLoadAndScaleToPercent null method (UT-MON-008) | E-02 (line 45, 55) | ○ |
| C-07 | Probes.getLoadAndScaleToPercent 負値 (UT-MON-009) | E-02 (line 48-50) | ○ |
| C-08 | Probes.getLoadAndScaleToPercent 例外 (UT-MON-010) | E-02 (line 51-53) | ○ |
| C-09 | MonitorService アクセサ (UT-MON-011〜014) | E-03 (line 68-82) | ○ |
| C-10 | MonitorService ライフサイクル (UT-MON-015〜016) | E-03 (line 85-92) | ○ |
| C-11 | FsHealthService.getHealth disabled (UT-MON-017) | E-05 (line 177-178) | ○ |
| C-12 | FsHealthService.getHealth brokenLock (UT-MON-018) | E-05 (line 179-180) | ○ |
| C-13 | FsHealthService.getHealth timeout (UT-MON-019) | E-05 (line 181-183) | ○ |
| C-14 | FsHealthService.getHealth healthy (UT-MON-020) | E-05 (line 184-185) | ○ |
| C-15 | FsHealthService.getHealth unhealthy paths (UT-MON-021) | E-05 (line 186-190) | ○ |
| C-16 | FsHealthService 動的設定 (UT-MON-022〜024) | E-05 (line 161-171) | ○ |
| C-17 | FsInfo.Path.addLong ロジック (UT-MON-025〜028) | E-06 (line 152-163) | ○ |
| C-18 | FsInfo.Path.add 集計 (UT-MON-029) | E-06 (line 165-171) | ○ |
| C-19 | FsInfo.Path アクセサ (UT-MON-030〜032) | E-06 (line 132-142) | ○ |
| C-20 | FsInfo.total 重複排除 (UT-MON-033) | E-06 (line 836-848) | ○ |
| C-21 | FsInfo.total 空paths (UT-MON-034) | E-06 (line 836-848) | ○ |
| C-22 | FsInfo.total null path (UT-MON-035) | E-06 (line 840-841) | ○ |
| C-23 | FsInfo.iterator (UT-MON-036) | E-06 (line 859-861) | ○ |
| C-24 | DeviceStats operations計算 (UT-MON-037〜038) | E-06 (line 425-429) | ○ |
| C-25 | DeviceStats readOperations (UT-MON-039〜040) | E-06 (line 431-435) | ○ |
| C-26 | DeviceStats writeOperations (UT-MON-041) | E-06 (line 437-441) | ○ |
| C-27 | DeviceStats readKilobytes (UT-MON-042) | E-06 (line 443-447) | ○ |
| C-28 | DeviceStats writeKilobytes (UT-MON-043) | E-06 (line 449-453) | ○ |
| C-29 | DeviceStats readTime/writeTime/queueSize/ioTime (UT-MON-044〜048) | E-06 (line 458-486) | ○ |
| C-30 | IoStats 集計 (UT-MON-049〜051) | E-06 (line 640-671) | ○ |
| C-31 | DeviceStats.Builder (UT-MON-052〜053) | E-06 (line 496-593) | ○ |
| C-32 | FsProbe.adjustForHugeFilesystems (UT-MON-054〜057) | E-07 (line 198-203) | ○ |
| C-33 | FsProbe.stats ノードファイル無し (UT-MON-058) | E-07 (line 73-76) | ○ |
| C-34 | FsServiceProvider.createFsService 分岐 (UT-MON-059〜060) | E-09 (line 51-56) | ○ |
| C-35 | GcNames.getByMemoryPoolName 全パターン (UT-MON-061〜067) | E-11 (line 49-69) | ○ |
| C-36 | GcNames.getByGcName 全パターン (UT-MON-068〜072) | E-11 (line 71-82) | ○ |
| C-37 | HotThreads.type バリデーション (UT-MON-073〜074) | E-12 (line 97-104) | ○ |
| C-38 | HotThreads 設定メソッド (UT-MON-075〜076) | E-12 (line 77-85) | ○ |
| C-39 | JvmGcMonitorService コンストラクタバリデーション (UT-MON-077〜079) | E-13 (line 147-205) | ○ |
| C-40 | JvmMonitor.checkGcOverhead (UT-MON-080〜082) | E-13 (line 535-548) | ○ |
| C-41 | JvmGcMonitorService.buildPools (UT-MON-083) | E-13 (line 341-362) | ○ |
| C-42 | JvmInfo.versionAsInteger (UT-MON-084〜085) | E-14 (line 375-394) | ○ |
| C-43 | JvmInfo.versionUpdatePack (UT-MON-086〜088) | E-14 (line 396-435) | ○ |
| C-44 | JvmInfo.Mem アクセサ (UT-MON-089〜090) | E-14 (line 627-645) | ○ |
| C-45 | JvmStats.Mem.getHeapUsedPercent (UT-MON-091〜092) | E-15 (line 662-667) | ○ |
| C-46 | JvmStats.MemoryPoolGcStats.getUsagePercent (UT-MON-093〜094) | E-15 (line 519-524) | ○ |
| C-47 | JvmStats アクセサ (UT-MON-095〜096) | E-15 | ○ |
| C-48 | JvmService.stats キャッシュ更新 (UT-MON-097) | E-16 (line 79-84) | △ |
| C-49 | JvmService.stats キャッシュ利用 (UT-MON-098) | E-16 (line 79-84) | △ |
| C-50 | JvmService.info (UT-MON-099) | E-16 (line 75-77) | ○ |
| C-51 | DeadlockAnalyzer シングルトン・findDeadlocks (UT-MON-100〜101) | E-18 (line 58-78) | ○ |
| C-52 | Deadlock.equals (UT-MON-102〜103) | E-18 (line 176-184) | ○ |
| C-53 | OsStats.calculatePercentage (UT-MON-104〜107) | E-22 (line 694-696) | ○ |
| C-54 | OsStats.Mem.getUsed (UT-MON-108〜109) | E-22 (line 382-396) | ○ |
| C-55 | OsStats.Mem パーセンテージ (UT-MON-110〜111) | E-22 (line 398-408) | ○ |
| C-56 | OsStats.Swap.getUsed (UT-MON-112〜113) | E-22 (line 313-328) | ○ |
| C-57 | OsStats.Builder (UT-MON-114) | E-22 (line 153-194) | ○ |
| C-58 | OsStats.Cgroup.CpuStat アクセサ (UT-MON-115) | E-22 (line 635-657) | ○ |
| C-59 | OsProbe メモリ取得 (UT-MON-116〜119) | E-20 (line 103-140) | △ |
| C-60 | OsProbe スワップ取得 (UT-MON-120〜121) | E-20 (line 145-182) | △ |
| C-61 | OsProbe CPU使用率 (UT-MON-122) | E-20 (line 239-240) | ○ |
| C-62 | OsInfo データモデル (UT-MON-123〜124) | E-19 (line 58-74) | ○ |
| C-63 | ProcessProbe FD取得 (UT-MON-125〜127) | E-24 (line 80-103) | ○ |
| C-64 | ProcessProbe CPU (UT-MON-128〜130) | E-24 (line 108-127) | ○ |
| C-65 | ProcessProbe メモリ (UT-MON-131) | E-24 (line 132-144) | ○ |
| C-66 | ProcessProbe シングルトン (UT-MON-132) | E-24 (line 67-73) | ○ |
| C-67 | ProcessInfo データモデル (UT-MON-133) | E-23 (line 50-58) | ○ |
| C-68 | ProcessStats データモデル (UT-MON-134〜137) | E-26 (line 50-64) | ○ |
| C-69 | ProcessService アクセサ (UT-MON-138〜139) | E-25 (line 72-79) | ○ |
| C-70 | WarmFsService.stats ディスク計算 (UT-MON-140〜144) | E-10 (line 51-91) | ○ |
| C-71 | OsStats.Cpu アクセサ (UT-MON-145〜147) | E-22 (line 246-252) | ○ |
| C-72 | JvmPid.getPid (UT-MON-148) | E-17 (line 42-44) | ○ |

## 4) 不足情報（Unknown / Missing）
- **JvmService.statsのキャッシュ動作テスト（C-48, C-49）**: System.currentTimeMillis()に依存するためテスト環境での再現にはタイムスタンプの制御が必要。synchronized修飾子によるスレッドセーフ性の検証も要考慮。
  - 候補：時間制御用のClockインジェクション / テストフレームワークでの時間操作
- **OsProbeのOS依存メソッド（C-59, C-60）**: getFreePhysicalMemorySize等はcom.sun.management.OperatingSystemMXBeanのリフレクション呼び出しに依存。テスト環境のJVM実装によって挙動が異なる可能性がある。
  - 候補：OsProbeのサブクラスによるメソッドオーバーライド / モックフレームワーク

## 5) リスクフラグ（レビュー観点）
- 0: FsInfo.Path.addLong, DeviceStats計算ロジック, GcNames解決 -- 純粋な計算ロジックでソースコードから直接確認可能
- 0: StatusInfo, ProcessInfo, OsInfo データモデル -- 単純なPOJOでリスク低
- 1: FsHealthService.getHealth -- 複数の状態条件の組み合わせがあり、条件分岐の網羅性を確認する必要がある
- 1: JvmGcMonitorService 閾値バリデーション -- 設定値の組み合わせが複雑
- 1: WarmFsService.stats -- IndicesService/IndexService/IndexShardのモック構成が複雑で、シャードのフィルタリング条件(primary && active)の再現に注意
- 2: OsProbe/ProcessProbe -- OS/JVM依存のリフレクション呼び出しを含み、環境依存のテスト結果になりやすい

## 6) レビュアーチェックリスト（最小）
- [ ] FsHealthService.getHealthの5つの状態分岐（disabled, brokenLock, timeout, healthy, unhealthy）が網羅されているか
- [ ] Probes.getLoadAndScaleToPercentの境界値（0.0, 1.0, 負値, null method）がカバーされているか
- [ ] DeviceStats/IoStatsのI/O統計計算（operations, readKilobytes, writeKilobytes等）のprevious=-1ケースが網羅されているか
- [ ] JvmGcMonitorServiceのGCオーバーヘッド閾値バリデーション（warn > info > debug）が正しく検証されているか
- [ ] OsStats.calculatePercentageの境界値（max=0, max<0, used==max）がカバーされているか
- [ ] WarmFsService.statsのdataToFileCacheSizeRatio計算とfreeBytes=Math.max(0, total-used)のエッジケースが検証されているか
- [ ] OsProbe/ProcessProbeのOS依存メソッドについて、メソッドnull時と例外時の-1/0返却が確認されているか
- [ ] GcNames.getByMemoryPoolName/getByGcNameの全マッピングパターンが網羅されているか
