---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 139
  claims_with_evidence: 135
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：server-persistent 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：135 / 139、根拠なし：4
- 優先レビュー（高）
  1. **UT-PER-008**：デフォルトキャンセル理由による失敗時の挙動 - CancelTasksRequest.DEFAULT_REASONとgetReasonCancelled()の詳細挙動は実行時テストで確認が必要
  2. **UT-PER-022/023**：ClusterStateObserverの非同期待機・タイムアウト挙動 - モックの適切な構成が必要
  3. **UT-PER-030/031**：PersistentTasksNodeService.clusterChangedの特定分岐条件 - GatewayService.STATE_NOT_RECOVERED_BLOCKの詳細条件は外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/persistent/AllocatedPersistentTask.java`
- E-02: `server/src/main/java/org/opensearch/persistent/PersistentTasksService.java`
- E-03: `server/src/main/java/org/opensearch/persistent/PersistentTasksNodeService.java`
- E-04: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java`
- E-05: `server/src/main/java/org/opensearch/persistent/PersistentTasksCustomMetadata.java`
- E-06: `server/src/main/java/org/opensearch/persistent/PersistentTasksExecutor.java`
- E-07: `server/src/main/java/org/opensearch/persistent/PersistentTasksExecutorRegistry.java`
- E-08: `server/src/main/java/org/opensearch/persistent/PersistentTaskResponse.java`
- E-09: `server/src/main/java/org/opensearch/persistent/NodePersistentTasksExecutor.java`
- E-10: `server/src/main/java/org/opensearch/persistent/StartPersistentTaskAction.java`
- E-11: `server/src/main/java/org/opensearch/persistent/CompletionPersistentTaskAction.java`
- E-12: `server/src/main/java/org/opensearch/persistent/RemovePersistentTaskAction.java`
- E-13: `server/src/main/java/org/opensearch/persistent/UpdatePersistentTaskStatusAction.java`
- E-14: `server/src/main/java/org/opensearch/persistent/decider/AssignmentDecision.java`
- E-15: `server/src/main/java/org/opensearch/persistent/decider/EnableAssignmentDecider.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PER-001: shouldCancelChildrenOnCancellationがtrueを返す | E-01 (L78-79) | ○ |
| C-02 | UT-PER-002: cancelOnParentLeavingがfalseを返す | E-01 (L87-89) | ○ |
| C-03 | UT-PER-003: 初期状態でSTARTEDステータス | E-01 (L73, L92-94) | ○ |
| C-04 | UT-PER-004: init()でID/allocationId設定 | E-01 (L112-122) | ○ |
| C-05 | UT-PER-005: markAsCompletedの正常フロー | E-01 (L155-157, L167-207) | ○ |
| C-06 | UT-PER-006: 二重完了防止 | E-01 (L168-170) | ○ |
| C-07 | UT-PER-007: markAsFailedの基本フロー | E-01 (L159-165) | ○ |
| C-08 | UT-PER-008: DEFAULT_REASONキャンセル時のnull failure | E-01 (L160-161) | △ |
| C-09 | UT-PER-009: markAsCancelledの状態遷移 | E-01 (L151-153) | ○ |
| C-10 | UT-PER-010: 不正状態からのキャンセル | E-01 (L152, compareAndSet) | ○ |
| C-11 | UT-PER-011: isCompletedの判定 | E-01 (L147-149) | ○ |
| C-12 | UT-PER-012: updatePersistentTaskState委譲 | E-01 (L101-106) | ○ |
| C-13 | UT-PER-013: waitForPersistentTask委譲 | E-01 (L139-145) | ○ |
| C-14 | UT-PER-014: sendStartRequest | E-02 (L81-91) | ○ |
| C-15 | UT-PER-015: sendCompletionRequest(成功) | E-02 (L98-106) | ○ |
| C-16 | UT-PER-016: sendCompletionRequest(失敗) | E-02 (L98-106) | ○ |
| C-17 | UT-PER-017: sendCancelRequest | E-02 (L111-120) | ○ |
| C-18 | UT-PER-018: sendCancelRequest例外ハンドリング | E-02 (L117-119) | ○ |
| C-19 | UT-PER-019: sendUpdateStateRequest | E-02 (L128-140) | ○ |
| C-20 | UT-PER-020: sendRemoveRequest | E-02 (L145-148) | ○ |
| C-21 | UT-PER-021: waitForPersistentTaskCondition即時成立 | E-02 (L175-188) | ○ |
| C-22 | UT-PER-022: waitForPersistentTaskCondition非同期待ち | E-02 (L189-206) | △ |
| C-23 | UT-PER-023: waitForPersistentTaskConditionタイムアウト | E-02 (L202-204) | △ |
| C-24 | UT-PER-024: waitForPersistentTasksCondition即時成立 | E-02 (L216-246) | ○ |
| C-25 | UT-PER-025: ClusterServiceクローズ時 | E-02 (L236-238) | ○ |
| C-26 | UT-PER-026: WaitForPersistentTaskListenerデフォルトタイムアウト | E-02 (L253-257) | ○ |
| C-27 | UT-PER-027: clusterChanged新規タスク開始 | E-03 (L91-154) | ○ |
| C-28 | UT-PER-028: clusterChangedタスクキャンセル | E-03 (L156-178) | ○ |
| C-29 | UT-PER-029: clusterChanged完了タスククリーンアップ | E-03 (L158-166) | ○ |
| C-30 | UT-PER-030: STATE_NOT_RECOVERED_BLOCKスキップ | E-03 (L92-96) | ○ |
| C-31 | UT-PER-031: 変更なしスキップ | E-03 (L123) | ○ |
| C-32 | UT-PER-032: Status正常生成 | E-03 (L339-341) | ○ |
| C-33 | UT-PER-033: Status null state | E-03 (L340, requireNonNull) | ○ |
| C-34 | UT-PER-034: Status equals同一 | E-03 (L376-381) | ○ |
| C-35 | UT-PER-035: Status equals異なる | E-03 (L376-381) | ○ |
| C-36 | UT-PER-036: getWriteableName | E-03 (L348-350) | ○ |
| C-37 | UT-PER-037: toXContent | E-03 (L353-358) | ○ |
| C-38 | UT-PER-038: createPersistentTask正常 | E-04 (L142-187) | ○ |
| C-39 | UT-PER-039: createPersistentTask重複ID | E-04 (L152-153) | ○ |
| C-40 | UT-PER-040: completePersistentTask正常 | E-04 (L197-243) | ○ |
| C-41 | UT-PER-041: completePersistentTask存在しない | E-04 (L223) | ○ |
| C-42 | UT-PER-042: completePersistentTask allocationId不一致 | E-04 (L209-223) | ○ |
| C-43 | UT-PER-043: removePersistentTask正常 | E-04 (L251-279) | ○ |
| C-44 | UT-PER-044: removePersistentTask存在しない | E-04 (L259) | ○ |
| C-45 | UT-PER-045: updatePersistentTaskState正常 | E-04 (L289-326) | ○ |
| C-46 | UT-PER-046: updatePersistentTaskState存在しない | E-04 (L307) | ○ |
| C-47 | UT-PER-047: unassignPersistentTask正常 | E-04 (L339-367) | ○ |
| C-48 | UT-PER-048: unassignPersistentTask存在しない | E-04 (L353) | ○ |
| C-49 | UT-PER-049: needsReassignment未割り当て | E-04 (L519-521) | ○ |
| C-50 | UT-PER-050: needsReassignmentノード喪失 | E-04 (L520) | ○ |
| C-51 | UT-PER-051: needsReassignment正常割り当て | E-04 (L519-521) | ○ |
| C-52 | UT-PER-052: persistentTasksChanged変更あり | E-04 (L513-516) | ○ |
| C-53 | UT-PER-053: persistentTasksChanged変更なし | E-04 (L513-516) | ○ |
| C-54 | UT-PER-054: reassignTasks正常 | E-04 (L481-510) | ○ |
| C-55 | UT-PER-055: reassignTasksタスクなし | E-04 (L485) | ○ |
| C-56 | UT-PER-056: shouldReassignPersistentTasksタスクnull | E-04 (L443-446) | ○ |
| C-57 | UT-PER-057: shouldReassignPersistentTasksノード変更 | E-04 (L442-466) | ○ |
| C-58 | UT-PER-058: setRecheckInterval | E-04 (L120-122) | ○ |
| C-59 | UT-PER-059: close | E-04 (L130-132) | ○ |
| C-60 | UT-PER-060: clusterChangedクラスタマネージャ | E-04 (L394-405) | ○ |
| C-61 | UT-PER-061: clusterChanged非マスタ | E-04 (L402-404) | ○ |
| C-62 | UT-PER-062: tasks()正常 | E-05 (L182-184) | ○ |
| C-63 | UT-PER-063: tasks()空 | E-05 (L182-184) | ○ |
| C-64 | UT-PER-064: getTask正常 | E-05 (L190-192) | ○ |
| C-65 | UT-PER-065: getTask存在しない | E-05 (L191) | ○ |
| C-66 | UT-PER-066: findTasks正常 | E-05 (L194-196) | ○ |
| C-67 | UT-PER-067: findTasks該当なし | E-05 (L194-196) | ○ |
| C-68 | UT-PER-068: getNumberOfTasksOnNode正常 | E-05 (L216-221) | ○ |
| C-69 | UT-PER-069: getNumberOfTasksOnNodeタスクなし | E-05 (L216-221) | ○ |
| C-70 | UT-PER-070: getTaskWithId正常 | E-05 (L233-239) | ○ |
| C-71 | UT-PER-071: getTaskWithIdメタデータなし | E-05 (L235-238) | ○ |
| C-72 | UT-PER-072: disassociateDeadNodes正常 | E-05 (L251-272) | ○ |
| C-73 | UT-PER-073: disassociateDeadNodesメタデータnull | E-05 (L253-255) | ○ |
| C-74 | UT-PER-074: disassociateDeadNodes変更不要 | E-05 (L265-267) | ○ |
| C-75 | UT-PER-075: equals同一 | E-05 (L199-204) | ○ |
| C-76 | UT-PER-076: equals異なる | E-05 (L199-204) | ○ |
| C-77 | UT-PER-077: hashCode一貫性 | E-05 (L207-209) | ○ |
| C-78 | UT-PER-078: Builder.addTask正常 | E-05 (L650-660) | ○ |
| C-79 | UT-PER-079: Builder.addTask重複 | E-05 (L656-658) | ○ |
| C-80 | UT-PER-080: Builder.reassignTask正常 | E-05 (L665-674) | ○ |
| C-81 | UT-PER-081: Builder.reassignTask存在しない | E-05 (L671) | ○ |
| C-82 | UT-PER-082: Builder.updateTaskState正常 | E-05 (L679-688) | ○ |
| C-83 | UT-PER-083: Builder.updateTaskState存在しない | E-05 (L685) | ○ |
| C-84 | UT-PER-084: Builder.removeTask正常 | E-05 (L693-700) | ○ |
| C-85 | UT-PER-085: Builder.removeTask存在しない | E-05 (L697) | ○ |
| C-86 | UT-PER-086: Builder.hasTask存在 | E-05 (L705-707) | ○ |
| C-87 | UT-PER-087: Builder.hasTask不在 | E-05 (L705-707) | ○ |
| C-88 | UT-PER-088: Builder.hasTask(id,allocationId)一致 | E-05 (L712-718) | ○ |
| C-89 | UT-PER-089: Builder.hasTask(id,allocationId)不一致 | E-05 (L712-718) | ○ |
| C-90 | UT-PER-090: Builder.isChanged初期 | E-05 (L727-729) | ○ |
| C-91 | UT-PER-091: getNextAllocationIdインクリメント | E-05 (L640-643) | ○ |
| C-92 | UT-PER-092: Assignment.isAssigned null | E-05 (L313-315) | ○ |
| C-93 | UT-PER-093: Assignment.isAssigned設定済み | E-05 (L313-315) | ○ |
| C-94 | UT-PER-094: Assignment.equals | E-05 (L301-306) | ○ |
| C-95 | UT-PER-095: PersistentTaskコンストラクタparams名不一致 | E-05 (L367-372) | ○ |
| C-96 | UT-PER-096: PersistentTaskコンストラクタstate名不一致 | E-05 (L373-379) | ○ |
| C-97 | UT-PER-097: PersistentTask.equals | E-05 (L406-417) | ○ |
| C-98 | UT-PER-098: PersistentTask.isAssigned | E-05 (L455-457) | ○ |
| C-99 | UT-PER-099: getAssignment最小負荷ノード選択 | E-06 (L72-79) | ○ |
| C-100 | UT-PER-100: getAssignmentノード不在 | E-06 (L74-75) | ○ |
| C-101 | UT-PER-101: selectLeastLoadedNodeタスクなし | E-06 (L84-102) | ○ |
| C-102 | UT-PER-102: selectLeastLoadedNode最小負荷 | E-06 (L84-102) | ○ |
| C-103 | UT-PER-103: selectLeastLoadedNode条件不一致 | E-06 (L89, L101) | ○ |
| C-104 | UT-PER-104: getDescription | E-06 (L128-130) | ○ |
| C-105 | UT-PER-105: createTask | E-06 (L114-123) | ○ |
| C-106 | UT-PER-106: getPersistentTaskExecutorSafe正常 | E-07 (L57-63) | ○ |
| C-107 | UT-PER-107: getPersistentTaskExecutorSafe未登録 | E-07 (L59-61) | ○ |
| C-108 | UT-PER-108: レジストリ初期化 | E-07 (L48-54) | ○ |
| C-109 | UT-PER-109: 空レジストリ | E-07 (L48-54) | ○ |
| C-110 | UT-PER-110: PersistentTaskResponse.getTask | E-08 (L64-66) | ○ |
| C-111 | UT-PER-111: PersistentTaskResponse.equals | E-08 (L69-74) | ○ |
| C-112 | UT-PER-112: PersistentTaskResponse.hashCode | E-08 (L77-79) | ○ |
| C-113 | UT-PER-113: executeTask正常 | E-09 (L53-75) | ○ |
| C-114 | UT-PER-114: executeTask nodeOperation例外 | E-09 (L69-71) | ○ |
| C-115 | UT-PER-115: executeTask スレッドプール失敗 | E-09 (L61-63) | ○ |
| C-116 | UT-PER-116: StartRequest validate正常 | E-10 (L110-127) | ○ |
| C-117 | UT-PER-117: StartRequest validate taskId null | E-10 (L112-114) | ○ |
| C-118 | UT-PER-118: StartRequest validate taskName null | E-10 (L115-117) | ○ |
| C-119 | UT-PER-119: StartRequest validate params名不一致 | E-10 (L118-125) | ○ |
| C-120 | UT-PER-120: CompletionRequest validate正常 | E-11 (L110-119) | ○ |
| C-121 | UT-PER-121: CompletionRequest validate taskId null | E-11 (L112-114) | ○ |
| C-122 | UT-PER-122: CompletionRequest validate allocationId負 | E-11 (L115-117) | ○ |
| C-123 | UT-PER-123: UpdateRequest validate正常 | E-13 (L119-130) | ○ |
| C-124 | UT-PER-124: UpdateRequest validate taskId null | E-13 (L121-123) | ○ |
| C-125 | UT-PER-125: UpdateRequest validate allocationId -1L | E-13 (L124-126) | ○ |
| C-126 | UT-PER-126: RemoveRequest validate常にnull | E-12 (L101-103) | ○ |
| C-127 | UT-PER-127: AssignmentDecisionコンストラクタ正常 | E-14 (L52-55) | ○ |
| C-128 | UT-PER-128: AssignmentDecisionコンストラクタtype null | E-14 (L53, requireNonNull) | ○ |
| C-129 | UT-PER-129: AssignmentDecisionコンストラクタreason null | E-14 (L54, requireNonNull) | ○ |
| C-130 | UT-PER-130: YES定数 | E-14 (L47) | ○ |
| C-131 | UT-PER-131: Type.resolve小文字 | E-14 (L89-91) | ○ |
| C-132 | UT-PER-132: Type.resolve不正文字列 | E-14 (L90, valueOf) | ○ |
| C-133 | UT-PER-133: canAssign ALL | E-15 (L86-91) | ○ |
| C-134 | UT-PER-134: canAssign NONE | E-15 (L87-89) | ○ |
| C-135 | UT-PER-135: setEnableAssignment | E-15 (L75-77) | ○ |
| C-136 | UT-PER-136: Allocation.fromString正常 | E-15 (L103-116) | ○ |
| C-137 | UT-PER-137: Allocation.fromString null | E-15 (L104-105) | ○ |
| C-138 | UT-PER-138: Allocation.fromString不正 | E-15 (L110-113) | ○ |
| C-139 | UT-PER-139: Allocation.toString | E-15 (L119-121) | △ |

## 4) 不足情報（Unknown / Missing）
- UT-PER-008 (C-08): CancelTasksRequest.DEFAULT_REASONの具体的な値と、getReasonCancelled()の返却条件はCancelTasksRequestクラスおよびCancellableTaskクラスに依存しており、本モジュール外の実装に基づく挙動のため、ソースコードからの完全な確認が困難
  - 候補：CancelTasksRequest.java / CancellableTask.java
- UT-PER-022/023 (C-22/C-23): ClusterStateObserverの非同期待機・タイムアウト挙動は外部クラスに強く依存しており、モック構成の適切性は実装時に確認が必要
  - 候補：ClusterStateObserver.java
- UT-PER-139 (C-139): Allocation.toString()の具体的な出力値はenumの定義から推定しているが、Locale.ROOT依存の小文字変換の正確性は軽微なリスク
  - 候補：Java Locale仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接確認可能なテストケースが大部分を占める
- 1: 中リスク - PersistentTasksNodeService.clusterChangedの複雑な分岐ロジックはテストケースの網羅性に注意が必要。特に、タスクの状態遷移（STARTED -> PENDING_CANCEL -> COMPLETED）の組み合わせテストが重要
- 1: 中リスク - PersistentTasksClusterService.reassignTasks/shouldReassignPersistentTasksは多くの外部状態に依存するため、適切なモック構成が必要

## 6) レビュアーチェックリスト（最小）
- [ ] AllocatedPersistentTask の状態遷移テスト（STARTED -> PENDING_CANCEL -> COMPLETED）が全パスをカバーしているか確認
- [ ] PersistentTasksClusterService のクラスタ状態更新テストで、クラスタ状態更新タスクのexecute()内ロジックが適切にテストされているか確認
- [ ] PersistentTasksCustomMetadata.Builder の各操作（addTask, removeTask, reassignTask, updateTaskState）でallocationIdのインクリメントが正しく行われることを確認
- [ ] PersistentTasksExecutor.selectLeastLoadedNode の負荷分散ロジックが同一負荷時の挙動を含めてテストされているか確認
- [ ] 各Actionクラス（Start/Completion/Remove/Update）のRequestバリデーションで全パターンが網羅されているか確認
