---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 116
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：server-plugins 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：116 / 120、根拠なし：4
- 優先レビュー（高）
  1. **UT-PLG-086 (reloadLuceneSPI)**: Lucene SPIのリロード動作は外部ライブラリ依存のため実行時挙動の確認が必要
  2. **UT-PLG-092 (nativeControllerPath)**: macOS判定はConstants.MAC_OS_Xに依存しテスト環境によって動作が異なる
  3. **UT-PLG-096 (dualModeEnabled)**: NetworkModule.TRANSPORT_SSL_DUAL_MODE_ENABLED設定のデフォルト値はNetworkModule側に定義
  4. **UT-PLG-109 (createLoader)**: ExtendedPluginsClassLoaderの実装はlibs-plugin-classloaderモジュールに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/plugins/PluginInfo.java` - PluginInfoクラスの完全なソースコード
- E-02: `server/src/main/java/org/opensearch/plugins/PluginsService.java` - PluginsServiceクラスの完全なソースコード
- E-03: `server/src/main/java/org/opensearch/plugins/Plugin.java` - Pluginクラスの完全なソースコード
- E-04: `server/src/main/java/org/opensearch/plugins/Platforms.java` - Platformsクラスの完全なソースコード
- E-05: `server/src/main/java/org/opensearch/plugins/MetadataUpgrader.java` - MetadataUpgraderクラスの完全なソースコード
- E-06: `server/src/main/java/org/opensearch/plugins/ExtensiblePlugin.java` - ExtensiblePluginインターフェースの完全なソースコード
- E-07: `server/src/main/java/org/opensearch/plugins/PluginLoaderIndirection.java` - PluginLoaderIndirectionクラスの完全なソースコード
- E-08: `server/src/main/java/org/opensearch/plugins/DefaultSecureTransportParameters.java` - DefaultSecureTransportParametersクラスの完全なソースコード
- E-09: `server/src/main/java/org/opensearch/plugins/DefaultSecureHttpTransportParameters.java` - DefaultSecureHttpTransportParametersクラスの完全なソースコード
- E-10: `server/src/main/java/org/opensearch/plugins/SecureSettingsFactory.java` - SecureSettingsFactoryインターフェースの完全なソースコード
- E-11: `server/src/main/java/org/opensearch/plugins/SecureTransportSettingsProvider.java` - SecureTransportSettingsProviderインターフェースの完全なソースコード
- E-12: `server/src/main/java/org/opensearch/plugins/SecureHttpTransportSettingsProvider.java` - SecureHttpTransportSettingsProviderインターフェースの完全なソースコード
- E-13: `server/src/main/java/org/opensearch/plugins/SecureAuxTransportSettingsProvider.java` - SecureAuxTransportSettingsProviderインターフェースの完全なソースコード
- E-14: `server/src/main/java/org/opensearch/plugins/TransportExceptionHandler.java` - TransportExceptionHandlerインターフェースの完全なソースコード
- E-15: `server/src/main/java/org/opensearch/plugins/ActionPlugin.java` - ActionPluginインターフェースの完全なソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PluginInfo Version版コンストラクタの正常系テスト | E-01 (L108-130) | ○ |
| C-02 | PluginInfo SemverRange版コンストラクタの正常系テスト | E-01 (L132-162) | ○ |
| C-03 | opensearchVersionRangesが複数指定でエラー | E-01 (L147-151) | ○ |
| C-04 | opensearchVersionRangesが空でエラー | E-01 (L147-151) | ○ |
| C-05 | optional拡張プラグインの分離 | E-01 (L156-161) | ○ |
| C-06 | isOptionalExtension trueケース | E-01 (L227-229) | ○ |
| C-07 | isOptionalExtension falseケース | E-01 (L227-229) | ○ |
| C-08 | isOptionalExtension 空文字 | E-01 (L227-229) | ○ |
| C-09 | readFromProperties正常系 | E-01 (L267-402) | ○ |
| C-10 | name欠落エラー | E-01 (L280-281) | ○ |
| C-11 | description欠落エラー | E-01 (L284-285) | ○ |
| C-12 | version欠落エラー | E-01 (L288-289) | ○ |
| C-13 | opensearch.versionとdependencies両方未定義 | E-01 (L294-297) | ○ |
| C-14 | opensearch.versionとdependencies両方定義 | E-01 (L299-302) | ○ |
| C-15 | dependencies SemverRange形式パース | E-01 (L308-338) | ○ |
| C-16 | dependencies opensearch以外指定でエラー | E-01 (L324-325) | ○ |
| C-17 | java.version欠落エラー | E-01 (L341-342) | ○ |
| C-18 | classname欠落エラー | E-01 (L346-347) | ○ |
| C-19 | extended.pluginsパース | E-01 (L354-360) | ○ |
| C-20 | extended.plugins未定義で空リスト | E-01 (L356-358) | ○ |
| C-21 | has.native.controller true | E-01 (L367-369) | ○ |
| C-22 | has.native.controller false | E-01 (L370-371) | ○ |
| C-23 | has.native.controller不正値 | E-01 (L373-383) | ○ |
| C-24 | 不明プロパティ検出 | E-01 (L387-389) | ○ |
| C-25 | custom.foldernameの設定 | E-01 (L350-352, L513-515) | ○ |
| C-26 | getTargetFolderName null時 | E-01 (L513-515) | ○ |
| C-27 | getTargetFolderName 空文字時 | E-01 (L513-515) | ○ |
| C-28 | getOpenSearchVersionRangesString 1件 | E-01 (L480-488) | ○ |
| C-29 | isExtendedPluginOptional trueケース | E-01 (L445-447) | ○ |
| C-30 | isExtendedPluginOptional falseケース | E-01 (L445-447) | ○ |
| C-31 | writeTo シリアライズ | E-01 (L233-258) | ○ |
| C-32 | StreamInputデシリアライズ | E-01 (L206-225) | ○ |
| C-33 | equals trueケース | E-01 (L538-549) | ○ |
| C-34 | equals falseケース | E-01 (L538-549) | ○ |
| C-35 | equals nullケース | E-01 (L538-549) | ○ |
| C-36 | hashCode一貫性 | E-01 (L552-554) | ○ |
| C-37 | toXContent | E-01 (L518-535) | ○ |
| C-38 | toString | E-01 (L557-600) | ○ |
| C-39 | verifyCompatibility 正常系 | E-02 (L466-479) | ○ |
| C-40 | verifyCompatibility 非互換 | E-02 (L466-479) | ○ |
| C-41 | isPluginVersionCompatible true | E-02 (L481-489) | ○ |
| C-42 | isPluginVersionCompatible false | E-02 (L481-489) | ○ |
| C-43 | findPluginDirs 正常系 | E-02 (L441-461) | ○ |
| C-44 | findPluginDirs 存在しないディレクトリ | E-02 (L444) | ○ |
| C-45 | findPluginDirs ドット始まりファイルスキップ | E-02 (L447-452) | ○ |
| C-46 | findPluginDirs 重複プラグイン | E-02 (L453-455) | ○ |
| C-47 | findPluginDirs 空ディレクトリ | E-02 (L441-461) | ○ |
| C-48 | checkForFailedPluginRemovals 正常系 | E-02 (L491-511) | ○ |
| C-49 | checkForFailedPluginRemovals マーカーファイル検出 | E-02 (L496-509) | ○ |
| C-50 | sortBundles 安定ソート | E-02 (L565-573) | ○ |
| C-51 | sortBundles 依存関係順序 | E-02 (L576-616) | ○ |
| C-52 | sortBundles 循環依存 | E-02 (L584-592) | ○ |
| C-53 | sortBundles オプショナル依存先不在 | E-02 (L601-605) | ○ |
| C-54 | sortBundles 必須依存先不在 | E-02 (L606-608) | ○ |
| C-55 | sortBundles 空セット | E-02 (L565-573) | ○ |
| C-56 | sortBundles 単一要素 | E-02 (L565-573) | ○ |
| C-57 | updatedSettings マージ | E-02 (L271-313) | ○ |
| C-58 | updatedSettings 重複設定キー | E-02 (L278-290) | ○ |
| C-59 | updatedSettings feature反映 | E-02 (L293-311) | ○ |
| C-60 | updatedSettings feature重複 | E-02 (L296-305) | ○ |
| C-61 | filterPlugins 型フィルタリング | E-02 (L904-906) | ○ |
| C-62 | filterPlugins 該当なし | E-02 (L904-906) | ○ |
| C-63 | info メソッド | E-02 (L351-353) | ○ |
| C-64 | getPluginSettings | E-02 (L111-113) | ○ |
| C-65 | getPluginSettingsFilter | E-02 (L115-117) | ○ |
| C-66 | createGuiceModules | E-02 (L315-321) | ○ |
| C-67 | getExecutorBuilders | E-02 (L323-329) | ○ |
| C-68 | getGuiceServiceClasses | E-02 (L332-338) | ○ |
| C-69 | loadExtensions | E-02 (L634-646) | ○ |
| C-70 | createExtension 引数なし | E-02 (L674-711, L700-701) | ○ |
| C-71 | createExtension プラグイン引数 | E-02 (L674-711, L702-703) | ○ |
| C-72 | createExtension publicコンストラクタなし | E-02 (L677-679) | ○ |
| C-73 | createExtension 複数コンストラクタ | E-02 (L681-683) | ○ |
| C-74 | createExtension パラメータ過多 | E-02 (L687-688) | ○ |
| C-75 | createExtension 型不一致 | E-02 (L690-697) | ○ |
| C-76 | findPluginsByDependency 必須依存 | E-02 (L416-432) | ○ |
| C-77 | findPluginsByDependency オプショナル依存 | E-02 (L416-432) | ○ |
| C-78 | findPluginsByDependency 該当なし | E-02 (L416-432) | ○ |
| C-79 | Bundle コンストラクタ正常系 | E-02 (L360-374) | ○ |
| C-80 | Bundle 重複jar | E-02 (L368-369) | ○ |
| C-81 | Bundle null plugin | E-02 (L361) | ○ |
| C-82 | Bundle equals | E-02 (L377-384) | ○ |
| C-83 | Bundle hashCode | E-02 (L386-388) | ○ |
| C-84 | コンストラクタ mandatoryプラグイン不在 | E-02 (L235-252) | ○ |
| C-85 | コンストラクタ mandatoryプラグイン存在 | E-02 (L235-252) | ○ |
| C-86 | reloadLuceneSPI | E-02 (L844-852) | △ |
| C-87 | platformName Linux AMD64 | E-04 (L77-98) | ○ |
| C-88 | platformName Windows AMD64 | E-04 (L77-98) | ○ |
| C-89 | platformName macOS AArch64 | E-04 (L77-98) | ○ |
| C-90 | platformName i386正規化 | E-04 (L77-98) | ○ |
| C-91 | platformName 未知OS | E-04 (L77-98) | ○ |
| C-92 | nativeControllerPath 非macOS | E-04 (L55-65) | △ |
| C-93 | MetadataUpgrader 複数アップグレーダー | E-05 (L51-59) | ○ |
| C-94 | MetadataUpgrader テンプレート変換 | E-05 (L51-59) | ○ |
| C-95 | MetadataUpgrader 空アップグレーダー | E-05 (L51-59) | ○ |
| C-96 | DefaultSecureTransportParameters dualModeEnabled | E-08 (L32-34) | △ |
| C-97 | DefaultSecureTransportParameters keyManagerFactory | E-08 (L37-39) | ○ |
| C-98 | DefaultSecureTransportParameters sslProvider | E-08 (L42-44) | ○ |
| C-99 | DefaultSecureTransportParameters clientAuth | E-08 (L47-49) | ○ |
| C-100 | DefaultSecureTransportParameters protocols | E-08 (L52-54) | ○ |
| C-101 | DefaultSecureTransportParameters cipherSuites | E-08 (L57-59) | ○ |
| C-102 | DefaultSecureTransportParameters trustManagerFactory | E-08 (L62-64) | ○ |
| C-103 | DefaultSecureHttpTransportParameters keyManagerFactory | E-09 (L23-25) | ○ |
| C-104 | DefaultSecureHttpTransportParameters sslProvider | E-09 (L28-30) | ○ |
| C-105 | DefaultSecureHttpTransportParameters clientAuth | E-09 (L33-35) | ○ |
| C-106 | DefaultSecureHttpTransportParameters protocols | E-09 (L38-40) | ○ |
| C-107 | DefaultSecureHttpTransportParameters cipherSuites | E-09 (L43-45) | ○ |
| C-108 | DefaultSecureHttpTransportParameters trustManagerFactory | E-09 (L48-50) | ○ |
| C-109 | PluginLoaderIndirection createLoader | E-07 (L47-49) | △ |
| C-110 | ActionHandler コンストラクタ | E-15 (L196-204) | ○ |
| C-111 | ActionHandler equals true | E-15 (L228-241) | ○ |
| C-112 | ActionHandler equals false | E-15 (L228-241) | ○ |
| C-113 | ActionHandler equals null | E-15 (L228-241) | ○ |
| C-114 | ActionHandler toString | E-15 (L219-225) | ○ |
| C-115 | ActionHandler toString supportActions付き | E-15 (L219-225) | ○ |
| C-116 | TransportExceptionHandler NOOP | E-14 (L23) | ○ |
| C-117 | checkBundleJarHell 正常系 | E-02 (L727-781) | ○ |
| C-118 | checkBundleJarHell 拡張プラグインと重複 | E-02 (L752-757) | ○ |
| C-119 | checkBundleJarHell コアと重複 | E-02 (L769-773) | ○ |
| C-120 | checkBundleJarHell オプショナルスキップ | E-02 (L736-738) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-86 (reloadLuceneSPI): Lucene SPIの内部動作はApache Luceneライブラリに依存するため、実行時の挙動を直接確認するにはLuceneのテスト基盤が必要
  - 候補：Apache Luceneのテストフレームワーク / モック化
- C-92 (nativeControllerPath): macOS判定（Constants.MAC_OS_X）はテスト実行環境に依存するため、全プラットフォームのテストにはモック化が必要
  - 候補：Constantsクラスのモック / 環境依存テストの分離
- C-96 (dualModeEnabled): NetworkModule.TRANSPORT_SSL_DUAL_MODE_ENABLED設定のデフォルト値と挙動はNetworkModuleモジュール側の定義に依存
  - 候補：NetworkModuleソースの確認 / 統合テスト
- C-109 (createLoader): ExtendedPluginsClassLoaderの実装詳細はlibs-plugin-classloaderモジュールに存在
  - 候補：libs-plugin-classloaderソースの確認

## 5) リスクフラグ（レビュー観点）
- 0: PluginInfo, PluginsServiceの大部分のテストケース - ソースコードに直接根拠があり低リスク
- 1: セキュリティ関連パラメータ（DefaultSecureTransportParameters, DefaultSecureHttpTransportParameters）のデフォルト値テスト - 実装は単純だがセキュリティ影響のためレビュー推奨
- 1: reloadLuceneSPI - 外部ライブラリ依存のため中リスク
- 1: checkBundleJarHell - JarHellチェックはクラスパス環境に依存するため中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] PluginInfo.readFromPropertiesの全バリデーション分岐がテストケースで網羅されているか
- [ ] PluginsService.sortBundlesの依存関係解決ロジック（循環依存、オプショナル依存、必須依存）のテストケースが十分か
- [ ] checkBundleJarHellのJarHellチェック（拡張プラグイン間、コアとの重複、オプショナルスキップ）が適切にテストされているか
- [ ] セキュリティ関連のデフォルトパラメータクラスのテストケースが全メソッドをカバーしているか
- [ ] PluginInfo.writeTo/StreamInputコンストラクタのバージョン分岐（V_2_13_0, V_2_19_0）が考慮されているか
- [ ] createExtensionメソッドのリフレクション関連エラーケースが網羅されているか
