---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 102
  claims_with_evidence: 98
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：server-ratelimitting 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：98 / 102、根拠なし：4
- 優先レビュー（高）
  1. **C-84 (stats()でコントローラ未登録時null返却)**：initialize()で自動登録されるため実際にこの状態が起こるか要確認
  2. **C-60, C-71 (クラスタステートnull時の挙動)**：clusterService.state()がnullとなる実際のシナリオを要確認
  3. **C-101, C-102 (シリアライズ/デシリアライズ往復テスト)**：テスト設計は妥当だが具体的なテストデータの定義が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/enums/AdmissionControlMode.java`
- E-02: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/enums/AdmissionControlActionType.java`
- E-03: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/AdmissionControlSettings.java`
- E-04: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/settings/CpuBasedAdmissionControllerSettings.java`
- E-05: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/settings/IoBasedAdmissionControllerSettings.java`
- E-06: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/controllers/AdmissionController.java`
- E-07: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/controllers/CpuBasedAdmissionController.java`
- E-08: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/controllers/IoBasedAdmissionController.java`
- E-09: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/AdmissionControlService.java`
- E-10: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/transport/AdmissionControlTransportHandler.java`
- E-11: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/transport/AdmissionControlTransportInterceptor.java`
- E-12: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/stats/AdmissionControlStats.java`
- E-13: `server/src/main/java/org/opensearch/ratelimitting/admissioncontrol/stats/AdmissionControllerStats.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AdmissionControlMode.fromName("disabled")がDISABLEDを返す | E-01 (L54-58) | ○ |
| C-02 | AdmissionControlMode.fromName("monitor_only")がMONITORを返す | E-01 (L54-58) | ○ |
| C-03 | AdmissionControlMode.fromName("enforced")がENFORCEDを返す | E-01 (L54-58) | ○ |
| C-04 | 大文字入力でもtoLowerCaseで変換される | E-01 (L55) | ○ |
| C-05 | 不正モードでIllegalArgumentException | E-01 (L63) | ○ |
| C-06 | getMode()がモード文字列を返す | E-01 (L46-47) | ○ |
| C-07 | AdmissionControlActionType.fromName("indexing")がINDEXINGを返す | E-02 (L36-42) | ○ |
| C-08 | AdmissionControlActionType.fromName("search")がSEARCHを返す | E-02 (L36-42) | ○ |
| C-09 | AdmissionControlActionType.fromName("cluster_admin")がCLUSTER_ADMINを返す | E-02 (L36-42) | ○ |
| C-10 | 不正アクションタイプでIllegalArgumentException | E-02 (L44-45) | ○ |
| C-11 | getType()がタイプ文字列を返す | E-02 (L31-33) | ○ |
| C-12 | デフォルト設定でDISABLEDモード | E-03 (L26, L33-39, L48) | ○ |
| C-13 | カスタム設定でモードが設定される | E-03 (L48) | ○ |
| C-14 | getAdmissionControlTransportLayerModeが正しく返す | E-03 (L64-66) | ○ |
| C-15 | ENFORCEDでisTransportLayerAdmissionControlEnforcedがtrue | E-03 (L72-74) | ○ |
| C-16 | MONITORでisTransportLayerAdmissionControlEnforcedがfalse | E-03 (L72-74) | ○ |
| C-17 | DISABLEDでisTransportLayerAdmissionControlEnforcedがfalse | E-03 (L72-74) | ○ |
| C-18 | ENFORCEDでisTransportLayerAdmissionControlEnabledがtrue | E-03 (L80-82) | ○ |
| C-19 | MONITORでisTransportLayerAdmissionControlEnabledがtrue | E-03 (L80-82) | ○ |
| C-20 | DISABLEDでisTransportLayerAdmissionControlEnabledがfalse | E-03 (L80-82) | ○ |
| C-21 | 動的設定更新でモードが変更される | E-03 (L49, L56-58) | ○ |
| C-22 | CpuBasedAdmissionControllerSettingsデフォルトCPU上限95 | E-04 (L27-28, L50-55, L60-65) | ○ |
| C-23 | CpuBasedAdmissionControllerSettingsカスタム設定 | E-04 (L75-85) | ○ |
| C-24 | getTransportLayerAdmissionControllerMode | E-04 (L91-93) | ○ |
| C-25 | getSearchCPULimit | E-04 (L95-97) | ○ |
| C-26 | getIndexingCPULimit | E-04 (L99-101) | ○ |
| C-27 | getClusterAdminCPULimit | E-04 (L103-105) | ○ |
| C-28 | setSearchCPULimit | E-04 (L111-113) | ○ |
| C-29 | setIndexingCPULimit | E-04 (L107-109) | ○ |
| C-30 | setClusterInfoCPULimit | E-04 (L115-117) | ○ |
| C-31 | IoBasedAdmissionControllerSettingsデフォルトIO上限95 | E-05 (L27-28, L52-57, L62-67) | ○ |
| C-32 | IoBasedAdmissionControllerSettingsクラスタ管理IO上限デフォルト100 | E-05 (L28, L72-77) | ○ |
| C-33 | IoBasedAdmissionControllerSettings getTransportLayerAdmissionControllerMode | E-05 (L97-99) | ○ |
| C-34 | getSearchIOUsageLimit | E-05 (L109-111) | ○ |
| C-35 | getIndexingIOUsageLimit | E-05 (L105-107) | ○ |
| C-36 | getClusterAdminIOUsageLimit | E-05 (L113-115) | ○ |
| C-37 | setSearchIOUsageLimit | E-05 (L93-95) | ○ |
| C-38 | setIndexingIOUsageLimit | E-05 (L89-91) | ○ |
| C-39 | setTransportLayerMode | E-05 (L101-103) | ○ |
| C-40 | isEnabledForTransportLayer DISABLEDでfalse | E-06 (L52-54) | ○ |
| C-41 | isEnabledForTransportLayer MONITORでtrue | E-06 (L52-54) | ○ |
| C-42 | isEnabledForTransportLayer ENFORCEDでtrue | E-06 (L52-54) | ○ |
| C-43 | isAdmissionControllerEnforced ENFORCEDでtrue | E-06 (L60-62) | ○ |
| C-44 | isAdmissionControllerEnforced MONITORでfalse | E-06 (L60-62) | ○ |
| C-45 | getName | E-06 (L72-74) | ○ |
| C-46 | addRejectionCount新規アクションタイプ | E-06 (L79-84) | ○ |
| C-47 | addRejectionCount累積加算 | E-06 (L79-84) | ○ |
| C-48 | getRejectionCount存在するキー | E-06 (L89-94) | ○ |
| C-49 | getRejectionCount存在しないキーで0 | E-06 (L89-94) | ○ |
| C-50 | getRejectionStats | E-06 (L99-103) | ○ |
| C-51 | getRejectionStats空の場合 | E-06 (L99-103) | ○ |
| C-52 | CpuBasedAdmissionControllerコンストラクタ | E-07 (L39-47) | ○ |
| C-53 | CpuBasedAdmissionController DISABLED時apply | E-07 (L54-58) | ○ |
| C-54 | CpuBasedAdmissionController MONITOR CPU未達 | E-07 (L54-58, L63-77, L82-105) | ○ |
| C-55 | CpuBasedAdmissionController MONITOR CPU超過 | E-07 (L54-58, L63-77, L82-105) | ○ |
| C-56 | CpuBasedAdmissionController ENFORCED CPU超過 | E-07 (L66-75) | ○ |
| C-57 | CpuBasedAdmissionController ENFORCED CPU未達 | E-07 (L82-105) | ○ |
| C-58 | CpuBasedAdmissionController 境界値 cpuUsage == maxCpuLimit | E-07 (L91: `>=`) | ○ |
| C-59 | CpuBasedAdmissionController 境界値 上限直下 | E-07 (L91: `>=`) | ○ |
| C-60 | CpuBasedAdmissionController クラスタステートnull | E-07 (L84) | △ |
| C-61 | CpuBasedAdmissionController ノード統計なし | E-07 (L89) | ○ |
| C-62 | CpuBasedAdmissionController INDEXING閾値 | E-07 (L110-127) | ○ |
| C-63 | CpuBasedAdmissionController CLUSTER_ADMIN閾値 | E-07 (L110-127) | ○ |
| C-64 | IoBasedAdmissionControllerコンストラクタ | E-08 (L38-46) | ○ |
| C-65 | IoBasedAdmissionController DISABLED時apply | E-08 (L55-59) | ○ |
| C-66 | IoBasedAdmissionController MONITOR IO未達 | E-08 (L55-59, L64-78, L83-106) | ○ |
| C-67 | IoBasedAdmissionController MONITOR IO超過 | E-08 (L55-59, L64-78, L83-106) | ○ |
| C-68 | IoBasedAdmissionController ENFORCED IO超過 | E-08 (L67-76) | ○ |
| C-69 | IoBasedAdmissionController ENFORCED IO未達 | E-08 (L83-106) | ○ |
| C-70 | IoBasedAdmissionController 境界値 ioUsage == ioUsageThreshold | E-08 (L92: `>=`) | ○ |
| C-71 | IoBasedAdmissionController クラスタステートnull | E-08 (L85) | △ |
| C-72 | IoBasedAdmissionController ノード統計なし | E-08 (L90) | ○ |
| C-73 | IoBasedAdmissionController INDEXING閾値 | E-08 (L111-128) | ○ |
| C-74 | IoBasedAdmissionController CLUSTER_ADMIN閾値 | E-08 (L111-128) | ○ |
| C-75 | AdmissionControlServiceコンストラクタ | E-09 (L52-65) | ○ |
| C-76 | registerAdmissionController CPU | E-09 (L93-96, L103-109) | ○ |
| C-77 | registerAdmissionController IO | E-09 (L93-96, L110-116) | ○ |
| C-78 | registerAdmissionController未サポート | E-09 (L117-118) | ○ |
| C-79 | getAdmissionControllers | E-09 (L126-128) | ○ |
| C-80 | getAdmissionController名前指定 | E-09 (L135-137) | ○ |
| C-81 | getAdmissionController存在しない名前 | E-09 (L136: getOrDefault null) | ○ |
| C-82 | applyTransportAdmissionControl全コントローラ適用 | E-09 (L83-87) | ○ |
| C-83 | stats()コントローラ登録済み | E-09 (L142-152) | ○ |
| C-84 | stats()コントローラ未登録でnull | E-09 (L144, L151) | △ |
| C-85 | messageReceived forceExecution=true | E-10 (L56-68) | ○ |
| C-86 | messageReceived forceExecution=false制御通過 | E-10 (L56-68) | ○ |
| C-87 | messageReceived forceExecution=falseリジェクション | E-10 (L62-66) | ○ |
| C-88 | interceptHandlerがAdmissionControlTransportHandlerを返す | E-11 (L33-47) | ○ |
| C-89 | AdmissionControlTransportInterceptorコンストラクタ | E-11 (L24-26) | ○ |
| C-90 | AdmissionControlStats コンストラクタ(List) | E-12 (L32-34) | ○ |
| C-91 | AdmissionControlStats コンストラクタ(StreamInput) | E-12 (L41-43) | ○ |
| C-92 | AdmissionControlStats writeTo | E-12 (L51-53) | ○ |
| C-93 | AdmissionControlStats toXContent | E-12 (L59-66) | ○ |
| C-94 | AdmissionControlStats getAdmissionControllerStatsList | E-12 (L55-57) | ○ |
| C-95 | AdmissionControllerStats コンストラクタ(AdmissionController) | E-13 (L29-32) | ○ |
| C-96 | AdmissionControllerStats コンストラクタ(StreamInput) | E-13 (L34-37) | ○ |
| C-97 | AdmissionControllerStats writeTo | E-13 (L52-56) | ○ |
| C-98 | AdmissionControllerStats toXContent | E-13 (L59-73) | ○ |
| C-99 | AdmissionControllerStats getAdmissionControllerName | E-13 (L39-41) | ○ |
| C-100 | AdmissionControllerStats getRejectionCount | E-13 (L43-45) | ○ |
| C-101 | AdmissionControlStats シリアライズ/デシリアライズ往復 | E-12 (L41-43, L51-53) | △ |
| C-102 | AdmissionControllerStats シリアライズ/デシリアライズ往復 | E-13 (L34-37, L52-56) | △ |

## 4) 不足情報（Unknown / Missing）
- C-60, C-71: clusterService.state()がnullを返すシナリオの実際の発生条件がソースコードからは明確でない。クラスタ初期化前やシャットダウン時に発生する可能性があるが、テストの前提条件として適切かレビューが必要。
  - 候補：ClusterServiceの初期化ライフサイクルに関するドキュメント / 既存テストコード
- C-84: AdmissionControlServiceのコンストラクタ内でinitialize()が呼ばれ、CPUコントローラが必ず登録されるため、admissionControllersが空になるシナリオが通常運用で起こるか不明。
  - 候補：AdmissionControlServiceの初期化パターンに関する設計書 / 既存テストコード
- C-101, C-102: シリアライズ/デシリアライズの往復テストは設計上妥当だが、具体的なテストデータの定義はソースコードだけでは判断しきれない部分がある。
  - 候補：既存のWriteableテストユーティリティ / OpenSearchTestCaseクラス

## 5) リスクフラグ（レビュー観点）
- リスク1（中リスク）：CpuBasedAdmissionControllerとIoBasedAdmissionControllerのapplyメソッドは外部依存（ResourceUsageCollectorService, ClusterService）が多く、モックの設定が複雑になる可能性がある
- リスク0（低リスク）：enum（AdmissionControlMode, AdmissionControlActionType）のテストは単純で信頼性が高い
- リスク1（中リスク）：AdmissionControlTransportHandlerのmessageReceivedテストはTransportChannelのモックが必要で、非同期処理のテスト設計に注意が必要
- リスク0（低リスク）：Settings系クラスのgetter/setterテストは単純で信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] CpuBasedAdmissionController/IoBasedAdmissionControllerの境界値テスト（C-58, C-59, C-70）でcpuUsage >= maxCpuLimit（等号含む）の比較演算子を正しくテストしているか
- [ ] AdmissionControlServiceのstats()メソッドのnull返却（C-84）が実際に発生するシナリオとして妥当か
- [ ] TransportHandlerのリジェクションテスト（C-87）でchannel.sendResponseの引数が正しいか
- [ ] IOベースのコントローラテストがLinux環境限定（Constants.LINUX）の制約を考慮しているか
