---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 176
  claims_with_evidence: 172
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：server-repositories 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：172 / 176、根拠なし：4
- 優先レビュー（高）
  1. **C-112 (UT-REP-112)**: RepositoriesStatsArchiveのevict内部メソッドの動作確認はprivateメソッドのため直接テスト不可の可能性
  2. **C-131 (UT-REP-131)**: isDedicatedVotingOnlyNodeのvoting_onlyロールは未実装のため常にfalseが返る
  3. **C-143 (UT-REP-143)**: BlobStoreProvider.createBlobStoreのcryptoMetadata連携は外部依存が大きい
  4. **C-170 (UT-REP-170)**: ReloadableFsRepository.reloadの動作確認は統合テスト寄り

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/repositories/IndexId.java`
- E-02: `server/src/main/java/org/opensearch/repositories/RepositoryStats.java`
- E-03: `server/src/main/java/org/opensearch/repositories/RepositoryCleanupResult.java`
- E-04: `server/src/main/java/org/opensearch/repositories/RepositoryInfo.java`
- E-05: `server/src/main/java/org/opensearch/repositories/RepositoryStatsSnapshot.java`
- E-06: `server/src/main/java/org/opensearch/repositories/VerificationFailure.java`
- E-07: `server/src/main/java/org/opensearch/repositories/RepositoryShardId.java`
- E-08: `server/src/main/java/org/opensearch/repositories/RepositoryOperation.java`
- E-09: `server/src/main/java/org/opensearch/repositories/ShardGenerations.java`
- E-10: `server/src/main/java/org/opensearch/repositories/RepositoryData.java`
- E-11: `server/src/main/java/org/opensearch/repositories/RepositoriesStatsArchive.java`
- E-12: `server/src/main/java/org/opensearch/repositories/IndexMetaDataGenerations.java`
- E-13: `server/src/main/java/org/opensearch/repositories/RepositoriesStats.java`
- E-14: `server/src/main/java/org/opensearch/repositories/RepositoryException.java`
- E-15: `server/src/main/java/org/opensearch/repositories/RepositoryMissingException.java`
- E-16: `server/src/main/java/org/opensearch/repositories/RepositoryVerificationException.java`
- E-17: `server/src/main/java/org/opensearch/repositories/RepositoriesModule.java`
- E-18: `server/src/main/java/org/opensearch/repositories/RepositoriesService.java`
- E-19: `server/src/main/java/org/opensearch/repositories/FilterRepository.java`
- E-20: `server/src/main/java/org/opensearch/repositories/VerifyNodeRepositoryAction.java`
- E-21: `server/src/main/java/org/opensearch/repositories/Repository.java`
- E-22: `server/src/main/java/org/opensearch/repositories/blobstore/RemoteStoreShardCleanupTask.java`
- E-23: `server/src/main/java/org/opensearch/repositories/blobstore/BlobStoreProvider.java`
- E-24: `server/src/main/java/org/opensearch/repositories/blobstore/EncryptionContextUtils.java`
- E-25: `server/src/main/java/org/opensearch/repositories/fs/FsRepository.java`
- E-26: `server/src/main/java/org/opensearch/repositories/fs/ReloadableFsRepository.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | IndexId 2引数コンストラクタでDEFAULT_SHARD_PATH_TYPEが設定される | E-01 (L67-69) | ○ |
| C-002 | IndexId 3引数コンストラクタで全フィールドが設定される | E-01 (L71-76) | ○ |
| C-003 | getName()がnameフィールドを返す | E-01 (L92-94) | ○ |
| C-004 | getId()がidフィールドを返す | E-01 (L107-109) | ○ |
| C-005 | getShardPathType()がshardPathTypeを返す | E-01 (L114-116) | ○ |
| C-006 | equals: 同一内容で等しい | E-01 (L124-133) | ○ |
| C-007 | equals: 異なるnameで不等 | E-01 (L124-133) | ○ |
| C-008 | equals: nullでfalse | E-01 (L128-129) | ○ |
| C-009 | equals: 異なるクラスでfalse | E-01 (L130) | ○ |
| C-010 | hashCode: 同一内容で同じ値 | E-01 (L136-142) | ○ |
| C-011 | toString: [name/id/shardPathType]形式 | E-01 (L119-121) | ○ |
| C-012 | writeTo: V_2_17_0以降でshardPathType書き込み | E-01 (L145-151) | ○ |
| C-013 | StreamInputデシリアライズ: 正常復元 | E-01 (L78-87) | ○ |
| C-014 | StreamInputデシリアライズ: 旧バージョンでデフォルト値 | E-01 (L81-85) | ○ |
| C-015 | toXContent: name, id, shard_path_typeが出力 | E-01 (L154-161) | ○ |
| C-016 | RepositoryStats: requestCountsコンストラクタ | E-02 (L66-70) | ○ |
| C-017 | RepositoryStats: extendedStatsコンストラクタ | E-02 (L72-76) | ○ |
| C-018 | RepositoryStats.merge: 非詳細モード | E-02 (L98-105) | ○ |
| C-019 | RepositoryStats.merge: 詳細モード | E-02 (L89-97) | ○ |
| C-020 | EMPTY_STATS定数 | E-02 (L58) | ○ |
| C-021 | RepositoryStats.equals | E-02 (L116-121) | ○ |
| C-022 | RepositoryStats.writeTo | E-02 (L109-113) | ○ |
| C-023 | RepositoryStats.toXContent: 非詳細 | E-02 (L134-147) | ○ |
| C-024 | RepositoryStats.toXContent: 詳細 | E-02 (L138-145) | ○ |
| C-025 | RepositoryCleanupResult: DeleteResultコンストラクタ | E-03 (L79-82) | ○ |
| C-026 | bytes()アクセサ | E-03 (L89-91) | ○ |
| C-027 | blobs()アクセサ | E-03 (L93-95) | ○ |
| C-028 | RepositoryCleanupResult.writeTo | E-03 (L98-101) | ○ |
| C-029 | RepositoryCleanupResult.toXContent | E-03 (L104-106) | ○ |
| C-030 | RepositoryCleanupResult: StreamInputコンストラクタ | E-03 (L84-87) | ○ |
| C-031 | RepositoryCleanupResult.PARSER | E-03 (L56-69) | ○ |
| C-032 | RepositoryInfo: 3引数コンストラクタ | E-04 (L59-63) | ○ |
| C-033 | RepositoryInfo.equals | E-04 (L87-92) | ○ |
| C-034 | RepositoryInfo.hashCode | E-04 (L95-97) | ○ |
| C-035 | RepositoryInfo.writeTo | E-04 (L72-76) | ○ |
| C-036 | RepositoryInfo.toXContent | E-04 (L79-84) | ○ |
| C-037 | RepositoryStatsSnapshot: コンストラクタ | E-05 (L59-63) | ○ |
| C-038 | getRepositoryInfo | E-05 (L71-73) | ○ |
| C-039 | getRepositoryStats | E-05 (L75-77) | ○ |
| C-040 | getClusterVersion | E-05 (L79-81) | ○ |
| C-041 | RepositoryStatsSnapshot.equals | E-05 (L100-107) | ○ |
| C-042 | RepositoryStatsSnapshot.writeTo | E-05 (L84-88) | ○ |
| C-043 | UNKNOWN_CLUSTER_VERSION定数 | E-05 (L54) | ○ |
| C-044 | VerificationFailure: コンストラクタ | E-06 (L50-53) | ○ |
| C-045 | nodeId()アクセサ | E-06 (L55-57) | ○ |
| C-046 | cause()アクセサ | E-06 (L59-61) | ○ |
| C-047 | VerificationFailure.toString | E-06 (L64-66) | ○ |
| C-048 | RepositoryShardId: コンストラクタ | E-07 (L55-59) | ○ |
| C-049 | index()アクセサ | E-07 (L65-67) | ○ |
| C-050 | indexName()アクセサ | E-07 (L69-71) | ○ |
| C-051 | shardId()アクセサ | E-07 (L73-75) | ○ |
| C-052 | RepositoryShardId.equals: 同一 | E-07 (L83-91) | ○ |
| C-053 | RepositoryShardId.equals: 不一致 | E-07 (L83-91) | ○ |
| C-054 | RepositoryShardId.writeTo | E-07 (L94-97) | ○ |
| C-055 | ShardGenerations.totalShards | E-09 (L80-82) | ○ |
| C-056 | totalShards: EMPTY | E-09 (L57) | ○ |
| C-057 | ShardGenerations.indices | E-09 (L89-91) | ○ |
| C-058 | getShardGen: 正常 | E-09 (L140-146) | ○ |
| C-059 | getShardGen: 存在しないインデックス | E-09 (L141-143) | ○ |
| C-060 | getShardGen: 範囲外シャードID | E-09 (L142) | ○ |
| C-061 | getGens: 正常 | E-09 (L148-151) | ○ |
| C-062 | getGens: 存在しないインデックス | E-09 (L149-150) | ○ |
| C-063 | obsoleteShardGenerations: 検出 | E-09 (L101-121) | ○ |
| C-064 | obsoleteShardGenerations: 変更なし | E-09 (L114) | ○ |
| C-065 | ShardGenerations.equals | E-09 (L154-163) | ○ |
| C-066 | Builder.put | E-09 (L227-229) | ○ |
| C-067 | Builder.putAll | E-09 (L215-225) | ○ |
| C-068 | Builder.retainIndicesAndPruneDeletes | E-09 (L196-213) | ○ |
| C-069 | Builder.build | E-09 (L232-243) | ○ |
| C-070 | RepositoryData.getGenId | E-10 (L224-226) | ○ |
| C-071 | RepositoryData.getSnapshotIds | E-10 (L231-233) | ○ |
| C-072 | RepositoryData.getSnapshotState | E-10 (L240-242) | ○ |
| C-073 | getSnapshotState: 存在しない | E-10 (L241) | ○ |
| C-074 | RepositoryData.getVersion | E-10 (L247-249) | ○ |
| C-075 | RepositoryData.getIndices | E-10 (L254-256) | ○ |
| C-076 | addSnapshot: 正常 | E-10 (L321-379) | ○ |
| C-077 | addSnapshot: 冪等(既存UUID) | E-10 (L329-334) | ○ |
| C-078 | removeSnapshots: 正常 | E-10 (L411-455) | ○ |
| C-079 | removeSnapshots: 存在しないスナップショット | E-10 (L416-420) | ○ |
| C-080 | getSnapshots: 正常 | E-10 (L460-466) | ○ |
| C-081 | getSnapshots: 存在しないIndexId | E-10 (L462-464) | ○ |
| C-082 | resolveIndexId: 正常 | E-10 (L503-505) | ○ |
| C-083 | resolveIndexId: 存在しないインデックス | E-10 (L504) | ○ |
| C-084 | resolveIndices | E-10 (L510-516) | ○ |
| C-085 | resolveNewIndices: 正常 | E-10 (L525-538) | ○ |
| C-086 | resolveNewIndices: inFlightIds参照 | E-10 (L530-531) | ○ |
| C-087 | withGenId: 新世代 | E-10 (L387-401) | ○ |
| C-088 | withGenId: 同一世代 | E-10 (L388-390) | ○ |
| C-089 | withVersions: 正常 | E-10 (L200-215) | ○ |
| C-090 | withVersions: 空Map | E-10 (L201-203) | ○ |
| C-091 | indicesToUpdateAfterRemovingSnapshot | E-10 (L265-278) | ○ |
| C-092 | indexMetaDataToRemoveAfterRemovingSnapshots | E-10 (L289-307) | ○ |
| C-093 | EMPTY定数 | E-10 (L87-96) | ○ |
| C-094 | snapshotsToXContent | E-10 (L553-613) | ○ |
| C-095 | snapshotsFromXContent | E-10 (L622-665) | ○ |
| C-096 | RepositoryData.equals | E-10 (L468-497) | ○ |
| C-097 | IndexMetaDataGenerations.isEmpty: EMPTY | E-12 (L80-82) | ○ |
| C-098 | isEmpty: 非空 | E-12 (L80-82) | ○ |
| C-099 | getIndexMetaBlobId: 正常 | E-12 (L92-94) | ○ |
| C-100 | getIndexMetaBlobId: 存在しない | E-12 (L93) | ○ |
| C-101 | indexMetaBlobId: 正常 | E-12 (L105-112) | ○ |
| C-102 | indexMetaBlobId: フォールバック | E-12 (L107-108) | ○ |
| C-103 | withAddedSnapshot | E-12 (L122-143) | ○ |
| C-104 | withRemovedSnapshots | E-12 (L151-158) | ○ |
| C-105 | buildUniqueIdentifier | E-12 (L189-199) | ○ |
| C-106 | IndexMetaDataGenerations.equals | E-12 (L160-174) | ○ |
| C-107 | RepositoriesStatsArchive.archive: 正常 | E-11 (L72-80) | ○ |
| C-108 | archive: 容量上限 | E-11 (L75-77) | ○ |
| C-109 | getArchivedStats: 正常 | E-11 (L82-85) | ○ |
| C-110 | getArchivedStats: 空 | E-11 (L82-85) | ○ |
| C-111 | clear | E-11 (L92-104) | ○ |
| C-112 | evict(内部)の自動エビクション | E-11 (L106-111) | △ |
| C-113 | RepositoriesStats: コンストラクタ | E-13 (L32-34) | ○ |
| C-114 | RepositoriesStats.writeTo | E-13 (L41-43) | ○ |
| C-115 | RepositoriesStats.toXContent | E-13 (L46-55) | ○ |
| C-116 | RepositoriesStats.toXContent: 空リスト | E-13 (L48) | ○ |
| C-117 | RepositoryException: 2引数コンストラクタ | E-14 (L49-51) | ○ |
| C-118 | RepositoryException: null名 | E-14 (L54) | ○ |
| C-119 | RepositoryException: 3引数コンストラクタ | E-14 (L53-56) | ○ |
| C-120 | RepositoryException.repository | E-14 (L63-65) | ○ |
| C-121 | RepositoryMissingException: コンストラクタ | E-15 (L47-49) | ○ |
| C-122 | RepositoryMissingException.status | E-15 (L51-54) | ○ |
| C-123 | RepositoryVerificationException: 2引数 | E-16 (L47-49) | ○ |
| C-124 | RepositoryVerificationException: 3引数 | E-16 (L51-53) | ○ |
| C-125 | RepositoryVerificationException.status | E-16 (L55-58) | ○ |
| C-126 | RepositoriesModule: デフォルト登録 | E-17 (L69-78) | ○ |
| C-127 | RepositoriesModule: 重複タイプ | E-17 (L88-89) | ○ |
| C-128 | getRepositoryService | E-17 (L127-129) | ○ |
| C-129 | RepositoriesService.repository: 正常 | E-18 (L592-599) | ○ |
| C-130 | RepositoriesService.repository: 存在しない | E-18 (L592-) | ○ |
| C-131 | isDedicatedVotingOnlyNode: voting_only | E-18 (L446-450) | △ |
| C-132 | isDedicatedVotingOnlyNode: DATA_ROLEあり | E-18 (L448) | ○ |
| C-133 | FilterRepository: コンストラクタ | E-19 (L68-73) | ○ |
| C-134 | FilterRepository.getMetadata | E-19 (L76-78) | ○ |
| C-135 | FilterRepository.isReadOnly | E-19 (L200-202) | ○ |
| C-136 | RemoteStoreShardCleanupTask.run: 正常 | E-22 (L38-50) | ○ |
| C-137 | RemoteStoreShardCleanupTask.run: 重複防止 | E-22 (L41, L47-49) | ○ |
| C-138 | RemoteStoreShardCleanupTask.run: 例外安全性 | E-22 (L43-46) | ○ |
| C-139 | BlobStoreProvider.blobStore: 通常 | E-23 (L41-46) | ○ |
| C-140 | BlobStoreProvider.blobStore: 暗号化 | E-23 (L42-43) | ○ |
| C-141 | BlobStoreProvider.initBlobStore: 未開始 | E-23 (L75-77) | ○ |
| C-142 | BlobStoreProvider.close | E-23 (L87-98) | ○ |
| C-143 | BlobStoreProvider.createBlobStore: 暗号化ラップ | E-23 (L57-59) | △ |
| C-144 | cryptofsToJson: 正常 | E-24 (L140-161) | ○ |
| C-145 | cryptofsToJson: 空文字列 | E-24 (L141-143) | ○ |
| C-146 | cryptofsToJson: null | E-24 (L141) | ○ |
| C-147 | jsonToCryptofs: 正常 | E-24 (L173-192) | ○ |
| C-148 | jsonToCryptofs: 空文字列 | E-24 (L174-176) | ○ |
| C-149 | mergeJson: 正常マージ | E-24 (L202-227) | ○ |
| C-150 | mergeJson: override優先 | E-24 (L213) | ○ |
| C-151 | mergeJson: null base | E-24 (L203-205) | ○ |
| C-152 | mergeJson: null override | E-24 (L206-208) | ○ |
| C-153 | mergeJson: 両方null | E-24 (L203-204) | ○ |
| C-154 | mergeAndEncodeEncryptionContexts: 正常 | E-24 (L46-78) | ○ |
| C-155 | mergeAndEncodeEncryptionContexts: 両方null | E-24 (L48-50) | ○ |
| C-156 | mergeAndEncodeEncryptionContexts: cryptofs形式変換 | E-24 (L56-59) | ○ |
| C-157 | mergeCryptoMetadata: 正常マージ | E-24 (L89-133) | ○ |
| C-158 | mergeCryptoMetadata: null index | E-24 (L93-95) | ○ |
| C-159 | mergeCryptoMetadata: null repository | E-24 (L96-98) | ○ |
| C-160 | mergeCryptoMetadata: 両方null | E-24 (L90-92) | ○ |
| C-161 | parseSimpleJson | E-24 (L237-243) | ○ |
| C-162 | FsRepository.validateLocation: 空location | E-25 (L141-173) | ○ |
| C-163 | FsRepository.validateLocation: 不正パス | E-25 (L150-173) | ○ |
| C-164 | FsRepository.readMetadata: chunk_size | E-25 (L127-139) | ○ |
| C-165 | FsRepository.readMetadata: base_path | E-25 (L133-138) | ○ |
| C-166 | FsRepository.basePath | E-25 (L189-191) | ○ |
| C-167 | FsRepository.chunkSize | E-25 (L184-186) | ○ |
| C-168 | FsRepository.getRestrictedSystemRepositorySettings | E-25 (L194-199) | ○ |
| C-169 | ReloadableFsRepository.isReloadable | E-26 (L76-78) | ○ |
| C-170 | ReloadableFsRepository.reload | E-26 (L81-86) | △ |
| C-171 | FailSwitch.fail: failRate=100 | E-26 (L109-116) | ○ |
| C-172 | FailSwitch.failRate | E-26 (L122-124) | ○ |
| C-173 | FailSwitch.failAlways | E-26 (L118-120) | ○ |
| C-174 | SlowDownWriteSwitch.setSleepSeconds | E-26 (L134-136) | ○ |
| C-175 | randomIntBetween: 範囲内 | E-26 (L100-103) | ○ |
| C-176 | randomIntBetween: min==max | E-26 (L100-103) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-112: evict()はprivateメソッドであり、直接テストが困難。getArchivedStats()やarchive()を通じた間接テストは可能だが、タイミング依存の挙動のため要確認
  - 候補：統合テスト / テスト用タイムソースの注入
- C-131: voting_onlyロールは現在未実装（コードコメント参照）。常にfalseを返すため、trueのケースはテスト不可能
  - 候補：モックによるロール設定 / 将来の実装後にテスト追加
- C-143: EncryptedBlobStoreのラップは外部クラスへの依存が大きく、単体テストではモック必須
  - 候補：BlobStoreのモック / CryptoMetadataのモック
- C-170: reload()メソッドはsuper.reload()を呼び出した後にvalidateLocation()やreadMetadata()を呼ぶため、Environment依存が大きい
  - 候補：統合テスト / Environmentモック

## 5) リスクフラグ（レビュー観点）
- 0: RepositoryDataのスナップショット追加/削除ロジック -- ソースコードの分岐が複雑だがテストケースで十分にカバー
- 1: EncryptionContextUtilsのcryptofs<->JSON変換 -- 特殊文字（カンマ、イコール）を含む入力のテストケースが不足している可能性
- 1: RepositoriesStatsArchiveのスレッドセーフティ -- synchronizedブロックの挙動は並行テストでの確認が望ましい
- 0: 例外クラス群 -- シンプルな構造のためリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] RepositoryDataのaddSnapshot/removeSnapshotsのテストケースが全分岐をカバーしているか確認
- [ ] ShardGenerationsのobsoleteShardGenerationsの境界条件（null世代値）が十分にテストされているか確認
- [ ] EncryptionContextUtilsのcryptofsToJson/jsonToCryptofsで特殊文字を含む入力のテストが必要か検討
- [ ] RepositoriesStatsArchiveの並行アクセス時の動作テストの必要性を検討
- [ ] FsRepositoryのvalidateLocationで実際のファイルシステムパスに依存するテストのモック方針を確認
- [ ] BlobStoreProviderのcryptoMetadata連携テストでモックの妥当性を確認
