---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 158
  claims_with_evidence: 152
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：server-rest 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：152 / 158、根拠なし：6
- 優先レビュー（高）
  1. **C-100 (サーキットブレーカー連携)**: RestControllerの内部private dispatchRequestメソッドの実装詳細に依存しており、テスト手段の検討が必要
  2. **C-124〜C-127 (RestCancellableNodeClient)**: 並行処理とイベント駆動の動作検証が必要でモック設計が要確認
  3. **C-148 (ページネーションレスポンス)**: PageTokenの生成方法とTable設定の前提条件が要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/rest/RestUtils.java` - URL デコード、CORS処理のユーティリティ
- E-02: `server/src/main/java/org/opensearch/rest/BaseRestHandler.java` - REST ハンドラ基底クラス
- E-03: `server/src/main/java/org/opensearch/rest/BytesRestResponse.java` - バイト列ベースのRESTレスポンス
- E-04: `server/src/main/java/org/opensearch/rest/RestResponse.java` - 抽象RESTレスポンス
- E-05: `server/src/main/java/org/opensearch/rest/RestMethodHandlers.java` - HTTPメソッド別ハンドラ管理
- E-06: `server/src/main/java/org/opensearch/rest/DeprecationRestHandler.java` - 非推奨ハンドラプロキシ
- E-07: `server/src/main/java/org/opensearch/rest/RestHeaderDefinition.java` - ヘッダ定義DTO
- E-08: `server/src/main/java/org/opensearch/rest/RestHandler.java` - RESTハンドラインターフェースとRoute/DeprecatedRoute/ReplacedRoute
- E-09: `server/src/main/java/org/opensearch/rest/AbstractRestChannel.java` - 抽象RESTチャネル
- E-10: `server/src/main/java/org/opensearch/rest/NamedRoute.java` - 名前付きルート
- E-11: `server/src/main/java/org/opensearch/rest/RestController.java` - RESTコントローラ（ディスパッチ）
- E-12: `server/src/main/java/org/opensearch/rest/RestChannel.java` - RESTチャネルインターフェース
- E-13: `server/src/main/java/org/opensearch/rest/MethodHandlers.java` - メソッドハンドラインターフェース
- E-14: `server/src/main/java/org/opensearch/rest/RestRequestFilter.java` - リクエストフィルタインターフェース
- E-15: `server/src/main/java/org/opensearch/rest/action/RestActions.java` - RESTアクションユーティリティ
- E-16: `server/src/main/java/org/opensearch/rest/action/RestMainAction.java` - メインアクション
- E-17: `server/src/main/java/org/opensearch/rest/action/RestCancellableNodeClient.java` - キャンセル可能クライアント
- E-18: `server/src/main/java/org/opensearch/rest/action/RestToXContentListener.java` - XContentリスナー
- E-19: `server/src/main/java/org/opensearch/rest/action/RestResponseListener.java` - レスポンスリスナー
- E-20: `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` - Cat API基底アクション
- E-21: `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java` - テーブルレスポンスビルダー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | RestUtils.decodeComponent: 通常文字列がそのまま返却される | E-01 (L161-172, decodingNeeded判定) | ○ |
| C-002 | RestUtils.decodeComponent: パーセントエンコードがデコードされる | E-01 (L161-172, decode関数) | ○ |
| C-003 | RestUtils.decodeComponent: nullで空文字列返却 | E-01 (L162-163, null判定) | ○ |
| C-004 | RestUtils.decodeComponent: 不正エスケープでIllegalArgumentException | E-01 (L210-213, decodeHexNibble) | ○ |
| C-005 | RestUtils.decodeComponent: %%のデコード | E-01 (L202-203, case '%%') | ○ |
| C-006 | RestUtils.decodeComponent: 末尾不完全エスケープで例外 | E-01 (L198-199, L205-206) | ○ |
| C-007 | RestUtils.decodeComponent: 空文字列処理 | E-01 (L166, decodingNeeded) | ○ |
| C-008 | RestUtils.decodeQueryString: 基本クエリパース | E-01 (L66-110) | ○ |
| C-009 | RestUtils.decodeQueryString: セミコロン区切り | E-01 (L87, c == ';') | ○ |
| C-010 | RestUtils.decodeQueryString: 値なしパラメータ | E-01 (L88-92) | ○ |
| C-011 | RestUtils.decodeQueryString: 負のfromIndex | E-01 (L67-69) | ○ |
| C-012 | RestUtils.decodeQueryString: fromIndex >= 長さ | E-01 (L70-72) | ○ |
| C-013 | RestUtils.decodeQueryString: フラグメント処理 | E-01 (L74) | ○ |
| C-014 | RestUtils.checkCorsSettingForRegex: 正規表現パース | E-01 (L250-262) | ○ |
| C-015 | RestUtils.checkCorsSettingForRegex: 非正規表現 | E-01 (L255-256, isRegex判定) | ○ |
| C-016 | RestUtils.checkCorsSettingForRegex: null入力 | E-01 (L251-253) | ○ |
| C-017 | RestUtils.checkCorsSettingForRegex: スラッシュ1つ | E-01 (L255, len > 2) | ○ |
| C-018 | RestUtils.corsSettingAsArray: カンマ区切り | E-01 (L271-276) | ○ |
| C-019 | RestUtils.corsSettingAsArray: null/空入力 | E-01 (L272-274) | ○ |
| C-020 | BaseRestHandler.handleRequest: 正常処理 | E-02 (L111-133) | ○ |
| C-021 | BaseRestHandler.handleRequest: 未消費パラメータで例外 | E-02 (L117-128) | ○ |
| C-022 | BaseRestHandler.handleRequest: usageCountインクリメント | E-02 (L130) | ○ |
| C-023 | BaseRestHandler.handleRequest: responseParams除外 | E-02 (L119) | ○ |
| C-024 | BaseRestHandler.unrecognizedStrings: 類似候補提示 | E-02 (L135-178, LevenshteinDistance) | ○ |
| C-025 | BaseRestHandler.unrecognizedStrings: 候補なし | E-02 (L165, keys.isEmpty()) | ○ |
| C-026 | BaseRestHandler.getUsageCount: 初期値0 | E-02 (L91, LongAdder初期値) | ○ |
| C-027 | BaseRestHandler.parseDeprecatedMasterTimeoutParameter: deprecationログ | E-02 (L254-271) | ○ |
| C-028 | BaseRestHandler.parseDeprecatedMasterTimeoutParameter: 重複パラメータエラー | E-02 (L266-268) | ○ |
| C-029 | BaseRestHandler.validateAndGetPageParams: 有効なページパラメータ | E-02 (L359-371) | ○ |
| C-030 | BaseRestHandler.validateAndGetPageParams: pageSize<=0で例外 | E-02 (L363-365) | ○ |
| C-031 | BaseRestHandler.validateAndGetPageParams: 不正sort値で例外 | E-02 (L367-369) | ○ |
| C-032 | BaseRestHandler.sendTask: タスク情報JSONレスポンス | E-02 (L345-354) | ○ |
| C-033 | BytesRestResponse: XContentBuilderコンストラクタ | E-03 (L74-76) | ○ |
| C-034 | BytesRestResponse: テキストコンストラクタ | E-03 (L81-83) | ○ |
| C-035 | BytesRestResponse: 例外コンストラクタ | E-03 (L108-139) | ○ |
| C-036 | BytesRestResponse: OpenSearchExceptionヘッダコピー | E-03 (L136-138) | ○ |
| C-037 | BytesRestResponse.createSimpleErrorResponse | E-03 (L177-182) | ○ |
| C-038 | BytesRestResponse.errorFromXContent: パース | E-03 (L184-218) | ○ |
| C-039 | BytesRestResponse.errorFromXContent: 例外なしJSON | E-03 (L206-208) | ○ |
| C-040 | RestResponse.addHeader | E-04 (L92-102) | ○ |
| C-041 | RestResponse.addHeader: マルチバリュー | E-04 (L92-102) | ○ |
| C-042 | RestResponse.getHeaders: 初期状態空マップ | E-04 (L107-113) | ○ |
| C-043 | RestResponse.copyHeaders | E-04 (L74-87) | ○ |
| C-044 | RestMethodHandlers: コンストラクタ | E-05 (L49-55) | ○ |
| C-045 | RestMethodHandlers.addMethods: 追加登録 | E-05 (L61-69) | ○ |
| C-046 | RestMethodHandlers.addMethods: 重複エラー | E-05 (L64-65) | ○ |
| C-047 | RestMethodHandlers.getHandler: 登録済み | E-05 (L75-77) | ○ |
| C-048 | RestMethodHandlers.getHandler: 未登録 | E-05 (L75-77, Map.get) | ○ |
| C-049 | RestMethodHandlers.getValidMethods | E-05 (L82-84) | ○ |
| C-050 | DeprecationRestHandler: コンストラクタ正常 | E-06 (L62-66) | ○ |
| C-051 | DeprecationRestHandler: handler null | E-06 (L63, Objects.requireNonNull) | ○ |
| C-052 | DeprecationRestHandler: 不正deprecationMessage | E-06 (L64, requireValidHeader) | ○ |
| C-053 | DeprecationRestHandler.handleRequest: deprecationログ | E-06 (L74-78) | ○ |
| C-054 | DeprecationRestHandler.validHeaderValue: 有効ASCII | E-06 (L97-112) | ○ |
| C-055 | DeprecationRestHandler.validHeaderValue: 制御文字 | E-06 (L106, c < 32) | ○ |
| C-056 | DeprecationRestHandler.validHeaderValue: null/空 | E-06 (L98-100) | ○ |
| C-057 | DeprecationRestHandler.validHeaderValue: ASCII 32 | E-06 (L106, c < 32) | ○ |
| C-058 | DeprecationRestHandler.validHeaderValue: ASCII 126 | E-06 (L106, c > 126) | ○ |
| C-059 | DeprecationRestHandler.validHeaderValue: ASCII 127 | E-06 (L106, c > 126) | ○ |
| C-060 | DeprecationRestHandler.requireValidHeader: 例外 | E-06 (L121-127) | ○ |
| C-061 | RestHeaderDefinition: getter | E-07 (L49-60) | ○ |
| C-062 | Route: コンストラクタ | E-08 (L218-221) | ○ |
| C-063 | Route.getPathWithPathParamsReplaced | E-08 (L227-229) | ○ |
| C-064 | Route.equals: 一致 | E-08 (L247-258) | ○ |
| C-065 | Route.equals: 不一致 | E-08 (L247-258) | ○ |
| C-066 | Route.equals: パスパラメータ正規化 | E-08 (L227-229, L255-257) | ○ |
| C-067 | Route.hashCode: パスパラメータ正規化 | E-08 (L236-239) | ○ |
| C-068 | DeprecatedRoute: getter | E-08 (L266-278) | ○ |
| C-069 | ReplacedRoute: 4引数コンストラクタ | E-08 (L299-303) | ○ |
| C-070 | ReplacedRoute: 3引数コンストラクタ | E-08 (L312-314) | ○ |
| C-071 | RestHandler.replaceRoutes | E-08 (L342-344) | ○ |
| C-072 | RestHandler.Wrapper: null検証 | E-08 (L148) | ○ |
| C-073 | RestHandler.Wrapper: handleRequest委譲 | E-08 (L157-159) | ○ |
| C-074 | AbstractRestChannel.newBuilder: デフォルト | E-09 (L90-92) | ○ |
| C-075 | AbstractRestChannel.newBuilder: format指定 | E-09 (L108-156, format変数) | ○ |
| C-076 | AbstractRestChannel.newBuilder: filter_path | E-09 (L142-146) | ○ |
| C-077 | AbstractRestChannel.newBuilder: prettyPrint | E-09 (L150-151) | ○ |
| C-078 | AbstractRestChannel.newErrorBuilder | E-09 (L95-98, useFiltering=false) | ○ |
| C-079 | AbstractRestChannel.bytesOutput | E-09 (L164-171) | ○ |
| C-080 | AbstractRestChannel.bytesOutput: リセット | E-09 (L167-168, bytesOut.reset()) | ○ |
| C-081 | AbstractRestChannel.detailedErrorsEnabled | E-09 (L191-193) | ○ |
| C-082 | NamedRoute.Builder.build: 正常 | E-10 (L112-114) | ○ |
| C-083 | NamedRoute.Builder.build: method未設定 | E-10 (L120-123) | ○ |
| C-084 | NamedRoute.Builder.build: 不正名前 | E-10 (L142-155) | ○ |
| C-085 | NamedRoute.isValidRouteName: 有効パターン | E-10 (L157-162) | ○ |
| C-086 | NamedRoute.isValidRouteName: 空白含む | E-10 (L161, matches) | ○ |
| C-087 | NamedRoute.isValidRouteName: 最大長 | E-10 (L160, <= MAX_LENGTH) | ○ |
| C-088 | NamedRoute.isValidRouteName: 最大長超過 | E-10 (L160, <= MAX_LENGTH) | ○ |
| C-089 | NamedRoute.isValidRouteName: null/空 | E-10 (L158-159) | ○ |
| C-090 | NamedRoute.name | E-10 (L168-169) | ○ |
| C-091 | NamedRoute.actionNames | E-10 (L175-177) | ○ |
| C-092 | NamedRoute.Builder.legacyActionNames: 無効名 | E-10 (L126-138) | ○ |
| C-093 | RestController: コンストラクタ/favicon | E-11 (L125-146) | ○ |
| C-094 | RestController.registerHandler: 全ルート登録 | E-11 (L244-258) | ○ |
| C-095 | RestController.dispatchRequest: 正常ディスパッチ | E-11 (L287-298, L419-483) | ○ |
| C-096 | RestController: 未登録パスで400 | E-11 (L482, handleBadRequest) | ○ |
| C-097 | RestController: 無効メソッドで405 | E-11 (L397-403, handleUnsupportedHttpMethod) | ○ |
| C-098 | RestController: OPTIONS処理 | E-11 (L393-396, L551-559) | ○ |
| C-099 | RestController: Content-Typeなしで406 | E-11 (L325-328, L408-417) | ○ |
| C-100 | RestController: サーキットブレーカー連携 | E-11 (L343-347) | △ |
| C-101 | RestController.dispatchBadRequest: 正常 | E-11 (L301-319) | ○ |
| C-102 | RestController.dispatchBadRequest: causeがnull | E-11 (L304-305) | ○ |
| C-103 | RestController: error_trace設定競合 | E-11 (L445-450) | ○ |
| C-104 | RestController: マルチバリューヘッダ検証 | E-11 (L425-433) | ○ |
| C-105 | RestController.getAllHandlers | E-11 (L152-156) | ○ |
| C-106 | RestController.dispatchHandler: 正常 | E-11 (L261-284) | ○ |
| C-107 | RestController.dispatchHandler: 未登録 | E-11 (L261-284) | ○ |
| C-108 | RestActions.parseVersion: versionパラメータ | E-15 (L78-81) | ○ |
| C-109 | RestActions.parseVersion: If-Matchヘッダ | E-15 (L82-85) | ○ |
| C-110 | RestActions.parseVersion: デフォルト | E-15 (L86) | ○ |
| C-111 | RestActions.urlParamsToQueryBuilder: qあり | E-15 (L229-244) | ○ |
| C-112 | RestActions.urlParamsToQueryBuilder: qなし | E-15 (L231-233) | ○ |
| C-113 | RestActions.urlParamsToQueryBuilder: 追加パラメータ | E-15 (L235-243) | ○ |
| C-114 | RestActions.buildBroadcastShardsHeader | E-15 (L106-130) | ○ |
| C-115 | RestActions.buildBroadcastShardsHeader: skipped | E-15 (L118-120) | ○ |
| C-116 | RestActions.buildNodesHeader | E-15 (L171-195) | ○ |
| C-117 | RestActions.getQueryContent: 正常パース | E-15 (L246-248, L284-313) | ○ |
| C-118 | RestActions.getQueryContent: 不正JSON | E-15 (L290-296) | ○ |
| C-119 | RestMainAction.routes | E-16 (L62-64) | ○ |
| C-120 | RestMainAction.getName | E-16 (L67-69) | ○ |
| C-121 | RestMainAction.canTripCircuitBreaker | E-16 (L91-93) | ○ |
| C-122 | RestMainAction.convertMainResponse | E-16 (L81-88) | ○ |
| C-123 | RestMainAction.convertMainResponse: prettyデフォルト | E-16 (L83-85) | ○ |
| C-124 | RestCancellableNodeClient.doExecute: タスク登録/解除 | E-17 (L99-128) | △ |
| C-125 | RestCancellableNodeClient.doExecute: 失敗時タスク解除 | E-17 (L116-123) | △ |
| C-126 | RestCancellableNodeClient.getNumChannels | E-17 (L79-81) | ○ |
| C-127 | RestCancellableNodeClient.CloseListener.onResponse: タスクキャンセル | E-17 (L171-185) | △ |
| C-128 | RestToXContentListener.buildResponse | E-18 (L59-67) | ○ |
| C-129 | RestResponseListener.processResponse | E-19 (L51-53) | ○ |
| C-130 | AbstractCatAction.prepareRequest: help=false | E-20 (L68-91) | ○ |
| C-131 | AbstractCatAction.prepareRequest: help=true | E-20 (L69-87) | ○ |
| C-132 | AbstractCatAction.responseParams | E-20 (L93-95) | ○ |
| C-133 | RestTable.buildResponse: テキスト | E-21 (L73-80) | ○ |
| C-134 | RestTable.buildResponse: JSON | E-21 (L73-80, L89-101) | ○ |
| C-135 | RestTable.buildTextPlainResponse: verbose | E-21 (L134-176, L136, L144) | ○ |
| C-136 | RestTable.buildTextPlainResponse: non-verbose | E-21 (L134-176, L136, L144) | ○ |
| C-137 | RestTable.buildDisplayHeaders: h指定 | E-21 (L211-261, L213) | ○ |
| C-138 | RestTable.buildDisplayHeaders: hなし | E-21 (L252-259) | ○ |
| C-139 | RestTable.buildDisplayHeaders: ワイルドカード | E-21 (L286-307) | ○ |
| C-140 | RestTable.getRowOrder: ソート | E-21 (L178-209) | ○ |
| C-141 | RestTable.getRowOrder: 逆順ソート | E-21 (L192-194, reverse=true) | ○ |
| C-142 | RestTable.getRowOrder: 不正ソートキー | E-21 (L200-204) | ○ |
| C-143 | RestTable.checkOutputTimestamp: ts=false | E-21 (L263-273) | ○ |
| C-144 | RestTable.pad: 左寄せ | E-21 (L366-392) | ○ |
| C-145 | RestTable.pad: 右寄せ | E-21 (L374-380) | ○ |
| C-146 | RestTable.pad: 最終列 | E-21 (L386-389) | ○ |
| C-147 | RestTable.buildHelpWidths | E-21 (L309-331) | ○ |
| C-148 | RestTable.buildXContentBuilder: ページネーション | E-21 (L93-101) | △ |
| C-149 | RestRequestFilter.getFilteredRequest: フィルタ適用 | E-14 (L59-95) | ○ |
| C-150 | RestRequestFilter.getFilteredRequest: コンテンツなし | E-14 (L61, L92-94) | ○ |
| C-151 | RestRequestFilter.getFilteredRequest: 空フィルタ | E-14 (L61, fields.isEmpty()) | ○ |
| C-152 | BaseRestHandler.Wrapper: null検証 | E-02 (L283) | ○ |
| C-153 | BaseRestHandler.Wrapper.getName: 委譲 | E-02 (L287-289) | ○ |
| C-154 | TableIndexComparator.compare: 正常比較 | E-21 (L498-523) | ○ |
| C-155 | TableIndexComparator.compare: 無効インデックス | E-21 (L512-521) | ○ |
| C-156 | TableIndexComparator.compareCell: 両方null | E-21 (L483-484) | ○ |
| C-157 | TableIndexComparator.compareCell: 片方null | E-21 (L485-488) | ○ |
| C-158 | RestToXContentListener.getRequestParams: スタックトレース | E-18 (L73-80) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-100: RestControllerのprivateメソッドdispatchRequest内のサーキットブレーカー統合は、CircuitBreakerServiceのモック設定が必要。テスト方法の具体的な設計はレビュー時に検討が必要。
  - 候補: CircuitBreakerServiceのモック / 統合テストとしての実施 / リフレクションによるprivateメソッドテスト
- C-124, C-125, C-127: RestCancellableNodeClientのdoExecute, CloseListener.onResponseは、NodeClient, HttpChannel, Task等の複雑なモック構成が必要。並行処理の正確性検証方法は要確認。
  - 候補: NodeClientモック / HttpChannelモック / ConcurrentHashMapの状態検証
- C-148: ページネーション付きテーブルのXContent出力は、PageTokenオブジェクトの生成方法と前提条件が明示されていない。
  - 候補: PageToken生成方法の確認 / Tableのセットアップ手順の明確化

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RestUtils, RestHeaderDefinition, Route等のユーティリティ・DTOクラスのテストケース（C-001〜C-019, C-061〜C-071）
- 0: 低リスク - BaseRestHandler, RestResponseの基本メソッドテストケース（C-020〜C-043）
- 1: 中リスク - RestController関連のテストケース（C-093〜C-107）。privateメソッドや内部クラスのテスト設計が必要。
- 1: 中リスク - RestCancellableNodeClient関連（C-124〜C-127）。並行処理のテストは不確実性がある。
- 0: 低リスク - Cat API関連のテストケース（C-130〜C-148）。テーブル操作は比較的直接的にテスト可能。

## 6) レビュアーチェックリスト（最小）
- [ ] RestControllerのprivateメソッドに対するテスト手法（リフレクション、パッケージプライベートなテスト用メソッド等）が適切か
- [ ] RestCancellableNodeClientの並行処理テストケースのモック設計が十分か
- [ ] ページネーション関連テストのPageToken前提条件が明確か
- [ ] 各テストケースの優先度付けがプロジェクトの重要度と一致しているか
- [ ] REST APIのセキュリティ関連テスト（ヘッダ検証、Content-Type検証等）が網羅されているか
- [ ] 境界値テストがURLデコード、文字列長、ASCII値範囲等で十分にカバーされているか
