---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 138
  claims_without_evidence: 12
confidence_derived: 0.92
---

# 根拠レポート：server-search 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：138 / 150、根拠なし：12
- 優先レビュー（高）
  1. **UT-SRC-049/050 SearchPipelineService.resolvePipeline**：メソッドの内部実装を直接読み取れず、例外型の推測あり
  2. **UT-SRC-059/060 QueryPhase.execute**：内部実装が複雑でモックベースの前提条件が推測
  3. **UT-SRC-078 SliceBuilder バリデーション**：例外型がコンストラクタ内バリデーションの詳細に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/search/SearchHit.java` - SearchHitクラス定義、コンストラクタ、フィールド、シリアライズ
- E-02: `server/src/main/java/org/opensearch/search/SearchHits.java` - SearchHitsクラス定義、empty()、getAt()、deepCopy()、writeTo()
- E-03: `server/src/main/java/org/opensearch/search/builder/SearchSourceBuilder.java` - SearchSourceBuilder定義、fromXContent()、各フィールドのセッター/ゲッター
- E-04: `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineService.java` - SearchPipelineService定義、resolvePipeline
- E-05: `server/src/main/java/org/opensearch/search/pipeline/PipelinedRequest.java` - PipelinedRequest定義、transformRequest、transformResponseListener
- E-06: `server/src/main/java/org/opensearch/search/pipeline/Pipeline.java` - Pipeline定義、transformRequest、transformResponse
- E-07: `server/src/main/java/org/opensearch/search/query/QueryPhase.java` - QueryPhase定義、execute()
- E-08: `server/src/main/java/org/opensearch/search/fetch/FetchPhase.java` - FetchPhase定義、execute()
- E-09: `server/src/main/java/org/opensearch/search/sort/FieldSortBuilder.java` - FieldSortBuilder定義、コンストラクタ、order、missing、sortMode
- E-10: `server/src/main/java/org/opensearch/search/sort/ScriptSortBuilder.java` - ScriptSortBuilder定義
- E-11: `server/src/main/java/org/opensearch/search/sort/GeoDistanceSortBuilder.java` - GeoDistanceSortBuilder定義
- E-12: `server/src/main/java/org/opensearch/search/sort/SortValue.java` - SortValue定義、from()メソッド
- E-13: `server/src/main/java/org/opensearch/search/SearchSortValues.java` - SearchSortValues定義、コンストラクタバリデーション
- E-14: `server/src/main/java/org/opensearch/search/rescore/QueryRescorer.java` - QueryRescorer定義、rescore()のnull/空チェック
- E-15: `server/src/main/java/org/opensearch/search/slice/SliceBuilder.java` - SliceBuilder定義、コンストラクタ
- E-16: `server/src/main/java/org/opensearch/search/collapse/CollapseBuilder.java` - CollapseBuilder定義
- E-17: `server/src/main/java/org/opensearch/search/aggregations/AggregatorFactories.java` - AggregatorFactories.Builder定義
- E-18: `server/src/main/java/org/opensearch/search/aggregations/InternalAggregation.java` - InternalAggregation.ReduceContext定義
- E-19: `server/src/main/java/org/opensearch/search/aggregations/InternalAggregations.java` - InternalAggregations定義、reduce()
- E-20: `server/src/main/java/org/opensearch/search/aggregations/MultiBucketConsumerService.java` - MultiBucketConsumerService定義
- E-21: `server/src/main/java/org/opensearch/search/backpressure/SearchBackpressureService.java` - SearchBackpressureService定義、doRun、onTaskCompleted
- E-22: `server/src/main/java/org/opensearch/search/backpressure/SearchBackpressureState.java` - SearchBackpressureState定義
- E-23: `server/src/main/java/org/opensearch/search/backpressure/trackers/HeapUsageTracker.java` - HeapUsageTracker定義
- E-24: `server/src/main/java/org/opensearch/search/backpressure/trackers/CpuUsageTracker.java` - CpuUsageTracker定義
- E-25: `server/src/main/java/org/opensearch/search/backpressure/trackers/ElapsedTimeTracker.java` - ElapsedTimeTracker定義
- E-26: `server/src/main/java/org/opensearch/search/backpressure/trackers/NodeDuressTrackers.java` - NodeDuressTrackers定義
- E-27: `server/src/main/java/org/opensearch/search/DocValueFormat.java` - DocValueFormat定義、DateTime、RAW、Decimal、GEOHASH、IP
- E-28: `server/src/main/java/org/opensearch/search/suggest/SuggestBuilder.java` - SuggestBuilder定義
- E-29: `server/src/main/java/org/opensearch/search/suggest/Suggest.java` - Suggest定義
- E-30: `server/src/main/java/org/opensearch/search/searchafter/SearchAfterBuilder.java` - SearchAfterBuilder定義
- E-31: `server/src/main/java/org/opensearch/search/MultiValueMode.java` - MultiValueMode定義
- E-32: `server/src/main/java/org/opensearch/search/SearchModule.java` - SearchModule定義
- E-33: `server/src/main/java/org/opensearch/search/internal/AliasFilter.java` - AliasFilter定義
- E-34: `server/src/main/java/org/opensearch/search/dfs/AggregatedDfs.java` - AggregatedDfs定義
- E-35: `server/src/main/java/org/opensearch/search/dfs/DfsPhase.java` - DfsPhase定義
- E-36: `server/src/main/java/org/opensearch/search/fetch/subphase/FetchSourceContext.java` - FetchSourceContext定義
- E-37: `server/src/main/java/org/opensearch/search/Scroll.java` - Scroll定義
- E-38: `server/src/main/java/org/opensearch/search/SearchShardTarget.java` - SearchShardTarget定義
- E-39: `server/src/main/java/org/opensearch/search/RescoreDocIds.java` - RescoreDocIds定義
- E-40: `server/src/main/java/org/opensearch/search/builder/PointInTimeBuilder.java` - PointInTimeBuilder定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SearchHitコンストラクタがnull documentFieldsを空Mapに変換 | E-01 (L165: `this.documentFields = documentFields == null ? emptyMap() : documentFields`) | ○ |
| C-02 | SearchHitのidがnullの場合idフィールドがnull | E-01 (L159-163: `if (id != null) { this.id = new Text(id); } else { this.id = null; }`) | ○ |
| C-03 | SearchHitのwriteTo/readFromシリアライズ整合性 | E-01 (L169以降: StreamInput/StreamOutputでの読み書き実装) | ○ |
| C-04 | SearchHits.empty()がtotalHits=0を返す | E-02 (L66-72: `new SearchHits(EMPTY, new TotalHits(0, Relation.EQUAL_TO), 0)`) | ○ |
| C-05 | SearchHits.getAt()がhits[position]を返す | E-02 (L189-191: `return hits[position]`) | ○ |
| C-06 | SearchHits.deepCopy()がシリアライズ経由でコピー | E-02 (L176-184: writeTo/readFromによるディープコピー) | ○ |
| C-07 | SearchSourceBuilder.fromXContent()がJSONからビルダーを構築 | E-03 (L141-149: parseXContent呼び出し) | ○ |
| C-08 | SearchSourceBuilderのfrom/sizeデフォルト値が-1 | E-03 (L169-171: `private int from = -1; private int size = -1`) | ○ |
| C-09 | SearchSortValuesの配列長不一致でIllegalArgumentException | E-13 (L73-74: `if (rawSortValues.length != sortValueFormats.length) { throw new IllegalArgumentException(...)`) | ○ |
| C-10 | SearchSortValuesのnull引数でNullPointerException | E-13 (L71: `Objects.requireNonNull(rawSortValues)`) | ○ |
| C-11 | QueryRescorer.rescoreがnull/空TopDocsをそのまま返却 | E-14 (L66-68: `if (topDocs == null \|\| topDocs.scoreDocs.length == 0) { return topDocs; }`) | ○ |
| C-12 | PipelinedRequest.transformRequestがプロセッサ空時にそのまま返却 | E-05 (L69-74: `if (hasProcessor) {...} else { requestListener.onResponse(this); }`) | ○ |
| C-13 | SearchBackpressureServiceのtrackerApplyConditions定義 | E-21 (L71-78: trackerApplyConditions Map定義) | ○ |
| C-14 | DocValueFormat.RAWのformat(long)がそのまま返却 | E-27 (L78: `default Object format(long value)`) | ○ |
| C-15 | SearchPipelineService.resolvePipelineの例外型 | E-04 | △ |
| C-16 | SliceBuilderのidがmax以上でIllegalArgumentException | E-15 | △ |
| C-17 | CollapseBuilderのnullフィールドでIllegalArgumentException | E-16 | △ |
| C-18 | QueryPhase.executeのTaskCancelledException | E-07 | △ |
| C-19 | FetchPhase.executeのTaskCancelledException | E-08 | △ |
| C-20 | SearchAfterBuilder.setSortValuesの空配列でIllegalArgumentException | E-30 | △ |
| C-21 | PointInTimeBuilder(null)でNullPointerException | E-40 | △ |
| C-22 | AggregatorFactories.Builder重複名でIllegalArgumentException | E-17 | △ |
| C-23 | MultiBucketConsumerのTooManyBucketsException発生 | E-20 | △ |
| C-24 | DfsPhase.executeの実行結果 | E-35 | △ |
| C-25 | SearchModule初期化で全ビルトイン登録 | E-32 | △ |
| C-26 | StreamSearchResult構築 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SliceBuilder、CollapseBuilder、SearchAfterBuilder、PointInTimeBuilderのコンストラクタ内バリデーション詳細は、ソースコードの該当行を直接確認していないため、例外型が推測に基づく
  - 候補：各ファイルのコンストラクタ実装の精読 / 既存テストコードの確認
- QueryPhase.execute、FetchPhase.executeの内部フローは複雑なため、テストケースの前提条件が推測に基づく
  - 候補：既存の統合テスト / SearchServiceのテストコード
- SearchPipelineService.resolvePipelineの例外型はIllegalArgumentExceptionと推測したが、実際にはResourceNotFoundExceptionの可能性がある
  - 候補：SearchPipelineServiceの実装詳細 / 既存テストコード
- server-searchモジュールは886ファイルと巨大で、aggregations配下のbucket/metrics/pipeline等の詳細な集約実装は本レポートでカバーしきれていない
  - 候補：aggregations配下の各サブパッケージの個別解析

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - SearchPipelineService関連（UT-SRC-049〜058）の例外型・前提条件は実装依存のため要確認
- 1: 中リスク - QueryPhase/FetchPhase（UT-SRC-059〜062）はSearchContextのモック構成に依存
- 0: 低リスク - SearchHit/SearchHits/SearchSourceBuilder等のPublicAPI関連テストケースはソースコードから直接確認済み
- 0: 低リスク - backpressure関連（UT-SRC-111〜121）はソースコードのtrackerApplyConditions定義から直接確認済み
- 1: 中リスク - aggregations関連（UT-SRC-081〜091）はファクトリ・リダクション部分の内部実装が複雑

## 6) レビュアーチェックリスト（最小）
- [ ] SearchPipelineService.resolvePipelineの例外型がIllegalArgumentExceptionで正しいか確認（ResourceNotFoundExceptionの可能性）
- [ ] SliceBuilder/CollapseBuilder/SearchAfterBuilderのコンストラクタバリデーションの例外型を実装と照合
- [ ] QueryPhase.execute/FetchPhase.executeのTaskCancelledException発生条件が正しいか確認
- [ ] aggregations配下のbucket/metrics/pipeline等の主要集約クラスについて追加テストケースの必要性を検討
- [ ] backpressure trackerの閾値超過判定ロジックが最新コードと一致しているか確認
- [ ] 886ファイル中の主要publicクラスが漏れなくカバーされているか確認（特にstarttree、approximate、streaming等の新しいサブパッケージ）
