---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 167
  claims_with_evidence: 164
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：server-tasks 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：164 / 167、根拠なし：3
- 優先レビュー（高）
  1. **C-132 TaskResultsService.storeResult インデックス自動作成**：実際の動作はインフラ依存であり、ユニットテストでの検証にはモック化が必要
  2. **C-137 taskResultIndexMapping ファイル読込失敗**：リソースファイルの不在はテスト環境構築に工夫が必要
  3. **C-148 TaskCancellationMonitoringService.stats**：System.nanoTime()依存のフィルタリングロジックをテストで再現するのが困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/tasks/Task.java` - Taskクラス定義、コンストラクタ、getter、リソーストラッキングメソッド
- E-02: `server/src/main/java/org/opensearch/tasks/CancellableTask.java` - キャンセル可能タスク、cancel/isCancelled/getCancellationStartTime等
- E-03: `server/src/main/java/org/opensearch/tasks/TaskInfo.java` - TaskInfo定義、コンストラクタバリデーション、シリアライゼーション、XContent
- E-04: `server/src/main/java/org/opensearch/tasks/TaskResult.java` - TaskResult定義、エラー/レスポンス処理、XContent
- E-05: `server/src/main/java/org/opensearch/tasks/TaskManager.java` - タスク登録/解除/キャンセル/ban管理、storeResult
- E-06: `server/src/main/java/org/opensearch/tasks/TaskCancellationService.java` - cancelTaskAndDescendants、BanParentTaskRequest
- E-07: `server/src/main/java/org/opensearch/tasks/TaskResourceTrackingService.java` - リソーストラッキングの開始/停止、スレッド実行管理
- E-08: `server/src/main/java/org/opensearch/tasks/TaskResultsService.java` - タスク結果保存、インデックス管理
- E-09: `server/src/main/java/org/opensearch/tasks/TaskCancellation.java` - キャンセル判定、スコア計算、マージ
- E-10: `server/src/main/java/org/opensearch/tasks/RawTaskStatus.java` - 未パースのステータス、toMap、equals/hashCode
- E-11: `server/src/main/java/org/opensearch/tasks/TaskCancellationStats.java` - キャンセル統計、シリアライゼーション
- E-12: `server/src/main/java/org/opensearch/tasks/TaskCancellationMonitoringService.java` - モニタリングサービス、イベントリスナー、統計取得
- E-13: `server/src/main/java/org/opensearch/tasks/TaskCancellationMonitoringSettings.java` - モニタリング設定、動的更新
- E-14: `server/src/main/java/org/opensearch/tasks/BaseSearchTaskCancellationStats.java` - キャンセル統計基底クラス
- E-15: `server/src/main/java/org/opensearch/tasks/TaskThreadContextStatePropagator.java` - TASK_IDのスレッドコンテキスト伝播
- E-16: `server/src/main/java/org/opensearch/tasks/LoggingTaskListener.java` - ログ出力リスナー
- E-17: `server/src/main/java/org/opensearch/tasks/consumer/TopNSearchTasksLogger.java` - Top Nクエリログ
- E-18: `server/src/main/java/org/opensearch/tasks/consumer/SearchShardTaskDetailsLogMessage.java` - ログメッセージフォーマット
- E-19: `server/src/main/java/org/opensearch/tasks/TaskAwareRequest.java` - リクエストインタフェース
- E-20: `server/src/main/java/org/opensearch/tasks/TaskListener.java` - タスクリスナーインタフェース
- E-21: `server/src/main/java/org/opensearch/tasks/SearchBackpressureTask.java` - マーカーインタフェース
- E-22: `server/src/main/java/org/opensearch/tasks/SearchTaskCancellationStats.java` - 検索タスクキャンセル統計
- E-23: `server/src/main/java/org/opensearch/tasks/SearchShardTaskCancellationStats.java` - シャード検索タスクキャンセル統計

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Taskコンストラクタで全フィールドが正しく設定される | E-01 (L128-165) | ○ |
| C-002 | getId()がidフィールドを返す | E-01 (L248-250) | ○ |
| C-003 | getType()がtypeフィールドを返す | E-01 (L255-257) | ○ |
| C-004 | getAction()がactionフィールドを返す | E-01 (L262-264) | ○ |
| C-005 | getDescription()がdescriptionフィールドを返す | E-01 (L269-271) | ○ |
| C-006 | getParentTaskId()がparentTaskを返す | E-01 (L290-292) | ○ |
| C-007 | getStatus()がデフォルトでnullを返す | E-01 (L300-302) | ○ |
| C-008 | supportsResourceTracking()がデフォルトでfalseを返す | E-01 (L512-514) | ○ |
| C-009 | getHeader()がheadersマップから値を返す | E-01 (L536-538) | ○ |
| C-010 | 存在しないヘッダーキーでnullが返る | E-01 (L536-538) | ○ |
| C-011 | taskInfo(detailed=true)でdescriptionとstatusが含まれる | E-01 (L177-179, L191-210) | ○ |
| C-012 | taskInfo(detailed=false)でdescriptionとstatusが含まれない | E-01 (L177-179, L191-210) | ○ |
| C-013 | 空リソースでゼロ値が返る | E-01 (L316-317) | ○ |
| C-014 | 複数スレッドのリソース合計が正しく計算される | E-01 (L344-355) | ○ |
| C-015 | 空リソースでgetTotalResourceUtilizationが0を返す | E-01 (L344-355) | ○ |
| C-016 | 空リソースでgetMinが0を返す | E-01 (L378-392) | ○ |
| C-017 | getMaxResourceStatsが最大値を計算する | E-01 (L397-408) | ○ |
| C-018 | getAverageResourceStatsが平均値を計算する | E-01 (L360-373) | ○ |
| C-019 | スレッド0件で平均が0になる | E-01 (L372) | ○ |
| C-020 | getThreadUsageがスレッド情報を正しく返す | E-01 (L413-425) | ○ |
| C-021 | 空リソースでスレッド使用状況がゼロ | E-01 (L413-425) | ○ |
| C-022 | startThreadResourceTrackingでエントリが追加される | E-01 (L434-446) | ○ |
| C-023 | 重複アクティブエントリでIllegalStateException | E-01 (L437-443) | ○ |
| C-024 | updateThreadResourceStatsでアクティブエントリが更新される | E-01 (L456-468) | ○ |
| C-025 | アクティブエントリなしでupdateがIllegalStateException | E-01 (L467) | ○ |
| C-026 | stopThreadResourceTrackingでエントリが非アクティブになる | E-01 (L478-491) | ○ |
| C-027 | アクティブエントリなしでstopがIllegalStateException | E-01 (L490) | ○ |
| C-028 | getActiveThreadResourceInfoがアクティブ情報を返す | E-01 (L493-503) | ○ |
| C-029 | 存在しないスレッドでnullが返る | E-01 (L493-503) | ○ |
| C-030 | アクティブスレッドがある場合にリスナー登録成功 | E-01 (L556-563) | ○ |
| C-031 | アクティブスレッド0でリスナー登録失敗 | E-01 (L556-563) | ○ |
| C-032 | カウント0でリスナーが呼び出される | E-01 (L589-609) | ○ |
| C-033 | カウント非0でリスナーが呼び出されない | E-01 (L589-609) | ○ |
| C-034 | result(error)でTaskResultが生成される | E-01 (L540-542) | ○ |
| C-035 | result(response)でToXContentのTaskResultが生成される | E-01 (L544-549) | ○ |
| C-036 | ToXContent未実装レスポンスでIllegalStateException | E-01 (L548) | ○ |
| C-037 | CancellableTask.cancelでキャンセル状態になる | E-02 (L92-97) | ○ |
| C-038 | 二重キャンセルが無視される | E-02 (L94) SetOnce.trySet | ○ |
| C-039 | 未キャンセル時isCancelled=false | E-02 (L99-101) | ○ |
| C-040 | キャンセル時にキャンセル開始時刻が返る | E-02 (L126-129) | ○ |
| C-041 | 未キャンセル時にnullが返る | E-02 (L126-129) | ○ |
| C-042 | キャンセル時にナノ秒時刻が返る | E-02 (L131-135) | ○ |
| C-043 | キャンセル理由が返る | E-02 (L141-144) | ○ |
| C-044 | 未キャンセル時にnullが返る | E-02 (L141-144) | ○ |
| C-045 | getCancellationTimeoutが正しい値を返す | E-02 (L108-110) | ○ |
| C-046 | cancelOnParentLeavingがデフォルトでtrue | E-02 (L121-123) | ○ |
| C-047 | TaskInfoコンストラクタが正しく初期化される | E-03 (L131-162) | ○ |
| C-048 | cancellable=false, cancelled=trueでIllegalArgumentException | E-03 (L146-148) | ○ |
| C-049 | TaskInfoのシリアライゼーション | E-03 (L168-220) | ○ |
| C-050 | TaskInfoのXContent出力 | E-03 (L304-339) | ○ |
| C-051 | status=nullでstatusフィールドが出力されない | E-03 (L309-311) | ○ |
| C-052 | resourceStats=nullでresource_statsが出力されない | E-03 (L330-334) | ○ |
| C-053 | fromXContentでパースが正しく行われる | E-03 (L341-401) | ○ |
| C-054 | TaskInfo.equalsが同一内容でtrue | E-03 (L410-428) | ○ |
| C-055 | TaskInfo.equalsが異なる内容でfalse | E-03 (L410-428) | ○ |
| C-056 | TaskInfo.hashCodeが一致 | E-03 (L430-447) | ○ |
| C-057 | 未完了TaskResultの生成 | E-04 (L82-84) | ○ |
| C-058 | エラー付きTaskResult | E-04 (L89-91) | ○ |
| C-059 | レスポンス付きTaskResult | E-04 (L96-98) | ○ |
| C-060 | getErrorAsMapのMap変換 | E-04 (L144-149) | ○ |
| C-061 | error=nullで空Map | E-04 (L145-147) | ○ |
| C-062 | getResponseAsMapのMap変換 | E-04 (L163-168) | ○ |
| C-063 | response=nullで空Map | E-04 (L164-166) | ○ |
| C-064 | TaskResultシリアライゼーション | E-04 (L110-123) | ○ |
| C-065 | TaskResult.toXContent出力 | E-04 (L175-193) | ○ |
| C-066 | TaskResult.equals/hashCode | E-04 (L218-240) | ○ |
| C-067 | TaskManager.registerで通常タスクが登録される | E-05 (L191-243) | ○ |
| C-068 | CancellableTaskがcancellableTasksに登録される | E-05 (L237-243, L246-265) | ○ |
| C-069 | ヘッダーサイズ超過でIllegalArgumentException | E-05 (L200-201) | ○ |
| C-070 | unregisterで通常タスクが解除される | E-05 (L298-334) | ○ |
| C-071 | CancellableTask登録解除 | E-05 (L323-328) | ○ |
| C-072 | cancelが正しく実行される | E-05 (L274-293) | ○ |
| C-073 | 未登録タスクのキャンセルでリスナー即呼出 | E-05 (L290-292) | ○ |
| C-074 | getTasksで全タスク取得 | E-05 (L426-432) | ○ |
| C-075 | getTasks空Map | E-05 (L426-432) | ○ |
| C-076 | getCancellableTasksでキャンセル可能タスクのみ | E-05 (L437-443) | ○ |
| C-077 | getTaskでID検索(通常) | E-05 (L448-455) | ○ |
| C-078 | getTaskでID検索(キャンセル可能) | E-05 (L448-455, L460-467) | ○ |
| C-079 | 存在しないIDでnull | E-05 (L448-455) | ○ |
| C-080 | setBanでbanが設定される | E-05 (L485-496) | ○ |
| C-081 | removeBanでbanが削除される | E-05 (L503-506) | ○ |
| C-082 | getBanCountでban数が返る | E-05 (L474-476) | ○ |
| C-083 | registerChildNodeで子ノード登録 | E-05 (L340-351) | ○ |
| C-084 | 存在しないタスクで空Releasable | E-05 (L350) | ○ |
| C-085 | waitForTaskCompletionで完了待ち | E-05 (L561-573) | ○ |
| C-086 | タイムアウトでOpenSearchTimeoutException | E-05 (L572) | ○ |
| C-087 | storeResult(error)で保存 | E-05 (L360-387) | ○ |
| C-088 | localNode=nullでonFailure呼出 | E-05 (L362-365) | ○ |
| C-089 | storeResult(response)で保存 | E-05 (L392-421) | ○ |
| C-090 | localNode=nullでonResponse呼出 | E-05 (L394-397) | ○ |
| C-091 | applyClusterStateでノード更新 | E-05 (L536-537) | ○ |
| C-092 | ノード離脱時にban削除 | E-05 (L538-556) | ○ |
| C-093 | cancelTaskAndDescendantsで委譲 | E-05 (L804-812) | ○ |
| C-094 | cancellationService未設定でIllegalStateException | E-05 (L809-810) | ○ |
| C-095 | startBanOnChildrenNodes | E-05 (L525-533) | ○ |
| C-096 | 存在しないタスクでコールバック即実行 | E-05 (L529-530) | ○ |
| C-097 | TaskCancellation.cancelの実行 | E-09 (L67-74) | ○ |
| C-098 | 非対象タスクで何もしない | E-09 (L68-69) | ○ |
| C-099 | isEligibleForCancellationがtrue | E-09 (L116-118) | ○ |
| C-100 | 理由空でfalse | E-09 (L117) | ○ |
| C-101 | キャンセル済みでfalse | E-09 (L117) | ○ |
| C-102 | totalCancellationScoreの合計 | E-09 (L109-111) | ○ |
| C-103 | 空リストでスコア0 | E-09 (L109-111) | ○ |
| C-104 | getReasonStringのカンマ区切り結合 | E-09 (L49-51) | ○ |
| C-105 | mergeで統合 | E-09 (L53-62) | ○ |
| C-106 | 自己マージで同一オブジェクト | E-09 (L54-56) | ○ |
| C-107 | compareTo | E-09 (L121-123) | ○ |
| C-108 | cancelTaskAndDescendants | E-09 (L79-86) | ○ |
| C-109 | Reason生成 | E-09 (L128-144) | ○ |
| C-110 | RawTaskStatus(BytesReference)生成 | E-10 (L59-61) | ○ |
| C-111 | null入力でNPE | E-10 (L60) requireNonNull | ○ |
| C-112 | toMapでMap変換 | E-10 (L95-97) | ○ |
| C-113 | getWriteableNameが'raw' | E-10 (L83-85) | ○ |
| C-114 | RawTaskStatusシリアライゼーション | E-10 (L66-73) | ○ |
| C-115 | equals/hashCode | E-10 (L100-114) | ○ |
| C-116 | TaskCancellationServiceコンストラクタ | E-06 (L71-80) | ○ |
| C-117 | 子タスクを含むキャンセル | E-06 (L86-126) | ○ |
| C-118 | 単独キャンセル | E-06 (L117-125) | ○ |
| C-119 | waitForCompletion=trueでの待機 | E-06 (L112-113) | ○ |
| C-120 | startTrackingでトラッキング開始 | E-07 (L103-113) | ○ |
| C-121 | トラッキング無効時に空StoredContext | E-07 (L104-108) | ○ |
| C-122 | 非対応タスクで空StoredContext | E-07 (L104) | ○ |
| C-123 | stopTrackingで削除 | E-07 (L126-148) | ○ |
| C-124 | 停止時にリスナー呼出 | E-07 (L139-147) | ○ |
| C-125 | taskExecutionStartedOnThread | E-07 (L189-201) | ○ |
| C-126 | 存在しないタスクで何もしない | E-07 (L192-196) | ○ |
| C-127 | taskExecutionFinishedOnThread | E-07 (L210-221) | ○ |
| C-128 | setTaskResourceTrackingEnabled | E-07 (L82-84) | ○ |
| C-129 | getResourceAwareTasks | E-07 (L223-225) | ○ |
| C-130 | refreshResourceStats(有効時) | E-07 (L156-178) | ○ |
| C-131 | refreshResourceStats(無効時) | E-07 (L157-159) | ○ |
| C-132 | storeResultでインデックス自動作成 | E-08 (L109-154) | △ |
| C-133 | 既存インデックスへの直接保存 | E-08 (L141-153) | ○ |
| C-134 | マッピングバージョン更新 | E-08 (L142-153) | ○ |
| C-135 | ResourceAlreadyExistsException時の処理 | E-08 (L128-135) | ○ |
| C-136 | taskResultIndexMappingの読込 | E-08 (L208-221) | ○ |
| C-137 | マッピングファイル読込失敗 | E-08 (L213-219) | △ |
| C-138 | TaskCancellationStatsコンストラクタ | E-11 (L29-35) | ○ |
| C-139 | TaskCancellationStatsシリアライゼーション | E-11 (L37-44, L65-70) | ○ |
| C-140 | TaskCancellationStats.toXContent | E-11 (L57-62) | ○ |
| C-141 | equals/hashCode | E-11 (L73-84) | ○ |
| C-142 | onTaskCancelledで追跡対象タスクがトラッカーに追加 | E-12 (L138-144) | ○ |
| C-143 | 追跡対象外タスクでトラッカー変更なし | E-12 (L139-141) | ○ |
| C-144 | onTaskCompletedでトラッカーから削除 | E-12 (L125-130) | ○ |
| C-145 | 追跡対象外タスク完了でトラッカー変更なし | E-12 (L126-128) | ○ |
| C-146 | doRun無効時にスキップ | E-12 (L73-75) | ○ |
| C-147 | 空トラッカー時にスキップ | E-12 (L73-75) | ○ |
| C-148 | stats()で統計取得 | E-12 (L146-159) | △ |
| C-149 | TaskCancellationMonitoringSettingsデフォルト初期化 | E-13 (L64-72) | ○ |
| C-150 | setDurationMillis | E-13 (L82-84) | ○ |
| C-151 | setIsEnabled | E-13 (L90-92) | ○ |
| C-152 | BaseSearchTaskCancellationStatsコンストラクタ | E-14 (L28-31) | ○ |
| C-153 | BaseSearchTaskCancellationStatsシリアライゼーション | E-14 (L33-36, L55-58) | ○ |
| C-154 | toXContent出力 | E-14 (L47-52) | ○ |
| C-155 | equals/hashCode | E-14 (L61-72) | ○ |
| C-156 | transientsでTASK_ID伝播 | E-15 (L26-34) | ○ |
| C-157 | TASK_IDなしで空マップ | E-15 (L26-34) | ○ |
| C-158 | headersで空マップ | E-15 (L43-45) | ○ |
| C-159 | LoggingTaskListener.instanceシングルトン | E-16 (L52-54) | ○ |
| C-160 | onResponseで例外なし | E-16 (L61-63) | ○ |
| C-161 | onFailureで例外なし | E-16 (L65-68) | ○ |
| C-162 | TopNSearchTasksLogger.acceptでSearchShardTask記録 | E-17 (L75-79) | ○ |
| C-163 | 非SearchShardTaskで何もしない | E-17 (L76-79) | ○ |
| C-164 | キューサイズ未満で追加 | E-17 (L92-94) | ○ |
| C-165 | キューサイズ超過で最小置換 | E-17 (L88-94) | ○ |
| C-166 | 新タスクが最小以下でキュー不変 | E-17 (L88-94) | ○ |
| C-167 | SearchShardTaskDetailsLogMessageの生成 | E-18 (L24-26, L28-39) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-132: TaskResultsService.storeResultのインデックス自動作成テストは、Clientのモック化が必要。実際のCreateIndexRequestの挙動はインフラ依存のため、ユニットテストではモックで模擬する必要がある。
  - 候補：Client mock / ClusterService mock / ClusterState mock
- C-137: taskResultIndexMappingのファイル読込失敗テストは、リソースファイル(task-index-mapping.json)がクラスパスに存在しない状態を再現する必要がある。通常のテスト環境ではファイルが存在するため、テスト方法の検討が必要。
  - 候補：カスタムClassLoader / リフレクションでのモック
- C-148: stats()メソッドはSystem.nanoTime()に依存したフィルタリングロジックを含むため、時間経過のシミュレーションが必要。
  - 候補：TaskManager mock / CancellableTask mock with cancellationStartTimeNanos

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - getter/setter系テスト（C-002〜C-010）は単純なフィールドアクセスのため正確性が高い
- 0: 低リスク - equals/hashCode系テスト（C-054〜C-056, C-066, C-115, C-141, C-155）はソースコードから直接導出
- 1: 中リスク - リソーストラッキング系テスト（C-013〜C-033）はスレッド並行処理が絡むためテスト実装時に注意が必要
- 1: 中リスク - TaskManager系テスト（C-067〜C-096）は多数の依存関係（ThreadPool, ThreadContext等）のモック化が必要
- 2: 高リスク - TaskResultsService系テスト（C-132〜C-137）はOpenSearchクライアント・クラスタ状態のモック化が複雑

## 6) レビュアーチェックリスト（最小）
- [ ] Task.javaのリソーストラッキングメソッド（startThread/updateThread/stopThread）の入力値・期待結果がソースコードの例外条件と一致しているか確認
- [ ] TaskManager.registerのヘッダーサイズ制限のテストケース（C-069）が実際の計算ロジック（key.length()*2 + value.length()*2）と整合しているか確認
- [ ] CancellableTaskの二重キャンセル防止（C-038）がSetOnce.trySetの動作と一致しているか確認
- [ ] TaskInfo.fromXContent（C-053）のパーサー定義と入力フォーマットが最新バージョンと整合しているか確認
- [ ] TaskCancellationMonitoringService.stats()（C-148）の時間フィルタリングロジックのテスト方法が実現可能か確認
- [ ] TaskResultsService.storeResult（C-132〜C-135）の非同期処理フローが正しくテスト可能か確認
