---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 117
  claims_with_evidence: 115
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：server-telemetry 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：115 / 117、根拠なし：2
- 優先レビュー（高）
  1. **C-17 (UT-TEL-017)**: MetricsRegistryFactory.close()のIOException時のログ出力確認 -- ログ出力の検証方法は実装依存
  2. **C-24 (UT-TEL-024)**: TracerFactory.close()のIOException時のログ出力確認 -- ログ出力の検証方法は実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/telemetry/TelemetryModule.java`
- E-02: `server/src/main/java/org/opensearch/telemetry/TelemetrySettings.java`
- E-03: `server/src/main/java/org/opensearch/telemetry/metrics/MetricsRegistryFactory.java`
- E-04: `server/src/main/java/org/opensearch/telemetry/metrics/NoopMetricsRegistryFactory.java`
- E-05: `server/src/main/java/org/opensearch/telemetry/tracing/SpanBuilder.java`
- E-06: `server/src/main/java/org/opensearch/telemetry/tracing/ThreadContextBasedTracerContextStorage.java`
- E-07: `server/src/main/java/org/opensearch/telemetry/tracing/TracerFactory.java`
- E-08: `server/src/main/java/org/opensearch/telemetry/tracing/AttributeNames.java`
- E-09: `server/src/main/java/org/opensearch/telemetry/tracing/WrappedTracer.java`
- E-10: `server/src/main/java/org/opensearch/telemetry/tracing/NoopTracerFactory.java`
- E-11: `server/src/main/java/org/opensearch/telemetry/tracing/handler/TraceableTransportResponseHandler.java`
- E-12: `server/src/main/java/org/opensearch/telemetry/tracing/listener/TraceableSearchRequestOperationsListener.java`
- E-13: `server/src/main/java/org/opensearch/telemetry/tracing/listener/TraceableActionListener.java`
- E-14: `server/src/main/java/org/opensearch/telemetry/tracing/channels/TraceableRestChannel.java`
- E-15: `server/src/main/java/org/opensearch/telemetry/tracing/channels/TraceableHttpChannel.java`
- E-16: `server/src/main/java/org/opensearch/telemetry/tracing/channels/TraceableTcpTransportChannel.java`
- E-17: `server/src/main/java/org/opensearch/telemetry/tracing/channels/TraceableStreamingRestChannel.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TelemetryModule: テレメトリプラグインが1つ登録される | E-01 (L25-33, registerTelemetry L39-45) | ○ |
| C-02 | TelemetryModule: プラグインなしでOptional.empty | E-01 (L35-37, getTelemetry) | ○ |
| C-03 | TelemetryModule: Optional.empty返却プラグイン | E-01 (L28-31, isPresent判定) | ○ |
| C-04 | TelemetryModule: 2つ以上でIllegalArgumentException | E-01 (L42-43, "Cannot register more than one telemetry") | ○ |
| C-05 | TelemetryModule: getTelemetry正常 | E-01 (L35-37) | ○ |
| C-06 | TelemetrySettings: デフォルト設定初期化 | E-02 (L24-65, 各Settingのデフォルト値) | ○ |
| C-07 | TelemetrySettings: カスタム設定初期化 | E-02 (L72-80) | ○ |
| C-08 | TelemetrySettings: setTracingEnabled | E-02 (L82-84) | ○ |
| C-09 | TelemetrySettings: setSamplingProbability | E-02 (L94-96) | ○ |
| C-10 | TelemetrySettings: 確率0.0境界 | E-02 (L48-55, min=0.00d) | ○ |
| C-11 | TelemetrySettings: 確率1.0境界 | E-02 (L48-55, max=1.00d) | ○ |
| C-12 | TelemetrySettings: isTracingFeatureEnabled | E-02 (L106-108) | ○ |
| C-13 | TelemetrySettings: isMetricsFeatureEnabled | E-02 (L110-112) | ○ |
| C-14 | MetricsRegistryFactory: Telemetry存在時 | E-03 (L39-42, L65-69) | ○ |
| C-15 | MetricsRegistryFactory: Telemetry空時Noop | E-03 (L68, NoopMetricsRegistry.INSTANCE) | ○ |
| C-16 | MetricsRegistryFactory: close正常 | E-03 (L57-63) | ○ |
| C-17 | MetricsRegistryFactory: close時IOExceptionログ | E-03 (L60-61) | △ |
| C-18 | NoopMetricsRegistryFactory: コンストラクタ | E-04 (L23-25) | ○ |
| C-19 | NoopMetricsRegistryFactory: getMetricsRegistry | E-04 (L28-29) | ○ |
| C-20 | NoopMetricsRegistryFactory: close | E-04 (L32-35) | ○ |
| C-21 | TracerFactory: Telemetry存在時WrappedTracer | E-07 (L72-77, L79-86) | ○ |
| C-22 | TracerFactory: Telemetry空時NoopTracer | E-07 (L76, NoopTracer.INSTANCE) | ○ |
| C-23 | TracerFactory: close正常 | E-07 (L57-63) | ○ |
| C-24 | TracerFactory: close時IOExceptionログ | E-07 (L60-61) | △ |
| C-25 | NoopTracerFactory: コンストラクタ | E-10 (L23-25) | ○ |
| C-26 | NoopTracerFactory: getTracer | E-10 (L28-29) | ○ |
| C-27 | NoopTracerFactory: close | E-10 (L32-35) | ○ |
| C-28 | WrappedTracer: 有効時defaultTracer返却 | E-09 (L73-74) | ○ |
| C-29 | WrappedTracer: 無効時NoopTracer返却 | E-09 (L74) | ○ |
| C-30 | WrappedTracer: startSpan有効時委譲 | E-09 (L42-44) | ○ |
| C-31 | WrappedTracer: startSpan無効時Noop | E-09 (L42-44, L73-74) | ○ |
| C-32 | WrappedTracer: getCurrentSpan | E-09 (L47-50) | ○ |
| C-33 | WrappedTracer: startScopedSpan | E-09 (L53-55) | ○ |
| C-34 | WrappedTracer: withSpanInScope | E-09 (L58-60) | ○ |
| C-35 | WrappedTracer: isRecording | E-09 (L63-65) | ○ |
| C-36 | WrappedTracer: close | E-09 (L68-70) | ○ |
| C-37 | WrappedTracer: startSpan(headers)は常にdefaultTracer | E-09 (L78-80) | ○ |
| C-38 | SpanBuilder: from(HttpRequest)正常 | E-05 (L52-53, L79-83, L85-99) | ○ |
| C-39 | SpanBuilder: クエリパラメータなし | E-05 (L94, L101-109) | ○ |
| C-40 | SpanBuilder: traceヘッダー | E-05 (L90-91, L111-119) | ○ |
| C-41 | SpanBuilder: from(RestRequest)正常 | E-05 (L61-63, L121-133) | ○ |
| C-42 | SpanBuilder: RestRequest null | E-05 (L123, L136-149) | ○ |
| C-43 | SpanBuilder: RestRequest例外時デフォルト | E-05 (L128-130) | ○ |
| C-44 | SpanBuilder: from(action, Connection) | E-05 (L71-73, L152-161) | ○ |
| C-45 | SpanBuilder: Connection nullノード | E-05 (L153, L158) | ○ |
| C-46 | SpanBuilder: from(action, TcpChannel)正常 | E-05 (L170-172, L174-178) | ○ |
| C-47 | SpanBuilder: TcpChannel remoteAddress null | E-05 (L175-177) | ○ |
| C-48 | SpanBuilder: from(spanName, SpanContext) | E-05 (L206-208) | ○ |
| C-49 | SpanBuilder: from(Task, actionName)正常 | E-05 (L216-218, L220-238) | ○ |
| C-50 | SpanBuilder: Task null時actionName使用 | E-05 (L233-237) | ○ |
| C-51 | SpanBuilder: 親タスクID伝播 | E-05 (L224-226) | ○ |
| C-52 | SpanBuilder: ReplicatedWriteRequest正常 | E-05 (L75-77, L186-198) | ○ |
| C-53 | SpanBuilder: BulkShardRequest判定 | E-05 (L194-196) | ○ |
| C-54 | SpanBuilder: shardId null | E-05 (L191-193) | ○ |
| C-55 | ThreadContextBasedTracerContextStorage: 初期化 | E-06 (L32-36) | ○ |
| C-56 | ThreadContextBasedTracerContextStorage: threadContext null | E-06 (L33) | ○ |
| C-57 | ThreadContextBasedTracerContextStorage: tracingTelemetry null | E-06 (L34) | ○ |
| C-58 | ThreadContextBasedTracerContextStorage: get正常 | E-06 (L39-41, L95-98) | ○ |
| C-59 | ThreadContextBasedTracerContextStorage: get null | E-06 (L97) | ○ |
| C-60 | ThreadContextBasedTracerContextStorage: put新規 | E-06 (L44-51) | ○ |
| C-61 | ThreadContextBasedTracerContextStorage: put更新 | E-06 (L48-49) | ○ |
| C-62 | ThreadContextBasedTracerContextStorage: transients正常 | E-06 (L55-64) | ○ |
| C-63 | ThreadContextBasedTracerContextStorage: transients CURRENT_SPANなし | E-06 (L57) | ○ |
| C-64 | ThreadContextBasedTracerContextStorage: transients null SpanReference | E-06 (L59) | ○ |
| C-65 | ThreadContextBasedTracerContextStorage: transients systemContext true | E-06 (L67-73) | ○ |
| C-66 | ThreadContextBasedTracerContextStorage: transients systemContext false | E-06 (L70-71) | ○ |
| C-67 | ThreadContextBasedTracerContextStorage: headers inject | E-06 (L77-88) | ○ |
| C-68 | ThreadContextBasedTracerContextStorage: headers null span | E-06 (L82) | ○ |
| C-69 | ThreadContextBasedTracerContextStorage: headers CURRENT_SPANなし | E-06 (L80) | ○ |
| C-70 | TraceableTransportResponseHandler: create recording=true | E-11 (L53-63) | ○ |
| C-71 | TraceableTransportResponseHandler: create recording=false | E-11 (L58-62) | ○ |
| C-72 | TraceableTransportResponseHandler: handleResponse | E-11 (L71-77) | ○ |
| C-73 | TraceableTransportResponseHandler: handleException | E-11 (L89-96) | ○ |
| C-74 | TraceableTransportResponseHandler: handleRejection | E-11 (L109-116) | ○ |
| C-75 | TraceableTransportResponseHandler: handleStreamResponse | E-11 (L80-86) | ○ |
| C-76 | TraceableTransportResponseHandler: read | E-11 (L66-68) | ○ |
| C-77 | TraceableTransportResponseHandler: executor | E-11 (L99-101) | ○ |
| C-78 | TraceableTransportResponseHandler: toString | E-11 (L104-106) | ○ |
| C-79 | TraceableActionListener: create recording=true | E-13 (L48-54) | ○ |
| C-80 | TraceableActionListener: create recording=false | E-13 (L49-53) | ○ |
| C-81 | TraceableActionListener: onResponse | E-13 (L57-63) | ○ |
| C-82 | TraceableActionListener: onFailure | E-13 (L66-74) | ○ |
| C-83 | TraceableSearchRequestOperationsListener: create recording=true | E-12 (L35-41) | ○ |
| C-84 | TraceableSearchRequestOperationsListener: create recording=false | E-12 (L36-40) | ○ |
| C-85 | TraceableSearchRequestOperationsListener: onPhaseStart | E-12 (L44-47) | ○ |
| C-86 | TraceableSearchRequestOperationsListener: onPhaseEnd | E-12 (L50-54) | ○ |
| C-87 | TraceableSearchRequestOperationsListener: onPhaseFailure | E-12 (L57-62) | ○ |
| C-88 | TraceableSearchRequestOperationsListener: onRequestEnd totalHits | E-12 (L68-74) | ○ |
| C-89 | TraceableSearchRequestOperationsListener: onRequestEnd totalHits null | E-12 (L72) | ○ |
| C-90 | TraceableRestChannel: create recording=true non-streaming | E-14 (L55-64) | ○ |
| C-91 | TraceableRestChannel: create recording=true streaming | E-14 (L57-58) | ○ |
| C-92 | TraceableRestChannel: create recording=false | E-14 (L61-63) | ○ |
| C-93 | TraceableRestChannel: sendResponse | E-14 (L107-113) | ○ |
| C-94 | TraceableRestChannel: newBuilder委譲 | E-14 (L67-69) | ○ |
| C-95 | TraceableRestChannel: request委譲 | E-14 (L92-94) | ○ |
| C-96 | TraceableHttpChannel: create recording=true | E-15 (L51-57) | ○ |
| C-97 | TraceableHttpChannel: create recording=false | E-15 (L52-56) | ○ |
| C-98 | TraceableHttpChannel: sendResponse | E-15 (L82-84) | ○ |
| C-99 | TraceableHttpChannel: handleException | E-15 (L60-64) | ○ |
| C-100 | TraceableHttpChannel: close | E-15 (L67-69) | ○ |
| C-101 | TraceableHttpChannel: isOpen | E-15 (L77-79) | ○ |
| C-102 | TraceableTcpTransportChannel: create recording=true | E-16 (L54-74) | ○ |
| C-103 | TraceableTcpTransportChannel: create recording=false | E-16 (L55-73) | ○ |
| C-104 | TraceableTcpTransportChannel: sendResponse正常 | E-16 (L87-96) | ○ |
| C-105 | TraceableTcpTransportChannel: sendResponse IOException | E-16 (L90-93) | ○ |
| C-106 | TraceableTcpTransportChannel: sendResponse例外 | E-16 (L115-122) | ○ |
| C-107 | TraceableTcpTransportChannel: sendResponseBatch | E-16 (L98-104) | ○ |
| C-108 | TraceableTcpTransportChannel: completeStream | E-16 (L106-112) | ○ |
| C-109 | TraceableTcpTransportChannel: getProfileName | E-16 (L77-79) | ○ |
| C-110 | TraceableTcpTransportChannel: getVersion | E-16 (L125-127) | ○ |
| C-111 | TraceableStreamingRestChannel: sendChunk非最終 | E-17 (L49-59) | ○ |
| C-112 | TraceableStreamingRestChannel: sendChunk最終 | E-17 (L56-58) | ○ |
| C-113 | TraceableStreamingRestChannel: prepareResponse | E-17 (L62-67) | ○ |
| C-114 | TraceableStreamingRestChannel: isReadable | E-17 (L70-72) | ○ |
| C-115 | TraceableStreamingRestChannel: isWritable | E-17 (L75-77) | ○ |
| C-116 | TraceableStreamingRestChannel: subscribe | E-17 (L80-82) | ○ |
| C-117 | AttributeNames: 定数値確認 | E-08 (L31-117) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-17, C-24: ログ出力（logger.warn）の検証には、ログフレームワークのモック化またはログキャプチャが必要であり、テストの実装方法はプロジェクトのテスト基盤に依存する
  - 候補：Log4jのAppenderモック / LogManager.getLogger()のテスト用設定 / テスト用のログキャプチャユーティリティ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全テストケースはソースコードの直接的な解析に基づいており、ロジックの網羅性は高い
- 1: 中リスク -- SpanBuilder の各 from() メソッドは多数のモック依存があり、テスト実装時にモックの設定が複雑になる可能性がある
- 0: 低リスク -- Noop系クラス（NoopTracerFactory, NoopMetricsRegistryFactory）は単純な実装であり、テストケースも明確

## 6) レビュアーチェックリスト（最小）
- [ ] SpanBuilder の各 from() メソッドに対して、入力値のパターンが十分にカバーされているか確認
- [ ] WrappedTracer の startSpan(headers) が常に defaultTracer に委譲される仕様が意図的かどうか確認
- [ ] ThreadContextBasedTracerContextStorage の transients/headers メソッドのスレッドセーフティが考慮されているか確認
- [ ] TraceableSearchRequestOperationsListener の onPhaseFailure で Throwable を Exception にキャストする箇所のエラーハンドリングが適切か確認
- [ ] TraceableTcpTransportChannel の create メソッドでクローズリスナーの onResponse が onFailure(null) を呼ぶ設計が意図的か確認
