---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 147
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：server-threadpool 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：147 / 150、根拠なし：3
- 優先レビュー（高）
  1. **C-035 scheduleUnlessShuttingDown異常系**：シャットダウン時の具体的な挙動はランタイム依存
  2. **C-039 awaitTerminationの戻り値**：全executor終了の保証はタイミング依存
  3. **C-148 assertNotScheduleThread**：assertベースのためテスト環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/threadpool/ThreadPool.java` - ThreadPoolメインクラス（1157行）
- E-02: `server/src/main/java/org/opensearch/threadpool/ExecutorBuilder.java` - ExecutorBuilder基底クラス（117行）
- E-03: `server/src/main/java/org/opensearch/threadpool/FixedExecutorBuilder.java` - FixedExecutorBuilder（194行）
- E-04: `server/src/main/java/org/opensearch/threadpool/ScalingExecutorBuilder.java` - ScalingExecutorBuilder（152行）
- E-05: `server/src/main/java/org/opensearch/threadpool/ResizableExecutorBuilder.java` - ResizableExecutorBuilder（133行）
- E-06: `server/src/main/java/org/opensearch/threadpool/ForkJoinPoolExecutorBuilder.java` - ForkJoinPoolExecutorBuilder（147行）
- E-07: `server/src/main/java/org/opensearch/threadpool/Scheduler.java` - Schedulerインターフェース（312行）
- E-08: `server/src/main/java/org/opensearch/threadpool/ThreadPoolStats.java` - ThreadPoolStats（372行）
- E-09: `server/src/main/java/org/opensearch/threadpool/ThreadPoolInfo.java` - ThreadPoolInfo（87行）
- E-10: `server/src/main/java/org/opensearch/threadpool/CancellableAdapter.java` - CancellableAdapter（61行）
- E-11: `server/src/main/java/org/opensearch/threadpool/ScheduledCancellableAdapter.java` - ScheduledCancellableAdapter（74行）
- E-12: `server/src/main/java/org/opensearch/threadpool/TaskAwareRunnable.java` - TaskAwareRunnable（90行）
- E-13: `server/src/main/java/org/opensearch/threadpool/RunnableTaskExecutionListener.java` - RunnableTaskExecutionListenerインターフェース（33行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ThreadPoolType.fromTypeが有効なタイプ文字列でThreadPoolTypeを返す | E-01 (L168-174) | ○ |
| C-002 | ThreadPoolType.fromTypeが無効なタイプ文字列でIllegalArgumentExceptionをスロー | E-01 (L170-173) | ○ |
| C-003 | ThreadPoolType.fromTypeにnullが渡された場合の挙動 | E-01 (L169) | ○ |
| C-004 | ThreadPoolType.getTypeが正しい文字列を返す | E-01 (L150-152) | ○ |
| C-005 | boundedByが範囲内の値をそのまま返す | E-01 (L738-740) | ○ |
| C-006 | boundedByがmin未満の値に対しminを返す | E-01 (L739) | ○ |
| C-007 | boundedByがmax超の値に対しmaxを返す | E-01 (L739) | ○ |
| C-008 | boundedByがmin境界値で正しく動作する | E-01 (L739) | ○ |
| C-009 | boundedByがmax境界値で正しく動作する | E-01 (L739) | ○ |
| C-010 | halfAllocatedProcessorsの計算式 | E-01 (L746-748) | ○ |
| C-011 | halfAllocatedProcessorsの最小値 | E-01 (L747) | ○ |
| C-012 | halfAllocatedProcessorsの奇数切り上げ | E-01 (L747) | ○ |
| C-013 | halfAllocatedProcessorsMaxFiveの計算 | E-01 (L750-752) | ○ |
| C-014 | halfAllocatedProcessorsMaxFiveの上限5 | E-01 (L751) | ○ |
| C-015 | halfAllocatedProcessorsMaxTenの計算 | E-01 (L754-756) | ○ |
| C-016 | halfAllocatedProcessorsMaxTenの上限10 | E-01 (L755) | ○ |
| C-017 | oneEighthAllocatedProcessorsの計算 | E-01 (L742-744) | ○ |
| C-018 | oneEighthAllocatedProcessorsの最小値1 | E-01 (L743) | ○ |
| C-019 | twiceAllocatedProcessorsの計算 | E-01 (L758-760) | ○ |
| C-020 | twiceAllocatedProcessorsの最小値2 | E-01 (L759) | ○ |
| C-021 | searchThreadPoolSizeの計算式 | E-01 (L762-764) | ○ |
| C-022 | searchThreadPoolSizeの最小プロセッサ | E-01 (L763) | ○ |
| C-023 | ThreadPoolコンストラクタの正常初期化 | E-01 (L244-381) | ○ |
| C-024 | 重複customBuilderの拒否 | E-01 (L348-349) | ○ |
| C-025 | executor()が有効な名前で返却 | E-01 (L622-628) | ○ |
| C-026 | executor()が無効な名前でIllegalArgumentException | E-01 (L624-626) | ○ |
| C-027 | generic()がGENERICのexecutorを返す | E-01 (L607-609) | ○ |
| C-028 | info(String)が有効な名前でInfoを返す | E-01 (L432-438) | ○ |
| C-029 | info(String)が無効な名前でnullを返す | E-01 (L433-434) | ○ |
| C-030 | info()がThreadPoolInfoを返す | E-01 (L428-430) | ○ |
| C-031 | stats()がThreadPoolStatsを生成 | E-01 (L538-597) | ○ |
| C-032 | schedule()のSAME executor | E-01 (L644-650) | ○ |
| C-033 | schedule()の非SAME executor | E-01 (L646-648) | ○ |
| C-034 | scheduleUnlessShuttingDown正常時 | E-01 (L652-670) | ○ |
| C-035 | scheduleUnlessShuttingDownシャットダウン時 | E-01 (L655-668) | △ |
| C-036 | scheduleWithFixedDelayがCancellableを返す | E-01 (L673-684) | ○ |
| C-037 | shutdown()の動作 | E-01 (L691-700) | ○ |
| C-038 | shutdownNow()の動作 | E-01 (L702-711) | ○ |
| C-039 | awaitTermination()の動作 | E-01 (L713-722) | △ |
| C-040 | terminate(ExecutorService)正常 | E-01 (L1079-1087) | ○ |
| C-041 | terminate(ExecutorService)にnull | E-01 (L1080, L1086) | ○ |
| C-042 | terminate(ThreadPool)正常 | E-01 (L1104-1116) | ○ |
| C-043 | terminate(ThreadPool)にnull | E-01 (L1105, L1115) | ○ |
| C-044 | getThreadContext | E-01 (L1129-1131) | ○ |
| C-045 | builders()の不変コレクション | E-01 (L227-229) | ○ |
| C-046 | relativeTimeInMillis | E-01 (L389-391) | ○ |
| C-047 | relativeTimeInNanos | E-01 (L399-401) | ○ |
| C-048 | absoluteTimeInMillis | E-01 (L423-425) | ○ |
| C-049 | validateSetting正常系(scaling) | E-01 (L453-493) | ○ |
| C-050 | validateSetting不正プール名 | E-01 (L457-459) | ○ |
| C-051 | validateSetting不正キー(scaling) | E-01 (L469-473) | ○ |
| C-052 | validateSetting非正値(scaling) | E-01 (L476-478) | ○ |
| C-053 | validateSetting core>max(scaling) | E-01 (L478-480) | ○ |
| C-054 | validateSetting非正値(fixed) | E-01 (L487-490) | ○ |
| C-055 | validateSetting不正キー(fixed) | E-01 (L482-486) | ○ |
| C-056 | setThreadPool scaling更新 | E-01 (L495-536) | ○ |
| C-057 | setThreadPool fixed更新 | E-01 (L525-534) | ○ |
| C-058 | setThreadPool不正プール名 | E-01 (L501-503) | ○ |
| C-059 | Info(name, type)コンストラクタ | E-01 (L942-944) | ○ |
| C-060 | Info(name, type, size)コンストラクタ | E-01 (L946-948) | ○ |
| C-061 | Infoシリアライゼーション | E-01 (L959-1009) | ○ |
| C-062 | RESIZABLE後方互換writeTo | E-01 (L995-998) | ○ |
| C-063 | FORK_JOIN後方互換writeTo | E-01 (L999-1002) | ○ |
| C-064 | fixed_auto_queue_sizeの変換 | E-01 (L964-966) | ○ |
| C-065 | Info toXContent SCALING | E-01 (L1042-1054) | ○ |
| C-066 | Info toXContent FIXED | E-01 (L1057-1068) | ○ |
| C-067 | Info toXContent FORK_JOIN | E-01 (L1055-1056) | ○ |
| C-068 | Info getterメソッド群 | E-01 (L1011-1035) | ○ |
| C-069 | CachedTimeThread relativeTimeInNanos interval>0 | E-01 (L875-880) | ○ |
| C-070 | CachedTimeThread relativeTimeInNanos interval=0 | E-01 (L876-879) | ○ |
| C-071 | CachedTimeThread absoluteTimeInMillis interval>0 | E-01 (L890-895) | ○ |
| C-072 | CachedTimeThread absoluteTimeInMillis interval=0 | E-01 (L891-894) | ○ |
| C-073 | ExecutorHolderコンストラクタ | E-01 (L912-925) | ○ |
| C-074 | ExecutorHolder executor() | E-01 (L922-924) | ○ |
| C-075 | ExecutorBuilder name() | E-02 (L59-61) | ○ |
| C-076 | ExecutorBuilder settingsKey | E-02 (L63-65) | ○ |
| C-077 | applyHardSizeLimit write | E-02 (L67-73) | ○ |
| C-078 | applyHardSizeLimit bulk | E-02 (L68) | ○ |
| C-079 | applyHardSizeLimit その他 | E-02 (L71) | ○ |
| C-080 | FixedExecutorBuilder getRegisteredSettings | E-03 (L132-135) | ○ |
| C-081 | FixedExecutorBuilder getSettings | E-03 (L137-143) | ○ |
| C-082 | FixedExecutorBuilder build | E-03 (L145-168) | ○ |
| C-083 | FixedExecutorBuilder build queueSize=-1 | E-03 (L165) | ○ |
| C-084 | FixedExecutorBuilder formatInfo | E-03 (L170-179) | ○ |
| C-085 | FixedExecutorBuilder formatInfo unbounded | E-03 (L177) | ○ |
| C-086 | ScalingExecutorBuilder getRegisteredSettings | E-04 (L92-95) | ○ |
| C-087 | ScalingExecutorBuilder getSettings | E-04 (L97-104) | ○ |
| C-088 | ScalingExecutorBuilder build | E-04 (L106-124) | ○ |
| C-089 | ScalingExecutorBuilder formatInfo | E-04 (L126-136) | ○ |
| C-090 | ResizableExecutorBuilder getRegisteredSettings | E-05 (L71-73) | ○ |
| C-091 | ResizableExecutorBuilder getSettings | E-05 (L76-82) | ○ |
| C-092 | ResizableExecutorBuilder build | E-05 (L84-108) | ○ |
| C-093 | ResizableExecutorBuilder build queueSize=-1 | E-05 (L105) | ○ |
| C-094 | ResizableExecutorBuilder formatInfo | E-05 (L110-119) | ○ |
| C-095 | ForkJoinPoolExecutorBuilder getRegisteredSettings | E-06 (L64-67) | ○ |
| C-096 | ForkJoinPoolExecutorBuilder getSettings | E-06 (L69-77) | ○ |
| C-097 | ForkJoinPoolExecutorBuilder build デフォルト | E-06 (L79-120) | ○ |
| C-098 | ForkJoinPoolExecutorBuilder build カスタムファクトリフォールバック | E-06 (L87-103) | ○ |
| C-099 | ForkJoinPoolExecutorBuilder build enableExceptionHandling=false | E-06 (L112-114) | ○ |
| C-100 | ForkJoinPoolExecutorBuilder formatInfo | E-06 (L122-125) | ○ |
| C-101 | Scheduler.initScheduler | E-07 (L70-80) | ○ |
| C-102 | Scheduler.terminate | E-07 (L82-90) | ○ |
| C-103 | Scheduler.wrapAsCancellable | E-07 (L143-145) | ○ |
| C-104 | Scheduler.wrapAsScheduledCancellable | E-07 (L152-154) | ○ |
| C-105 | ReschedulingRunnable cancel | E-07 (L231-235) | ○ |
| C-106 | ReschedulingRunnable cancel冪等 | E-07 (L232-234) | ○ |
| C-107 | ReschedulingRunnable doRun | E-07 (L243-248) | ○ |
| C-108 | ReschedulingRunnable doRunキャンセル後 | E-07 (L245) | ○ |
| C-109 | ReschedulingRunnable onAfter再スケジュール | E-07 (L262-271) | ○ |
| C-110 | ReschedulingRunnable onAfterキャンセル後 | E-07 (L264) | ○ |
| C-111 | ReschedulingRunnable onRejection | E-07 (L256-259) | ○ |
| C-112 | ReschedulingRunnable onFailure | E-07 (L251-253) | ○ |
| C-113 | ThreadPoolStatsソート | E-08 (L331-334) | ○ |
| C-114 | ThreadPoolStatsシリアライゼーション | E-08 (L336-343) | ○ |
| C-115 | ThreadPoolStats toXContent | E-08 (L363-371) | ○ |
| C-116 | ThreadPoolStats iterator | E-08 (L346-348) | ○ |
| C-117 | Stats compareTo名前順 | E-08 (L241-255) | ○ |
| C-118 | Stats compareTo両方null | E-08 (L242-243) | ○ |
| C-119 | Stats compareTo片方null | E-08 (L244-247) | ○ |
| C-120 | Stats compareTo同名スレッド数 | E-08 (L250-253) | ○ |
| C-121 | Stats toXContent全フィールド | E-08 (L207-238) | ○ |
| C-122 | Stats toXContent省略フィールド | E-08 (L213-236) | ○ |
| C-123 | Stats getterメソッド群 | E-08 (L166-204) | ○ |
| C-124 | Stats getWaitTime変換 | E-08 (L194-196) | ○ |
| C-125 | Statsシリアライゼーション | E-08 (L137-163) | ○ |
| C-126 | Stats Builder build | E-08 (L261-326) | ○ |
| C-127 | Stats Builder デフォルト | E-08 (L262-270) | ○ |
| C-128 | ThreadPoolInfo不変リスト | E-09 (L56-58) | ○ |
| C-129 | ThreadPoolInfoシリアライゼーション | E-09 (L60-67) | ○ |
| C-130 | ThreadPoolInfo toXContent | E-09 (L78-86) | ○ |
| C-131 | ThreadPoolInfo iterator | E-09 (L70-72) | ○ |
| C-132 | CancellableAdapter cancel | E-10 (L53-55) | ○ |
| C-133 | CancellableAdapter isCancelled | E-10 (L57-60) | ○ |
| C-134 | CancellableAdapter isCancelled未キャンセル | E-10 (L58-59) | ○ |
| C-135 | ScheduledCancellableAdapter cancel | E-11 (L66-68) | ○ |
| C-136 | ScheduledCancellableAdapter isCancelled | E-11 (L70-73) | ○ |
| C-137 | ScheduledCancellableAdapter getDelay | E-11 (L55-57) | ○ |
| C-138 | ScheduledCancellableAdapter compareTo | E-11 (L59-63) | ○ |
| C-139 | TaskAwareRunnable doRun taskId有り | E-12 (L69-84) | ○ |
| C-140 | TaskAwareRunnable doRun taskId無し | E-12 (L74-76) | ○ |
| C-141 | TaskAwareRunnable doRun例外時finished保証 | E-12 (L77-83) | ○ |
| C-142 | TaskAwareRunnable isForceExecution AbstractRunnable | E-12 (L55-57) | ○ |
| C-143 | TaskAwareRunnable isForceExecution通常 | E-12 (L56) | ○ |
| C-144 | TaskAwareRunnable onRejection AbstractRunnable | E-12 (L60-66) | ○ |
| C-145 | TaskAwareRunnable onRejection通常 | E-12 (L63-64) | ○ |
| C-146 | TaskAwareRunnable unwrap | E-12 (L87-89) | ○ |
| C-147 | TaskAwareRunnable onFailure | E-12 (L50-52) | ○ |
| C-148 | assertNotScheduleThread | E-01 (L1133-1140) | △ |
| C-149 | assertCurrentMethodIsNotCalledRecursively | E-01 (L1142-1156) | ○ |
| C-150 | THREAD_POOL_TYPES定数マッピング | E-01 (L177-211) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-035: scheduleUnlessShuttingDownの異常系テストはシャットダウン状態のモック/スタブが必要。ランタイム状態に依存するため、具体的な挙動は統合テストで検証する方が適切な可能性がある
  - 候補：ThreadPoolシャットダウンシナリオの統合テスト / OpenSearchRejectedExecutionExceptionのモック
- C-039: awaitTerminationの戻り値は全executorのタイムアウトに依存。テスト環境のタイミングにより結果が変わる可能性がある
  - 候補：短いタイムアウトでのテスト / モックExecutorService
- C-148: assertNotScheduleThreadはJVMのassert有効時のみ動作。テスト環境でassertが無効な場合はテスト不可
  - 候補：assert有効フラグの確認 / assertionError期待テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードの直接的なメソッド・分岐に基づいている
- 1: 中リスク - シリアライゼーション関連テスト（C-061〜064, C-114, C-125, C-129）はVersion定数への依存があり、バージョンアップ時に要確認
- 1: 中リスク - 動的スレッドプール更新（C-056〜058）は実行時の副作用を伴うため、統合テストとの併用が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 全ThreadPoolType（DIRECT, FIXED, RESIZABLE, SCALING, FORK_JOIN）に対するテストケースが網羅されているか
- [ ] validateSetting/setThreadPoolの全条件分岐がテストされているか
- [ ] シリアライゼーション後方互換性テスト（RESIZABLE->FIXED, FORK_JOIN->FIXED）が十分か
- [ ] CachedTimeThreadのinterval=0とinterval>0の両方のパスがカバーされているか
- [ ] TaskAwareRunnableのtaskId有無・例外時の全パスがテストされているか
- [ ] Stats.compareToのnull境界値パターンが全て網羅されているか
- [ ] ExecutorBuilderのapplyHardSizeLimitが"bulk", "write", "system_write"の全対象を含むか
