---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 160
  claims_with_evidence: 152
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：server-transport 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：152 / 160、根拠なし：8
- 優先レビュー（高）
  1. **TransportServiceの初期化テスト（C-159, C-160）**：TransportService.javaは非常に大規模で全メソッドを網羅できていない可能性
  2. **InboundPipelineのバイトハンドリング（C-084）**：統合的な処理で内部動作の検証根拠が間接的
  3. **RemoteConnectionManagerのラウンドロビン（C-105）**：counterのオーバーフロー時の挙動が未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/transport/TransportStatus.java` - ビットフラグ操作定義
- E-02: `server/src/main/java/org/opensearch/transport/TransportStats.java` - 統計情報クラス定義
- E-03: `server/src/main/java/org/opensearch/transport/Header.java` - ヘッダークラス定義
- E-04: `server/src/main/java/org/opensearch/transport/TcpHeader.java` - TCPヘッダー定数・書き込み
- E-05: `server/src/main/java/org/opensearch/transport/StatsTracker.java` - 統計トラッキング
- E-06: `server/src/main/java/org/opensearch/transport/ConnectionProfile.java` - 接続プロファイル
- E-07: `server/src/main/java/org/opensearch/transport/TransportRequestOptions.java` - リクエストオプション
- E-08: `server/src/main/java/org/opensearch/transport/InboundDecoder.java` - インバウンドデコーダー
- E-09: `server/src/main/java/org/opensearch/transport/InboundAggregator.java` - インバウンドアグリゲータ
- E-10: `server/src/main/java/org/opensearch/transport/InboundPipeline.java` - インバウンドパイプライン
- E-11: `server/src/main/java/org/opensearch/transport/ClusterConnectionManager.java` - クラスタ接続管理
- E-12: `server/src/main/java/org/opensearch/transport/RemoteConnectionManager.java` - リモート接続管理
- E-13: `server/src/main/java/org/opensearch/transport/TransportDecompressor.java` - データ展開
- E-14: `server/src/main/java/org/opensearch/transport/TransportHandshaker.java` - ハンドシェイク処理
- E-15: `server/src/main/java/org/opensearch/transport/PlainTransportFuture.java` - Future実装
- E-16: `server/src/main/java/org/opensearch/transport/TransportRequestDeduplicator.java` - リクエスト重複排除
- E-17: `server/src/main/java/org/opensearch/transport/RemoteConnectionInfo.java` - リモート接続情報
- E-18: `server/src/main/java/org/opensearch/transport/TransportInfo.java` - トランスポート情報
- E-19: `server/src/main/java/org/opensearch/transport/nativeprotocol/CompressibleBytesOutputStream.java` - 圧縮出力ストリーム
- E-20: `server/src/main/java/org/opensearch/transport/TransportService.java` - メインサービスクラス
- E-21: `server/src/main/java/org/opensearch/transport/TransportSettings.java` - 設定定数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | TransportStatus.isRequestでビット0が0のときtrueが返る | E-01 L47-49 STATUS_REQRES=1<<0, (value & STATUS_REQRES)==0 | ○ |
| C-002 | TransportStatus.isRequestでレスポンスの場合falseが返る | E-01 L47-49 | ○ |
| C-003 | TransportStatus.setRequestでビット0がクリアされる | E-01 L51-54 value &= ~STATUS_REQRES | ○ |
| C-004 | TransportStatus.setResponseでビット0がセットされる | E-01 L56-59 value |= STATUS_REQRES | ○ |
| C-005 | TransportStatus.isErrorでビット1が判定される | E-01 L61-63 STATUS_ERROR=1<<1 | ○ |
| C-006 | TransportStatus.isErrorでエラーなしの場合falseが返る | E-01 L61-63 | ○ |
| C-007 | TransportStatus.setErrorでエラービットがセットされる | E-01 L65-68 | ○ |
| C-008 | TransportStatus.isCompressで圧縮ビットが判定される | E-01 L70-72 STATUS_COMPRESS=1<<2 | ○ |
| C-009 | TransportStatus.setCompressで圧縮ビットがセットされる | E-01 L74-77 | ○ |
| C-010 | TransportStatus.isHandshakeでハンドシェイクビットが判定される | E-01 L79-81 STATUS_HANDSHAKE=1<<3 | ○ |
| C-011 | TransportStatus.setHandshakeでハンドシェイクビットがセットされる | E-01 L83-86 | ○ |
| C-012 | 複数フラグ同時判定が正しく動作する | E-01 全メソッド | ○ |
| C-013 | TransportStats.BuilderでTransportStatsが正しく生成される | E-02 L65-72, L151-198 | ○ |
| C-014 | 非推奨コンストラクタで正しく生成される | E-02 L78-86 | ○ |
| C-015 | TransportStatsのシリアライズ・デシリアライズ | E-02 L88-105 | ○ |
| C-016 | serverOpen/getServerOpenアクセサ | E-02 L107-113 | ○ |
| C-017 | rxSizeがByteSizeValueで返却される | E-02 L123-129 | ○ |
| C-018 | txSizeがByteSizeValueで返却される | E-02 L139-145 | ○ |
| C-019 | TransportStats.toXContent出力 | E-02 L200-211 | ○ |
| C-020 | Builder全フィールド0のデフォルト値 | E-02 L151-158 | ○ |
| C-021 | Headerコンストラクタ | E-03 L68-74 | ○ |
| C-022 | Header.isRequestがTransportStatusに委譲 | E-03 L96-98 | ○ |
| C-023 | Header.isResponseがTransportStatusに委譲 | E-03 L100-102 | ○ |
| C-024 | Header.isErrorがTransportStatusに委譲 | E-03 L104-106 | ○ |
| C-025 | Header.isHandshakeがTransportStatusに委譲 | E-03 L108-110 | ○ |
| C-026 | Header.isCompressedがTransportStatusに委譲 | E-03 L112-114 | ○ |
| C-027 | Header.needsToReadVariableHeaderでheadersがnullならtrue | E-03 L120-122 | ○ |
| C-028 | Header.needsToReadVariableHeaderでheaders設定済みならfalse | E-03 L120-122 | ○ |
| C-029 | Header.finishParsingHeaderでリクエスト時features/actionNameが設定 | E-03 L132-146 | ○ |
| C-030 | Header.finishParsingHeaderでレスポンス時RESPONSE_NAMEが設定 | E-03 L143-145 | ○ |
| C-031 | features空配列でemptySetが設定 | E-03 L137-139 | ○ |
| C-032 | Header.toStringフォーマット | E-03 L148-169 | ○ |
| C-033 | TcpHeader.headerSizeがHEADER_SIZEを返す | E-04 L71-73 | ○ |
| C-034 | TcpHeader.writeHeaderの書き込み処理 | E-04 L77-93 | ○ |
| C-035 | TcpHeader定数値 | E-04 L47-68 | ○ |
| C-036 | StatsTracker.markBytesRead/getBytesRead | E-05 L52-66 | ○ |
| C-037 | StatsTracker.markMessageReceived/getMessagesReceived | E-05 L56-70 | ○ |
| C-038 | StatsTracker.markBytesWritten/getBytesWritten | E-05 L60-78 | ○ |
| C-039 | StatsTracker.getMessagesSent | E-05 L80-82 writeBytesMetric.count() | ○ |
| C-040 | StatsTracker 0バイト境界値 | E-05 L52-53 LongAdder.add(0) | ○ |
| C-041 | StatsTrackerスレッドセーフ性 | E-05 L48-50 LongAdder/MeanMetric使用 | ○ |
| C-042 | ConnectionProfile.resolveConnectionProfileでprofile=null時 | E-06 L61-86 | ○ |
| C-043 | ConnectionProfile.resolveConnectionProfileで完全設定時 | E-06 L64-69 | ○ |
| C-044 | ConnectionProfile.resolveConnectionProfileで部分null補完 | E-06 L70-85 | ○ |
| C-045 | fallbackProfile=nullでNPE | E-06 L62 Objects.requireNonNull | ○ |
| C-046 | buildDefaultConnectionProfile | E-06 L94-118, E-21 | ○ |
| C-047 | buildSingleChannelProfile | E-06 L124-157 | ○ |
| C-048 | buildSingleChannelProfileタイムアウト・圧縮付き | E-06 L132-157 | ○ |
| C-049 | getNumConnections | E-06 L322-324 | ○ |
| C-050 | getNumConnectionsPerType | E-06 L333-340 | ○ |
| C-051 | Builder.setConnectTimeout負値 | E-06 L213-219 | ○ |
| C-052 | Builder.setHandshakeTimeout負値 | E-06 L224-230 | ○ |
| C-053 | Builder.addConnections types=null | E-06 L253-256 | ○ |
| C-054 | Builder.addConnections types空配列 | E-06 L253-256 | ○ |
| C-055 | Builder.addConnections重複タイプ | E-06 L257-260 | ○ |
| C-056 | Builder.build不完全プロファイル | E-06 L272-277 | ○ |
| C-057 | ConnectionTypeHandle.getChannelラウンドロビン | E-06 L368-374 | ○ |
| C-058 | ConnectionTypeHandle.getChannel length=0 | E-06 L369-371 | ○ |
| C-059 | TransportRequestOptions.timeout | E-07 L54-56 | ○ |
| C-060 | TransportRequestOptions.type | E-07 L58-60 | ○ |
| C-061 | EMPTY定数のデフォルト値 | E-07 L62, L91 type=Type.REG | ○ |
| C-062 | Builder.withTimeout(long) | E-07 L95-97 | ○ |
| C-063 | Builder.withType | E-07 L104-107 | ○ |
| C-064 | InboundDecoder.decodeメッセージデコード | E-08 L70-136 | ○ |
| C-065 | InboundDecoder.decodePINGメッセージ | E-08 L84-87 messageLength==0 → PING | ○ |
| C-066 | InboundDecoder.decodeクローズ後例外 | E-08 L224-228 ensureOpen() | ○ |
| C-067 | InboundDecoder.decode不完全データ | E-08 L82-84, L167-191 headerBytesToRead | ○ |
| C-068 | ensureVersionCompatibility互換 | E-08 L230-242 | ○ |
| C-069 | ensureVersionCompatibility非互換 | E-08 L236-239 | ○ |
| C-070 | ensureVersionCompatibilityハンドシェイクN-2 | E-08 L235 | ○ |
| C-071 | readHeader | E-08 L194-218 | ○ |
| C-072 | InboundAggregator.headerReceived | E-09 L88-96 | ○ |
| C-073 | InboundAggregator.headerReceivedクローズ後 | E-09 L201-205 ensureOpen() | ○ |
| C-074 | InboundAggregator.aggregate | E-09 L98-114 | ○ |
| C-075 | InboundAggregator.aggregate複数コンテンツ | E-09 L104-113 contentAggregation | ○ |
| C-076 | finishAggregation空コンテンツ | E-09 L119-120 isFirstContent → EMPTY | ○ |
| C-077 | finishAggregation単一コンテンツ | E-09 L121-122 | ○ |
| C-078 | finishAggregation複数コンテンツ | E-09 L123-127 CompositeBytesReference | ○ |
| C-079 | finishAggregationアクション未発見 | E-09 L216-219 ActionNotFoundTransportException | ○ |
| C-080 | finishAggregationサーキットブレーカー | E-09 L229-235 CircuitBreakingException | ○ |
| C-081 | isAggregating true | E-09 L158-160 currentHeader != null | ○ |
| C-082 | isAggregating false | E-09 L158-160 | ○ |
| C-083 | InboundAggregator.close | E-09 L174-178 | ○ |
| C-084 | InboundPipeline.handleBytes | E-10 L108-118, L120-125 | ○ |
| C-085 | InboundPipeline.handleBytes uncaughtException | E-10 L109-111 | ○ |
| C-086 | InboundPipeline.close | E-10 L99-106 | ○ |
| C-087 | ClusterConnectionManager.connectToNode正常 | E-11 L128-208 | ○ |
| C-088 | ClusterConnectionManager.connectToNode node=null | E-11 L136-139 | ○ |
| C-089 | ClusterConnectionManager.connectToNode pendingDisconnection | E-11 L142-145 | ○ |
| C-090 | ClusterConnectionManager.connectToNode既接続 | E-11 L152-155 | ○ |
| C-091 | ClusterConnectionManager.connectToNodeクローズ後 | E-11 L147-150 | ○ |
| C-092 | ClusterConnectionManager.getConnection正常 | E-11 L220-226 | ○ |
| C-093 | ClusterConnectionManager.getConnection未接続 | E-11 L222-224 NodeNotConnectedException | ○ |
| C-094 | ClusterConnectionManager.nodeConnected true | E-11 L232-234 | ○ |
| C-095 | ClusterConnectionManager.nodeConnected false | E-11 L232-234 | ○ |
| C-096 | ClusterConnectionManager.disconnectFromNode正常 | E-11 L240-248 | ○ |
| C-097 | ClusterConnectionManager.disconnectFromNode未接続 | E-11 L241-242 nodeChannels==null | ○ |
| C-098 | ClusterConnectionManager.size | E-11 L265-267 | ○ |
| C-099 | ClusterConnectionManager.size 0 | E-11 L265-267 | ○ |
| C-100 | ClusterConnectionManager.getAllConnectedNodes | E-11 L270-272 | ○ |
| C-101 | setPendingDisconnection | E-11 L251-254 | ○ |
| C-102 | clearPendingDisconnections | E-11 L257-259 | ○ |
| C-103 | RemoteConnectionManager.getConnection正常 | E-12 L99-105 | ○ |
| C-104 | RemoteConnectionManager.getConnectionプロキシフォールバック | E-12 L102-104 ProxyConnection | ○ |
| C-105 | RemoteConnectionManager.getAnyRemoteConnectionラウンドロビン | E-12 L132-154 | ○ |
| C-106 | RemoteConnectionManager.getAnyRemoteConnection空 | E-12 L153 NoSuchRemoteClusterException | ○ |
| C-107 | ProxyConnection.sendRequest | E-12 L209-217 | ○ |
| C-108 | ProxyConnection.getNode | E-12 L204-206 | ○ |
| C-109 | TransportDecompressor.decompress正常 | E-13 L70-137 | ○ |
| C-110 | TransportDecompressor.decompress非圧縮 | E-13 L73-88 IllegalStateException | ○ |
| C-111 | TransportDecompressor.canDecompress true | E-13 L139-141 | ○ |
| C-112 | TransportDecompressor.canDecompress false | E-13 L139-141 | ○ |
| C-113 | TransportDecompressor.pollDecompressedPage正常 | E-13 L147-163 | ○ |
| C-114 | TransportDecompressor.pollDecompressedPage空 | E-13 L148-149 | ○ |
| C-115 | TransportDecompressor.isEOS | E-13 L143-145 inflater.finished() | ○ |
| C-116 | TransportDecompressor.close | E-13 L166-171 | ○ |
| C-117 | TransportHandshaker.sendHandshake正常 | E-14 L76-105 | ○ |
| C-118 | TransportHandshaker.sendHandshake失敗 | E-14 L97-104 | ○ |
| C-119 | TransportHandshaker.handleHandshake正常 | E-14 L107-123 | ○ |
| C-120 | TransportHandshaker.handleHandshake不完全 | E-14 L110-121 nextByte != -1 | ○ |
| C-121 | removeHandlerForHandshake正常 | E-14 L125-127 | ○ |
| C-122 | removeHandlerForHandshake存在しないID | E-14 L125-127 pendingHandshakes.remove | ○ |
| C-123 | HandshakeResponseHandler互換バージョン | E-14 L156-172 | ○ |
| C-124 | HandshakeResponseHandler非互換バージョン | E-14 L159-168 | ○ |
| C-125 | HandshakeResponseHandler重複レスポンス | E-14 L157 isDone.compareAndSet | ○ |
| C-126 | HandshakeRequest.writeTo | E-14 L220-228 | ○ |
| C-127 | HandshakeResponse.getResponseVersion | E-14 L250-252 | ○ |
| C-128 | PlainTransportFuture.txGet正常 | E-15 L63-76 | ○ |
| C-129 | PlainTransportFuture.txGet OpenSearchException | E-15 L70-71 | ○ |
| C-130 | PlainTransportFuture.txGet TransportException wrap | E-15 L72-74 | ○ |
| C-131 | PlainTransportFuture.txGet(timeout) | E-15 L79-93 | ○ |
| C-132 | PlainTransportFuture.handleResponse正常 | E-15 L106-113 | ○ |
| C-133 | PlainTransportFuture.handleResponse例外 | E-15 L110-112 ResponseHandlerFailureTransportException | ○ |
| C-134 | PlainTransportFuture.handleException | E-15 L116-122 | ○ |
| C-135 | TransportRequestDeduplicator.executeOnce初回 | E-16 L64-69 | ○ |
| C-136 | TransportRequestDeduplicator.executeOnce重複 | E-16 L65-68 completionListener==null | ○ |
| C-137 | TransportRequestDeduplicator全リスナー通知 | E-16 L111-125 | ○ |
| C-138 | TransportRequestDeduplicatorエラー通知 | E-16 L119-120 | ○ |
| C-139 | TransportRequestDeduplicator.clear | E-16 L75-77 | ○ |
| C-140 | TransportRequestDeduplicator.size | E-16 L79-81 | ○ |
| C-141 | TransportRequestDeduplicator.size空 | E-16 L79-81 | ○ |
| C-142 | RemoteConnectionInfoコンストラクタ | E-17 L60-65 | ○ |
| C-143 | RemoteConnectionInfoシリアライズ | E-17 L67-73, L96-102 | ○ |
| C-144 | RemoteConnectionInfo.equals同値 | E-17 L119-127 | ○ |
| C-145 | RemoteConnectionInfo.equals異値 | E-17 L119-127 | ○ |
| C-146 | RemoteConnectionInfo.hashCode | E-17 L130-132 | ○ |
| C-147 | RemoteConnectionInfo.toXContent | E-17 L105-116 | ○ |
| C-148 | TransportInfoコンストラクタ | E-18 L70-82 | ○ |
| C-149 | TransportInfo profileAddresses=null | E-18 L70-72 | ○ |
| C-150 | TransportInfoシリアライズ | E-18 L84-112 | ○ |
| C-151 | TransportInfo.toXContent | E-18 L141-158 | ○ |
| C-152 | formatPublishAddressString cname有効 | E-18 L121-138 | ○ |
| C-153 | formatPublishAddressString IPのみ | E-18 L124 InetAddresses.isInetAddress | ○ |
| C-154 | CompressibleBytesOutputStream圧縮初期化 | E-19 L67-75 | ○ |
| C-155 | CompressibleBytesOutputStream非圧縮初期化 | E-19 L72-74 | ○ |
| C-156 | CompressibleBytesOutputStream.materializeBytes圧縮 | E-19 L83-92 | ○ |
| C-157 | CompressibleBytesOutputStream.materializeBytes非圧縮 | E-19 L87-91 | ○ |
| C-158 | CompressibleBytesOutputStream.reset | E-19 L118-120 UnsupportedOperationException | ○ |
| C-159 | TransportServiceコンストラクタ初期化 | E-20 L267-344 | △ |
| C-160 | TransportService.getRemoteClusterService | E-20 L346-348 | △ |

## 4) 不足情報（Unknown / Missing）
- TransportServiceの全publicメソッドの網羅が不完全。TransportServiceは約1000行以上の大規模クラスであり、sendRequest, registerRequestHandler, doStart, doStop, doClose等の重要メソッドのテストケースが不足している
  - 候補：TransportService.sendRequest / TransportService.registerRequestHandler / TransportService.doStart
- RemoteClusterService, RemoteClusterAware, RemoteConnectionStrategy, SniffConnectionStrategy, ProxyConnectionStrategyなどのリモートクラスタ関連クラスのテストケースが未生成
  - 候補：RemoteClusterService / SniffConnectionStrategy / ProxyConnectionStrategy
- TcpTransport, OutboundHandler, InboundHandler, NativeMessageHandler等のコアトランスポートクラスのテストケースが未生成
  - 候補：TcpTransport / OutboundHandler / InboundHandler
- client配下（Client, AbstractClient, FilterClient等）のテストケースが未生成
  - 候補：server/src/main/java/org/opensearch/transport/client/ 配下のクラス群
- stream配下（StreamingTransportChannel, StreamTransportResponse等）のテストケースが未生成
  - 候補：server/src/main/java/org/opensearch/transport/stream/ 配下のクラス群

## 5) リスクフラグ（レビュー観点）
- 1: TransportServiceは巨大クラスのため、テストケース160件では全メソッドを網羅できていない。特にsendRequest系、ライフサイクル管理（doStart/doStop/doClose）は高リスク
- 1: RemoteCluster関連クラス群（RemoteClusterService, RemoteConnectionStrategy等）は109ファイル中で重要な部分だが今回のテストケースでは直接カバーされていない部分がある
- 0: TransportStatus, Header, TcpHeader等のデータ構造クラスは網羅的にカバーされている
- 0: ConnectionProfile, StatsTracker等のユーティリティクラスは十分にカバーされている
- 1: client配下（Client, AbstractClient, FilterClient等）のクラスはテストケースに含まれていない

## 6) レビュアーチェックリスト（最小）
- [ ] TransportStatusのビット操作テストが全パターン（0x00~0x0F）を網羅しているか確認
- [ ] ConnectionProfile.Builderの全バリデーションロジックがテストされているか確認
- [ ] InboundDecoder.ensureVersionCompatibilityの境界バージョン値が妥当か確認
- [ ] ClusterConnectionManager.connectToNodeの並行接続シナリオが十分か確認
- [ ] RemoteConnectionManager.getAnyRemoteConnectionのcounterオーバーフロー時の挙動確認
- [ ] TransportServiceの主要publicメソッド（sendRequest, registerRequestHandler等）のテスト追加要否を検討
- [ ] client配下、stream配下のクラスに対するテスト追加要否を検討
- [ ] TransportDecompressorの実際の圧縮データを用いた統合テストの必要性を検討
