---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：server-usage 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし：全テストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/usage/UsageService.java` - UsageServiceクラス本体（コンストラクタ、addRestHandler、getRestUsageStats）
- E-02: `server/src/main/java/org/opensearch/usage/package-info.java` - パッケージ説明
- E-03: `server/src/main/java/org/opensearch/rest/BaseRestHandler.java` - BaseRestHandlerクラス（getName、getUsageCount メソッド）
- E-04: UsageService.java 行80-101 - addRestHandlerメソッドのnullチェック、名前チェック、競合検出ロジック
- E-05: UsageService.java 行109-119 - getRestUsageStatsメソッドのフィルタリングロジック（usageCount > 0）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでhandlersマップが空で初期化される | E-01（行71-73: `this.handlers = new HashMap<>()`） | ○ |
| C-02 | 有効なハンドラが正常に登録される | E-04（行85: `handlers.put(handler.getName(), handler)`） | ○ |
| C-03 | 同一インスタンスを複数回登録しても例外が発生しない | E-04（行91: `maybeHandler != null && maybeHandler != handler` の条件により同一インスタンスは許容） | ○ |
| C-04 | 複数の異なるハンドラが正常に登録される | E-04（行85: HashMap.putにより異なるキーで複数登録可能） | ○ |
| C-05 | nullが渡された場合にNullPointerExceptionがスローされる | E-04（行81: `Objects.requireNonNull(handler)`） | ○ |
| C-06 | getName()がnullを返すハンドラでIllegalArgumentExceptionがスローされる | E-04（行82-84: `if (handler.getName() == null)` チェック） | ○ |
| C-07 | 同一名の異なるインスタンスでIllegalArgumentExceptionがスローされる | E-04（行91-100: `maybeHandler != null && maybeHandler != handler` で競合検出） | ○ |
| C-08 | ハンドラ未登録時に空のMapが返される | E-05（行112: handlersが空のため forEach が実行されず空Mapが返る） | ○ |
| C-09 | usageCount > 0のハンドラの統計が返される | E-05（行114: `if (usageCount > 0)` 条件でフィルタリング） | ○ |
| C-10 | usageCount = 0のハンドラは統計に含まれない | E-05（行114: `if (usageCount > 0)` により0は除外） | ○ |
| C-11 | 複数ハンドラの統計が正しく返される | E-05（行112-117: forEach で全ハンドラを走査） | ○ |
| C-12 | usageCount = 1のハンドラが統計に含まれる | E-05（行114: `usageCount > 0` により1は含まれる） | ○ |
| C-13 | ハンドラ1件のみで正しい統計が返される | E-05（行112-117: forEachは件数に依存しない） | ○ |
| C-14 | 返却されるMapが新しいインスタンスである | E-05（行111: `restUsageMap = new HashMap<>()` で毎回新規作成） | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はなし。全テストケースがソースコードの実装に直接基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モジュールが非常に小さく（1クラス、2メソッド）、全てのロジックパスがソースコードから直接確認可能
- 0: 低リスク - BaseRestHandlerは抽象クラスのためテスト時にモック/スタブが必要だが、テストケース設計自体には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] addRestHandlerのエラーメッセージフォーマット（Locale.ROOT使用）がテストケースで検証対象に含まれているか確認
- [ ] getRestUsageStatsの戻り値型（Map<String, Long>）が正しくテストケースに反映されているか確認
- [ ] BaseRestHandlerのモック/スタブ実装方針がテスト実装時に明確になっているか確認
- [ ] スレッドセーフティに関するテストケースの追加が必要かどうか検討（HashMapは非同期のため）
