---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 138
  claims_with_evidence: 135
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：server-wlm 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：135 / 138、根拠なし：3
- 優先レビュー（高）
  1. **C-049 getElapsedTime**: nanoTimeSupplierのモック方法はソースコードで確認可能だが、実際のテスト時のタイミング制御に依存
  2. **C-092 cancelTasks MONITOR_ONLY**: WLMモード別のキャンセル動作はソースコードで確認可能だが、ログ出力のみの検証が必要
  3. **C-138 SortBy null安全**: getComparatorのnull安全性はソースコードで確認可能だが、実際のnull入力パターンの網羅性に要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/wlm/WlmMode.java` - WLMモードの列挙型定義（fromName, getName）
- E-02: `server/src/main/java/org/opensearch/wlm/ResourceType.java` - リソースタイプの列挙型定義（fromName, getName, hasStatsEnabled, getSortedValues）
- E-03: `server/src/main/java/org/opensearch/wlm/MutableWorkloadGroupFragment.java` - ワークロードグループ設定（validateResourceLimits, ResiliencyMode, shouldParse, equals）
- E-04: `server/src/main/java/org/opensearch/wlm/WorkloadManagementSettings.java` - WLM設定管理（閾値設定・バリデーション）
- E-05: `server/src/main/java/org/opensearch/wlm/WorkloadGroupTask.java` - ワークロードグループタスク（setWorkloadGroupId, getWorkloadGroupId, getElapsedTime）
- E-06: `server/src/main/java/org/opensearch/wlm/WorkloadGroupsStateAccessor.java` - ステートアクセサ（addNewWorkloadGroup, removeWorkloadGroup, getWorkloadGroupState）
- E-07: `server/src/main/java/org/opensearch/wlm/WorkloadGroupLevelResourceUsageView.java` - リソース使用量ビュー
- E-08: `server/src/main/java/org/opensearch/wlm/WorkloadGroupService.java` - メインサービスクラス（doRun, rejectIfNeeded, clusterChanged, shouldSBPHandle, onTaskCompleted等）
- E-09: `server/src/main/java/org/opensearch/wlm/cancellation/MaximumResourceTaskSelectionStrategy.java` - タスク選択戦略
- E-10: `server/src/main/java/org/opensearch/wlm/cancellation/WorkloadGroupTaskCancellationService.java` - タスクキャンセルサービス
- E-11: `server/src/main/java/org/opensearch/wlm/cancellation/TaskSelectionStrategy.java` - タスク選択戦略インターフェース
- E-12: `server/src/main/java/org/opensearch/wlm/tracker/WorkloadGroupResourceUsageTrackerService.java` - リソース使用量追跡サービス
- E-13: `server/src/main/java/org/opensearch/wlm/tracker/CpuUsageCalculator.java` - CPU使用量計算
- E-14: `server/src/main/java/org/opensearch/wlm/tracker/MemoryUsageCalculator.java` - メモリ使用量計算
- E-15: `server/src/main/java/org/opensearch/wlm/tracker/ResourceUsageCalculator.java` - リソース使用量計算基底クラス
- E-16: `server/src/main/java/org/opensearch/wlm/WorkloadManagementTransportInterceptor.java` - トランスポートインターセプタ
- E-17: `server/src/main/java/org/opensearch/wlm/WorkloadGroupThreadContextStatePropagator.java` - スレッドコンテキスト伝播
- E-18: `server/src/main/java/org/opensearch/wlm/listeners/WorkloadGroupRequestOperationListener.java` - リクエストリスナー
- E-19: `server/src/main/java/org/opensearch/wlm/stats/WorkloadGroupStats.java` - ワークロードグループ統計
- E-20: `server/src/main/java/org/opensearch/wlm/stats/WorkloadGroupState.java` - ワークロードグループ状態
- E-21: `server/src/main/java/org/opensearch/wlm/stats/WlmStats.java` - WLM統計
- E-22: `server/src/main/java/org/opensearch/wlm/stats/SortOrder.java` - ソート順
- E-23: `server/src/main/java/org/opensearch/wlm/stats/SortBy.java` - ソートフィールド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | WlmMode.fromNameで"enabled"を渡すとENABLEDが返る | E-01 (L32-38) | ○ |
| C-002 | WlmMode.fromNameで"monitor_only"を渡すとMONITOR_ONLYが返る | E-01 (L19, L32-38) | ○ |
| C-003 | WlmMode.fromNameで"disabled"を渡すとDISABLEDが返る | E-01 (L20, L32-38) | ○ |
| C-004 | WlmMode.fromNameで不正な名前を渡すとIllegalArgumentException | E-01 (L38) | ○ |
| C-005 | WlmMode.getNameで"enabled"が返る | E-01 (L28-29) | ○ |
| C-006 | ResourceType.fromNameで"cpu"を渡すとCPUが返る | E-02 (L54-61) | ○ |
| C-007 | ResourceType.fromNameで"memory"を渡すとMEMORYが返る | E-02 (L54-61) | ○ |
| C-008 | ResourceType.fromNameで不正名を渡すとIllegalArgumentException | E-02 (L60) | ○ |
| C-009 | ResourceType.fromNameは大文字小文字を区別する | E-02 (L56: equals使用) | ○ |
| C-010 | ResourceType.getNameで"cpu"が返る | E-02 (L68) | ○ |
| C-011 | ResourceType.hasStatsEnabledでtrueが返る | E-02 (L28-29: true設定) | ○ |
| C-012 | ResourceType.getSortedValuesで[CPU, MEMORY]が返る | E-02 (L35) | ○ |
| C-013 | validateResourceLimitsで有効値が成功 | E-03 (L150-163) | ○ |
| C-014 | validateResourceLimitsでnull入力が成功 | E-03 (L151-153) | ○ |
| C-015 | validateResourceLimitsで0以下の値がエラー | E-03 (L159) | ○ |
| C-016 | validateResourceLimitsで1.0超過の値がエラー | E-03 (L159) | ○ |
| C-017 | validateResourceLimitsで1.0が成功 | E-03 (L159: <= 0 || > 1.0) | ○ |
| C-018 | validateResourceLimitsで負の値がエラー | E-03 (L159) | ○ |
| C-019 | ResiliencyMode.fromNameで"soft"がSOFTを返す | E-03 (L208-213) | ○ |
| C-020 | ResiliencyMode.fromNameで"enforced"がENFORCEDを返す | E-03 (L208-213) | ○ |
| C-021 | ResiliencyMode.fromNameで"monitor"がMONITORを返す | E-03 (L208-213) | ○ |
| C-022 | ResiliencyMode.fromNameは大文字小文字を区別しない | E-03 (L210: equalsIgnoreCase) | ○ |
| C-023 | ResiliencyMode.fromNameで不正名がIllegalArgumentException | E-03 (L213) | ○ |
| C-024 | MutableWorkloadGroupFragment.equalsで同一内容がtrue | E-03 (L166-171) | ○ |
| C-025 | MutableWorkloadGroupFragment.equalsで異なる内容がfalse | E-03 (L166-171) | ○ |
| C-026 | shouldParseで"resiliency_mode"がtrue | E-03 (L84-91, L116-118) | ○ |
| C-027 | shouldParseで"resource_limits"がtrue | E-03 (L84-91, L116-118) | ○ |
| C-028 | shouldParseで未知フィールドがfalse | E-03 (L90) | ○ |
| C-029 | WorkloadManagementSettingsがデフォルト値で初期化される | E-04 (L22-31, L144-173) | ○ |
| C-030 | メモリキャンセル閾値の正常設定 | E-04 (L236-251) | ○ |
| C-031 | メモリキャンセル閾値0.95超過でエラー | E-04 (L237-240) | ○ |
| C-032 | メモリキャンセル閾値0.95が成功 | E-04 (L237: >比較) | ○ |
| C-033 | キャンセル閾値がリジェクション未満でエラー | E-04 (L351-362) | ○ |
| C-034 | メモリリジェクション閾値の正常設定 | E-04 (L296-311) | ○ |
| C-035 | メモリリジェクション閾値0.90超過でエラー | E-04 (L297-300) | ○ |
| C-036 | リジェクションがキャンセル超過でエラー | E-04 (L351-362) | ○ |
| C-037 | CPUキャンセル閾値の正常設定 | E-04 (L266-281) | ○ |
| C-038 | CPUキャンセル閾値0.95超過でエラー | E-04 (L267-270) | ○ |
| C-039 | CPUリジェクション閾値の正常設定 | E-04 (L326-341) | ○ |
| C-040 | CPUリジェクション閾値0.90超過でエラー | E-04 (L327-330) | ○ |
| C-041 | デフォルトWLMモードがMONITOR_ONLY | E-04 (L31, L145) | ○ |
| C-042 | setWorkloadGroupIdでthreadContextからID設定 | E-05 (L84-91) | ○ |
| C-043 | ヘッダーなしthreadContextでデフォルトID | E-05 (L86-90) | ○ |
| C-044 | null threadContextでデフォルトID | E-05 (L86-90) | ○ |
| C-045 | getWorkloadGroupIdが設定値を返す | E-05 (L72-77) | ○ |
| C-046 | 未設定時にgetWorkloadGroupIdがnullを返す | E-05 (L72-77) | ○ |
| C-047 | isWorkloadGroupSetがsetWorkloadGroupId後にtrue | E-05 (L85, L97-99) | ○ |
| C-048 | isWorkloadGroupSetの初期値がfalse | E-05 (L36) | ○ |
| C-049 | getElapsedTimeがnanoTimeSupplier - startTimeNanosを返す | E-05 (L93-95) | △ |
| C-050 | shouldCancelChildrenOnCancellationがfalseを返す | E-05 (L102-104) | ○ |
| C-051 | addNewWorkloadGroupで新グループ追加 | E-06 (L56-57) | ○ |
| C-052 | addNewWorkloadGroupで既存グループは上書きされない | E-06 (L57: putIfAbsent) | ○ |
| C-053 | removeWorkloadGroupでグループ削除 | E-06 (L64-65) | ○ |
| C-054 | 存在しないグループ削除でエラーなし | E-06 (L65: Map.remove) | ○ |
| C-055 | getWorkloadGroupStateで存在グループ取得 | E-06 (L45-49) | ○ |
| C-056 | getWorkloadGroupStateで未存在IDがデフォルト返却 | E-06 (L46-49: getOrDefault) | ○ |
| C-057 | getResourceUsageDataがマップを返す | E-07 (L35-37) | ○ |
| C-058 | getActiveTasksがリストを返す | E-07 (L43-46) | ○ |
| C-059 | getActiveTasksが空リストを返す | E-07 (L43-46) | ○ |
| C-060 | doRunでDISABLED時にキャンセル不実行 | E-08 (L126-128) | ○ |
| C-061 | doRunでENABLED時にキャンセル実行 | E-08 (L126-131) | ○ |
| C-062 | incrementFailuresForで失敗カウント増加 | E-08 (L195-203) | ○ |
| C-063 | incrementFailuresForでnull stateスキップ | E-08 (L199-201) | ○ |
| C-064 | nodeStatsで_all指定時に全グループ取得 | E-08 (L208-229) | ○ |
| C-065 | nodeStatsで特定ID指定時にそのグループのみ | E-08 (L208-229) | ○ |
| C-066 | nodeStatsで存在しないIDがResourceNotFoundException | E-08 (L213-216) | ○ |
| C-067 | rejectIfNeededで非ENABLEDモードはリジェクトなし | E-08 (L256-258) | ○ |
| C-068 | rejectIfNeededでnull IDはリジェクトなし | E-08 (L260) | ○ |
| C-069 | rejectIfNeededでデフォルトIDはリジェクトなし | E-08 (L260) | ○ |
| C-070 | rejectIfNeededでリソース超過時にリジェクション | E-08 (L278-312) | ○ |
| C-071 | rejectIfNeededでSOFTモード非duress時はリジェクトなし | E-08 (L274-276) | ○ |
| C-072 | rejectIfNeededでSOFTモードduress時はリジェクション | E-08 (L274-276, L278-312) | ○ |
| C-073 | clusterChangedで新グループ追加 | E-08 (L158-175) | ○ |
| C-074 | clusterChangedで削除グループ処理 | E-08 (L177-187) | ○ |
| C-075 | shouldSBPHandleで非ENABLEDがtrue | E-08 (L337-345) | ○ |
| C-076 | shouldSBPHandleで有効グループ設定済みがfalse | E-08 (L337-345) | ○ |
| C-077 | shouldSBPHandleで無効グループIDがtrue | E-08 (L340-343) | ○ |
| C-078 | onTaskCompletedでcompletionカウント増加 | E-08 (L348-363) | ○ |
| C-079 | onTaskCompletedで非WorkloadGroupTaskスキップ | E-08 (L349-351) | ○ |
| C-080 | onTaskCompletedで存在しないグループはデフォルトカウント | E-08 (L354-362) | ○ |
| C-081 | resourceLimitBreachedで超過時true | E-08 (L234-250) | ○ |
| C-082 | resourceLimitBreachedで非超過時false | E-08 (L234-250) | ○ |
| C-083 | resourceLimitBreachedで存在しないグループがResourceNotFoundException | E-08 (L236-238) | ○ |
| C-084 | selectTasksForCancellationでリソース高順選択 | E-09 (L36-38, L50-70) | ○ |
| C-085 | selectTasksForCancellationで負limitがIllegalArgumentException | E-09 (L51-53) | ○ |
| C-086 | selectTasksForCancellationでlimit < MIN_VALUEが空リスト | E-09 (L54-56) | ○ |
| C-087 | selectTasksForCancellationで空タスクリストが空リスト | E-09 (L58-69) | ○ |
| C-088 | selectTasksForCancellationで累積停止 | E-09 (L62-68) | ○ |
| C-089 | cancelTasksでENFORCEDモードキャンセル | E-10 (L80-92) | ○ |
| C-090 | cancelTasksでduress時削除済みグループキャンセル | E-10 (L119-139) | ○ |
| C-091 | cancelTasksでduress時SOFTモードキャンセル | E-10 (L119-139) | ○ |
| C-092 | cancelTasksでMONITOR_ONLYはログのみ | E-10 (L216-233) | △ |
| C-093 | pruneDeletedWorkloadGroupsでタスクなしグループ除去 | E-10 (L274-281) | ○ |
| C-094 | pruneDeletedWorkloadGroupsでタスクありグループ残留 | E-10 (L274-281) | ○ |
| C-095 | getAllCancellableTasksでResiliencyMode別取得 | E-10 (L150-156) | ○ |
| C-096 | getAllCancellableTasksで超過なし空リスト | E-10 (L163-194) | ○ |
| C-097 | constructWorkloadGroupLevelUsageViewsでビュー構築 | E-12 (L44-66) | ○ |
| C-098 | constructWorkloadGroupLevelUsageViewsでタスクなし空マップ | E-12 (L44-66) | ○ |
| C-099 | CpuUsageCalculator.calculateResourceUsageで合計/プロセッサ数 | E-13 (L27-31) | ○ |
| C-100 | CpuUsageCalculator.calculateResourceUsageで空リスト0 | E-13 (L28) | ○ |
| C-101 | CpuUsageCalculator.calculateTaskResourceUsageで個別計算 | E-13 (L35-37) | ○ |
| C-102 | MemoryUsageCalculator.calculateResourceUsageで合計 | E-14 (L27-29) | ○ |
| C-103 | MemoryUsageCalculator.calculateResourceUsageで空リスト0 | E-14 (L28) | ○ |
| C-104 | MemoryUsageCalculator.calculateTaskResourceUsageで個別計算 | E-14 (L32-34) | ○ |
| C-105 | interceptHandlerでRequestHandlerが返る | E-16 (L31-38) | ○ |
| C-106 | messageReceivedでWorkloadGroupTask時にID設定とリジェクト | E-16 (L57-63) | ○ |
| C-107 | messageReceivedで通常Task時は通常ハンドラのみ | E-16 (L57-63) | ○ |
| C-108 | isSearchWorkloadRequestでWorkloadGroupTaskがtrue | E-16 (L66-68) | ○ |
| C-109 | isSearchWorkloadRequestで通常Taskがfalse | E-16 (L66-68) | ○ |
| C-110 | transientsでworkloadGroupId伝播 | E-17 (L30-37) | ○ |
| C-111 | transientsで未設定時null | E-17 (L34) | ○ |
| C-112 | headersでworkloadGroupId伝播 | E-17 (L45-52) | ○ |
| C-113 | onRequestStartでrejectIfNeeded呼出 | E-18 (L36-39) | ○ |
| C-114 | onRequestFailureでincrementFailuresFor呼出 | E-18 (L42-45) | ○ |
| C-115 | WorkloadGroupState初期化でCPU/MEMORYのResourceTypeState作成 | E-20 (L46-53) | ○ |
| C-116 | getTotalCompletionsの初期値0 | E-20 (L24, L59-61) | ○ |
| C-117 | getTotalCompletionsがインクリメント後に正しい値 | E-20 (L24, L59-61) | ○ |
| C-118 | setLastRecordedUsageで使用量設定 | E-20 (L104-106) | ○ |
| C-119 | getLastRecordedUsageの初期値0.0 | E-20 (L98) | ○ |
| C-120 | WorkloadGroupStatsHolder.fromでState変換 | E-19 (L150-165) | ○ |
| C-121 | WorkloadGroupStats.toXContentでシリアライズ | E-19 (L57-70) | ○ |
| C-122 | WorkloadGroupStats.equalsで同一内容true | E-19 (L73-78) | ○ |
| C-123 | ResourceStats.fromでResourceTypeState変換 | E-19 (L263-269) | ○ |
| C-124 | ResourceStats.equalsで同一内容true | E-19 (L297-302) | ○ |
| C-125 | WlmStats初期化 | E-21 (L28-31) | ○ |
| C-126 | WlmStats.equalsで同一内容true | E-21 (L50-55) | ○ |
| C-127 | WlmStats.toXContentでシリアライズ | E-21 (L45-47) | ○ |
| C-128 | SortOrder.fromStringで"asc"がASC | E-22 (L34-40) | ○ |
| C-129 | SortOrder.fromStringで"desc"がDESC | E-22 (L34-40) | ○ |
| C-130 | SortOrder.fromStringで不正入力がIllegalArgumentException | E-22 (L37-38) | ○ |
| C-131 | SortOrder.ASC.applyで同一コンパレータ | E-22 (L20-23) | ○ |
| C-132 | SortOrder.DESC.applyでreversedコンパレータ | E-22 (L25-29) | ○ |
| C-133 | SortBy.fromStringで"workload_group"がWORKLOAD_GROUP | E-23 (L57-63) | ○ |
| C-134 | SortBy.fromStringで"node_id"がNODE_ID | E-23 (L57-63) | ○ |
| C-135 | SortBy.fromStringで不正入力がIllegalArgumentException | E-23 (L60-61) | ○ |
| C-136 | SortBy.WORKLOAD_GROUPコンパレータがワークロードグループ名順 | E-23 (L19-34) | ○ |
| C-137 | SortBy.NODE_IDコンパレータがノードID順 | E-23 (L36-53) | ○ |
| C-138 | SortBy.WORKLOAD_GROUPコンパレータがnull安全 | E-23 (L22-27) | △ |

## 4) 不足情報（Unknown / Missing）
- C-049 (getElapsedTime): テストケースとして成立するが、nanoTimeSupplierのモック実装とstartTimeNanosの設定方法は、CancellableTaskの親クラスに依存するため、実際のテスト実装時に確認が必要
  - 候補：CancellableTask / Task の親クラス実装
- C-092 (MONITOR_ONLYモード動作): ソースコード上はWlmMode.ENABLEDでない場合にcancelメソッドを呼ばない実装だが、ログ出力の検証方法はテストフレームワークに依存
  - 候補：LogManagerのモック / ログアサーション方法
- C-138 (SortBy null安全): ソースコード上null/emptyチェックは実装されているが、全てのnullパターン（node==null, stats==null等）の網羅性は要確認
  - 候補：SortByの各getComparator実装の網羅テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - WlmMode, ResourceType, SortOrder, SortByの列挙型テスト（ソースコード直接対応）
- 0: 低リスク - MutableWorkloadGroupFragment, WorkloadGroupLevelResourceUsageView のバリデーション/ゲッターテスト
- 0: 低リスク - WorkloadGroupState, WorkloadGroupStats のデータクラステスト
- 1: 中リスク - WorkloadGroupService のrejectIfNeeded, shouldSBPHandle等のビジネスロジックテスト（複数条件の組み合わせ）
- 1: 中リスク - WorkloadGroupTaskCancellationService のキャンセルロジックテスト（ResiliencyMode, WlmMode, NodeDuressの組み合わせ）
- 0: 低リスク - CpuUsageCalculator, MemoryUsageCalculator の計算ロジックテスト

## 6) レビュアーチェックリスト（最小）
- [ ] WorkloadGroupService.rejectIfNeededの全条件分岐（ENABLED/SOFTモード/ENFORCEDモード/デフォルトID/null ID）が網羅されているか
- [ ] WorkloadGroupTaskCancellationServiceのキャンセル動作が各モード（ENABLED/MONITOR_ONLY/DISABLED）で正しくテストされているか
- [ ] WorkloadManagementSettingsの閾値バリデーション（rejection < cancellation制約）が全パターンカバーされているか
- [ ] MaximumResourceTaskSelectionStrategyの境界値テスト（limit=0, limit<0, 空リスト）が十分か
- [ ] MutableWorkloadGroupFragmentのvalidateResourceLimitsの境界値（0.0, 1.0, 負値）が全てカバーされているか
