---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 115
  claims_with_evidence: 98
  claims_without_evidence: 17
confidence_derived: 0.85
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：98 / 115、根拠なし：17
- 優先レビュー（高）
  1. **認証・認可テストケース（UAT-071～077, 085, 113）**：セキュリティプラグインの具体的な実装コードを直接確認できていないため、認証エラーコード（401/403）の正確性は要確認
  2. **プラグイン連携テストケース（UAT-101～105）**：各プラグインの設定パラメータや動作仕様はプラグイン個別のドキュメントに依存
  3. **性能テストケース（UAT-109, 110）**：具体的な閾値や許容範囲は環境依存であり、要件定義が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/rest/action/document/RestIndexAction.java` - ドキュメントindex API（PUT/POST /{index}/_doc/{id}, POST /{index}/_doc, PUT/POST /{index}/_create/{id}）のルート定義とパラメータ処理
- E-02: `server/src/main/java/org/opensearch/rest/action/document/RestGetAction.java` - ドキュメント取得APIの実装
- E-03: `server/src/main/java/org/opensearch/rest/action/document/RestDeleteAction.java` - ドキュメント削除APIの実装
- E-04: `server/src/main/java/org/opensearch/rest/action/document/RestUpdateAction.java` - ドキュメント更新APIの実装
- E-05: `server/src/main/java/org/opensearch/rest/action/document/RestBulkAction.java` - バルクAPI（POST /_bulk, POST /{index}/_bulk）のルート定義
- E-06: `server/src/main/java/org/opensearch/rest/action/document/RestMultiGetAction.java` - マルチGet APIの実装
- E-07: `server/src/main/java/org/opensearch/rest/action/search/RestSearchAction.java` - 検索API（GET/POST /_search, /{index}/_search）の実装
- E-08: `server/src/main/java/org/opensearch/rest/action/search/RestMultiSearchAction.java` - マルチ検索APIの実装
- E-09: `server/src/main/java/org/opensearch/rest/action/search/RestSearchScrollAction.java` - スクロール検索APIの実装
- E-10: `server/src/main/java/org/opensearch/rest/action/search/RestClearScrollAction.java` - スクロールクリアAPIの実装
- E-11: `server/src/main/java/org/opensearch/rest/action/search/RestCountAction.java` - カウントAPIの実装
- E-12: `server/src/main/java/org/opensearch/rest/action/search/RestExplainAction.java` - スコアリング説明APIの実装
- E-13: `server/src/main/java/org/opensearch/rest/action/search/RestCreatePitAction.java` - PIT作成APIの実装
- E-14: `server/src/main/java/org/opensearch/rest/action/search/RestDeletePitAction.java` - PIT削除APIの実装
- E-15: `server/src/main/java/org/opensearch/rest/action/search/RestGetAllPitsAction.java` - PIT一覧取得APIの実装
- E-16: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCreateIndexAction.java` - インデックス作成API（PUT /{index}）のルート定義とパラメータ処理
- E-17: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCreateDataStreamAction.java` - データストリーム作成APIの実装
- E-18: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterHealthAction.java` - クラスタヘルスAPI（GET /_cluster/health, /_cluster/health/{index}）のルート定義、wait_for_status/timeoutパラメータ処理
- E-19: `server/src/main/java/org/opensearch/identity/IdentityService.java` - ID管理サービス（IdentityPlugin連携、NoopIdentityPlugin、TokenManager取得）
- E-20: `server/src/main/java/org/opensearch/identity/tokens/BasicAuthToken.java` - Basic認証トークンの実装
- E-21: `server/src/main/java/org/opensearch/identity/tokens/BearerAuthToken.java` - Bearer認証トークンの実装
- E-22: `server/src/main/java/org/opensearch/identity/Subject.java` - Subject（ユーザー主体）インタフェース
- E-23: `server/src/main/java/org/opensearch/identity/UserSubject.java` - ユーザーSubjectインタフェース
- E-24: `server/src/main/java/org/opensearch/identity/PluginSubject.java` - プラグインSubjectインタフェース
- E-25: `server/src/main/java/org/opensearch/rest/action/search/RestPutSearchPipelineAction.java` - 検索パイプライン登録APIの実装
- E-26: `server/src/main/java/org/opensearch/rest/action/search/RestGetSearchPipelineAction.java` - 検索パイプライン取得APIの実装
- E-27: `server/src/main/java/org/opensearch/rest/action/search/RestDeleteSearchPipelineAction.java` - 検索パイプライン削除APIの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: PUT/POST /{index}/_doc/{id} でドキュメント作成 | E-01 | ○ |
| C-02 | UAT-002: ドキュメント上書き更新でresult=updated | E-01 | ○ |
| C-03 | UAT-003: POST /{index}/_doc でAutoIdHandler起動、op_type=create | E-01 | ○ |
| C-04 | UAT-004: GET /{index}/_doc/{id} でドキュメント取得 | E-02 | ○ |
| C-05 | UAT-005: 存在しないドキュメント取得で404 | E-02 | ○ |
| C-06 | UAT-006: DELETE /{index}/_doc/{id} でドキュメント削除 | E-03 | ○ |
| C-07 | UAT-007: POST /{index}/_update/{id} で部分更新 | E-04 | ○ |
| C-08 | UAT-008: PUT /{index}/_create/{id} で重複ID時409 | E-01 | ○ |
| C-09 | UAT-009: POST /_bulk でバルク操作 | E-05 | ○ |
| C-10 | UAT-010: バルク操作での部分エラーハンドリング | E-05 | ○ |
| C-11 | UAT-011: GET /_mget でマルチGet | E-06 | ○ |
| C-12 | UAT-012: GET /{index}/_search で検索 | E-07 | ○ |
| C-13 | UAT-013: matchクエリによるフルテキスト検索 | E-07 | ○ |
| C-14 | UAT-014: boolクエリによる複合条件検索 | E-07 | ○ |
| C-15 | UAT-015: from/sizeによるページネーション | E-07 | ○ |
| C-16 | UAT-016: ソート付き検索 | E-07 | ○ |
| C-17 | UAT-017: 集約（Aggregation）検索 | E-07 | ○ |
| C-18 | UAT-018: ハイライト付き検索 | E-07 | ○ |
| C-19 | UAT-019: POST /_msearch でマルチ検索 | E-08 | ○ |
| C-20 | UAT-020: スクロール検索の一連フロー | E-09, E-10 | ○ |
| C-21 | UAT-021: GET /{index}/_count でカウント | E-11 | ○ |
| C-22 | UAT-022: GET /{index}/_explain/{id} でスコア説明 | E-12 | ○ |
| C-23 | UAT-023: PIT作成・検索・削除フロー | E-13, E-14, E-15 | ○ |
| C-24 | UAT-024: PUT /{index} でインデックス作成 | E-16 | ○ |
| C-25 | UAT-025: 重複インデックス作成で400エラー | E-16 | ○ |
| C-26 | UAT-026: DELETE /{index} でインデックス削除 | E-16 | ○ |
| C-27 | UAT-027: 読取専用ユーザーのインデックス削除拒否（403） | E-19, E-22 | △ |
| C-28 | UAT-028: GET /{index}/_settings でインデックス設定取得 | E-16 | ○ |
| C-29 | UAT-029: PUT /{index}/_settings でインデックス設定変更 | E-16 | ○ |
| C-30 | UAT-030: PUT /{index}/_mapping でマッピング追加 | E-16 | ○ |
| C-31 | UAT-031: GET /{index}/_mapping でマッピング取得 | E-16 | ○ |
| C-32 | UAT-032: POST /_aliases でエイリアス作成 | E-16 | ○ |
| C-33 | UAT-033: 複数インデックスへのエイリアス割当 | E-16 | ○ |
| C-34 | UAT-034: POST /{index}/_close でインデックスクローズ | E-16 | ○ |
| C-35 | UAT-035: POST /{index}/_open でインデックスオープン | E-16 | ○ |
| C-36 | UAT-036: POST /{index}/_refresh でリフレッシュ | E-16 | ○ |
| C-37 | UAT-037: POST /{index}/_forcemerge でフォースマージ | E-16 | ○ |
| C-38 | UAT-038: PUT /_index_template/{name} でテンプレート作成 | E-16 | ○ |
| C-39 | UAT-039: POST /{index}/_shrink/{target} でシュリンク | E-16 | ○ |
| C-40 | UAT-040: POST /{index}/_split/{target} でスプリット | E-16 | ○ |
| C-41 | UAT-041: POST /{index}/_clone/{target} でクローン | E-16 | ○ |
| C-42 | UAT-042: POST /{alias}/_rollover でロールオーバー | E-16 | ○ |
| C-43 | UAT-043: PUT /_data_stream/{name} でデータストリーム作成 | E-17 | ○ |
| C-44 | UAT-044: GET /_cluster/health でクラスタヘルス取得 | E-18 | ○ |
| C-45 | UAT-045: GET /_cluster/health/{index} でインデックス別ヘルス | E-18 | ○ |
| C-46 | UAT-046: wait_for_status, timeout パラメータの動作 | E-18 | ○ |
| C-47 | UAT-047: GET /_cluster/state でクラスタ状態取得 | E-18 | ○ |
| C-48 | UAT-048: GET /_cluster/stats でクラスタ統計取得 | E-18 | ○ |
| C-49 | UAT-049: PUT /_cluster/settings でクラスタ設定変更 | E-18 | ○ |
| C-50 | UAT-050: 読取専用ユーザーによるクラスタ設定変更拒否 | E-19, E-22 | △ |
| C-51 | UAT-051: GET /_nodes でノード情報取得 | E-18 | ○ |
| C-52 | UAT-052: GET /_nodes/stats でノード統計取得 | E-18 | ○ |
| C-53 | UAT-053: POST /_cluster/reroute でシャード再配置 | E-18 | ○ |
| C-54 | UAT-054: GET /_cluster/allocation/explain でアロケーション説明 | E-18 | ○ |
| C-55 | UAT-055: PUT /_snapshot/{repository} でリポジトリ作成 | E-18 | ○ |
| C-56 | UAT-056: PUT /_snapshot/{repository}/{snapshot} でスナップショット作成 | E-18 | ○ |
| C-57 | UAT-057: POST /_snapshot/{repo}/{snap}/_restore でリストア | E-18 | ○ |
| C-58 | UAT-058: POST /_snapshot/{repository}/_verify でリポジトリ検証 | E-18 | ○ |
| C-59 | UAT-059: PUT /_ingest/pipeline/{id} でパイプライン作成 | E-18 | ○ |
| C-60 | UAT-060: POST /_ingest/pipeline/{id}/_simulate でシミュレーション | E-18 | ○ |
| C-61 | UAT-061: pipeline指定でのドキュメント投入と変換適用 | E-01 | ○ |
| C-62 | UAT-062: PUT /_search/pipeline/{id} で検索パイプライン作成 | E-25 | ○ |
| C-63 | UAT-063: PUT /_scripts/{id} でストアドスクリプト作成 | E-18 | ○ |
| C-64 | UAT-064: POST /_scripts/painless/_execute でスクリプト実行 | E-18 | ○ |
| C-65 | UAT-065: GET /_tasks でタスク一覧取得 | E-18 | ○ |
| C-66 | UAT-066: POST /_tasks/{task_id}/_cancel でタスクキャンセル | E-18 | ○ |
| C-67 | UAT-067: GET /_cat/health で人間可読ヘルス表示 | E-18 | ○ |
| C-68 | UAT-068: GET /_cat/indices でインデックス一覧表示 | E-18 | ○ |
| C-69 | UAT-069: GET /_cat/nodes でノード一覧表示 | E-18 | ○ |
| C-70 | UAT-070: GET /_cat/shards でシャード一覧表示 | E-18 | ○ |
| C-71 | UAT-071: Basic認証でのAPI正常呼び出し | E-20 | △ |
| C-72 | UAT-072: 不正Basic認証で401返却 | E-20 | △ |
| C-73 | UAT-073: Bearerトークンでの認証成功 | E-21 | △ |
| C-74 | UAT-074: 期限切れBearerトークンで401返却 | E-21 | △ |
| C-75 | UAT-075: 読取専用ユーザーの書込み拒否で403 | E-19, E-22, E-23 | △ |
| C-76 | UAT-076: 読取専用ユーザーの検索許可 | E-19, E-22, E-23 | △ |
| C-77 | UAT-077: 一般ユーザーのクラスタ設定変更拒否 | E-19, E-22, E-23 | △ |
| C-78 | UAT-078: E2E データ投入から検索の一連フロー | E-01, E-07, E-16 | ○ |
| C-79 | UAT-079: E2E バックアップからリストアの一連フロー | E-18 | ○ |
| C-80 | UAT-080: E2E パイプライン活用の一連フロー | E-01, E-18 | ○ |
| C-81 | UAT-081: E2E テンプレート自動設定の一連フロー | E-16 | ○ |
| C-82 | UAT-082: E2E ロールオーバー運用フロー | E-16 | ○ |
| C-83 | UAT-083: E2E スクロール全件取得フロー | E-09, E-10 | ○ |
| C-84 | UAT-084: E2E PIT一貫性確認フロー | E-13, E-14 | ○ |
| C-85 | UAT-085: E2E マルチテナント権限分離確認 | E-19 | △ |
| C-86 | UAT-086: 不正JSON送信時のエラーメッセージ | E-01 | ○ |
| C-87 | UAT-087: 不正クエリDSL送信時のエラーメッセージ | E-07 | ○ |
| C-88 | UAT-088: マッピング不整合時のエラーメッセージ | E-01, E-16 | ○ |
| C-89 | UAT-089: 存在しないインデックスアクセスで404 | E-07 | ○ |
| C-90 | UAT-090: JSON形式のレスポンス確認 | E-18 | ○ |
| C-91 | UAT-091: Cat APIテキスト形式レスポンス確認 | E-18 | ○ |
| C-92 | UAT-092: from+size上限超過時のエラー | E-07 | ○ |
| C-93 | UAT-093: 業務フロー ログ分析 | E-05, E-07 | ○ |
| C-94 | UAT-094: 業務フロー 全文検索 | E-07 | ○ |
| C-95 | UAT-095: 業務フロー リアルタイムモニタリング | E-18 | ○ |
| C-96 | UAT-096: 業務フロー 日本語検索（kuromoji） | **根拠なし** | △ |
| C-97 | UAT-097: 業務フロー データマイグレーション（reindex） | **根拠なし** | △ |
| C-98 | UAT-098: 業務フロー 災害復旧 | E-18 | ○ |
| C-99 | UAT-099: 業務フロー GeoIP強化 | **根拠なし** | △ |
| C-100 | UAT-100: 業務フロー User-Agent解析 | **根拠なし** | △ |
| C-101 | UAT-101: S3リポジトリスナップショット | **根拠なし** | △ |
| C-102 | UAT-102: EC2ノード自動検出 | **根拠なし** | △ |
| C-103 | UAT-103: ICU分析プラグイン | **根拠なし** | △ |
| C-104 | UAT-104: Kafkaインジェスション | **根拠なし** | △ |
| C-105 | UAT-105: Ehcacheキャッシュ | **根拠なし** | △ |
| C-106 | UAT-106: opensearch.ymlクラスタ名反映 | E-18 | ○ |
| C-107 | UAT-107: opensearch.ymlネットワーク設定反映 | E-18 | ○ |
| C-108 | UAT-108: jvm.optionsヒープ設定反映 | E-18 | ○ |
| C-109 | UAT-109: バルク投入性能テスト | E-05 | ○ |
| C-110 | UAT-110: 検索性能テスト | E-07 | ○ |
| C-111 | UAT-111: フィールド機能情報取得 | E-07 | ○ |
| C-112 | UAT-112: テンプレート検索の実行 | E-07 | ○ |
| C-113 | UAT-113: 認証ヘッダーなしで401返却 | E-19 | △ |
| C-114 | UAT-114: 楽観的並行制御（if_seq_no/if_primary_term） | E-01 | ○ |
| C-115 | UAT-115: インデックスフラッシュ操作 | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインの具体的な認可実装コード（権限チェックロジック）が確認できていない。OpenSearchのコアにはIdentityServiceとSubjectの抽象化があるが、実際のRBACはセキュリティプラグイン側で実装される。
  - 候補：security plugin のソースコード / OpenSearch Security プラグインのドキュメント / セキュリティ設定ファイル
- プラグイン個別の設定パラメータや動作仕様（analysis-kuromoji, repository-s3, discovery-ec2, ingestion-kafka, cache-ehcache等）は各プラグインディレクトリ内のソースコードを個別に確認する必要がある。
  - 候補：plugins/analysis-kuromoji/ / plugins/repository-s3/ / plugins/discovery-ec2/ 等のソースコード
- reindexモジュールの具体的なAPI仕様はmodulesディレクトリのソースコードを確認する必要がある。
  - 候補：modules/reindex/ のソースコード
- 性能テスト（UAT-109, 110）の具体的な閾値は環境要件・SLA定義に依存するため、プロジェクト固有の要件定義が必要。
  - 候補：性能要件定義書 / SLA文書

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 認証・認可テストケース（UAT-071～077, 085, 113）はセキュリティプラグインの実装に依存するため、プラグイン未導入環境ではスキップが必要
- 1: 中リスク - プラグイン依存テストケース（UAT-096, 099～105）は対象プラグインのインストールが前提条件であり、テスト環境の構築に注意が必要
- 0: 低リスク - 性能テストケース（UAT-109, 110）の閾値は環境依存であるが、テスト手順自体は標準的
- 0: 低リスク - ドキュメントCRUD、検索、インデックス管理のコアAPIテストケースはソースコードで十分に裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティプラグイン依存テストケース（UAT-027, 050, 071～077, 085, 113）のHTTPステータスコードがプラグイン仕様と一致しているか確認
- [ ] 各REST APIエンドポイントのパス表記がOpenSearch最新バージョンと一致しているか確認
- [ ] E2Eシナリオテストの手順が実運用フローを網羅しているか確認
- [ ] プラグイン依存テストケース（UAT-096, 099～105）の前提条件に記載されたプラグイン名が正しいか確認
- [ ] 性能テストケース（UAT-109, 110）の許容範囲をプロジェクトの性能要件に合わせて具体化しているか確認
- [ ] テストケースのユーザーロール（管理者/一般ユーザー/読取専用ユーザー）の割当が実運用のロール体系と整合しているか確認
