---
generated_at: 2026-02-03 00:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全件根拠あり）

**注記**: 本プロジェクト（OpenSearch）は検索エンジン基盤であり、一般的な業務アプリケーションにおける帳票（PDF帳票・Excel帳票等）は存在しません。帳票に相当する出力として、Cat APIによるテキストテーブル出力、ビルドレポート、テストエラーレポートを抽出しています。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestHealthAction.java` - getName()が "cat_health_action"、routes()が GET /_cat/health
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestNodesAction.java` - getName()が "cat_nodes_action"、routes()が GET /_cat/nodes
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java` - getName()が "cat_indices_action"、routes()が GET /_cat/indices
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` - getName()が "cat_shards_action"、routes()が GET /_cat/shards
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestAllocationAction.java` - getName()が "cat_allocation_action"、routes()が GET /_cat/allocation
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestThreadPoolAction.java` - getName()が "cat_threadpool_action"、routes()が GET /_cat/thread_pool
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestSegmentsAction.java` - getName()が "cat_segments_action"、routes()が GET /_cat/segments
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestCatRecoveryAction.java` - getName()が "cat_recovery_action"、routes()が GET /_cat/recovery
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/RestCountAction.java` - getName()が "cat_count_action"、routes()が GET /_cat/count
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestAliasAction.java` - getName()が "cat_alias_action"、routes()が GET /_cat/aliases
- E-11: `server/src/main/java/org/opensearch/rest/action/cat/RestFielddataAction.java` - getName()が "cat_fielddata_action"、routes()が GET /_cat/fielddata
- E-12: `server/src/main/java/org/opensearch/rest/action/cat/RestPluginsAction.java` - getName()が "cat_plugins_action"、routes()が GET /_cat/plugins
- E-13: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` - getName()が "cat_templates_action"、routes()が GET /_cat/templates
- E-14: `server/src/main/java/org/opensearch/rest/action/cat/RestNodeAttrsAction.java` - getName()が "cat_node_attrs_action"、routes()が GET /_cat/nodeattrs
- E-15: `server/src/main/java/org/opensearch/rest/action/cat/RestRepositoriesAction.java` - getName()が "cat_repositories_action"、routes()が GET /_cat/repositories
- E-16: `server/src/main/java/org/opensearch/rest/action/cat/RestSnapshotAction.java` - getName()が "cat_snapshot_action"、routes()が GET /_cat/snapshots
- E-17: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` - getName()が "cat_tasks_action"、routes()が GET /_cat/tasks
- E-18: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` - getName()が "cat_pending_cluster_tasks_action"、routes()が GET /_cat/pending_tasks
- E-19: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java` - getName()が "cat_cluster_manager_action"、routes()が GET /_cat/cluster_manager
- E-20: `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` - getName()が "cat_segment_replication_action"
- E-21: `server/src/main/java/org/opensearch/rest/action/cat/RestPitSegmentsAction.java` - getName()が "cat_pit_segments_action"
- E-22: `build.gradle` - testAggregateTestReport(AggregateTestReport)の定義（720行目付近）
- E-23: `gradle/code-coverage.gradle` - jacocoTestReportタスクの定義（37-40行目付近）
- E-24: `buildSrc/src/main/java/org/opensearch/gradle/test/ErrorReportingTestListener.java` - テストエラーレポート出力クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Health Report: クラスタのヘルス状態をテキストテーブル形式で出力 | E-01 | ○ |
| C-02 | Nodes Report: クラスタ内の各ノード情報をテキストテーブル形式で出力 | E-02 | ○ |
| C-03 | Indices Report: インデックスの一覧と統計情報をテキストテーブル形式で出力 | E-03 | ○ |
| C-04 | Shards Report: シャードの配置情報をテキストテーブル形式で出力 | E-04 | ○ |
| C-05 | Allocation Report: ノードごとのディスク使用量とシャード割り当て状況を出力 | E-05 | ○ |
| C-06 | Thread Pool Report: 各ノードのスレッドプール状態を出力 | E-06 | ○ |
| C-07 | Segments Report: インデックスのLuceneセグメント情報を出力 | E-07 | ○ |
| C-08 | Recovery Report: シャードのリカバリ進捗情報を出力 | E-08 | ○ |
| C-09 | Count Report: ドキュメント数を出力 | E-09 | ○ |
| C-10 | Aliases Report: インデックスエイリアスの一覧を出力 | E-10 | ○ |
| C-11 | Fielddata Report: ノードごとのフィールドデータ使用量を出力 | E-11 | ○ |
| C-12 | Plugins Report: 各ノードにインストールされたプラグイン情報を出力 | E-12 | ○ |
| C-13 | Templates Report: インデックステンプレートの一覧を出力 | E-13 | ○ |
| C-14 | Node Attributes Report: 各ノードのカスタム属性情報を出力 | E-14 | ○ |
| C-15 | Repositories Report: スナップショットリポジトリの一覧情報を出力 | E-15 | ○ |
| C-16 | Snapshots Report: スナップショットの一覧と状態情報を出力 | E-16 | ○ |
| C-17 | Tasks Report: クラスタで実行中のタスク情報を出力 | E-17 | ○ |
| C-18 | Pending Cluster Tasks Report: 保留中のクラスタタスク情報を出力 | E-18 | ○ |
| C-19 | Cluster Manager Report: 現在のクラスタマネージャノード情報を出力 | E-19 | ○ |
| C-20 | Segment Replication Report: セグメントレプリケーションの進捗状況を出力 | E-20 | ○ |
| C-21 | PIT Segments Report: Point-in-Timeに関連するセグメント情報を出力 | E-21 | ○ |
| C-22 | テスト集約レポート: Gradleビルドで生成されるテスト結果の集約レポート | E-22 | ○ |
| C-23 | JaCoCoカバレッジレポート: コードカバレッジレポート | E-23 | ○ |
| C-24 | テストエラーレポート: テスト実行時の失敗詳細をファイル出力 | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての主張について、ソースコードまたはビルド設定ファイルに根拠が確認されました。
- ただし、本プロジェクトはインフラ基盤（検索エンジン）であり、一般的なビジネスアプリケーションの帳票（PDF/Excel/印刷帳票等）は存在しません。Cat APIのテキストテーブル出力を帳票に相当するものとして抽出しています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Cat API各アクションはソースコードのクラス定義・ルート定義・getName()メソッドから直接確認可能
- 0: 低リスク - ビルドレポート（テスト集約・JaCoCo）はbuild.gradleおよびgradle設定ファイルから直接確認可能
- 1: 中リスク - 帳票の定義範囲について、本プロジェクトが検索エンジン基盤であるため「帳票」の概念をCat API等に拡大解釈している点はレビュアー判断が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Cat API（No.1-21）の各エンドポイントが実際のソースコードと一致しているか確認
- [ ] ビルドレポート（No.22-23）のGradle設定が最新のbuild.gradleと一致しているか確認
- [ ] 本プロジェクトにおける「帳票」の定義範囲（Cat API + ビルドレポート + テストエラーレポート）が妥当か判断
- [ ] プラグインやモジュールで追加される帳票的な出力が漏れていないか確認
