# 帳票設計書 23-JaCoCoカバレッジレポート

## 概要

本ドキュメントは、OpenSearch プロジェクトの Gradle ビルドシステムで生成される JaCoCo コードカバレッジレポートの設計仕様を定義する。テスト実行時のコードカバレッジ（行カバレッジ・分岐カバレッジ等）を測定し、XML/HTML/CSV 形式で出力する帳票である。

### 本帳票の処理概要

JaCoCo カバレッジレポートは、OpenSearch の各サブプロジェクトにおけるテスト実行時のコードカバレッジを測定・レポートする帳票である。

**業務上の目的・背景**：ソフトウェアの品質保証においてコードカバレッジはテストの網羅性を定量的に評価する重要な指標である。OpenSearch プロジェクトでは JaCoCo（Java Code Coverage）ライブラリを使用してテスト実行時のカバレッジデータを収集し、レポートとして可視化する。これにより、テストが不足している領域の特定、品質基準の達成状況の確認、リファクタリング時のテスト網羅性の維持が可能となる。

**帳票の利用シーン**：プルリクエストのコードレビューにおけるカバレッジ確認、品質ゲートとしてのカバレッジ閾値チェック、テスト拡充の優先順位決定、CI/CD パイプラインでの品質メトリクス収集時に利用される。

**主要な出力内容**：
1. パッケージ別のカバレッジサマリー（行カバレッジ率、分岐カバレッジ率）
2. クラス別のカバレッジ詳細（行カバレッジ、分岐カバレッジ、メソッドカバレッジ）
3. ソースコードレベルのカバレッジ表示（カバーされた行/カバーされていない行のハイライト）
4. 命令（instruction）カバレッジ、複雑度（complexity）カバレッジ

**帳票の出力タイミング**：`-Dtests.coverage` システムプロパティを有効にしてビルドを実行した場合に、テスト実行後に自動的に生成される。`jacocoTestReport` タスクは各テストタイプ（test, internalClusterTest, javaRestTest, yamlRestTest）の実行データが存在する場合にのみ実行される。

**帳票の利用者**：OpenSearch の開発者、品質保証担当者、CI/CD パイプライン管理者

## 帳票種別

集計表（XML/HTML/CSV レポート形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | カバレッジレポート | ローカルファイルシステム | `./gradlew jacocoTestReport -Dtests.coverage` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | XML（デフォルト有効）、HTML（オプション）、CSV（オプション） |
| 用紙サイズ | N/A（ファイル出力） |
| 向き | N/A |
| ファイル名 | `{project}/build/reports/jacoco/test/jacocoTestReport.xml` 等 |
| 出力方法 | ローカルファイルシステムへの出力 |
| 文字コード | UTF-8 |

### レポート形式の制御

| 形式 | システムプロパティ | デフォルト値 |
|------|-----------------|------------|
| XML | `tests.coverage.report.xml` | `true`（有効） |
| HTML | `tests.coverage.report.html` | `false`（無効） |
| CSV | `tests.coverage.report.csv` | `false`（無効） |

## 帳票レイアウト

### レイアウト概要

JaCoCo 標準のレポート構造に基づく。XML 形式ではマシンリーダブルな形式、HTML 形式ではブラウザで閲覧可能な階層的ナビゲーション構造を持つ。

```
┌─────────────────────────────────────────────────────────────┐
│                   全体サマリー                                │
│  命令カバレッジ | 分岐カバレッジ | 行カバレッジ | メソッドカバレッジ │
├─────────────────────────────────────────────────────────────┤
│                 パッケージ一覧                                │
│  パッケージ名 | 命令 | 分岐 | 行 | 複雑度 | メソッド | クラス    │
├─────────────────────────────────────────────────────────────┤
│              クラス一覧（パッケージ別）                         │
│  クラス名 | 命令 | 分岐 | 行 | 複雑度 | メソッド                │
├─────────────────────────────────────────────────────────────┤
│           メソッド一覧（クラス別）                              │
│  メソッド名 | 命令 | 分岐 | 行 | 複雑度                        │
├─────────────────────────────────────────────────────────────┤
│          ソースコード表示（HTML のみ）                          │
│  行番号 | ソースコード（カバレッジ色分け付き）                     │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | レポートタイトル | プロジェクト名 | Gradle プロジェクト設定 | テキスト |
| 2 | 全体カバレッジサマリー | 各カバレッジメトリクスの全体集計 | JaCoCo 実行データ | パーセンテージ |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | パッケージ名 | Java パッケージの完全修飾名 | クラスファイル解析 | 文字列 | 可変 |
| 2 | 命令カバレッジ | バイトコード命令の実行率 | JaCoCo 実行データ (.exec) | missed/total (%) | 可変 |
| 3 | 分岐カバレッジ | 条件分岐の網羅率 | JaCoCo 実行データ (.exec) | missed/total (%) | 可変 |
| 4 | 行カバレッジ | ソースコード行の実行率 | JaCoCo 実行データ (.exec) | missed/total (%) | 可変 |
| 5 | 複雑度カバレッジ | サイクロマティック複雑度の網羅率 | JaCoCo 実行データ (.exec) | missed/total | 可変 |
| 6 | メソッドカバレッジ | メソッド実行率 | JaCoCo 実行データ (.exec) | missed/total (%) | 可変 |
| 7 | クラスカバレッジ | クラス実行率 | JaCoCo 実行データ (.exec) | missed/total (%) | 可変 |

### フッター部

フッター部はレポート形式に依存する（HTML 形式の場合は JaCoCo バージョン情報等を含む）。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| tests.coverage | カバレッジ収集の有効化フラグ | Yes（システムプロパティ） |
| 実行データファイル | `.exec` ファイルの存在 | Yes（1つ以上必要） |

### 対象テストタイプ

| テストタイプ | 実行データパス | 説明 |
|------------|-------------|------|
| test | `$buildDir/jacoco/test.exec` | ユニットテスト |
| internalClusterTest | `$buildDir/jacoco/internalClusterTest.exec` | 内部クラスタテスト |
| javaRestTest | `$buildDir/jacoco/javaRestTest.exec` | Java REST テスト |
| yamlRestTest | `$buildDir/jacoco/yamlRestTest.exec` | YAML REST テスト |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | パッケージ名 | 昇順 |
| 2 | クラス名 | 昇順 |

### 改ページ条件

改ページは発生しない（HTML/XML/CSV はファイル全体として出力）。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用せず、JaCoCo の実行データファイル（.exec）とクラスファイルを入力とする。

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| JaCoCo 実行データ (.exec) | カバレッジデータ | `$buildDir/jacoco/*.exec` |
| コンパイル済みクラスファイル | カバレッジ対象コード | `sourceSets` から取得 |
| ソースファイル | HTML レポートでのソースコード表示 | `sourceSets` から取得 |

### データソース別参照項目詳細

#### JaCoCo 実行データ (.exec)

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| プローブ実行情報 | 命令カバレッジ、分岐カバレッジ、行カバレッジ | テスト実行後に .exec ファイルが存在 | バイナリ形式 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| カバレッジ率 | (実行された項目数 / 全項目数) * 100 | 小数第1位 | 各メトリクス共通 |
| Missed | 全項目数 - 実行された項目数 | N/A | カバーされなかった項目数 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[gradlew test -Dtests.coverage] --> B[JaCoCo エージェントによるカバレッジ収集]
    B --> C[.exec ファイル生成]
    C --> D{.exec ファイル存在?}
    D -->|Yes| E[jacocoTestReport タスク実行]
    D -->|No| F[レポート生成スキップ]
    E --> G[実行データとクラスファイルの結合]
    G --> H{レポート形式判定}
    H -->|XML| I[XML レポート生成]
    H -->|HTML| J[HTML レポート生成]
    H -->|CSV| K[CSV レポート生成]
    I --> L[build/reports/jacoco/ に出力]
    J --> L
    K --> L
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 実行データなし | テスト未実行または .exec ファイル未生成 | タスクがスキップされる（onlyIf条件不成立） | テストを実行してから再度レポート生成 |
| クラスファイル不一致 | カバレッジ収集後にコードが変更された | JaCoCo のクラスIDミスマッチ警告 | クリーンビルドからやり直し |
| メモリ不足 | 大規模プロジェクトでのレポート生成 | OutOfMemoryError | Gradle デーモンのヒープサイズを増加 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百～数千クラス（サブプロジェクト単位） |
| 目標出力時間 | レポート生成は数秒～数十秒（プロジェクト規模に依存） |
| 同時出力数上限 | サブプロジェクトごとに1レポート |

## セキュリティ考慮事項

- カバレッジレポートにはソースコードの構造情報が含まれるため、外部への公開には注意が必要
- HTML レポートにはソースコード全文が含まれる可能性があるため、アクセス制御を適切に設定すること
- CI/CD 成果物として保存する場合は、内部利用に限定すること

## 備考

- JaCoCo のバージョンは `0.8.13` が使用されている（gradle/code-coverage.gradle 行22）
- XML レポートはデフォルトで有効（`tests.coverage.report.xml` = `true`）、HTML と CSV はデフォルトで無効
- `tests.coverage` システムプロパティが有効な場合、追加で4種類の `JacocoCoverageReport`（test, internalClusterTest, javaRestTest, yamlRestTest）が `check` タスクに紐づく（gradle/code-coverage.gradle 行73-99）
- `jacocoTestReport` タスクは、対象の `.exec` ファイルが1つ以上存在する場合にのみ実行される（onlyIf 条件、行63-68）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

JaCoCo カバレッジレポートの設定構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | code-coverage.gradle | `gradle/code-coverage.gradle` | JaCoCo プラグインの適用と設定。行9 で `jacoco` プラグイン適用、行22 で JaCoCo バージョン `0.8.13` を指定 |

**読解のコツ**: Gradle の `jacoco` プラグインは JaCoCo ライブラリを Gradle ビルドに統合するためのプラグインであり、`JacocoReport` タスクを提供する。

#### Step 2: レポート形式の設定を理解する

レポート出力形式の制御方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | code-coverage.gradle | `gradle/code-coverage.gradle` | 行26-35: `JacocoReport` タスクのレポート形式設定。XML はデフォルト有効、HTML/CSV はシステムプロパティで制御 |

**主要処理フロー**:
1. **行26-35**: 全 `JacocoReport` タスクに共通のレポート形式設定を適用
2. **行31**: `xml.required` は `tests.coverage.report.xml` プロパティで制御（デフォルト `true`）
3. **行32**: `html.required` は `tests.coverage.report.html` プロパティで制御（デフォルト `false`）
4. **行33**: `csv.required` は `tests.coverage.report.csv` プロパティで制御（デフォルト `false`）

#### Step 3: テスト実行データの収集を理解する

各テストタイプからの実行データ収集方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | code-coverage.gradle | `gradle/code-coverage.gradle` | 行38-71: `jacocoTestReport` タスクの拡張設定。4種類のテストタイプ（test, internalClusterTest, javaRestTest, yamlRestTest）からの実行データ収集 |

**主要処理フロー**:
- **行43-58**: 各テストタイプの存在チェックと、対応する `.exec` ファイルパスの追加
- **行59-60**: 存在する `.exec` ファイルのみを `executionData` に設定
- **行63-68**: `onlyIf` 条件で、少なくとも1つの `.exec` ファイルが存在する場合にのみ実行

#### Step 4: 集約カバレッジレポートを理解する

`tests.coverage` プロパティ有効時の追加レポート設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | code-coverage.gradle | `gradle/code-coverage.gradle` | 行73-100: `tests.coverage` プロパティが有効な場合の追加レポート定義と `check` タスクへの紐づけ |

**主要処理フロー**:
- **行76-88**: 4種類の `JacocoCoverageReport` を定義（testSuiteName でテストタイプを区別）
- **行92-98**: `check` タスクに4種類のカバレッジレポートタスクを依存として追加

### プログラム呼び出し階層図

```
gradle/code-coverage.gradle
    |
    +-- apply plugin: 'jacoco'                           [行9]
    |
    +-- jacoco.toolVersion = '0.8.13'                    [行22]
    |
    +-- JacocoReport 共通設定                              [行26-35]
    |   +-- xml.required (デフォルト true)
    |   +-- html.required (デフォルト false)
    |   +-- csv.required (デフォルト false)
    |
    +-- jacocoTestReport 拡張設定                          [行38-71]
    |   +-- test.exec 追加                               [行43-46]
    |   +-- internalClusterTest.exec 追加                 [行47-50]
    |   +-- javaRestTest.exec 追加                       [行51-54]
    |   +-- yamlRestTest.exec 追加                       [行55-58]
    |   +-- onlyIf: .exec ファイル存在チェック              [行63-68]
    |
    +-- (if tests.coverage) 集約レポート定義                [行73-100]
        +-- testCodeCoverageReport
        +-- testCodeCoverageReportInternalClusterTest
        +-- testCodeCoverageReportJavaRestTest
        +-- testCodeCoverageReportYamlRestTest
        +-- check タスクへの依存追加                       [行92-98]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

テスト実行時の             --> JaCoCo エージェント              --> .exec ファイル
バイトコードプローブ             |                                  (バイナリ形式)
                                v
.exec ファイル            --> jacocoTestReport タスク          --> XML レポート
クラスファイル                   |                                  (デフォルト有効)
ソースファイル                   |
                                +-------------------------------> HTML レポート
                                |                                  (オプション)
                                +-------------------------------> CSV レポート
                                                                   (オプション)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| code-coverage.gradle | `gradle/code-coverage.gradle` | 設定 | JaCoCo カバレッジ設定の中心ファイル |
| build.gradle | `build.gradle` | 設定 | ルートプロジェクトのビルド定義 |
| TESTING.md | `TESTING.md` | ドキュメント | テスト実行方法のドキュメント（jacocoTestReport への言及あり） |
| OpenSearchTestBasePlugin.java | `buildSrc/src/main/java/org/opensearch/gradle/OpenSearchTestBasePlugin.java` | ソース | テストタスクの共通設定プラグイン |
