---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：21-PIT_Segments_Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：根拠不足
  2. **PIT機能のバージョン情報（2.3.0以降）**：コード上のアノテーションに基づくが公式ドキュメント未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestPitSegmentsAction.java`（全行）
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/segments/PitSegmentsAction.java`（全行）
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/segments/PitSegmentsRequest.java`（全行）
- E-04: `server/src/main/java/org/opensearch/action/admin/indices/segments/TransportPitSegmentsAction.java`（全行）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java`（全行）
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（行22）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/pit_segments と /_cat/pit_segments/_all | E-01 行49 | ○ |
| C-02 | テーブルに15カラムが定義されている | E-01 行98-116 | ○ |
| C-03 | index, shard, prirep, ip, segment等のカラム定義と属性 | E-01 行100-115 | ○ |
| C-04 | id カラムはデフォルト非表示 | E-01 行104 `default:false` | ○ |
| C-05 | size.memory は固定値 0L | E-01 行141 | ○ |
| C-06 | _all 指定で全PIT取得 | E-04 行100-109 | ○ |
| C-07 | アクション名は indices:monitor/point_in_time/segments | E-02 行19 | ○ |
| C-08 | PitSegmentsRequest は BroadcastRequest を継承 | E-03 行33 | ○ |
| C-09 | pit_id は JSON のリクエストボディから解析される | E-03 行93-124, E-01 行71-75 | ○ |
| C-10 | バリデーションで pit_id 未指定時にエラー | E-03 行86-91 | ○ |
| C-11 | METADATA_READ レベルのクラスタブロックチェック | E-04 行163-169 | ○ |
| C-12 | PitReaderContext から セグメント情報を取得 | E-04 行217-221 | ○ |
| C-13 | PitReaderContext が null の場合は空リストを返す | E-04 行218-219 | ○ |
| C-14 | PitAwareShardRouting でシャードルーティングを拡張 | E-04 行227-278 | ○ |
| C-15 | allowSystemIndexAccessByDefault() が true | E-01 行58-60 | ○ |
| C-16 | AbstractCatAction で help パラメータ対応 | E-05 行68-91 | ○ |
| C-17 | help 表示は v, h, s, format 等のパラメータを受け付ける | E-05 行93-95 | ○ |
| C-18 | ThreadPool.Names.MANAGEMENT スレッドプールで実行 | E-04 行87 | ○ |
| C-19 | パフォーマンス要件（通常数秒以内） | **根拠なし** | △ |
| C-20 | PIT は OpenSearch 2.3.0 以降で利用可能 | E-03 行32 `@PublicApi(since = "2.3.0")` | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: パフォーマンス要件の具体的な数値はソースコードからは確認できない。ブロードキャスト通信のレイテンシはクラスタ構成に依存する。
  - 候補：パフォーマンステスト結果 / 運用ドキュメント / ベンチマーク結果
- C-20: `@PublicApi(since = "2.3.0")` アノテーションからバージョンを推定したが、PIT機能全体の導入バージョンと一致するかは公式リリースノートでの確認が必要。
  - 候補：OpenSearch リリースノート / CHANGELOG

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カラム定義とデータ取得元の対応は全てソースコードで確認済み
- 0: 低リスク - エラー処理の記載はソースコードと整合
- 1: 中リスク - size.memory が常に 0 を返す点について、将来的な変更可能性あり
- 0: 低リスク - 処理フローはソースコードの制御フローと一致

## 6) レビュアーチェックリスト（最小）
- [ ] size.memory が常に 0 を返す実装が意図的かどうかの確認
- [ ] パフォーマンス要件の記載が運用実態と合致するかの確認
- [ ] PIT 機能の利用可能バージョン（2.3.0）が正確かの確認
- [ ] セキュリティ考慮事項でのアクセス制御記述が運用ポリシーと整合するかの確認
