---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 11
  claims_without_evidence: 4
confidence_derived: 0.73
---

# 根拠レポート：22-テスト集約レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.73**
  - 根拠あり：11 / 15、根拠なし：4
- 優先レビュー（高）
  1. **HTML レポートの出力パス**：Gradle の AggregateTestReport のデフォルト出力先の確認が必要
  2. **HTML レポートのレイアウト詳細**：Gradle 内部テンプレートに依存するため詳細不明
  3. **テスト総数の見積もり（数千～数万件）**：実測値の確認が必要
  4. **成功率の計算式**：Gradle 内部ロジックに基づく推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `build.gradle`（行718-733）
- E-02: `buildSrc/src/main/java/org/opensearch/gradle/OpenSearchTestBasePlugin.java`（全行）
- E-03: `buildSrc/src/main/java/org/opensearch/gradle/test/ErrorReportingTestListener.java`（全行）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（行23）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | testAggregateTestReport は AggregateTestReport 型で定義 | E-01 行720 | ○ |
| C-02 | testSuiteName は "test" に設定 | E-01 行721 | ○ |
| C-03 | check タスクが testAggregateTestReport に依存 | E-01 行731-733 | ○ |
| C-04 | JUnit XML レポートが有効化されている | E-01 行727-729 | ○ |
| C-05 | デフォルトの test タスクは **/*Tests.class のみ対象 | E-02 行69 | ○ |
| C-06 | ErrorReportingTestListener が全テストタスクに登録される | E-02 行81-84 | ○ |
| C-07 | テストの最大並列フォーク数が tests.jvms プロパティで設定 | E-02 行115 | ○ |
| C-08 | テストのヒープサイズはデフォルト 512m | E-02 行120-121 | ○ |
| C-09 | テストのロギングレベルは WARN | E-02 行175 | ○ |
| C-10 | ErrorReportingTestListener はテスト出力をファイルに書き出す | E-03 行256-311 | ○ |
| C-11 | 失敗テストのリスト表示機能がある | E-03 行138-143 | ○ |
| C-12 | HTML レポートの出力パスは build/reports/tests/unit-test/aggregated-results/index.html | **根拠なし** | △ |
| C-13 | HTML レポートのレイアウト（サマリー、プロジェクト一覧等） | **根拠なし** | △ |
| C-14 | テスト総数は数千～数万件 | **根拠なし** | △ |
| C-15 | レポート生成時間は数秒～数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: AggregateTestReport のデフォルト出力パスは Gradle のドキュメントに記載されているが、プロジェクト固有のカスタマイズがないか確認が必要。
  - 候補：Gradle 公式ドキュメント / 実際のビルド出力の確認
- C-13: HTML レポートのレイアウトは Gradle 内部のテンプレートに依存しており、ソースコードからは確認できない。
  - 候補：Gradle ソースコード / 実際のレポート出力の確認
- C-14: テスト総数の推定値は実際のビルド実行で確認する必要がある。
  - 候補：CI/CD の実行ログ / テスト実行結果
- C-15: レポート生成時間は環境依存であり、ソースコードからは推定できない。
  - 候補：CI/CD の実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - HTML レポートの出力パスが正確かどうかの確認が必要
- 1: 中リスク - レポートレイアウトの詳細は Gradle 内部実装に依存
- 0: 低リスク - タスク定義と依存関係はソースコードで確認済み
- 0: 低リスク - テスト実行設定はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTML レポートの実際の出力パスを `./gradlew testAggregateTestReport` を実行して確認
- [ ] HTML レポートのレイアウトが設計書の記載と一致するかの確認
- [ ] テスト集約の対象スコープ（"test" スイートのみ）が要件に合致するかの確認
- [ ] Jenkins 連携用の JUnit XML 出力が正しく動作するかの確認
