---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：23-JaCoCoカバレッジレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **レポートの出力パス**：Gradle のデフォルト出力パスに基づく推定
  2. **HTML レポートのレイアウト詳細**：JaCoCo 内部テンプレートに依存
  3. **パフォーマンス要件**：実測値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `gradle/code-coverage.gradle`（全行）
- E-02: `buildSrc/src/main/java/org/opensearch/gradle/OpenSearchTestBasePlugin.java`（全行）
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv`（行24）
- E-04: `TESTING.md`（jacocoTestReport への言及）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JaCoCo プラグインが apply される | E-01 行9 | ○ |
| C-02 | JaCoCo バージョンは 0.8.13 | E-01 行22 | ○ |
| C-03 | XML レポートはデフォルトで有効 | E-01 行31 | ○ |
| C-04 | HTML レポートはデフォルトで無効 | E-01 行32 | ○ |
| C-05 | CSV レポートはデフォルトで無効 | E-01 行33 | ○ |
| C-06 | test.exec が実行データとして収集される | E-01 行44 | ○ |
| C-07 | internalClusterTest.exec が実行データとして収集される | E-01 行48 | ○ |
| C-08 | javaRestTest.exec が実行データとして収集される | E-01 行52 | ○ |
| C-09 | yamlRestTest.exec が実行データとして収集される | E-01 行56 | ○ |
| C-10 | onlyIf 条件で .exec ファイル存在チェック | E-01 行63-68 | ○ |
| C-11 | tests.coverage プロパティで集約レポートが追加定義される | E-01 行73-100 | ○ |
| C-12 | 4種類の JacocoCoverageReport が定義される | E-01 行76-88 | ○ |
| C-13 | check タスクに4種類のカバレッジレポートが依存追加 | E-01 行92-98 | ○ |
| C-14 | JacocoReport タスクは VERIFICATION_GROUP に属する | E-01 行27 | ○ |
| C-15 | mavenCentral() と gradlePluginPortal() がリポジトリに設定 | E-01 行12-13 | ○ |
| C-16 | レポートの出力パスは build/reports/jacoco/test/ | **根拠なし** | △ |
| C-17 | HTML レポートのレイアウト（パッケージ、クラス、メソッド階層） | **根拠なし** | △ |
| C-18 | レポート生成時間は数秒～数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: レポートの出力パスは Gradle の JaCoCo プラグインのデフォルト設定に基づく推定であり、プロジェクト固有のカスタマイズがないか確認が必要。
  - 候補：Gradle 公式ドキュメント / 実際のビルド出力の確認
- C-17: HTML レポートのレイアウトは JaCoCo ライブラリ内部のテンプレートに依存しており、ソースコードからは確認できない。
  - 候補：JaCoCo 公式ドキュメント / 実際のレポート出力の確認
- C-18: レポート生成時間は環境依存であり、ソースコードからは推定できない。
  - 候補：CI/CD の実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - JaCoCo の設定値はソースコードで全て確認済み
- 0: 低リスク - テストタイプとその実行データパスの対応は正確
- 1: 中リスク - レポート出力パスの正確性は実行して確認が必要
- 0: 低リスク - onlyIf 条件のロジックはソースコードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] レポートの実際の出力パスを `./gradlew jacocoTestReport -Dtests.coverage` で確認
- [ ] HTML レポートのレイアウトが設計書の記載と一致するかの確認
- [ ] JaCoCo バージョン 0.8.13 が最新かどうかの確認
- [ ] 4種類のテストタイプ全てが正しくカバレッジ収集対象に含まれているかの確認
