---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 130
  claims_with_evidence: 126
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：126 / 130、根拠なし：4
- 優先レビュー（高）
  1. **C-035 Star-Treeインデックス**：機能の説明が推測を含む（事前集計の詳細動作）
  2. **C-123 オートフォースマージ**：自動実行条件の詳細が未確認
  3. **C-125 インデックススケーリング**：スケーリングの詳細仕様が未確認
  4. **C-126 自動タグ付け共通基盤**：機能の詳細動作が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/create/` - インデックス作成アクション
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/delete/` - インデックス削除アクション
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/open/` および `close/` - インデックス開閉アクション
- E-04: `server/src/main/java/org/opensearch/action/admin/indices/alias/` - エイリアスアクション
- E-05: `server/src/main/java/org/opensearch/action/admin/indices/rollover/` - ロールオーバーアクション
- E-06: `server/src/main/java/org/opensearch/action/admin/indices/shrink/` - シュリンク/スプリットアクション
- E-07: `server/src/main/java/org/opensearch/action/admin/indices/template/` - テンプレートアクション
- E-08: `server/src/main/java/org/opensearch/action/admin/indices/datastream/` - データストリームアクション
- E-09: `server/src/main/java/org/opensearch/action/admin/indices/view/` - ビューアクション
- E-10: `server/src/main/java/org/opensearch/action/index/` - ドキュメントインデックスアクション
- E-11: `server/src/main/java/org/opensearch/action/get/` - ドキュメント取得アクション
- E-12: `server/src/main/java/org/opensearch/action/delete/` - ドキュメント削除アクション
- E-13: `server/src/main/java/org/opensearch/action/bulk/` - バルクアクション
- E-14: `server/src/main/java/org/opensearch/index/reindex/` - リインデックスアクション
- E-15: `server/src/main/java/org/opensearch/action/admin/indices/mapping/` - マッピングアクション
- E-16: `server/src/main/java/org/opensearch/action/admin/indices/settings/` - 設定アクション
- E-17: `server/src/main/java/org/opensearch/search/query/` - 検索クエリ
- E-18: `server/src/main/java/org/opensearch/action/search/SearchAction.java` - 検索アクション
- E-19: `server/src/main/java/org/opensearch/action/search/MultiSearchAction.java` - マルチサーチアクション
- E-20: `server/src/main/java/org/opensearch/action/search/SearchScrollAction.java` - スクロール検索アクション
- E-21: `server/src/main/java/org/opensearch/action/search/CreatePitAction.java` - PIT作成アクション
- E-22: `server/src/main/java/org/opensearch/action/search/StreamSearchAction.java` - ストリーミング検索アクション
- E-23: `server/src/main/java/org/opensearch/search/suggest/` - サジェスト
- E-24: `server/src/main/java/org/opensearch/action/fieldcaps/` - フィールドキャパビリティ
- E-25: `server/src/main/java/org/opensearch/action/explain/` - Explainアクション
- E-26: `server/src/main/java/org/opensearch/action/admin/indices/validate/` - Validateアクション
- E-27: `server/src/main/java/org/opensearch/search/profile/` - プロファイリング
- E-28: `server/src/main/java/org/opensearch/action/termvectors/` - TermVectorsアクション
- E-29: `server/src/main/java/org/opensearch/search/aggregations/bucket/` - バケット集計
- E-30: `server/src/main/java/org/opensearch/search/aggregations/metrics/` - メトリクス集計
- E-31: `server/src/main/java/org/opensearch/search/aggregations/pipeline/` - パイプライン集計
- E-32: `modules/aggs-matrix-stats/` - Matrix Stats集計モジュール
- E-33: `server/src/main/java/org/opensearch/search/startree/` - Star-Tree検索
- E-34: `server/src/main/java/org/opensearch/ingest/` - インジェストパイプライン
- E-35: `modules/ingest-common/` - インジェスト共通モジュール
- E-36: `modules/ingest-geoip/` - GeoIPモジュール
- E-37: `modules/ingest-user-agent/` - User-Agentモジュール
- E-38: `plugins/ingest-attachment/` - Attachmentプラグイン
- E-39: `server/src/main/java/org/opensearch/action/admin/indices/streamingingestion/` - ストリーミングインジェスト
- E-40: `plugins/ingestion-kafka/` - Kafkaインジェストプラグイン
- E-41: `plugins/ingestion-kinesis/` - Kinesisインジェストプラグイン
- E-42: `plugins/ingestion-fs/` - FSインジェストプラグイン
- E-43: `server/src/main/java/org/opensearch/search/pipeline/` - 検索パイプライン
- E-44: `modules/search-pipeline-common/` - 検索パイプライン共通モジュール
- E-45: `server/src/main/java/org/opensearch/action/admin/cluster/health/` - クラスタヘルスアクション
- E-46: `server/src/main/java/org/opensearch/cluster/ClusterState.java` - クラスタ状態
- E-47: `server/src/main/java/org/opensearch/action/admin/cluster/node/` - ノードアクション
- E-48: `server/src/main/java/org/opensearch/action/admin/cluster/settings/` - クラスタ設定アクション
- E-49: `server/src/main/java/org/opensearch/action/admin/cluster/tasks/` - タスクアクション
- E-50: `server/src/main/java/org/opensearch/discovery/` - ディスカバリ
- E-51: `server/src/main/java/org/opensearch/cluster/coordination/` - クラスタ調整
- E-52: `server/src/main/java/org/opensearch/cluster/decommission/` - デコミッション
- E-53: `server/src/main/java/org/opensearch/cluster/awarenesshealth/` - アウェアネスヘルス
- E-54: `server/src/main/java/org/opensearch/cluster/routing/allocation/` - シャードアロケーション
- E-55: `server/src/main/java/org/opensearch/cluster/routing/OperationRouting.java` - オペレーションルーティング
- E-56: `server/src/main/java/org/opensearch/cluster/routing/WeightedRoutingService.java` - 重み付きルーティング
- E-57: `server/src/main/java/org/opensearch/index/SegmentReplicationPressureService.java` - セグメントレプリケーション
- E-58: `server/src/main/java/org/opensearch/action/admin/indices/tiering/` - 階層化アクション
- E-59: `server/src/main/java/org/opensearch/index/remote/` - リモートストア
- E-60: `server/src/main/java/org/opensearch/gateway/remote/` - リモートゲートウェイ
- E-61: `server/src/main/java/org/opensearch/snapshots/SnapshotsService.java` - スナップショットサービス
- E-62: `server/src/main/java/org/opensearch/snapshots/RestoreService.java` - リストアサービス
- E-63: `server/src/main/java/org/opensearch/repositories/RepositoriesService.java` - リポジトリサービス
- E-64: `plugins/repository-s3/` - S3リポジトリプラグイン
- E-65: `plugins/repository-azure/` - Azureリポジトリプラグイン
- E-66: `plugins/repository-gcs/` - GCSリポジトリプラグイン
- E-67: `plugins/repository-hdfs/` - HDFSリポジトリプラグイン
- E-68: `modules/analysis-common/` - 共通解析モジュール
- E-69: `plugins/analysis-icu/` - ICU解析プラグイン
- E-70: `plugins/analysis-kuromoji/` - Kuromojiプラグイン
- E-71: `plugins/analysis-nori/` - Noriプラグイン
- E-72: `plugins/analysis-smartcn/` - SmartCNプラグイン
- E-73: `plugins/analysis-phonetic/` - Phoneticプラグイン
- E-74: `plugins/analysis-stempel/` - Stempelプラグイン
- E-75: `plugins/analysis-ukrainian/` - ウクライナ語プラグイン
- E-76: `plugins/analysis-phonenumber/` - 電話番号プラグイン
- E-77: `modules/lang-painless/` - Painlessモジュール
- E-78: `modules/lang-mustache/` - Mustacheモジュール
- E-79: `modules/lang-expression/` - Expressionモジュール
- E-80: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/` - ストアドスクリプトアクション
- E-81: `server/src/main/java/org/opensearch/crypto/` - 暗号化パッケージ
- E-82: `plugins/crypto-kms/` - KMSプラグイン
- E-83: `server/src/main/java/org/opensearch/identity/` - アイデンティティパッケージ
- E-84: `modules/mapper-extras/` - マッパー拡張モジュール
- E-85: `plugins/mapper-annotated-text/` - Annotated Textプラグイン
- E-86: `plugins/mapper-murmur3/` - Murmur3プラグイン
- E-87: `plugins/mapper-size/` - Sizeプラグイン
- E-88: `server/src/main/java/org/opensearch/index/mapper/DerivedFieldMapper.java` - Derived Fieldマッパー
- E-89: `server/src/main/java/org/opensearch/index/mapper/StarTreeMapper.java` - Star-Treeマッパー
- E-90: `modules/transport-netty4/` - Netty4トランスポートモジュール
- E-91: `modules/transport-grpc/` - gRPCトランスポートモジュール
- E-92: `plugins/transport-reactor-netty4/` - Reactor Netty4プラグイン
- E-93: `server/src/main/java/org/opensearch/transport/RemoteClusterService.java` - リモートクラスタサービス
- E-94: `server/src/main/java/org/opensearch/plugins/` - プラグインフレームワーク
- E-95: `server/src/main/java/org/opensearch/extensions/` - 拡張フレームワーク
- E-96: `plugins/discovery-ec2/` - EC2ディスカバリプラグイン
- E-97: `plugins/discovery-gce/` - GCEディスカバリプラグイン
- E-98: `plugins/discovery-azure-classic/` - Azureディスカバリプラグイン
- E-99: `server/src/main/java/org/opensearch/wlm/` - ワークロード管理パッケージ
- E-100: `plugins/workload-management/` - ワークロード管理プラグイン
- E-101: `server/src/main/java/org/opensearch/telemetry/` - テレメトリパッケージ
- E-102: `plugins/telemetry-otel/` - OpenTelemetryプラグイン
- E-103: `server/src/main/java/org/opensearch/action/admin/indices/stats/` - インデックス統計アクション
- E-104: `server/src/main/java/org/opensearch/action/admin/cluster/stats/` - クラスタ統計アクション
- E-105: `modules/cache-common/` - キャッシュ共通モジュール
- E-106: `plugins/cache-ehcache/` - Ehcacheプラグイン
- E-107: `server/src/main/java/org/opensearch/index/cache/` - インデックスキャッシュ
- E-108: `modules/percolator/` - パーコレータモジュール
- E-109: `modules/rank-eval/` - ランク評価モジュール
- E-110: `modules/geo/` - Geoモジュール
- E-111: `modules/parent-join/` - Parent-Joinモジュール
- E-112: `modules/opensearch-dashboards/` - Dashboardsモジュール
- E-113: `plugins/arrow-flight-rpc/` - Arrow Flight RPCプラグイン
- E-114: `server/src/main/java/org/opensearch/arrow/` - Arrowパッケージ
- E-115: `server/src/main/java/org/opensearch/action/admin/indices/forcemerge/` - フォースマージアクション
- E-116: `server/src/main/java/org/opensearch/action/admin/indices/flush/` - フラッシュアクション
- E-117: `server/src/main/java/org/opensearch/action/admin/indices/refresh/` - リフレッシュアクション
- E-118: `server/src/main/java/org/opensearch/action/admin/indices/recovery/` - リカバリアクション
- E-119: `server/src/main/java/org/opensearch/action/admin/indices/segments/` - セグメントアクション
- E-120: `server/src/main/java/org/opensearch/action/admin/indices/cache/` - キャッシュクリアアクション
- E-121: `server/src/main/java/org/opensearch/index/autoforcemerge/` - オートフォースマージ
- E-122: `server/src/main/java/org/opensearch/action/admin/indices/readonly/` - リードオンリーアクション
- E-123: `server/src/main/java/org/opensearch/action/admin/indices/scale/` - スケーリングアクション
- E-124: `modules/autotagging-commons/` - 自動タグ付けモジュール
- E-125: `server/src/main/java/org/opensearch/ratelimitting/` - レート制限パッケージ
- E-126: `server/src/main/java/org/opensearch/threadpool/` - スレッドプール
- E-127: `server/src/main/java/org/opensearch/gateway/` - ゲートウェイ
- E-128: `modules/store-subdirectory/` - Store Subdirectoryモジュール
- E-129: `server/src/main/java/org/opensearch/index/compositeindex/` - コンポジットインデックス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | インデックス作成機能が存在する | E-01 | ○ |
| C-002 | インデックス削除機能が存在する | E-02 | ○ |
| C-003 | インデックスオープン/クローズ機能が存在する | E-03 | ○ |
| C-004 | インデックスエイリアス機能が存在する | E-04 | ○ |
| C-005 | インデックスロールオーバー機能が存在する | E-05 | ○ |
| C-006 | インデックスシュリンク/スプリット機能が存在する | E-06 | ○ |
| C-007 | インデックステンプレート機能が存在する | E-07 | ○ |
| C-008 | データストリーム機能が存在する | E-08 | ○ |
| C-009 | インデックスビュー機能が存在する | E-09 | ○ |
| C-010 | ドキュメントインデックス（登録）機能が存在する | E-10 | ○ |
| C-011 | ドキュメント取得機能が存在する | E-11 | ○ |
| C-012 | ドキュメント削除機能が存在する | E-12 | ○ |
| C-013 | バルク操作機能が存在する | E-13 | ○ |
| C-014 | リインデックス機能が存在する | E-14 | ○ |
| C-015 | Update By Query機能が存在する | E-14 | ○ |
| C-016 | Delete By Query機能が存在する | E-14 | ○ |
| C-017 | マッピング管理機能が存在する | E-15 | ○ |
| C-018 | インデックス設定管理機能が存在する | E-16 | ○ |
| C-019 | 全文検索機能が存在する | E-17 | ○ |
| C-020 | 検索API機能が存在する | E-18 | ○ |
| C-021 | マルチサーチ機能が存在する | E-19 | ○ |
| C-022 | スクロール検索機能が存在する | E-20 | ○ |
| C-023 | Point in Time（PIT）機能が存在する | E-21 | ○ |
| C-024 | ストリーミング検索機能が存在する | E-22 | ○ |
| C-025 | 検索サジェスト機能が存在する | E-23 | ○ |
| C-026 | フィールドキャパビリティ機能が存在する | E-24 | ○ |
| C-027 | Explain API機能が存在する | E-25 | ○ |
| C-028 | Validate API機能が存在する | E-26 | ○ |
| C-029 | 検索プロファイリング機能が存在する | E-27 | ○ |
| C-030 | TermVectors API機能が存在する | E-28 | ○ |
| C-031 | バケット集計機能が存在する | E-29 | ○ |
| C-032 | メトリクス集計機能が存在する | E-30 | ○ |
| C-033 | パイプライン集計機能が存在する | E-31 | ○ |
| C-034 | Matrix Stats集計機能が存在する | E-32 | ○ |
| C-035 | Star-Treeインデックスによる事前集計機能が存在する | E-33, E-129 | △ |
| C-036 | インジェストパイプライン機能が存在する | E-34 | ○ |
| C-037 | インジェスト共通プロセッサが存在する | E-35 | ○ |
| C-038 | GeoIPプロセッサが存在する | E-36 | ○ |
| C-039 | User-Agentプロセッサが存在する | E-37 | ○ |
| C-040 | Attachmentプロセッサが存在する | E-38 | ○ |
| C-041 | ストリーミングインジェスト機能が存在する | E-39 | ○ |
| C-042 | Kafkaインジェスト機能が存在する | E-40 | ○ |
| C-043 | Kinesisインジェスト機能が存在する | E-41 | ○ |
| C-044 | ファイルシステムインジェスト機能が存在する | E-42 | ○ |
| C-045 | 検索パイプライン管理機能が存在する | E-43 | ○ |
| C-046 | 検索パイプライン共通プロセッサが存在する | E-44 | ○ |
| C-047 | クラスタヘルス機能が存在する | E-45 | ○ |
| C-048 | クラスタ状態管理機能が存在する | E-46 | ○ |
| C-049 | ノード情報・統計機能が存在する | E-47 | ○ |
| C-050 | クラスタ設定管理機能が存在する | E-48 | ○ |
| C-051 | タスク管理機能が存在する | E-49 | ○ |
| C-052 | ノードディスカバリ機能が存在する | E-50 | ○ |
| C-053 | クラスタマネージャ選出機能が存在する | E-51 | ○ |
| C-054 | ノードデコミッション機能が存在する | E-52 | ○ |
| C-055 | Awareness Health機能が存在する | E-53 | ○ |
| C-056 | シャードアロケーション機能が存在する | E-54 | ○ |
| C-057 | シャードルーティング機能が存在する | E-55 | ○ |
| C-058 | 重み付きルーティング機能が存在する | E-56 | ○ |
| C-059 | セグメントレプリケーション機能が存在する | E-57 | ○ |
| C-060 | インデックス階層化機能が存在する | E-58 | ○ |
| C-061 | リモートストア機能が存在する | E-59 | ○ |
| C-062 | リモートクラスタ状態管理機能が存在する | E-60 | ○ |
| C-063 | スナップショット作成・管理機能が存在する | E-61 | ○ |
| C-064 | スナップショットリストア機能が存在する | E-62 | ○ |
| C-065 | リポジトリ管理機能が存在する | E-63 | ○ |
| C-066 | S3リポジトリプラグインが存在する | E-64 | ○ |
| C-067 | Azureリポジトリプラグインが存在する | E-65 | ○ |
| C-068 | GCSリポジトリプラグインが存在する | E-66 | ○ |
| C-069 | HDFSリポジトリプラグインが存在する | E-67 | ○ |
| C-070 | 共通アナライザモジュールが存在する | E-68 | ○ |
| C-071 | ICUアナライザプラグインが存在する | E-69 | ○ |
| C-072 | Kuromojiプラグインが存在する | E-70 | ○ |
| C-073 | Noriプラグインが存在する | E-71 | ○ |
| C-074 | SmartCNプラグインが存在する | E-72 | ○ |
| C-075 | Phoneticプラグインが存在する | E-73 | ○ |
| C-076 | Stempelプラグインが存在する | E-74 | ○ |
| C-077 | ウクライナ語アナライザプラグインが存在する | E-75 | ○ |
| C-078 | 電話番号アナライザプラグインが存在する | E-76 | ○ |
| C-079 | Painlessスクリプトモジュールが存在する | E-77 | ○ |
| C-080 | Mustacheテンプレートモジュールが存在する | E-78 | ○ |
| C-081 | Expressionスクリプトモジュールが存在する | E-79 | ○ |
| C-082 | ストアドスクリプト機能が存在する | E-80 | ○ |
| C-083 | 暗号化・復号化機能が存在する | E-81 | ○ |
| C-084 | KMS暗号化プラグインが存在する | E-82 | ○ |
| C-085 | アイデンティティ管理機能が存在する | E-83 | ○ |
| C-086 | 追加マッパーモジュールが存在する | E-84 | ○ |
| C-087 | Annotated Textマッパープラグインが存在する | E-85 | ○ |
| C-088 | Murmur3マッパープラグインが存在する | E-86 | ○ |
| C-089 | Sizeマッパープラグインが存在する | E-87 | ○ |
| C-090 | Derived Fields機能が存在する | E-88 | ○ |
| C-091 | Star-Treeマッパーが存在する | E-89 | ○ |
| C-092 | Netty4トランスポートモジュールが存在する | E-90 | ○ |
| C-093 | gRPCトランスポートモジュールが存在する | E-91 | ○ |
| C-094 | Reactor Netty4トランスポートプラグインが存在する | E-92 | ○ |
| C-095 | リモートクラスタ接続機能が存在する | E-93 | ○ |
| C-096 | プラグインフレームワークが存在する | E-94 | ○ |
| C-097 | 拡張機能フレームワークが存在する | E-95 | ○ |
| C-098 | EC2ディスカバリプラグインが存在する | E-96 | ○ |
| C-099 | GCEディスカバリプラグインが存在する | E-97 | ○ |
| C-100 | Azureディスカバリプラグインが存在する | E-98 | ○ |
| C-101 | ワークロードグループ管理機能が存在する | E-99 | ○ |
| C-102 | ワークロード管理プラグインが存在する | E-100 | ○ |
| C-103 | テレメトリフレームワークが存在する | E-101 | ○ |
| C-104 | OpenTelemetryプラグインが存在する | E-102 | ○ |
| C-105 | インデックス統計機能が存在する | E-103 | ○ |
| C-106 | クラスタ統計機能が存在する | E-104 | ○ |
| C-107 | キャッシュ共通基盤が存在する | E-105 | ○ |
| C-108 | Ehcacheプラグインが存在する | E-106 | ○ |
| C-109 | インデックスキャッシュ機能が存在する | E-107 | ○ |
| C-110 | パーコレータ機能が存在する | E-108 | ○ |
| C-111 | ランク評価API機能が存在する | E-109 | ○ |
| C-112 | Geoモジュールが存在する | E-110 | ○ |
| C-113 | Parent-Join機能が存在する | E-111 | ○ |
| C-114 | Dashboards連携機能が存在する | E-112 | ○ |
| C-115 | Arrow Flight RPCプラグインが存在する | E-113 | ○ |
| C-116 | Arrowストリーミング機能が存在する | E-114 | ○ |
| C-117 | フォースマージ機能が存在する | E-115 | ○ |
| C-118 | フラッシュ機能が存在する | E-116 | ○ |
| C-119 | リフレッシュ機能が存在する | E-117 | ○ |
| C-120 | リカバリ機能が存在する | E-118 | ○ |
| C-121 | セグメント情報機能が存在する | E-119 | ○ |
| C-122 | キャッシュクリア機能が存在する | E-120 | ○ |
| C-123 | オートフォースマージ機能が存在する | E-121 | △ |
| C-124 | インデックスリードオンリー機能が存在する | E-122 | ○ |
| C-125 | インデックススケーリング機能が存在する | E-123 | △ |
| C-126 | 自動タグ付け共通基盤が存在する | E-124 | △ |
| C-127 | レート制限機能が存在する | E-125 | ○ |
| C-128 | スレッドプール管理機能が存在する | E-126 | ○ |
| C-129 | ゲートウェイ機能が存在する | E-127 | ○ |
| C-130 | Store Subdirectoryモジュールが存在する | E-128 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-035 Star-Treeインデックス**：Star-Treeインデックスの「事前集計」という表現は、コード構造からの推測を含む。Star-Treeの具体的な集計最適化メカニズムの詳細ドキュメントが不足している
  - 候補：OpenSearch公式ドキュメント / RFC・設計ドキュメント / コード内コメント
- **C-123 オートフォースマージ**：自動フォースマージの発動条件やトリガー条件の詳細が未確認
  - 候補：IndexSettings / AutoForceMerge関連クラスのJavadoc
- **C-125 インデックススケーリング**：スケーリング機能の具体的な動作仕様（動的レプリカ追加/削除のメカニズム）が未確認
  - 候補：scale関連アクションクラスの詳細確認
- **C-126 自動タグ付け共通基盤**：自動タグ付けの具体的なタグ付けルールや対象の詳細が未確認
  - 候補：autotagging-commonsモジュールの詳細確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の機能はディレクトリ構造・ソースコードファイルの存在から直接確認できる
- 1: 中リスク - Star-Treeインデックス、オートフォースマージ、インデックススケーリング、自動タグ付けの4機能は説明文に推測を含む可能性がある
- 0: 低リスク - カテゴリ分類はパッケージ構造に基づいており妥当性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 機能一覧の130項目がプロジェクトの主要機能を網羅しているか確認
- [ ] 各機能の「説明」がソースコードの実装と一致しているか確認（特にC-035、C-123、C-125、C-126）
- [ ] カテゴリ分類が組織の分類基準と整合しているか確認
- [ ] sandbox配下の実験的機能が含まれるべきか判断
- [ ] セキュリティプラグイン等の別リポジトリで管理される機能の扱いを確認
