# 機能設計書 100-Azureディスカバリ

## 概要

本ドキュメントは、Azure環境でのノード自動検出プラグイン（Azure Classic Discovery Plugin）の設計を記述する。Azureディスカバリプラグインは、Azure Classic Management APIを使用してクラスタメンバーのシードホストを自動検出する。

### 本機能の処理概要

Azureディスカバリプラグインは、Azure Classic（Service Management）APIを呼び出してAzureインスタンスの情報を取得し、クラスタのシードホストとして使用可能なノードのアドレスリストを生成する。

**業務上の目的・背景**：Azure環境ではインスタンスのIPアドレスが動的に変わるため、静的な設定によるノードディスカバリは困難である。Azureディスカバリプラグインにより、Azure Management APIを使った動的なノード検出が可能となる。ただし、本プラグインはClassic（旧）APIベースであり、非推奨（Deprecated）である。

**機能の利用シーン**：Azure Classic環境でOpenSearchクラスタを運用する場合に使用される。Azure Resource Manager（ARM）ベースの環境では使用は推奨されない。

**主要な処理内容**：
1. AzureComputeServiceの初期化 - Azureクレデンシャルを使用した管理クライアントの生成
2. ホステッドサービス情報の取得 - Azure Management APIによるデプロイメント情報の取得
3. デプロイメントフィルタリング - デプロイメントスロット、ステータスによるフィルタリング
4. ホストアドレス解決 - プライベートIP/パブリックIPからホストアドレスを決定
5. シードホストリスト提供 - SeedHostsProviderインターフェースを通じてホストリストを返却

**関連システム・外部連携**：Azure Classic Management API。Microsoft Azure SDK for Javaを使用。

**権限による制御**：Azure Management APIへのアクセス権が管理証明書に必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Azureディスカバリに直接対応する画面はない |

## 機能種別

データ連携（Azureノード検出） / 非推奨機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| discovery.azure.host.type | String | No | ホストタイプ（private_ip/public_ip） | デフォルトprivate_ip |
| discovery.azure.deployment.name | String | No | デプロイメント名 | - |
| discovery.azure.deployment.slot | String | No | デプロイメントスロット（production/staging） | - |
| cloud.azure.management.subscription.id | String | Yes | AzureサブスクリプションID | - |
| cloud.azure.management.cloud.service.name | String | Yes | クラウドサービス名 | - |
| cloud.azure.management.keystore.path | String | Yes | キーストアのパス | - |
| cloud.azure.management.keystore.password | String | Yes | キーストアのパスワード | - |
| discovery.seed_providers | String | No | "azure"を指定して有効化 | - |

### 入力データソース

opensearch.yml設定ファイル。Azure Classic Management APIのレスポンス。Azure管理証明書。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| List<TransportAddress> | List | 検出されたシードホストのトランスポートアドレスリスト |

### 出力先

ディスカバリモジュール（SeedHostsProvider経由）。

## 処理フロー

### 処理シーケンス

```
1. AzureDiscoveryPlugin初期化
   └─ 非推奨警告の出力
   └─ AzureComputeServiceImplの生成
2. getSeedHostProviders()で"azure"プロバイダを登録
   └─ AzureSeedHostsProviderのインスタンスを返却
3. AzureSeedHostsProvider.getSeedAddresses()呼び出し
   └─ AzureComputeService.getHostedServiceDetails()の呼び出し
   └─ デプロイメント情報の走査
   └─ デプロイメントスロット・ステータスによるフィルタリング
   └─ RoleInstanceからホストアドレスを取得
4. TransportAddressリストの生成
```

### フローチャート

```mermaid
flowchart TD
    A[getSeedAddresses呼び出し] --> B[Azure API呼び出し]
    B --> C{成功?}
    C -->|Yes| D[デプロイメント走査]
    C -->|No| E{サービス無効?}
    E -->|Yes| F[空リスト返却]
    E -->|No| G[エラー処理]
    D --> H{Running?}
    H -->|Yes| I[RoleInstance走査]
    H -->|No| J[スキップ]
    I --> K{host_type}
    K -->|private_ip| L[InstanceEndpoint.vip]
    K -->|public_ip| M[InstanceEndpoint.vip(public)]
    L --> N[TransportAddress生成]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-100-01 | 非推奨 | Azure Classic Discovery Pluginは非推奨 | 常時 |
| BR-100-02 | ホストタイプ | private_ipまたはpublic_ipを選択 | 常時 |
| BR-100-03 | デプロイメントフィルタ | Running状態のデプロイメントのみ対象 | 常時 |
| BR-100-04 | サービス無効時 | AzureServiceDisableException時は空リスト | サービス無効設定時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AzureServiceDisableException | サービス無効 | Azure管理サービスが無効化されている | 設定を確認 |
| AzureServiceRemoteException | リモートエラー | Azure API呼び出し失敗 | クレデンシャルと権限を確認 |
| IOException | I/Oエラー | ネットワーク接続エラー | ネットワーク設定を確認 |

### リトライ仕様

Azure SDK内部のリトライメカニズムに依存する。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- Azure Management APIの呼び出し頻度に注意
- ディスカバリの定期実行間隔を適切に設定

## セキュリティ考慮事項

- Azure管理証明書（キーストア）が必要
- キーストアのパスワードはセキュア設定で管理すべき
- 本プラグインは非推奨であり、セキュリティパッチが適用されない可能性がある

## 備考

- 本プラグインはDeprecated（非推奨）である - 起動時に非推奨警告が出力される
- pluginsディレクトリに配置される
- Azure Resource Manager（ARM）APIベースの代替実装が推奨される
- HostTypeはprivate_ipとpublic_ipの2種類のみ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AzureComputeService.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/management/AzureComputeService.java` | Azure管理サービスのインターフェース |
| 1-2 | AzureSeedHostsProvider.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/discovery/azure/classic/AzureSeedHostsProvider.java` | HostType列挙の定義 |

**読解のコツ**: HostType列挙値はprivate_ipとpublic_ipの2種類のみ。Azure Classic APIのHostedServiceGetDetailedResponseが主要なレスポンスモデル。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AzureDiscoveryPlugin.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/plugin/discovery/azure/classic/AzureDiscoveryPlugin.java` | プラグインのエントリーポイント |

**主要処理フロー**:
1. **55行目**: AzureDiscoveryPlugin定義 - DiscoveryPluginを実装
2. **57行目**: AZURE = "azure" 定数
3. **62-65行目**: コンストラクタ - 非推奨警告の出力
4. **69-71行目**: createComputeService() - AzureComputeServiceImplの生成
5. **74-78行目**: getSeedHostProviders() - "azure"プロバイダの登録

#### Step 3: シードホスト検出処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AzureSeedHostsProvider.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/discovery/azure/classic/AzureSeedHostsProvider.java` | シードホスト検出の実装 |

**主要処理フロー**:
- **62行目**: SeedHostsProviderを実装
- **66-80行目**: HostType列挙 - private_ip, public_ip
- 各DeploymentからRoleInstanceを走査し、InstanceEndpointからIP情報を取得

#### Step 4: Azure管理サービス実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AzureComputeServiceImpl.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/management/AzureComputeServiceImpl.java` | Azure Management APIの呼び出し実装 |

### プログラム呼び出し階層図

```
AzureDiscoveryPlugin
    |
    +-- getSeedHostProviders()
         +-- AzureSeedHostsProvider(settings, azureComputeService, transportService, networkService)
              |
              +-- getSeedAddresses()
                   +-- azureComputeService.getHostedServiceDetails()
                   +-- HostedServiceGetDetailedResponse処理
                   +-- デプロイメントフィルタ（スロット、ステータス）
                   +-- RoleInstance走査
                   +-- InstanceEndpointからIP取得
                   +-- TransportAddressリスト生成
```

### データフロー図

```
[入力]                            [処理]                           [出力]

Azure Management API ──────> AzureSeedHostsProvider ──────> List<TransportAddress>
  (getHostedServiceDetails)   デプロイメントフィルタ                   |
  レスポンス                  RoleInstance走査            ディスカバリモジュール
                              IP抽出                    (クラスタ参加処理)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AzureDiscoveryPlugin.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/plugin/discovery/azure/classic/AzureDiscoveryPlugin.java` | ソース | プラグインメインクラス |
| AzureSeedHostsProvider.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/discovery/azure/classic/AzureSeedHostsProvider.java` | ソース | シードホスト検出 |
| AzureComputeService.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/management/AzureComputeService.java` | ソース | Azure管理サービスIF |
| AzureComputeServiceImpl.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/management/AzureComputeServiceImpl.java` | ソース | Azure管理サービス実装 |
| AzureServiceDisableException.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/AzureServiceDisableException.java` | ソース | サービス無効例外 |
| AzureServiceRemoteException.java | `plugins/discovery-azure-classic/src/main/java/org/opensearch/cloud/azure/classic/AzureServiceRemoteException.java` | ソース | リモートエラー例外 |
