# 機能設計書 102-ワークロード管理プラグイン

## 概要

本ドキュメントは、OpenSearchのワークロード管理プラグイン（Workload Management Plugin）の設計を記述する。ワークロードグループのCRUD操作を提供するREST API、ルールベースの自動タグ付け、およびクラスタ設定管理を行うプラグインである。

### 本機能の処理概要

**業務上の目的・背景**：ワークロードグループの管理操作（作成・取得・更新・削除）をREST API経由で提供し、管理者がワークロードの分類と制御を容易に行えるようにする。また、ルールベースの自動タグ付けにより、リクエストを自動的に適切なワークロードグループに振り分ける機能を提供する。

**機能の利用シーン**：管理者がワークロードグループを定義・管理する際のAPI操作、およびリクエストがインデックスパターンやユーザー属性に基づいて自動的にワークロードグループに割り当てられる場面で利用される。

**主要な処理内容**：
1. ワークロードグループのCRUD操作（REST API: Create/Get/Update/Delete）
2. ワークロードグループのクラスタ状態への永続化（WorkloadGroupPersistenceService）
3. ルールベースの自動タグ付け（AutoTaggingActionFilter）
4. ルールの同期メカニズム（RefreshBasedSyncMechanism）
5. クラスタ設定値の提供（WlmClusterSettingValuesProvider）
6. システムインデックス（.wlm_rules）によるルールの永続化

**関連システム・外部連携**：クラスタ状態管理（ClusterService）、ルールフレームワーク（rule module）、トランスポートサービスとの連携。

**権限による制御**：REST APIは管理者向けのエンドポイントとして提供される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 167 | WLM統計一覧 | 補助機能 | ワークロード管理プラグインによる統計収集処理 |

## 機能種別

CRUD操作 / ルール管理 / 自動タグ付け

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| name | String | Yes（Create時） | ワークロードグループ名 | 空文字不可 |
| resiliency_mode | String | Yes（Create時） | レジリエンシーモード | soft/enforced/monitor |
| resource_limits | Object | No | リソース制限（cpu/memory） | 0.0 < value <= 1.0 |

### 入力データソース

- REST APIリクエストボディ（JSON）
- システムインデックス .wlm_rules

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| _id | String | ワークロードグループID |
| name | String | ワークロードグループ名 |
| resiliency_mode | String | レジリエンシーモード |
| resource_limits | Object | リソース制限値 |

### 出力先

REST APIレスポンス（JSON形式）、クラスタ状態メタデータ

## 処理フロー

### 処理シーケンス

```
1. REST APIリクエスト受信
   └─ RestCreateWorkloadGroupAction / RestGetWorkloadGroupAction等
2. TransportAction実行
   └─ TransportCreateWorkloadGroupAction等
3. WorkloadGroupPersistenceService呼出
   └─ クラスタ状態の更新（Create/Update/Delete）
4. クラスタ状態変更の伝搬
   └─ 全ノードへのWorkloadGroup定義の配布
```

### フローチャート

```mermaid
flowchart TD
    A[REST API Request] --> B[RestHandler]
    B --> C[TransportAction]
    C --> D[WorkloadGroupPersistenceService]
    D --> E[ClusterState Update]
    E --> F[Response to Client]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-201 | グループ数上限 | ワークロードグループの最大数制限（MAX_QUERY_GROUP_COUNT） | グループ作成時 |
| BR-202 | ルール数上限 | WLMルールの最大数制限（MAX_WLM_RULES_SETTING） | ルール作成時 |
| BR-203 | 自動タグ付けフィルタ | リクエストの属性に基づいてworkloadGroupIdをThreadContextに設定 | 全リクエスト処理時 |

### 計算ロジック

特になし（CRUD操作が主）。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ワークロードグループ作成 | ClusterState Metadata | INSERT | 新規ワークロードグループ定義を追加 |
| ルール永続化 | .wlm_rules インデックス | INSERT/UPDATE/DELETE | ルール情報の永続化 |

### テーブル別操作詳細

#### .wlm_rules システムインデックス

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | rule document | ルール定義JSON | IndexStoredRulePersistenceServiceで管理 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | IllegalArgumentException | 不正なパラメータ | パラメータを修正 |
| 409 | ResourceAlreadyExistsException | 同名グループが既存 | 別名を使用 |
| 404 | ResourceNotFoundException | 指定グループが存在しない | 正しいIDを使用 |

### リトライ仕様

クラスタ状態更新の失敗時はTransportAction内で再試行される。

## トランザクション仕様

クラスタ状態変更はクラスタマネージャを通じたコンセンサスで処理される。

## パフォーマンス要件

ルール同期のリフレッシュ間隔は設定可能（RefreshBasedSyncMechanism.RULE_SYNC_REFRESH_INTERVAL_SETTING）。

## セキュリティ考慮事項

- REST APIエンドポイントはクラスタ管理権限が必要
- システムインデックス .wlm_rules は保護されたインデックス

## 備考

- プラグインはActionPlugin, SystemIndexPlugin, DiscoveryPlugin, ExtensiblePlugin, RuleFrameworkExtensionを実装
- AttributeExtractorExtensionによる拡張ポイントを提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WorkloadGroupFeatureType.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/WorkloadGroupFeatureType.java` | WLMルールのフィーチャータイプ定義 |
| 1-2 | CreateWorkloadGroupRequest.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/CreateWorkloadGroupRequest.java` | 作成リクエストのデータ構造 |

**読解のコツ**: RuleFrameworkExtensionインターフェースの実装パターンに注目する。FeatureType/Attribute/Ruleの関係性を先に理解するとよい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WorkloadManagementPlugin.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WorkloadManagementPlugin.java` | プラグインのエントリーポイント。createComponents()でサービス初期化 |
| 2-2 | RestCreateWorkloadGroupAction.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rest/RestCreateWorkloadGroupAction.java` | REST APIハンドラ |

**主要処理フロー**:
1. **121-175行目**: `createComponents()`でFeatureType、RulePersistenceService、RuleRoutingService、AutoTaggingActionFilterを初期化
2. **189-196行目**: `getActions()`で4つのCRUDアクション（Create/Get/Delete/Update）を登録
3. **204-218行目**: `getRestHandlers()`で4つのRESTハンドラを登録

#### Step 3: ビジネスロジック層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AutoTaggingActionFilter.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/AutoTaggingActionFilter.java` | リクエストの自動タグ付けロジック |
| 3-2 | RefreshBasedSyncMechanism.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/RefreshBasedSyncMechanism.java` | ルール同期メカニズム |
| 3-3 | WorkloadGroupPersistenceService.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/service/WorkloadGroupPersistenceService.java` | ワークロードグループの永続化サービス |

### プログラム呼び出し階層図

```
WorkloadManagementPlugin
    |
    +-- RestCreateWorkloadGroupAction
    |       +-- TransportCreateWorkloadGroupAction
    |               +-- WorkloadGroupPersistenceService
    |                       +-- ClusterState.update()
    |
    +-- AutoTaggingActionFilter
    |       +-- InMemoryRuleProcessingService
    |               +-- AttributeValueStoreFactory
    |
    +-- RefreshBasedSyncMechanism
            +-- IndexStoredRulePersistenceService
            +-- RuleEventClassifier
```

### データフロー図

```
[入力]                    [処理]                              [出力]

REST API Request  -----> RestHandler
                          |
                          v
                   TransportAction              -----> REST API Response
                          |
                          v
                   PersistenceService           -----> ClusterState Update
                          |
                          v
                   .wlm_rules Index             -----> ルール永続化
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WorkloadManagementPlugin.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WorkloadManagementPlugin.java` | ソース | プラグインメインクラス |
| WorkloadManagementPluginModule.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WorkloadManagementPluginModule.java` | ソース | Guiceモジュール |
| AutoTaggingActionFilter.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/AutoTaggingActionFilter.java` | ソース | 自動タグ付けフィルタ |
| WlmClusterSettingValuesProvider.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/WlmClusterSettingValuesProvider.java` | ソース | クラスタ設定値プロバイダ |
| WorkloadGroupFeatureType.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/WorkloadGroupFeatureType.java` | ソース | フィーチャータイプ定義 |
| WorkloadGroupPersistenceService.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/service/WorkloadGroupPersistenceService.java` | ソース | 永続化サービス |
| TransportCreateWorkloadGroupAction.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/TransportCreateWorkloadGroupAction.java` | ソース | 作成トランスポートアクション |
| TransportGetWorkloadGroupAction.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/TransportGetWorkloadGroupAction.java` | ソース | 取得トランスポートアクション |
| TransportDeleteWorkloadGroupAction.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/TransportDeleteWorkloadGroupAction.java` | ソース | 削除トランスポートアクション |
| TransportUpdateWorkloadGroupAction.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/action/TransportUpdateWorkloadGroupAction.java` | ソース | 更新トランスポートアクション |
| RefreshBasedSyncMechanism.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/RefreshBasedSyncMechanism.java` | ソース | ルール同期メカニズム |
| RuleEventClassifier.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/sync/detect/RuleEventClassifier.java` | ソース | ルールイベント分類 |
| WorkloadGroupRuleRoutingService.java | `plugins/workload-management/src/main/java/org/opensearch/plugin/wlm/rule/WorkloadGroupRuleRoutingService.java` | ソース | ルールルーティングサービス |
