# 機能設計書 103-テレメトリフレームワーク

## 概要

本ドキュメントは、OpenSearchのテレメトリフレームワーク（Telemetry Framework）の設計を記述する。メトリクス・トレーシングの収集基盤を提供し、プラグイン方式でテレメトリバックエンドを差し替え可能にする機能である。

### 本機能の処理概要

**業務上の目的・背景**：分散システムであるOpenSearchクラスタの内部動作を可視化するため、トレーシング（分散トレース）とメトリクス（数値指標）の収集基盤が必要となる。このフレームワークはプラグイン方式でテレメトリの実装を差し替え可能にし、OpenTelemetryなど異なるバックエンドに対応できる拡張性を提供する。

**機能の利用シーン**：クラスタの性能分析、障害調査時の分散トレース解析、リクエスト処理時間の計測、REST/Transport層のトレーシングで利用される。

**主要な処理内容**：
1. TelemetryPluginインターフェースによるプラグイン拡張ポイントの提供
2. TelemetryModuleによるテレメトリ実装の登録・管理（1つのみ許可）
3. TracerFactoryによるTracerインスタンスの生成・管理
4. MetricsRegistryFactoryによるメトリクスレジストリの生成・管理
5. WrappedTracerによるトレーシングの有効/無効の動的切替
6. ThreadContextBasedTracerContextStorageによるスパンコンテキストの伝搬
7. SpanBuilderによるスパン属性の構築
8. Traceable*Channel/Handler/ListenerによるHTTP/TCP/RESTチャネルのトレース計装

**関連システム・外部連携**：TelemetryPluginインターフェースを実装するプラグイン（例：telemetry-otel）と連携。OpenTelemetry SDKなどの外部テレメトリライブラリとの橋渡しを行う。

**権限による制御**：テレメトリの有効/無効はクラスタ設定で制御される。特定の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は直接的な画面を持たない内部基盤機能 |

## 機能種別

基盤機能 / テレメトリ収集 / プラグイン拡張

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| telemetry.tracer.enabled | boolean | No | トレーシング有効/無効 | デフォルト: false |
| telemetry.feature.tracer.enabled | boolean | No | トレーシング機能有効（Final） | デフォルト: false |
| telemetry.feature.metrics.enabled | boolean | No | メトリクス機能有効（Final） | デフォルト: false |
| telemetry.tracer.sampler.probability | double | No | サンプリング確率 | 0.00-1.00、デフォルト: 0.01 |
| telemetry.otel.metrics.publish.interval | TimeValue | No | メトリクス公開間隔 | デフォルト: 60s |

### 入力データソース

- クラスタ設定（Settings）
- ThreadContext（スパンコンテキスト伝搬用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Span | Span | 分散トレーススパン |
| Metrics | Counter/Histogram/UpDownCounter | メトリクスデータポイント |

### 出力先

テレメトリプラグインのExporter経由で外部バックエンド（Jaeger, Prometheus等）

## 処理フロー

### 処理シーケンス

```
1. TelemetryModule初期化
   └─ TelemetryPluginからTelemetry実装を取得（1つのみ）
2. TracerFactory初期化
   └─ Telemetry実装からTracingTelemetryを取得しDefaultTracerを生成
   └─ WrappedTracerでラップ（有効/無効の動的切替対応）
3. MetricsRegistryFactory初期化
   └─ Telemetry実装からMetricsTelemetryを取得
4. リクエスト処理時のトレーシング
   └─ SpanBuilderでスパン生成→ThreadContextに伝搬→スパン終了
```

### フローチャート

```mermaid
flowchart TD
    A[Node起動] --> B[TelemetryModule初期化]
    B --> C{TelemetryPlugin存在?}
    C -->|Yes| D[Telemetry実装登録]
    C -->|No| E[NoopTracer使用]
    D --> F[TracerFactory生成]
    F --> G[WrappedTracer生成]
    G --> H{tracer.enabled?}
    H -->|Yes| I[DefaultTracer有効]
    H -->|No| J[NoopTracer使用]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-301 | 単一テレメトリ制約 | テレメトリ実装は1つのみ登録可能 | TelemetryModule初期化時 |
| BR-302 | 動的トレーシング切替 | telemetry.tracer.enabled設定で動的に有効/無効切替 | 設定変更時 |
| BR-303 | サンプリング制御 | 設定された確率でスパンをサンプリング | スパン生成時 |

### 計算ロジック

サンプリング確率に基づく確率的サンプリング。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。テレメトリデータは外部バックエンドにエクスポートされる。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IllegalArgumentException | 2つ以上のTelemetryPlugin登録 | テレメトリプラグインは1つのみインストール |
| - | IOException | Tracerクローズ時のエラー | ログ出力して継続 |

### リトライ仕様

テレメトリデータのエクスポート失敗時のリトライはExporter実装に依存する。

## トランザクション仕様

トランザクション管理の対象外。テレメトリデータはベストエフォートで送信される。

## パフォーマンス要件

- デフォルトサンプリング確率: 0.01（1%）でオーバーヘッドを最小化
- メトリクス公開間隔: デフォルト60秒
- NoopTracer使用時はゼロオーバーヘッド

## セキュリティ考慮事項

- トレーシング設定はノードスコープの設定として管理
- telemetry.feature.tracer.enabled/telemetry.feature.metrics.enabledはFinal設定（起動時のみ変更可能）
- テレメトリデータに機密情報が含まれないよう注意が必要

## 備考

- 本機能は `@ExperimentalApi` として提供されている
- テレメトリ未設定時はNoopTracer/NoopMetricsRegistryが使用され、パフォーマンスへの影響はない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TelemetrySettings.java | `server/src/main/java/org/opensearch/telemetry/TelemetrySettings.java` | 全テレメトリ設定の定義 |

**読解のコツ**: `Setting.Property.Final`の設定はノード起動時にのみ設定可能で、動的変更できない。`Setting.Property.Dynamic`の設定は実行時に変更可能。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TelemetryModule.java | `server/src/main/java/org/opensearch/telemetry/TelemetryModule.java` | テレメトリ実装の登録。1つのみ許可する制約 |
| 2-2 | TracerFactory.java | `server/src/main/java/org/opensearch/telemetry/tracing/TracerFactory.java` | Tracerインスタンスの生成 |

**主要処理フロー**:
1. **25-33行目** (TelemetryModule): TelemetryPluginリストからTelemetry実装を取得・登録
2. **39-42行目** (TelemetryModule): 2つ以上の登録でIllegalArgumentException
3. **39-42行目** (TracerFactory): コンストラクタでTracer生成パイプライン実行
4. **72-77行目** (TracerFactory): Telemetry未設定時はNoopTracer返却

#### Step 3: トレーシング計装層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WrappedTracer.java | `server/src/main/java/org/opensearch/telemetry/tracing/WrappedTracer.java` | 有効/無効の動的切替を提供するラッパー |
| 3-2 | SpanBuilder.java | `server/src/main/java/org/opensearch/telemetry/tracing/SpanBuilder.java` | スパン属性の構築ユーティリティ |
| 3-3 | ThreadContextBasedTracerContextStorage.java | `server/src/main/java/org/opensearch/telemetry/tracing/ThreadContextBasedTracerContextStorage.java` | ThreadContextベースのスパンコンテキスト保存 |
| 3-4 | TraceableRestChannel.java | `server/src/main/java/org/opensearch/telemetry/tracing/channels/TraceableRestChannel.java` | RESTチャネルのトレース計装 |

### プログラム呼び出し階層図

```
Node.start()
    |
    +-- TelemetryModule(telemetryPlugins, telemetrySettings)
    |       +-- TelemetryPlugin.getTelemetry()
    |
    +-- TracerFactory(telemetrySettings, telemetry, threadContext)
    |       +-- DefaultTracer(tracingTelemetry, contextStorage)
    |       +-- WrappedTracer(settings, defaultTracer)
    |
    +-- MetricsRegistryFactory(telemetrySettings, telemetry)
            +-- MetricsTelemetry -> MetricsRegistry

リクエスト処理時:
    TraceableRestChannel.sendResponse()
        +-- Tracer.startSpan()
        +-- ThreadContextBasedTracerContextStorage.put()
        +-- Tracer.endSpan()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

Settings           ----> TelemetrySettings
                          |
TelemetryPlugin    ----> TelemetryModule
                          |
                          v
ThreadContext       ----> TracerFactory
                          |
                          +-> WrappedTracer        -----> Span Export
                          +-> MetricsRegistry      -----> Metrics Export
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TelemetryModule.java | `server/src/main/java/org/opensearch/telemetry/TelemetryModule.java` | ソース | テレメトリモジュール初期化 |
| TelemetrySettings.java | `server/src/main/java/org/opensearch/telemetry/TelemetrySettings.java` | ソース | テレメトリ設定 |
| TracerFactory.java | `server/src/main/java/org/opensearch/telemetry/tracing/TracerFactory.java` | ソース | Tracerファクトリ |
| WrappedTracer.java | `server/src/main/java/org/opensearch/telemetry/tracing/WrappedTracer.java` | ソース | 動的切替ラッパー |
| SpanBuilder.java | `server/src/main/java/org/opensearch/telemetry/tracing/SpanBuilder.java` | ソース | スパン構築 |
| ThreadContextBasedTracerContextStorage.java | `server/src/main/java/org/opensearch/telemetry/tracing/ThreadContextBasedTracerContextStorage.java` | ソース | コンテキストストレージ |
| AttributeNames.java | `server/src/main/java/org/opensearch/telemetry/tracing/AttributeNames.java` | ソース | スパン属性名定数 |
| MetricsRegistryFactory.java | `server/src/main/java/org/opensearch/telemetry/metrics/MetricsRegistryFactory.java` | ソース | メトリクスレジストリファクトリ |
| NoopMetricsRegistryFactory.java | `server/src/main/java/org/opensearch/telemetry/metrics/NoopMetricsRegistryFactory.java` | ソース | Noopメトリクスレジストリ |
| NoopTracerFactory.java | `server/src/main/java/org/opensearch/telemetry/tracing/NoopTracerFactory.java` | ソース | NoopTracerファクトリ |
| TraceableRestChannel.java | `server/src/main/java/org/opensearch/telemetry/tracing/channels/TraceableRestChannel.java` | ソース | RESTチャネル計装 |
| TraceableHttpChannel.java | `server/src/main/java/org/opensearch/telemetry/tracing/channels/TraceableHttpChannel.java` | ソース | HTTPチャネル計装 |
| TraceableTcpTransportChannel.java | `server/src/main/java/org/opensearch/telemetry/tracing/channels/TraceableTcpTransportChannel.java` | ソース | TCPトランスポート計装 |
| TraceableTransportResponseHandler.java | `server/src/main/java/org/opensearch/telemetry/tracing/handler/TraceableTransportResponseHandler.java` | ソース | トランスポートレスポンスハンドラ計装 |
| TraceableSearchRequestOperationsListener.java | `server/src/main/java/org/opensearch/telemetry/tracing/listener/TraceableSearchRequestOperationsListener.java` | ソース | 検索リクエスト操作リスナー計装 |
| TraceableActionListener.java | `server/src/main/java/org/opensearch/telemetry/tracing/listener/TraceableActionListener.java` | ソース | アクションリスナー計装 |
